/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.SdkConstants;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.DesugarIncrementalTransformHelper;
import com.android.build.gradle.internal.transforms.DesugarWorkerItem;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.core.DesugarProcessArgs;
import com.android.builder.core.DesugarProcessBuilder;
import com.android.builder.model.Version;
import com.android.builder.utils.FileCache;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.workers.WorkerExecutor;

public class DesugarTransform
extends Transform {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DesugarTransform.class);
    private static final AtomicReference<Path> desugarJar = new AtomicReference<Object>(null);
    private static final String DESUGAR_JAR = "desugar_deploy.jar";
    static final int MIN_INPUT_SIZE_TO_COPY_TO_TMP = 400;
    private final Supplier<List<File>> androidJarClasspath;
    private final List<Path> compilationBootclasspath;
    private final FileCache userCache;
    private final int minSdk;
    private final JavaProcessExecutor executor;
    private final Path tmpDir;
    private final WaitableExecutor waitableExecutor;
    private boolean verbose;
    private final boolean enableGradleWorkers;
    private final String projectVariant;
    private final boolean enableIncrementalDesugaring;
    private Set<InputEntry> cacheMisses = Sets.newConcurrentHashSet();

    public DesugarTransform(Supplier<List<File>> androidJarClasspath, String compilationBootclasspath, FileCache userCache, int minSdk, JavaProcessExecutor executor, boolean verbose, boolean enableGradleWorkers, Path tmpDir, String projectVariant, boolean enableIncrementalDesugaring) {
        this(androidJarClasspath, compilationBootclasspath, userCache, minSdk, executor, verbose, enableGradleWorkers, tmpDir, projectVariant, enableIncrementalDesugaring, WaitableExecutor.useGlobalSharedThreadPool());
    }

    DesugarTransform(Supplier<List<File>> androidJarClasspath, String compilationBootclasspath, FileCache userCache, int minSdk, JavaProcessExecutor executor, boolean verbose, boolean enableGradleWorkers, Path tmpDir, String projectVariant, boolean enableIncrementalDesugaring, WaitableExecutor waitableExecutor) {
        this.androidJarClasspath = androidJarClasspath;
        this.compilationBootclasspath = PathUtils.getClassPathItems((String)compilationBootclasspath);
        this.userCache = null;
        this.minSdk = minSdk;
        this.executor = executor;
        this.waitableExecutor = waitableExecutor;
        this.verbose = verbose;
        this.enableGradleWorkers = enableGradleWorkers;
        this.tmpDir = tmpDir;
        this.projectVariant = projectVariant;
        this.enableIncrementalDesugaring = enableIncrementalDesugaring;
    }

    public String getName() {
        return "desugar";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return ImmutableSet.of((Object)QualifiedContent.Scope.PROVIDED_ONLY, (Object)QualifiedContent.Scope.TESTED_CODE);
    }

    public Map<String, Object> getParameterInputs() {
        return ImmutableMap.of((Object)"Min sdk", (Object)this.minSdk);
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        ImmutableList.Builder files = ImmutableList.builder();
        this.androidJarClasspath.get().forEach(file -> files.add((Object)SecondaryFile.nonIncremental((File)file)));
        this.compilationBootclasspath.forEach(file -> files.add((Object)SecondaryFile.nonIncremental((File)file.toFile())));
        return files.build();
    }

    public boolean isIncremental() {
        return this.enableIncrementalDesugaring;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        try {
            Set<File> additionalPaths = this.incrementalAnalysis(transformInvocation);
            DesugarTransform.initDesugarJar(this.userCache);
            this.processInputs(transformInvocation, additionalPaths);
            this.waitableExecutor.waitForTasksWithQuickFail(true);
            List<String> classpath = DesugarTransform.getClasspath(transformInvocation);
            List<String> bootclasspath = this.getBootclasspath();
            List<DesugarProcessArgs> processArgs = this.getProcessArgs(classpath, bootclasspath);
            if (this.enableGradleWorkers) {
                this.processNonCachedOnesWithGradleExecutor(transformInvocation.getContext().getWorkerExecutor(), processArgs);
            } else {
                this.processNonCachedOnes(processArgs);
            }
            for (InputEntry e : this.cacheMisses) {
                if (e.getCache() == null || e.getInputs() == null) continue;
                e.getCache().createFileInCacheIfAbsent(e.getInputs(), in -> Files.copy(e.getOutputPath(), in.toPath(), new CopyOption[0]));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TransformException((Throwable)e);
        }
        catch (Exception e) {
            throw new TransformException((Throwable)e);
        }
    }

    private Set<File> incrementalAnalysis(TransformInvocation invocation) throws InterruptedException {
        if (!this.enableIncrementalDesugaring) {
            return ImmutableSet.of();
        }
        DesugarIncrementalTransformHelper helper = new DesugarIncrementalTransformHelper(this.projectVariant);
        Set<Path> additionalPaths = helper.getAdditionalPaths(invocation, this.waitableExecutor);
        return additionalPaths.stream().map(Path::toFile).collect(Collectors.toSet());
    }

    void processInputs(TransformInvocation transformInvocation, Set<File> additionalPaths) throws Exception {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider);
        if (!transformInvocation.isIncremental()) {
            outputProvider.deleteAll();
        }
        for (TransformInput input : transformInvocation.getInputs()) {
            Path output;
            for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                output = DesugarTransform.getOutputPath(transformInvocation.getOutputProvider(), (QualifiedContent)dirInput);
                if (!dirInput.getFile().isDirectory()) {
                    PathUtils.deleteIfExists((Path)output);
                }
                this.processDirectory(output, additionalPaths, dirInput, transformInvocation.isIncremental());
            }
            for (JarInput jarInput : input.getJarInputs()) {
                if (transformInvocation.isIncremental() && jarInput.getStatus() == Status.NOTCHANGED && !additionalPaths.contains(jarInput.getFile())) continue;
                output = DesugarTransform.getOutputPath(outputProvider, (QualifiedContent)jarInput);
                PathUtils.deleteIfExists((Path)output);
                this.processSingle(jarInput.getFile().toPath(), output, jarInput.getScopes());
            }
        }
    }

    Set<InputEntry> getCacheMisses() {
        return this.cacheMisses;
    }

    private void processDirectory(Path output, Set<File> additionalPaths, DirectoryInput dirInput, boolean isIncremental) throws Exception {
        Path dirPath = dirInput.getFile().toPath();
        if (!isIncremental) {
            PathUtils.deleteIfExists((Path)output);
            this.processSingle(dirPath, output, dirInput.getScopes());
            return;
        }
        List<File> additionalFromThisDir = DesugarTransform.getAllInDir(dirInput.getFile(), additionalPaths);
        Map<Status, Set<File>> byStatus = TransformInputUtil.getByStatus(dirInput);
        if (byStatus.get(Status.ADDED).isEmpty() && byStatus.get(Status.REMOVED).isEmpty() && byStatus.get(Status.CHANGED).isEmpty() && additionalFromThisDir.isEmpty()) {
            return;
        }
        int cntFilesToProcess = byStatus.get(Status.ADDED).size() + byStatus.get(Status.CHANGED).size() + additionalFromThisDir.size();
        int totalSize = FileUtils.getAllFiles((File)dirPath.toFile()).size();
        if (totalSize < 400 || cntFilesToProcess > totalSize / 10) {
            PathUtils.deleteIfExists((Path)output);
            this.processSingle(dirPath, output, dirInput.getScopes());
            return;
        }
        Files.createDirectories(this.tmpDir, new FileAttribute[0]);
        Path changedClasses = Files.createTempDirectory(this.tmpDir, "desugar_changed", new FileAttribute[0]);
        for (File file : Iterables.concat((Iterable)byStatus.get(Status.ADDED), (Iterable)byStatus.get(Status.CHANGED), (Iterable)byStatus.get(Status.REMOVED), additionalFromThisDir)) {
            String name = file.getName();
            if (!name.endsWith(".class")) continue;
            File parentFile = file.getParentFile();
            if (!parentFile.isDirectory()) {
                Path relativeDirPath = dirPath.relativize(parentFile.toPath());
                PathUtils.deleteIfExists((Path)relativeDirPath);
                continue;
            }
            Path parentRelativePathToInput = dirPath.relativize(parentFile.toPath());
            Path tmpCopyDir = changedClasses.resolve(parentRelativePathToInput);
            Files.createDirectories(tmpCopyDir, new FileAttribute[0]);
            String nameNoExt = name.substring(0, name.length() - ".class".length());
            for (File sibling : Objects.requireNonNull(parentFile.listFiles())) {
                Path finalPath;
                if (!sibling.getName().startsWith(nameNoExt) || !sibling.getName().endsWith(".class") || !Files.notExists(finalPath = tmpCopyDir.resolve(sibling.getName()), new LinkOption[0])) continue;
                Files.copy(sibling.toPath(), finalPath, new CopyOption[0]);
            }
            File outputDirForFile = output.resolve(parentRelativePathToInput).toFile();
            if (!outputDirForFile.isDirectory()) continue;
            for (File outputSibling : Objects.requireNonNull(outputDirForFile.listFiles())) {
                if (!outputSibling.getName().startsWith(nameNoExt) || !outputSibling.getName().endsWith(".class")) continue;
                FileUtils.deleteIfExists((File)outputSibling);
            }
        }
        this.processSingle(changedClasses, output, dirInput.getScopes());
    }

    private static List<File> getAllInDir(File dir, Set<File> additionalPaths) {
        ArrayList<File> inDir = new ArrayList<File>();
        for (File additionalPath : additionalPaths) {
            if (!FileUtils.isFileInDirectory((File)additionalPath, (File)dir)) continue;
            inDir.add(additionalPath);
        }
        return inDir;
    }

    private void processNonCachedOnes(List<DesugarProcessArgs> args) throws InterruptedException {
        for (DesugarProcessArgs arg : args) {
            this.waitableExecutor.execute(() -> {
                DesugarProcessBuilder processBuilder = new DesugarProcessBuilder(arg, desugarJar.get());
                boolean isWindows = SdkConstants.currentPlatform() == 2;
                this.executor.execute(processBuilder.build(isWindows), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)logger)).rethrowFailure().assertNormalExitValue();
                return null;
            });
        }
        this.waitableExecutor.waitForTasksWithQuickFail(true);
    }

    private void processNonCachedOnesWithGradleExecutor(WorkerExecutor workerExecutor, List<DesugarProcessArgs> processArgs) throws IOException {
        for (DesugarProcessArgs processArg : processArgs) {
            DesugarWorkerItem workerItem = new DesugarWorkerItem(desugarJar.get(), processArg, PathUtils.createTmpDirToRemoveOnShutdown((String)"gradle_lambdas"));
            workerExecutor.submit(DesugarWorkerItem.DesugarAction.class, workerItem::configure);
        }
        workerExecutor.await();
    }

    private List<DesugarProcessArgs> getProcessArgs(List<String> classpath, List<String> bootclasspath) {
        int parallelExecutions = this.waitableExecutor.getParallelism();
        int index = 0;
        ArrayListMultimap procBuckets = ArrayListMultimap.create();
        for (InputEntry pathPathEntry : this.cacheMisses) {
            int bucketId = index % parallelExecutions;
            procBuckets.put((Object)bucketId, (Object)pathPathEntry);
            ++index;
        }
        ArrayList<DesugarProcessArgs> args = new ArrayList<DesugarProcessArgs>(procBuckets.keySet().size());
        for (Integer bucketId : procBuckets.keySet()) {
            HashMap inToOut = Maps.newHashMap();
            for (InputEntry e : procBuckets.get((Object)bucketId)) {
                inToOut.put(e.getInputPath().toString(), e.getOutputPath().toString());
            }
            DesugarProcessArgs processArgs = new DesugarProcessArgs((Map)inToOut, classpath, bootclasspath, this.tmpDir.toString(), this.verbose, this.minSdk);
            args.add(processArgs);
        }
        return args;
    }

    private static List<String> getClasspath(TransformInvocation transformInvocation) {
        ImmutableList.Builder classpathEntries = ImmutableList.builder();
        classpathEntries.addAll(TransformInputUtil.getAllFiles(transformInvocation.getInputs()).stream().map(File::toString).iterator());
        classpathEntries.addAll(TransformInputUtil.getAllFiles(transformInvocation.getReferencedInputs()).stream().map(File::toString).iterator());
        return classpathEntries.build();
    }

    private List<String> getBootclasspath() {
        List<String> desugarBootclasspath = this.androidJarClasspath.get().stream().map(File::toString).collect(Collectors.toList());
        this.compilationBootclasspath.forEach(p -> desugarBootclasspath.add(p.toString()));
        return desugarBootclasspath;
    }

    private void processSingle(Path input, Path output, Set<? super QualifiedContent.Scope> scopes) {
        this.waitableExecutor.execute(() -> {
            if (Files.notExists(input, new LinkOption[0])) {
                return null;
            }
            if (output.toString().endsWith(".jar")) {
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
            } else {
                Files.createDirectories(output, new FileAttribute[0]);
            }
            FileCache cacheToUse = Files.isRegularFile(input, new LinkOption[0]) && Objects.equals(scopes, Collections.singleton(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) ? this.userCache : null;
            this.processUsingCache(input, output, cacheToUse);
            return null;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processUsingCache(Path input, Path output, FileCache cache) {
        if (cache != null) {
            try {
                FileCache.Inputs cacheKey = DesugarTransform.getBuildCacheInputs(input, this.minSdk);
                if (cache.cacheEntryExists(cacheKey)) {
                    FileCache.QueryResult result = cache.createFile(output.toFile(), cacheKey, () -> {
                        throw new AssertionError((Object)"Entry should exist.");
                    });
                    if (result.getQueryEvent().equals((Object)FileCache.QueryEvent.CORRUPTED)) {
                        Objects.requireNonNull(result.getCauseOfCorruption());
                        logger.verbose("The build cache at '%1$s' contained an invalid cache entry.\nCause: %2$s\nWe have recreated the cache entry.\n", cache.getCacheDirectory().getAbsolutePath(), Throwables.getStackTraceAsString((Throwable)result.getCauseOfCorruption()));
                    }
                    if (!Files.notExists(output, new LinkOption[0])) return;
                    throw new RuntimeException(String.format("Entry for %s is invalid. Please clean your build cache under %s.", output.toString(), cache.getCacheDirectory().getAbsolutePath()));
                }
                this.cacheMissAction(cache, cacheKey, input, output);
                return;
            }
            catch (Exception exception) {
                logger.error(null, String.format("Unable to Desugar '%1$s' to '%2$s' using the build cache at '%3$s'.\n", input.toString(), output.toString(), cache.getCacheDirectory().getAbsolutePath()), new Object[0]);
                throw new RuntimeException(exception);
            }
        } else {
            this.cacheMissAction(null, null, input, output);
        }
    }

    private void cacheMissAction(FileCache cache, FileCache.Inputs inputs, Path input, Path output) {
        this.cacheMisses.add(new InputEntry(cache, inputs, input, output));
    }

    private static Path getOutputPath(TransformOutputProvider outputProvider, QualifiedContent content2) {
        return outputProvider.getContentLocation(content2.getName(), content2.getContentTypes(), content2.getScopes(), content2 instanceof DirectoryInput ? Format.DIRECTORY : Format.JAR).toPath();
    }

    private static FileCache.Inputs getBuildCacheInputs(Path input, int minSdkVersion) {
        FileCache.Inputs.Builder buildCacheInputs = new FileCache.Inputs.Builder(FileCache.Command.DESUGAR_LIBRARY);
        buildCacheInputs.putFile(FileCacheInputParams.FILE.name(), input.toFile(), FileCache.FileProperties.PATH_HASH).putString(FileCacheInputParams.PLUGIN_VERSION.name(), Version.ANDROID_GRADLE_PLUGIN_VERSION).putLong(FileCacheInputParams.MIN_SDK_VERSION.name(), (long)minSdkVersion);
        return buildCacheInputs.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDesugarJar(FileCache cache) throws IOException {
        if (DesugarTransform.isDesugarJarInitialized()) {
            return;
        }
        URL url = DesugarProcessBuilder.class.getClassLoader().getResource(DESUGAR_JAR);
        Preconditions.checkNotNull((Object)url);
        Path extractedDesugar = null;
        if (cache != null) {
            try {
                String fileHash;
                try (HashingInputStream stream = new HashingInputStream(Hashing.sha256(), url.openStream());){
                    fileHash = stream.hash().toString();
                }
                FileCache.Inputs inputs = new FileCache.Inputs.Builder(FileCache.Command.EXTRACT_DESUGAR_JAR).putString("pluginVersion", Version.ANDROID_GRADLE_PLUGIN_VERSION).putString("jarUrl", url.toString()).putString("fileHash", fileHash).build();
                File cachedFile = cache.createFileInCacheIfAbsent(inputs, file -> DesugarTransform.copyDesugarJar(url, file.toPath())).getCachedFile();
                Preconditions.checkNotNull((Object)cachedFile);
                extractedDesugar = cachedFile.toPath();
            }
            catch (IOException | ExecutionException e) {
                logger.error(e, "Unable to cache Desugar jar. Extracting to temp dir.", new Object[0]);
            }
        }
        AtomicReference<Path> atomicReference = desugarJar;
        synchronized (atomicReference) {
            if (DesugarTransform.isDesugarJarInitialized()) {
                return;
            }
            if (extractedDesugar == null) {
                extractedDesugar = PathUtils.createTmpToRemoveOnShutdown((String)DESUGAR_JAR);
                DesugarTransform.copyDesugarJar(url, extractedDesugar);
            }
            desugarJar.set(extractedDesugar);
        }
    }

    private static void copyDesugarJar(URL inputUrl, Path targetPath) throws IOException {
        try (InputStream inputStream = inputUrl.openConnection().getInputStream();){
            Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static boolean isDesugarJarInitialized() {
        return desugarJar.get() != null && Files.isRegularFile(desugarJar.get(), new LinkOption[0]);
    }

    static class InputEntry {
        private final FileCache cache;
        private final FileCache.Inputs inputs;
        private final Path inputPath;
        private final Path outputPath;

        public InputEntry(FileCache cache, FileCache.Inputs inputs, Path inputPath, Path outputPath) {
            this.cache = cache;
            this.inputs = inputs;
            this.inputPath = inputPath;
            this.outputPath = outputPath;
        }

        public FileCache getCache() {
            return this.cache;
        }

        public FileCache.Inputs getInputs() {
            return this.inputs;
        }

        public Path getInputPath() {
            return this.inputPath;
        }

        public Path getOutputPath() {
            return this.outputPath;
        }
    }

    private static enum FileCacheInputParams {
        FILE,
        PLUGIN_VERSION,
        MIN_SDK_VERSION;

    }
}

