/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class CopyOutputs
extends AndroidVariantTask {
    FileCollection fullApks;
    FileCollection abiSplits;
    FileCollection resourcesSplits;
    File destinationDir;
    OutputScope outputScope;

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    @InputFiles
    public FileCollection getFullApks() {
        return this.fullApks;
    }

    @InputFiles
    @Optional
    public FileCollection getAbiSplits() {
        return this.abiSplits;
    }

    @InputFiles
    @Optional
    public FileCollection getResourcesSplits() {
        return this.resourcesSplits;
    }

    @TaskAction
    protected void copy() throws IOException {
        FileUtils.cleanOutputDir((File)this.getDestinationDir());
        this.parallelCopy(TaskOutputHolder.TaskOutputType.FULL_APK, this.fullApks);
        this.parallelCopy(TaskOutputHolder.TaskOutputType.ABI_PACKAGED_SPLIT, this.abiSplits);
        this.parallelCopy(TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, this.resourcesSplits);
        this.outputScope.save(TaskOutputHolder.TaskOutputType.APK, this.getDestinationDir());
    }

    private void parallelCopy(TaskOutputHolder.TaskOutputType inputType, FileCollection inputs) {
        this.outputScope.parallelForEachOutput(BuildOutputs.load((TaskOutputHolder.OutputType)inputType, inputs), inputType, TaskOutputHolder.TaskOutputType.APK, (split, output) -> {
            if (output != null) {
                File destination = new File(this.getDestinationDir(), output.getName());
                FileUtils.copyFile((File)output, (File)destination);
                return destination;
            }
            return null;
        });
    }

    public static class ConfigAction
    implements TaskConfigAction<CopyOutputs> {
        private final VariantScope variantScope;
        private final File outputDirectory;

        public ConfigAction(VariantScope variantScope, File outputDirectory) {
            this.variantScope = variantScope;
            this.outputDirectory = outputDirectory;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("copyOutputs");
        }

        @Override
        public Class<CopyOutputs> getType() {
            return CopyOutputs.class;
        }

        @Override
        public void execute(CopyOutputs task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.outputScope = this.variantScope.getOutputScope();
            task.fullApks = this.variantScope.getOutput(TaskOutputHolder.TaskOutputType.FULL_APK);
            Project project = this.variantScope.getGlobalScope().getProject();
            task.abiSplits = this.variantScope.hasOutput(TaskOutputHolder.TaskOutputType.ABI_PACKAGED_SPLIT) ? this.variantScope.getOutput(TaskOutputHolder.TaskOutputType.ABI_PACKAGED_SPLIT) : project.files(new Object[0]);
            task.resourcesSplits = this.variantScope.hasOutput(TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT) ? this.variantScope.getOutput(TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT) : project.files(new Object[0]);
            task.destinationDir = this.outputDirectory;
        }
    }
}

