/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0011B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/AndroidGradlePluginVersion;", "", "majorVersion", "", "minorVersion", "microVersion", "previewType", "previewVersion", "(IIIII)V", "getMajorVersion", "()I", "getMicroVersion", "getMinorVersion", "getPreviewType", "getPreviewVersion", "compareTo", "other", "Companion", "gradle-core"})
public final class AndroidGradlePluginVersion
implements Comparable<AndroidGradlePluginVersion> {
    private final int majorVersion;
    private final int minorVersion;
    private final int microVersion;
    private final int previewType;
    private final int previewVersion;
    private static final Pattern PATTERN;
    public static final Companion Companion;

    @Override
    public int compareTo(@NotNull AndroidGradlePluginVersion other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (this.majorVersion != other.majorVersion) {
            return this.majorVersion - other.majorVersion;
        }
        if (this.minorVersion != other.minorVersion) {
            return this.minorVersion - other.minorVersion;
        }
        if (this.microVersion != other.microVersion) {
            return this.microVersion - other.microVersion;
        }
        if (this.previewType != other.previewType) {
            return this.previewType - other.previewType;
        }
        return this.previewVersion - other.previewVersion;
    }

    public final int getMajorVersion() {
        return this.majorVersion;
    }

    public final int getMinorVersion() {
        return this.minorVersion;
    }

    public final int getMicroVersion() {
        return this.microVersion;
    }

    public final int getPreviewType() {
        return this.previewType;
    }

    public final int getPreviewVersion() {
        return this.previewVersion;
    }

    public AndroidGradlePluginVersion(int majorVersion, int minorVersion, int microVersion, int previewType, int previewVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.microVersion = microVersion;
        this.previewType = previewType;
        this.previewVersion = previewVersion;
    }

    static {
        Companion = new Companion(null);
        PATTERN = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+)(-(((alpha|beta)([0-9]+))|dev))?");
    }

    @JvmStatic
    public static final boolean isPluginVersion(@NotNull String versionString) {
        Intrinsics.checkParameterIsNotNull((Object)versionString, (String)"versionString");
        return Companion.isPluginVersion(versionString);
    }

    @JvmStatic
    @NotNull
    public static final AndroidGradlePluginVersion parseString(@NotNull String versionString) {
        Intrinsics.checkParameterIsNotNull((Object)versionString, (String)"versionString");
        return Companion.parseString(versionString);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/AndroidGradlePluginVersion$Companion;", "", "()V", "PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getPATTERN", "()Ljava/util/regex/Pattern;", "isPluginVersion", "", "versionString", "", "parseString", "Lcom/android/build/gradle/internal/AndroidGradlePluginVersion;", "gradle-core"})
    public static final class Companion {
        private final Pattern getPATTERN() {
            return PATTERN;
        }

        @JvmStatic
        public final boolean isPluginVersion(@NotNull String versionString) {
            Intrinsics.checkParameterIsNotNull((Object)versionString, (String)"versionString");
            return this.getPATTERN().matcher(versionString).matches();
        }

        @JvmStatic
        @NotNull
        public final AndroidGradlePluginVersion parseString(@NotNull String versionString) {
            int previewVersion;
            int previewType;
            Intrinsics.checkParameterIsNotNull((Object)versionString, (String)"versionString");
            Matcher matcher = this.getPATTERN().matcher(versionString);
            if (!matcher.matches()) {
                throw (Throwable)new IllegalArgumentException(versionString + " is not a valid Android Gradle plugin version");
            }
            int majorVersion = Integer.parseInt(matcher.group(1));
            int minorVersion = Integer.parseInt(matcher.group(2));
            int microVersion = Integer.parseInt(matcher.group(3));
            if (matcher.group(4) == null) {
                previewType = 4;
                previewVersion = 0;
            } else if (Intrinsics.areEqual((Object)matcher.group(5), (Object)"dev")) {
                previewType = 3;
                previewVersion = 0;
            } else {
                int n;
                String previewTypeString = matcher.group(7);
                if (Intrinsics.areEqual((Object)previewTypeString, (Object)"alpha")) {
                    n = 1;
                } else {
                    Preconditions.checkState((boolean)Intrinsics.areEqual((Object)previewTypeString, (Object)"beta"));
                    n = 2;
                }
                previewType = n;
                previewVersion = Integer.parseInt(matcher.group(8));
            }
            return new AndroidGradlePluginVersion(majorVersion, minorVersion, microVersion, previewType, previewVersion);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

