/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import android.databinding.tool.DataBindingCompilerArgs;
import com.android.build.VariantOutput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.JavaCompileOptions;
import com.android.build.gradle.internal.InstantRunTaskManager;
import com.android.build.gradle.internal.LibraryTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskFactoryImpl;
import com.android.build.gradle.internal.VariantDimensionData;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.coverage.JacocoReportTask;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.AnnotationProcessorOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.incremental.BuildInfoLoaderTask;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.incremental.InstantRunAnchorTaskConfigAction;
import com.android.build.gradle.internal.model.CoreExternalNativeBuild;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.packaging.GradleKeystoreHelper;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.VariantPublishingSpec;
import com.android.build.gradle.internal.res.GenerateLibraryRFileTask;
import com.android.build.gradle.internal.res.LinkAndroidResForBundleTask;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.res.namespaced.NamespacedResourcesTaskManager;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.CheckProguardFiles;
import com.android.build.gradle.internal.tasks.DependencyReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ExtractProguardFiles;
import com.android.build.gradle.internal.tasks.ExtractTryWithResourcesSupportJar;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.InstallVariantTask;
import com.android.build.gradle.internal.tasks.LintCompile;
import com.android.build.gradle.internal.tasks.MockableAndroidJarTask;
import com.android.build.gradle.internal.tasks.PipelineToPublicationTask;
import com.android.build.gradle.internal.tasks.PlatformAttrExtractorTask;
import com.android.build.gradle.internal.tasks.PrepareLintJar;
import com.android.build.gradle.internal.tasks.SigningReportTask;
import com.android.build.gradle.internal.tasks.SourceSetsTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.TestServerTask;
import com.android.build.gradle.internal.tasks.UninstallTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportBuildInfoTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingGenBaseClassesTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingMergeArtifactsTransform;
import com.android.build.gradle.internal.tasks.databinding.DataBindingMergeGenClassLogTransform;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.TestDataImpl;
import com.android.build.gradle.internal.transforms.BuiltInShrinkerTransform;
import com.android.build.gradle.internal.transforms.CustomClassTransform;
import com.android.build.gradle.internal.transforms.D8MainDexListTransform;
import com.android.build.gradle.internal.transforms.DesugarTransform;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransform;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransformBuilder;
import com.android.build.gradle.internal.transforms.DexMergerTransform;
import com.android.build.gradle.internal.transforms.DexMergerTransformCallable;
import com.android.build.gradle.internal.transforms.DexTransform;
import com.android.build.gradle.internal.transforms.ExternalLibsMergerTransform;
import com.android.build.gradle.internal.transforms.ExtractJarsTransform;
import com.android.build.gradle.internal.transforms.FixStackFramesTransform;
import com.android.build.gradle.internal.transforms.JacocoTransform;
import com.android.build.gradle.internal.transforms.JarMergingTransform;
import com.android.build.gradle.internal.transforms.MainDexListTransform;
import com.android.build.gradle.internal.transforms.MergeJavaResourcesTransform;
import com.android.build.gradle.internal.transforms.MultiDexTransform;
import com.android.build.gradle.internal.transforms.PreDexTransform;
import com.android.build.gradle.internal.transforms.ProGuardTransform;
import com.android.build.gradle.internal.transforms.ProguardConfigurable;
import com.android.build.gradle.internal.transforms.ShrinkResourcesTransform;
import com.android.build.gradle.internal.transforms.StripDebugSymbolTransform;
import com.android.build.gradle.internal.variant.AndroidArtifactVariantData;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.CleanBuildCache;
import com.android.build.gradle.tasks.CompatibleScreensManifest;
import com.android.build.gradle.tasks.CopyOutputs;
import com.android.build.gradle.tasks.ExternalNativeBuildJsonTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeCleanTask;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.GenerateSplitAbiRes;
import com.android.build.gradle.tasks.GenerateTestConfig;
import com.android.build.gradle.tasks.InstantRunResourcesApkBuilder;
import com.android.build.gradle.tasks.JavaPreCompileTask;
import com.android.build.gradle.tasks.LintGlobalTask;
import com.android.build.gradle.tasks.LintPerVariantTask;
import com.android.build.gradle.tasks.MainApkListPersistence;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.PackageSplitAbi;
import com.android.build.gradle.tasks.PackageSplitRes;
import com.android.build.gradle.tasks.PreColdSwapTask;
import com.android.build.gradle.tasks.ProcessManifest;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.build.gradle.tasks.ShaderCompile;
import com.android.build.gradle.tasks.SplitsDiscovery;
import com.android.build.gradle.tasks.factory.AndroidUnitTest;
import com.android.build.gradle.tasks.factory.JavaCompileConfigAction;
import com.android.build.gradle.tasks.factory.ProcessJavaResConfigAction;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DefaultDexOptions;
import com.android.builder.core.VariantType;
import com.android.builder.dexing.DexerTool;
import com.android.builder.dexing.DexingType;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.DataBindingOptions;
import com.android.builder.profile.Recorder;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestServer;
import com.android.builder.utils.FileCache;
import com.android.ide.common.build.ApkData;
import com.android.manifmerger.ManifestMerger2;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class TaskManager {
    public static final String DIR_BUNDLES = "bundles";
    public static final String INSTALL_GROUP = "Install";
    public static final String BUILD_GROUP = "build";
    public static final String ANDROID_GROUP = "Android";
    public static final String FEATURE_SUFFIX = "Feature";
    public static final String MAIN_PREBUILD = "preBuild";
    public static final String UNINSTALL_ALL = "uninstallAll";
    public static final String DEVICE_CHECK = "deviceCheck";
    public static final String DEVICE_ANDROID_TEST = "device" + VariantType.ANDROID_TEST.getSuffix();
    public static final String CONNECTED_CHECK = "connectedCheck";
    public static final String CONNECTED_ANDROID_TEST = "connected" + VariantType.ANDROID_TEST.getSuffix();
    public static final String ASSEMBLE_ANDROID_TEST = "assembleAndroidTest";
    public static final String LINT = "lint";
    public static final String EXTRACT_PROGUARD_FILES = "extractProguardFiles";
    protected final Project project;
    protected final ProjectOptions projectOptions;
    protected final AndroidBuilder androidBuilder;
    protected final DataBindingBuilder dataBindingBuilder;
    protected final SdkHandler sdkHandler;
    protected final AndroidConfig extension;
    protected final ToolingModelBuilderRegistry toolingRegistry;
    protected final GlobalScope globalScope;
    protected final Recorder recorder;
    private final Logger logger;
    private final FileCache buildCache;
    protected final TaskFactory taskFactory;
    public MockableAndroidJarTask createMockableJar;

    public TaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        this.globalScope = globalScope;
        this.project = project;
        this.projectOptions = projectOptions;
        this.androidBuilder = androidBuilder;
        this.dataBindingBuilder = dataBindingBuilder;
        this.sdkHandler = sdkHandler;
        this.extension = extension;
        this.toolingRegistry = toolingRegistry;
        this.recorder = recorder;
        this.logger = Logging.getLogger(this.getClass());
        this.buildCache = globalScope.getBuildCache();
        this.taskFactory = new TaskFactoryImpl(project.getTasks());
    }

    public boolean isComponentModelPlugin() {
        return false;
    }

    public TaskFactory getTaskFactory() {
        return this.taskFactory;
    }

    public DataBindingBuilder getDataBindingBuilder() {
        return this.dataBindingBuilder;
    }

    public abstract void createTasksForVariantScope(VariantScope var1);

    protected Collection<Object> getNdkBuildable(BaseVariantData variantData) {
        if (variantData.ndkCompileTask == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(variantData.ndkCompileTask);
    }

    public void configureScopeForNdk(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        scope.setNdkSoFolder(Collections.singleton(new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/lib")));
        File objFolder = new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/obj");
        scope.setNdkObjFolder(objFolder);
        for (Abi abi : NdkHandler.getAbiList()) {
            scope.addNdkDebuggableLibraryFolders(abi, new File(objFolder, "local/" + abi.getName()));
        }
    }

    public void createTasksBeforeEvaluate() {
        this.taskFactory.create(UNINSTALL_ALL, (Action<DefaultTask>)((Action)uninstallAllTask -> {
            uninstallAllTask.setDescription("Uninstall all applications.");
            uninstallAllTask.setGroup(INSTALL_GROUP);
        }));
        this.taskFactory.create(DEVICE_CHECK, (Action<DefaultTask>)((Action)deviceCheckTask -> {
            deviceCheckTask.setDescription("Runs all device checks using Device Providers and Test Servers.");
            deviceCheckTask.setGroup("verification");
        }));
        this.taskFactory.create(CONNECTED_CHECK, (Action<DefaultTask>)((Action)connectedCheckTask -> {
            connectedCheckTask.setDescription("Runs all device checks on currently connected devices.");
            connectedCheckTask.setGroup("verification");
        }));
        this.taskFactory.create(MAIN_PREBUILD, (Action<DefaultTask>)((Action)task -> {}));
        ExtractProguardFiles extractProguardFiles = this.taskFactory.create(EXTRACT_PROGUARD_FILES, ExtractProguardFiles.class, task -> {});
        extractProguardFiles.dependsOn(new Object[]{MAIN_PREBUILD});
        this.taskFactory.create(new SourceSetsTask.ConfigAction(this.extension));
        this.taskFactory.create(ASSEMBLE_ANDROID_TEST, (Action<DefaultTask>)((Action)assembleAndroidTestTask -> {
            assembleAndroidTestTask.setGroup(BUILD_GROUP);
            assembleAndroidTestTask.setDescription("Assembles all the Test applications.");
        }));
        this.taskFactory.create(new LintCompile.ConfigAction(this.globalScope));
        this.createGlobalLintTask();
        this.configureCustomLintChecksConfig();
        if (this.buildCache != null) {
            this.taskFactory.create(new CleanBuildCache.ConfigAction(this.globalScope));
        }
        this.taskFactory.create(new TaskConfigAction<ConfigAttrTask>(){

            @Override
            public String getName() {
                return "resolveConfigAttr";
            }

            @Override
            public Class<ConfigAttrTask> getType() {
                return ConfigAttrTask.class;
            }

            @Override
            public void execute(ConfigAttrTask task) {
                task.resolvable = true;
            }
        });
        this.taskFactory.create(new TaskConfigAction<ConfigAttrTask>(){

            @Override
            public String getName() {
                return "consumeConfigAttr";
            }

            @Override
            public Class<ConfigAttrTask> getType() {
                return ConfigAttrTask.class;
            }

            @Override
            public void execute(ConfigAttrTask task) {
                task.consumable = true;
            }
        });
    }

    private void configureCustomLintChecksConfig() {
        this.globalScope.setLintChecks(TaskManager.createCustomLintChecksConfig(this.project));
    }

    public static Configuration createCustomLintChecksConfig(Project project) {
        Configuration lintChecks = (Configuration)project.getConfigurations().maybeCreate("lintChecks");
        lintChecks.setVisible(false);
        lintChecks.setDescription("Configuration to apply external lint check jar");
        lintChecks.setCanBeConsumed(false);
        return lintChecks;
    }

    public void configureCustomLintChecks() {
        File lintJar = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{LINT, "lint.jar"});
        PrepareLintJar copyLintTask = this.taskFactory.create(new PrepareLintJar.ConfigAction(this.globalScope, lintJar));
        this.globalScope.addTaskOutput(TaskOutputHolder.TaskOutputType.LINT_JAR, lintJar, copyLintTask.getName());
    }

    public void createGlobalLintTask() {
        this.taskFactory.create(LINT, LintGlobalTask.class, task -> {});
        this.taskFactory.configure("check", (Action<? super Task>)((Action)it -> it.dependsOn(new Object[]{LINT})));
    }

    public void configureGlobalLintTask(Collection<VariantScope> variants) {
        List<VariantScope> filteredVariants = variants.stream().filter(TaskManager::isLintVariant).collect(Collectors.toList());
        if (filteredVariants.isEmpty()) {
            return;
        }
        new LintGlobalTask.GlobalConfigAction(this.globalScope, filteredVariants).execute((LintGlobalTask)this.taskFactory.findByName(LINT));
        FileCollection lintJarCollection = this.globalScope.getOutput(TaskOutputHolder.TaskOutputType.LINT_JAR);
        File lintJar = lintJarCollection.getSingleFile();
        for (VariantScope scope : variants) {
            scope.addTaskOutput(TaskOutputHolder.TaskOutputType.LINT_JAR, lintJar, "prepareLintJar");
        }
    }

    public void createMockableJarTask() {
        File mockableJar = this.globalScope.getMockableAndroidJarFile();
        this.createMockableJar = this.taskFactory.create(new MockableAndroidJarTask.ConfigAction(this.globalScope, mockableJar));
        this.globalScope.addTaskOutput(TaskOutputHolder.TaskOutputType.MOCKABLE_JAR, mockableJar, this.createMockableJar.getName());
    }

    public void createAttrFromAndroidJarTask() {
        File platformRtxt = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"attr", "R.txt"});
        PlatformAttrExtractorTask task = this.taskFactory.create(new PlatformAttrExtractorTask.ConfigAction(this.globalScope, platformRtxt));
        this.globalScope.addTaskOutput(TaskOutputHolder.TaskOutputType.PLATFORM_R_TXT, platformRtxt, task.getName());
    }

    protected void createDependencyStreams(VariantScope variantScope) {
        this.handleJacocoDependencies(variantScope);
        TransformManager transformManager = variantScope.getTransformManager();
        transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-res-plus-native").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES, ExtendedContentType.NATIVE_LIBS}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.JAVA_RES)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-native").addContentTypes(TransformManager.CONTENT_NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.JNI)).build());
        if (this.extension.getDataBinding().isEnabled()) {
            transformManager.addStream(OriginalStream.builder(this.project, "sub-project-data-binding").addContentTypes(TransformManager.DATA_BINDING_ARTIFACT).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.DATA_BINDING_ARTIFACT)).build());
            transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-data-binding").addContentTypes(TransformManager.DATA_BINDING_ARTIFACT).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.DATA_BINDING_ARTIFACT)).build());
            transformManager.addStream(OriginalStream.builder(this.project, "sub-project-data-binding-base-classes").addContentTypes(TransformManager.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT)).build());
            transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-data-binding-base-classes").addContentTypes(TransformManager.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT)).build());
        }
        transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.CLASSES)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-res-plus-native").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES, ExtendedContentType.NATIVE_LIBS}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.JAVA_RES)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-native").addContentTypes(TransformManager.CONTENT_NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.JNI)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "provided-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROVIDED_ONLY).setFileCollection(variantScope.getProvidedOnlyClasspath()).build());
        if (variantScope.getTestedVariantData() != null) {
            BaseVariantData testedVariantData = variantScope.getTestedVariantData();
            VariantScope testedVariantScope = testedVariantData.getScope();
            VariantPublishingSpec testedSpec = testedVariantScope.getPublishingSpec().getTestingSpec(variantScope.getVariantConfiguration().getType());
            VariantPublishingSpec.OutputPublishingSpec taskOutputSpec = testedSpec.getSpec(AndroidArtifacts.ArtifactType.CLASSES);
            TaskOutputHolder.OutputType testedOutputType = taskOutputSpec.getOutputType();
            transformManager.addStream(OriginalStream.builder(this.project, "tested-code-classes").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.TESTED_CODE).setFileCollection(testedVariantScope.getOutput(testedOutputType)).build());
            transformManager.addStream(OriginalStream.builder(this.project, "tested-code-deps").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.TESTED_CODE).setArtifactCollection(testedVariantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES)).build());
        }
    }

    public void createMergeApkManifestsTask(VariantScope variantScope) {
        AndroidArtifactVariantData androidArtifactVariantData = (AndroidArtifactVariantData)variantScope.getVariantData();
        Set<String> screenSizes = androidArtifactVariantData.getCompatibleScreens();
        CompatibleScreensManifest csmTask = this.taskFactory.create(new CompatibleScreensManifest.ConfigAction(variantScope, screenSizes));
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.COMPATIBLE_SCREEN_MANIFEST, variantScope.getCompatibleScreensManifestDirectory(), csmTask.getName());
        ImmutableList.Builder optionalFeatures = ImmutableList.builder();
        if (variantScope.isTestOnly()) {
            optionalFeatures.add((Object)ManifestMerger2.Invoker.Feature.TEST_ONLY);
        }
        if (variantScope.getVariantConfiguration().getDexingType() == DexingType.LEGACY_MULTIDEX) {
            optionalFeatures.add((Object)ManifestMerger2.Invoker.Feature.ADD_MULTIDEX_APPLICATION_IF_NO_NAME);
        }
        if (((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable()) {
            optionalFeatures.add((Object)ManifestMerger2.Invoker.Feature.DEBUGGABLE);
        }
        if (!TaskManager.getAdvancedProfilingTransforms(this.projectOptions).isEmpty() && ((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable()) {
            optionalFeatures.add((Object)ManifestMerger2.Invoker.Feature.ADVANCED_PROFILING);
        }
        ManifestProcessorTask processManifestTask = this.createMergeManifestTask(variantScope, (ImmutableList.Builder<ManifestMerger2.Invoker.Feature>)optionalFeatures);
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, variantScope.getManifestOutputDirectory(), processManifestTask.getName());
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.MANIFEST_METADATA, ExistingBuildElements.getMetadataFile(variantScope.getManifestOutputDirectory()), processManifestTask.getName());
        variantScope.setManifestProcessorTask(processManifestTask);
        processManifestTask.dependsOn(new Object[]{variantScope.getCheckManifestTask()});
        if (variantScope.getMicroApkTask() != null) {
            processManifestTask.dependsOn(new Object[]{variantScope.getMicroApkTask()});
        }
    }

    private static List<String> getAdvancedProfilingTransforms(ProjectOptions options) {
        String string = options.get(StringOption.IDE_ANDROID_CUSTOM_CLASS_TRANSFORMS);
        if (string == null) {
            return ImmutableList.of();
        }
        return Splitter.on((char)',').splitToList((CharSequence)string);
    }

    private static File computeManifestReportFile(VariantScope variantScope) {
        return FileUtils.join((File)variantScope.getGlobalScope().getOutputsDir(), (String[])new String[]{"logs", "manifest-merger-" + variantScope.getVariantConfiguration().getBaseName() + "-report.txt"});
    }

    protected ManifestProcessorTask createMergeManifestTask(VariantScope variantScope, ImmutableList.Builder<ManifestMerger2.Invoker.Feature> optionalFeatures) {
        if (variantScope.getVariantConfiguration().isInstantRunBuild(this.globalScope)) {
            optionalFeatures.add((Object)ManifestMerger2.Invoker.Feature.INSTANT_RUN_REPLACEMENT);
        }
        File reportFile = TaskManager.computeManifestReportFile(variantScope);
        MergeManifests mergeManifestsAndroidTask = this.taskFactory.create(new MergeManifests.ConfigAction(variantScope, (List<ManifestMerger2.Invoker.Feature>)optionalFeatures.build(), reportFile));
        String name = mergeManifestsAndroidTask.getName();
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS, variantScope.getInstantRunManifestOutputDirectory(), name);
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.MANIFEST_MERGE_REPORT, reportFile, name);
        return mergeManifestsAndroidTask;
    }

    public ProcessManifest createMergeLibManifestsTask(VariantScope scope) {
        File libraryProcessedManifest = new File(scope.getManifestOutputDirectory(), "AndroidManifest.xml");
        File reportFile = TaskManager.computeManifestReportFile(scope);
        ProcessManifest processManifest = this.taskFactory.create(new ProcessManifest.ConfigAction(scope, libraryProcessedManifest, reportFile));
        String taskName = processManifest.getName();
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, scope.getManifestOutputDirectory(), taskName);
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.AAPT_FRIENDLY_MERGED_MANIFESTS, scope.getAaptFriendlyManifestOutputDirectory(), taskName);
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.LIBRARY_MANIFEST, libraryProcessedManifest, taskName);
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.MANIFEST_MERGE_REPORT, reportFile, taskName);
        processManifest.dependsOn(new Object[]{scope.getCheckManifestTask()});
        scope.setManifestProcessorTask(processManifest);
        return processManifest;
    }

    protected void createProcessTestManifestTask(VariantScope scope, VariantScope testedScope) {
        ProcessTestManifest processTestManifestTask = this.taskFactory.create(new ProcessTestManifest.ConfigAction(scope, testedScope.getOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS)));
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, scope.getManifestOutputDirectory(), processTestManifestTask.getName());
        if (scope.getCheckManifestTask() != null) {
            processTestManifestTask.dependsOn(new Object[]{scope.getCheckManifestTask()});
        }
        scope.setManifestProcessorTask(processTestManifestTask);
    }

    public void createRenderscriptTask(VariantScope scope) {
        scope.setRenderscriptCompileTask(this.taskFactory.create(new RenderscriptCompile.ConfigAction(scope)));
        GradleVariantConfiguration config = scope.getVariantConfiguration();
        if (config.getType().isForTesting()) {
            scope.getRenderscriptCompileTask().dependsOn(new Object[]{scope.getManifestProcessorTask()});
        } else {
            scope.getRenderscriptCompileTask().dependsOn(new Object[]{scope.getPreBuildTask()});
        }
        scope.getResourceGenTask().dependsOn(new Object[]{scope.getRenderscriptCompileTask()});
        if (!config.getRenderscriptNdkModeEnabled()) {
            scope.getSourceGenTask().dependsOn(new Object[]{scope.getRenderscriptCompileTask()});
        }
    }

    public MergeResources createMergeResourcesTask(VariantScope scope, boolean processResources) {
        boolean alsoOutputNotCompiledResources = scope.useResourceShrinker() || scope.getTestedVariantData() == null && this.globalScope.getExtension().getTestOptions().getUnitTests().isIncludeAndroidResources();
        return this.basicCreateMergeResourcesTask(scope, MergeType.MERGE, null, true, processResources, alsoOutputNotCompiledResources, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
    }

    public MergeResources basicCreateMergeResourcesTask(VariantScope scope, MergeType mergeType, File outputLocation, boolean includeDependencies, boolean processResources, boolean alsoOutputNotCompiledResources, ImmutableSet<MergeResources.Flag> flags) {
        File mergedOutputDir = (File)MoreObjects.firstNonNull((Object)outputLocation, (Object)scope.getDefaultMergeResourcesOutputDir());
        String taskNamePrefix = mergeType.name().toLowerCase(Locale.ENGLISH);
        File mergedNotCompiledDir = alsoOutputNotCompiledResources ? new File(this.globalScope.getIntermediatesDir() + "/merged-not-compiled-resources/" + scope.getVariantConfiguration().getDirName()) : null;
        MergeResources mergeResourcesTask = this.taskFactory.create(new MergeResources.ConfigAction(scope, taskNamePrefix, mergedOutputDir, mergedNotCompiledDir, includeDependencies, processResources, true, flags));
        scope.addTaskOutput(mergeType.getOutputType(), mergedOutputDir, mergeResourcesTask.getName());
        if (alsoOutputNotCompiledResources) {
            scope.addTaskOutput(TaskOutputHolder.TaskOutputType.MERGED_NOT_COMPILED_RES, mergedNotCompiledDir, mergeResourcesTask.getName());
        }
        mergeResourcesTask.dependsOn(new Object[]{scope.getResourceGenTask()});
        if (this.extension.getTestOptions().getUnitTests().isIncludeAndroidResources()) {
            scope.getCompileTask().dependsOn(new Object[]{mergeResourcesTask});
        }
        scope.setResourceOutputDir(mergedOutputDir);
        scope.setMergeResourceOutputDir(outputLocation);
        return mergeResourcesTask;
    }

    public MergeSourceSetFolders createMergeAssetsTask(VariantScope scope) {
        GradleVariantConfiguration variantConfiguration = scope.getVariantConfiguration();
        File outputDir = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"assets", variantConfiguration.getDirName()});
        MergeSourceSetFolders mergeAssetsTask = this.taskFactory.create(new MergeSourceSetFolders.MergeAppAssetConfigAction(scope, outputDir));
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.MERGED_ASSETS, outputDir, mergeAssetsTask.getName());
        mergeAssetsTask.dependsOn(new Object[]{scope.getAssetGenTask()});
        scope.setMergeAssetsTask(mergeAssetsTask);
        return mergeAssetsTask;
    }

    public Optional<TransformTask> createMergeJniLibFoldersTasks(VariantScope variantScope) {
        MergeSourceSetFolders mergeJniLibFoldersTask = this.taskFactory.create(new MergeSourceSetFolders.MergeJniLibFoldersConfigAction(variantScope));
        mergeJniLibFoldersTask.dependsOn(new Object[]{variantScope.getAssetGenTask()});
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "mergedJniFolder").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolder(variantScope.getMergeNativeLibsOutputDir()).setDependency(mergeJniLibFoldersTask.getName()).build());
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "local-ndk-build").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolders(variantScope::getNdkSoFolder).setDependency(this.getNdkBuildable(variantScope.getVariantData())).build());
        if (variantScope.getExternalNativeJsonGenerator() != null) {
            variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "external-native-build").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolder(variantScope.getExternalNativeJsonGenerator().getObjFolder()).setDependency(((ExternalNativeBuildTask)((Object)Preconditions.checkNotNull((Object)((Object)variantScope.getExternalNativeBuildTask())))).getName()).build());
        }
        if (variantScope.getVariantConfiguration().getRenderscriptSupportModeEnabled()) {
            Supplier<Collection<File>> supplier = () -> {
                File rsLibs;
                ImmutableList.Builder builder = ImmutableList.builder();
                if (variantScope.getRenderscriptLibOutputDir().isDirectory()) {
                    builder.add((Object)variantScope.getRenderscriptLibOutputDir());
                }
                if ((rsLibs = variantScope.getGlobalScope().getAndroidBuilder().getSupportNativeLibFolder()) != null && rsLibs.isDirectory()) {
                    builder.add((Object)rsLibs);
                }
                if (variantScope.getVariantConfiguration().getRenderscriptSupportModeBlasEnabled()) {
                    File rsBlasLib = variantScope.getGlobalScope().getAndroidBuilder().getSupportBlasLibFolder();
                    if (rsBlasLib == null || !rsBlasLib.isDirectory()) {
                        throw new GradleException("Renderscript BLAS support mode is not supported in BuildTools" + rsBlasLib);
                    }
                    builder.add((Object)rsBlasLib);
                }
                return builder.build();
            };
            variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "rs-support-mode-output").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolders(supplier).setDependency(variantScope.getRenderscriptCompileTask().getName()).build());
        }
        Set<? super QualifiedContent.Scope> mergeScopes = this.getResMergingScopes(variantScope);
        MergeJavaResourcesTransform mergeTransform = new MergeJavaResourcesTransform(variantScope.getGlobalScope().getExtension().getPackagingOptions(), mergeScopes, ExtendedContentType.NATIVE_LIBS, "mergeJniLibs", variantScope);
        return variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, mergeTransform);
    }

    public void createBuildConfigTask(VariantScope scope) {
        GenerateBuildConfig generateBuildConfigTask = this.taskFactory.create(new GenerateBuildConfig.ConfigAction(scope));
        scope.setGenerateBuildConfigTask(generateBuildConfigTask);
        scope.getSourceGenTask().dependsOn(new Object[]{generateBuildConfigTask.getName()});
        if (scope.getVariantConfiguration().getType().isForTesting()) {
            generateBuildConfigTask.dependsOn(new Object[]{scope.getManifestProcessorTask()});
        } else {
            generateBuildConfigTask.dependsOn(new Object[]{scope.getCheckManifestTask()});
        }
    }

    public void createGenerateResValuesTask(VariantScope scope) {
        GenerateResValues generateResValuesTask = this.taskFactory.create(new GenerateResValues.ConfigAction(scope));
        scope.getResourceGenTask().dependsOn(new Object[]{generateResValuesTask});
    }

    public void createApkProcessResTask(VariantScope scope) {
        this.createProcessResTask(scope, new File(this.globalScope.getIntermediatesDir(), "symbols/" + scope.getVariantData().getVariantConfiguration().getDirName()), scope.getProcessResourcePackageOutputDirectory(), null, MergeType.MERGE, scope.getGlobalScope().getProjectBaseName());
    }

    protected boolean isLibrary() {
        return false;
    }

    public void createProcessResTask(VariantScope scope, File symbolLocation, File resPackageOutputFolder, TaskOutputHolder.TaskOutputType packageOutputType, MergeType mergeType, String baseName) {
        boolean useAaptToGenerateLegacyMultidexMainDexProguardRules;
        BaseVariantData variantData = scope.getVariantData();
        variantData.calculateFilters(scope.getGlobalScope().getExtension().getSplits());
        this.createSplitsDiscovery(scope);
        boolean bl = useAaptToGenerateLegacyMultidexMainDexProguardRules = scope.getDexingType() == DexingType.LEGACY_MULTIDEX;
        if (Boolean.TRUE.equals(scope.getGlobalScope().getExtension().getAaptOptions().getNamespaced())) {
            new NamespacedResourcesTaskManager(this.globalScope, this.taskFactory, scope).createNamespacedResourceTasks(resPackageOutputFolder, packageOutputType, baseName, useAaptToGenerateLegacyMultidexMainDexProguardRules);
            return;
        }
        this.createNonNamespacedResourceTasks(scope, symbolLocation, resPackageOutputFolder, packageOutputType, mergeType, baseName, useAaptToGenerateLegacyMultidexMainDexProguardRules);
    }

    private void createNonNamespacedResourceTasks(VariantScope scope, File symbolDirectory, File resPackageOutputFolder, TaskOutputHolder.TaskOutputType packageOutputType, MergeType mergeType, String baseName, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules) {
        String taskName;
        File symbolTableWithPackageName = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res", "symbol-table-with-package", scope.getVariantConfiguration().getDirName(), "package-aware-r.txt"});
        File symbolFile = new File(symbolDirectory, "R.txt");
        if (mergeType == MergeType.PACKAGE) {
            GenerateLibraryRFileTask task = this.taskFactory.create(new GenerateLibraryRFileTask.ConfigAction(scope, symbolFile, symbolTableWithPackageName));
            taskName = task.getName();
            scope.setProcessResourcesTask(task);
        } else {
            LinkApplicationAndroidResourcesTask processAndroidResources = this.taskFactory.create(this.createProcessAndroidResourcesConfigAction(scope, () -> symbolDirectory, symbolTableWithPackageName, resPackageOutputFolder, useAaptToGenerateLegacyMultidexMainDexProguardRules, mergeType, baseName));
            taskName = processAndroidResources.getName();
            scope.addTaskOutput(TaskOutputHolder.TaskOutputType.PROCESSED_RES, resPackageOutputFolder, taskName);
            if (packageOutputType != null) {
                scope.addTaskOutput(packageOutputType, resPackageOutputFolder, processAndroidResources.getName());
            }
            scope.setProcessResourcesTask(processAndroidResources);
            File resourcesAsProtosFile = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res-bundle", scope.getVariantConfiguration().getDirName(), "bundled-res.ap_"});
            LinkAndroidResForBundleTask linkResForBundle = this.taskFactory.create(new LinkAndroidResForBundleTask.ConfigAction(scope, resourcesAsProtosFile));
            scope.addTaskOutput(TaskOutputHolder.TaskOutputType.LINKED_RES_FOR_BUNDLE, resourcesAsProtosFile, linkResForBundle.getName());
        }
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.SYMBOL_LIST, symbolFile, taskName);
        scope.getSourceGenTask().dependsOn(new Object[]{taskName});
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.SYMBOL_LIST_WITH_PACKAGE_NAME, symbolTableWithPackageName, taskName);
        Task t = (Task)this.project.getTasks().findByName(taskName);
        if (t != null) {
            scope.getSourceGenTask().dependsOn(new Object[]{taskName});
        }
    }

    protected TaskConfigAction<LinkApplicationAndroidResourcesTask> createProcessAndroidResourcesConfigAction(VariantScope scope, Supplier<File> symbolLocation, File symbolWithPackageName, File resPackageOutputFolder, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules, MergeType sourceTaskOutputType, String baseName) {
        return new LinkApplicationAndroidResourcesTask.ConfigAction(scope, symbolLocation, symbolWithPackageName, resPackageOutputFolder, useAaptToGenerateLegacyMultidexMainDexProguardRules, sourceTaskOutputType, baseName, this.isLibrary());
    }

    public PackageSplitRes createSplitResourcesTasks(VariantScope scope) {
        PackageSplitRes packageSplitRes;
        BaseVariantData variantData = scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS), (Object)"Can only create split resources tasks for pure splits.");
        File densityOrLanguagesPackages = scope.getSplitDensityOrLanguagesPackagesOutputDirectory();
        variantData.packageSplitResourcesTask = packageSplitRes = this.taskFactory.create(new PackageSplitRes.ConfigAction(scope, densityOrLanguagesPackages));
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, densityOrLanguagesPackages, packageSplitRes.getName());
        if (scope.getVariantConfiguration().getSigningConfig() != null) {
            packageSplitRes.dependsOn(new Object[]{this.getValidateSigningTask(scope)});
        }
        return packageSplitRes;
    }

    public PackageSplitAbi createSplitAbiTasks(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS), (Object)"split ABI tasks are only compatible with pure splits.");
        ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(this.extension.getSplits().getAbiFilters());
        if (filters.isEmpty()) {
            return null;
        }
        List<ApkData> fullApkDatas = variantData.getOutputScope().getSplitsByType(VariantOutput.OutputType.FULL_SPLIT);
        if (!fullApkDatas.isEmpty()) {
            throw new RuntimeException("In release 21 and later, there cannot be full splits and pure splits, found " + Joiner.on((String)",").join(fullApkDatas) + " and abi filters " + Joiner.on((String)",").join(filters));
        }
        File generateSplitAbiResOutputDirectory = scope.getGenerateSplitAbiResOutputDirectory();
        GenerateSplitAbiRes generateSplitAbiRes = this.taskFactory.create(new GenerateSplitAbiRes.ConfigAction(scope, generateSplitAbiResOutputDirectory));
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.ABI_PROCESSED_SPLIT_RES, generateSplitAbiResOutputDirectory, generateSplitAbiRes.getName());
        File generateSplitAbiPackagesOutputDirectory = scope.getSplitAbiPackagesOutputDirectory();
        PackageSplitAbi packageSplitAbiTask = this.taskFactory.create(new PackageSplitAbi.ConfigAction(scope, generateSplitAbiPackagesOutputDirectory, scope.getOutput(TaskOutputHolder.TaskOutputType.ABI_PROCESSED_SPLIT_RES)));
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.ABI_PACKAGED_SPLIT, generateSplitAbiPackagesOutputDirectory, packageSplitAbiTask.getName());
        variantData.packageSplitAbiTask = packageSplitAbiTask;
        packageSplitAbiTask.dependsOn(new Object[]{scope.getNdkBuildable()});
        if (variantData.getVariantConfiguration().getSigningConfig() != null) {
            packageSplitAbiTask.dependsOn(new Object[]{this.getValidateSigningTask(variantData.getScope())});
        }
        if (scope.getExternalNativeBuildTask() != null) {
            packageSplitAbiTask.dependsOn(new Object[]{scope.getExternalNativeBuildTask()});
        }
        return packageSplitAbiTask;
    }

    public void createSplitTasks(VariantScope variantScope) {
        this.createSplitResourcesTasks(variantScope);
        this.createSplitAbiTasks(variantScope);
    }

    protected abstract Set<? super QualifiedContent.Scope> getResMergingScopes(VariantScope var1);

    public void createProcessJavaResTask(VariantScope variantScope) {
        File destinationDir = variantScope.getSourceFoldersJavaResDestinationDir();
        Sync processJavaResourcesTask = this.taskFactory.create(new ProcessJavaResConfigAction(variantScope, destinationDir));
        variantScope.setProcessJavaResourcesTask(processJavaResourcesTask);
        variantScope.getVariantData().processJavaResourcesTask = processJavaResourcesTask;
        processJavaResourcesTask.dependsOn(new Object[]{variantScope.getPreBuildTask()});
        ConfigurableFileCollection collection = variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.JAVA_RES, destinationDir, processJavaResourcesTask.getName());
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "processed-java-res").addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)collection).build());
    }

    public void createMergeJavaResTransform(VariantScope variantScope) {
        TransformManager transformManager = variantScope.getTransformManager();
        Set<? super QualifiedContent.Scope> mergeScopes = this.getResMergingScopes(variantScope);
        MergeJavaResourcesTransform mergeTransform = new MergeJavaResourcesTransform(variantScope.getGlobalScope().getExtension().getPackagingOptions(), mergeScopes, (QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES, "mergeJavaRes", variantScope);
        variantScope.setMergeJavaResourcesTask(transformManager.addTransform(this.taskFactory, variantScope, mergeTransform).orElse(null));
    }

    public AidlCompile createAidlTask(VariantScope scope) {
        AidlCompile aidlCompileTask = this.taskFactory.create(new AidlCompile.ConfigAction(scope));
        scope.setAidlCompileTask(aidlCompileTask);
        scope.getSourceGenTask().dependsOn(new Object[]{aidlCompileTask});
        aidlCompileTask.dependsOn(new Object[]{scope.getPreBuildTask()});
        return aidlCompileTask;
    }

    public void createShaderTask(VariantScope scope) {
        MergeSourceSetFolders mergeShadersTask = this.taskFactory.create(new MergeSourceSetFolders.MergeShaderSourceFoldersConfigAction(scope));
        File outputDir = scope.getGeneratedAssetsDir("shaders");
        ShaderCompile shaderCompileTask = this.taskFactory.create(new ShaderCompile.ConfigAction(scope, outputDir));
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.SHADER_ASSETS, outputDir, shaderCompileTask.getName());
        shaderCompileTask.dependsOn(new Object[]{mergeShadersTask});
        scope.getAssetGenTask().dependsOn(new Object[]{shaderCompileTask});
    }

    protected abstract void postJavacCreation(VariantScope var1);

    public JavaCompile createJavacTask(VariantScope scope) {
        File processorListFile = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"javaPrecompile", scope.getDirName(), "annotationProcessors.json"});
        JavaPreCompileTask preCompileTask = this.taskFactory.create(new JavaPreCompileTask.ConfigAction(scope, processorListFile));
        preCompileTask.dependsOn(new Object[]{scope.getPreBuildTask()});
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.ANNOTATION_PROCESSOR_LIST, processorListFile, preCompileTask.getName());
        File outputFolder = new File(this.globalScope.getIntermediatesDir(), "/classes/" + scope.getVariantConfiguration().getDirName());
        JavaCompile javacTask = this.taskFactory.create(new JavaCompileConfigAction(scope, outputFolder));
        scope.setJavacTask(javacTask);
        TaskManager.setupCompileTaskDependencies(scope, (Task)javacTask);
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.JAVAC, outputFolder, javacTask.getName());
        this.postJavacCreation(scope);
        return javacTask;
    }

    public void addJavacClassesStream(VariantScope scope) {
        scope.getTransformManager().addStream(OriginalStream.builder(this.project, "javac-output").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(scope.getOutput(TaskOutputHolder.TaskOutputType.JAVAC)).build());
        scope.getTransformManager().addStream(OriginalStream.builder(this.project, "pre-javac-generated-bytecode").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(scope.getVariantData().getAllPreJavacGeneratedBytecode()).build());
        scope.getTransformManager().addStream(OriginalStream.builder(this.project, "post-javac-generated-bytecode").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(scope.getVariantData().getAllPostJavacGeneratedBytecode()).build());
        if (scope.hasOutput(TaskOutputHolder.TaskOutputType.RUNTIME_R_CLASS_CLASSES)) {
            scope.getTransformManager().addStream(OriginalStream.builder(this.project, "final-r-classes").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(scope.getOutput(TaskOutputHolder.TaskOutputType.RUNTIME_R_CLASS_CLASSES)).build());
        }
    }

    private static void setupCompileTaskDependencies(VariantScope scope, Task compileTask) {
        if (scope.getSourceGenTask() != null) {
            compileTask.dependsOn(new Object[]{scope.getSourceGenTask()});
        }
    }

    public static void setJavaCompilerTask(Task javaCompilerTask, VariantScope scope) {
        scope.getCompileTask().dependsOn(new Object[]{javaCompilerTask});
    }

    public void createGenerateMicroApkDataTask(VariantScope scope, FileCollection config) {
        GenerateApkDataTask generateMicroApkTask = this.taskFactory.create(new GenerateApkDataTask.ConfigAction(scope, config));
        scope.setMicroApkTask(generateMicroApkTask);
        scope.getResourceGenTask().dependsOn(new Object[]{generateMicroApkTask});
    }

    public void createExternalNativeBuildJsonGenerators(VariantScope scope) {
        CoreExternalNativeBuild externalNativeBuild = this.extension.getExternalNativeBuild();
        ExternalNativeBuildTaskUtils.ExternalNativeBuildProjectPathResolution pathResolution = ExternalNativeBuildTaskUtils.getProjectPath(externalNativeBuild);
        if (pathResolution.errorText != null) {
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, pathResolution.errorText, scope.getVariantConfiguration().getFullName());
            return;
        }
        if (pathResolution.makeFile == null) {
            return;
        }
        scope.setExternalNativeJsonGenerator(ExternalNativeJsonGenerator.create(this.project.getProjectDir(), this.project.getBuildDir(), pathResolution.externalNativeBuildDir, (NativeBuildSystem)((Object)Preconditions.checkNotNull((Object)((Object)pathResolution.buildSystem))), pathResolution.makeFile, this.androidBuilder, this.sdkHandler, scope));
    }

    public void createExternalNativeBuildTasks(VariantScope scope) {
        ExternalNativeJsonGenerator generator = scope.getExternalNativeJsonGenerator();
        if (generator == null) {
            return;
        }
        ExternalNativeBuildJsonTask generateTask = this.taskFactory.create(ExternalNativeBuildJsonTask.createTaskConfigAction(generator, scope));
        generateTask.dependsOn(new Object[]{scope.getPreBuildTask()});
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        String targetAbi = projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI) ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
        ExternalNativeBuildTask buildTask = this.taskFactory.create(new ExternalNativeBuildTask.ConfigAction(targetAbi, generator, scope, this.androidBuilder));
        buildTask.dependsOn(new Object[]{generateTask});
        scope.setExternalNativeBuildTask(buildTask);
        scope.getCompileTask().dependsOn(new Object[]{buildTask});
        Task cleanTask = (Task)Preconditions.checkNotNull((Object)this.taskFactory.findByName("clean"));
        cleanTask.dependsOn(new Object[]{this.taskFactory.create(new ExternalNativeCleanTask.ConfigAction(generator, scope, this.androidBuilder)).getName()});
    }

    public void createNdkTasks(VariantScope scope) {
        if (ExternalNativeBuildTaskUtils.isExternalNativeBuildEnabled(this.extension.getExternalNativeBuild())) {
            return;
        }
        NdkCompile ndkCompileTask = this.taskFactory.create(new NdkCompile.ConfigAction(scope));
        ndkCompileTask.dependsOn(new Object[]{scope.getPreBuildTask()});
        if (Boolean.TRUE.equals(scope.getVariantData().getVariantConfiguration().getMergedFlavor().getRenderscriptNdkModeEnabled())) {
            ndkCompileTask.dependsOn(new Object[]{scope.getRenderscriptCompileTask()});
        }
        scope.getCompileTask().dependsOn(new Object[]{ndkCompileTask});
    }

    public static void createStripNativeLibraryTask(TaskFactory taskFactory, VariantScope scope) {
        if (!scope.getGlobalScope().getNdkHandler().isConfigured()) {
            return;
        }
        TransformManager transformManager = scope.getTransformManager();
        GlobalScope globalScope = scope.getGlobalScope();
        transformManager.addTransform(taskFactory, scope, new StripDebugSymbolTransform(globalScope.getProject(), globalScope.getNdkHandler(), globalScope.getExtension().getPackagingOptions().getDoNotStrip(), scope.getVariantConfiguration().getType() == VariantType.LIBRARY));
    }

    public void createUnitTestVariantTasks(TestVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        BaseVariantData testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData(), (Object)"Not a unit test variant");
        VariantScope testedVariantScope = testedVariantData.getScope();
        this.createPreBuildTasks(variantScope);
        this.createDependencyStreams(variantScope);
        this.createProcessJavaResTask(variantScope);
        this.createCompileAnchorTask(variantScope);
        if (this.extension.getTestOptions().getUnitTests().isIncludeAndroidResources()) {
            File unitTestConfigDir = new File(this.globalScope.getIntermediatesDir(), "unitTestConfig/" + variantData.getVariantConfiguration().getDirName());
            GenerateTestConfig generateTestConfig = this.taskFactory.create(new GenerateTestConfig.ConfigAction(variantScope, unitTestConfigDir));
            variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.UNIT_TEST_CONFIG_DIRECTORY, unitTestConfigDir, generateTestConfig.getName());
            variantScope.getCompileTask().dependsOn(new Object[]{generateTestConfig});
        }
        Task compileTask = variantScope.getCompileTask();
        compileTask.dependsOn(new Object[]{variantScope.getProcessJavaResourcesTask(), testedVariantScope.getProcessJavaResourcesTask()});
        if (this.extension.getTestOptions().getUnitTests().isIncludeAndroidResources()) {
            compileTask.dependsOn(new Object[]{testedVariantScope.getMergeAssetsTask()});
            compileTask.dependsOn(new Object[]{testedVariantScope.getManifestProcessorTask()});
        }
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR, this.project.files(new Object[0]), null);
        JavaCompile javacTask = this.createJavacTask(variantScope);
        this.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask((Task)javacTask, variantScope);
        javacTask.dependsOn(new Object[]{testedVariantScope.getJavacTask()});
        this.createMergeJavaResTransform(variantScope);
        this.createRunUnitTestTask(variantScope);
        DefaultTask assembleUnitTests = variantScope.getAssembleTask();
        assembleUnitTests.dependsOn(new Object[]{this.createMockableJar});
        assembleUnitTests.setGroup(null);
    }

    protected void createSplitsDiscovery(VariantScope variantScope) {
        if (variantScope.getVariantData().getType().getCanHaveSplits()) {
            File splitListOutputFile = new File(new File(variantScope.getSplitSupportDirectory(), "split-list"), "split-list.gson");
            SplitsDiscovery splitsDiscoveryAndroidTask = this.taskFactory.create(new SplitsDiscovery.ConfigAction(variantScope, splitListOutputFile));
            variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.SPLIT_LIST, splitListOutputFile, splitsDiscoveryAndroidTask.getName());
        }
    }

    public void createAndroidTestVariantTasks(TestVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        this.createAnchorTasks(variantScope);
        this.createDependencyStreams(variantScope);
        this.taskFactory.create(new MainApkListPersistence.ConfigAction(variantScope));
        this.createProcessTestManifestTask(variantScope, ((BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData())).getScope());
        this.createGenerateResValuesTask(variantScope);
        this.createRenderscriptTask(variantScope);
        this.createMergeResourcesTask(variantScope, true);
        this.createShaderTask(variantScope);
        this.createMergeAssetsTask(variantScope);
        this.createBuildConfigTask(variantScope);
        this.createApkProcessResTask(variantScope);
        this.createProcessJavaResTask(variantScope);
        this.createAidlTask(variantScope);
        if (!this.isComponentModelPlugin()) {
            this.createNdkTasks(variantScope);
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.createMergeJniLibFoldersTasks(variantScope);
        this.createDataBindingTasksIfNecessary(variantScope, MergeType.MERGE);
        JavaCompile javacTask = this.createJavacTask(variantScope);
        this.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask((Task)javacTask, variantScope);
        this.createPostCompilationTasks(variantScope);
        this.createPackagingTask(variantScope, null);
        this.taskFactory.configure(ASSEMBLE_ANDROID_TEST, (Action<? super Task>)((Action)assembleTest -> assembleTest.dependsOn(new Object[]{variantData.getScope().getAssembleTask().getName()})));
        this.createConnectedTestForVariant(variantScope);
    }

    private static boolean isLintVariant(VariantScope variantScope) {
        VariantType variantType = variantScope.getVariantConfiguration().getType();
        return !variantType.isForTesting() && variantType != VariantType.FEATURE;
    }

    public void createLintTasks(VariantScope scope) {
        if (!TaskManager.isLintVariant(scope)) {
            return;
        }
        this.taskFactory.create(new LintPerVariantTask.ConfigAction(scope));
    }

    private String getTaskPath(String taskName) {
        return this.project.getRootProject() == this.project ? ':' + taskName : this.project.getPath() + ':' + taskName;
    }

    private void maybeCreateLintVitalTask(ApkVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        if (!TaskManager.isLintVariant(variantScope) || variantScope.getInstantRunBuildContext().isInInstantRunMode() || ((CoreBuildType)variantConfig.getBuildType()).isDebuggable() || !this.extension.getLintOptions().isCheckReleaseBuilds()) {
            return;
        }
        LintPerVariantTask lintReleaseCheck = this.taskFactory.create(new LintPerVariantTask.VitalConfigAction(variantScope));
        if (variantData.javacTask != null) {
            lintReleaseCheck.dependsOn(new Object[]{variantData.javacTask});
        }
        variantScope.getAssembleTask().dependsOn(new Object[]{lintReleaseCheck});
        this.project.getGradle().getTaskGraph().whenReady(taskGraph -> {
            if (taskGraph.hasTask(this.getTaskPath(LINT))) {
                this.project.getTasks().getByName(lintReleaseCheck.getName()).setEnabled(false);
            }
        });
    }

    private void createRunUnitTestTask(VariantScope variantScope) {
        AndroidUnitTest runTestsTask = this.taskFactory.create(new AndroidUnitTest.ConfigAction(variantScope));
        this.taskFactory.configure("test", (Action<? super Task>)((Action)test -> test.dependsOn(new Object[]{runTestsTask.getName()})));
    }

    public void createTopLevelTestTasks(boolean hasFlavors) {
        DefaultTask deviceAndroidTestTask;
        DefaultTask connectedAndroidTestTask;
        this.createMockableJarTask();
        this.createAttrFromAndroidJarTask();
        ArrayList reportTasks = Lists.newArrayListWithExpectedSize((int)2);
        List<DeviceProvider> providers = this.extension.getDeviceProviders();
        if (hasFlavors) {
            connectedAndroidTestTask = this.taskFactory.create(new AndroidReportTask.ConfigAction(this.globalScope, AndroidReportTask.ConfigAction.TaskKind.CONNECTED));
            reportTasks.add(connectedAndroidTestTask.getName());
        } else {
            connectedAndroidTestTask = this.taskFactory.create(CONNECTED_ANDROID_TEST, (Action<DefaultTask>)((Action)connectedTask -> {
                connectedTask.setGroup("verification");
                connectedTask.setDescription("Installs and runs instrumentation tests for all flavors on connected devices.");
            }));
        }
        this.taskFactory.configure(CONNECTED_CHECK, (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{connectedAndroidTestTask.getName()})));
        if (providers.size() > 1 || hasFlavors) {
            deviceAndroidTestTask = this.taskFactory.create(new AndroidReportTask.ConfigAction(this.globalScope, AndroidReportTask.ConfigAction.TaskKind.DEVICE_PROVIDER));
            reportTasks.add(deviceAndroidTestTask.getName());
        } else {
            deviceAndroidTestTask = this.taskFactory.create(DEVICE_ANDROID_TEST, (Action<DefaultTask>)((Action)providerTask -> {
                providerTask.setGroup("verification");
                providerTask.setDescription("Installs and runs instrumentation tests using all Device Providers.");
            }));
        }
        this.taskFactory.configure(DEVICE_CHECK, (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{deviceAndroidTestTask.getName()})));
        this.taskFactory.create("test", (Action<DefaultTask>)((Action)unitTestTask -> {
            unitTestTask.setGroup("verification");
            unitTestTask.setDescription("Run unit tests for all variants.");
        }));
        this.taskFactory.configure("check", (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{"test"})));
        if (!reportTasks.isEmpty() && this.project.getGradle().getStartParameter().isContinueOnFailure()) {
            this.project.getGradle().getTaskGraph().whenReady(taskGraph -> {
                for (String reportTask : reportTasks) {
                    if (!taskGraph.hasTask(this.getTaskPath(reportTask))) continue;
                    this.taskFactory.configure(reportTask, (Action<? super Task>)((Action)task -> ((AndroidReportTask)task).setWillRun()));
                }
            });
        }
    }

    protected void createConnectedTestForVariant(VariantScope variantScope) {
        BaseVariantData baseVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData());
        TestVariantData testVariantData = (TestVariantData)variantScope.getVariantData();
        boolean isLibrary = baseVariantData.getVariantConfiguration().getType() == VariantType.LIBRARY;
        TestDataImpl testData = new TestDataImpl(testVariantData, variantScope.getOutput(TaskOutputHolder.TaskOutputType.APK), isLibrary ? null : testVariantData.getTestedVariantData().getScope().getOutput(TaskOutputHolder.TaskOutputType.APK));
        testData.setExtraInstrumentationTestRunnerArgs(this.projectOptions.getExtraInstrumentationTestRunnerArgs());
        this.configureTestData(testData);
        ImmutableList artifactsTasks = ImmutableList.of((Object)variantScope.getAssembleTask(), (Object)testVariantData.getTestedVariantData().getScope().getAssembleTask());
        DeviceProviderInstrumentTestTask connectedTask = this.taskFactory.create(new DeviceProviderInstrumentTestTask.ConfigAction(testVariantData.getScope(), (DeviceProvider)new ConnectedDeviceProvider(this.sdkHandler.getSdkInfo().getAdb(), this.extension.getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.logger)), testData, (FileCollection)this.project.files(new Object[0])));
        connectedTask.dependsOn(artifactsTasks.toArray());
        variantScope.setConnectedTask(connectedTask);
        this.taskFactory.configure(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedAndroidTest -> connectedAndroidTest.dependsOn(new Object[]{connectedTask.getName()})));
        if (((CoreBuildType)baseVariantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled()) {
            Configuration jacocoAntConfiguration = JacocoConfigurations.getJacocoAntTaskConfiguration(this.project, this.getJacocoVersion(variantScope));
            Object reportTask = this.taskFactory.create(new JacocoReportTask.ConfigAction(variantScope, jacocoAntConfiguration));
            reportTask.dependsOn(new Object[]{connectedTask.getName()});
            variantScope.setCoverageReportTask((Task)reportTask);
            baseVariantData.getScope().getCoverageReportTask().dependsOn(new Object[]{reportTask});
            this.taskFactory.configure(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedAndroidTest -> connectedAndroidTest.dependsOn(new Object[]{reportTask.getName()})));
        }
        List<DeviceProvider> providers = this.extension.getDeviceProviders();
        for (DeviceProvider deviceProvider : providers) {
            DeviceProviderInstrumentTestTask providerTask = this.taskFactory.create(new DeviceProviderInstrumentTestTask.ConfigAction(testVariantData.getScope(), deviceProvider, testData, (FileCollection)this.project.files(new Object[0])));
            providerTask.dependsOn(artifactsTasks.toArray());
            this.taskFactory.configure(DEVICE_ANDROID_TEST, (Action<? super Task>)((Action)deviceAndroidTest -> deviceAndroidTest.dependsOn(new Object[]{providerTask.getName()})));
        }
        List<TestServer> servers = this.extension.getTestServers();
        for (TestServer testServer : servers) {
            TestServerTask serverTask = this.taskFactory.create(new TestServerTask.TestServerTaskConfigAction(variantScope, testServer));
            serverTask.dependsOn(new Object[]{variantScope.getAssembleTask()});
            this.taskFactory.configure(DEVICE_CHECK, (Action<? super Task>)((Action)deviceAndroidTest -> deviceAndroidTest.dependsOn(new Object[]{serverTask.getName()})));
        }
    }

    public void createPostCompilationTasks(VariantScope variantScope) {
        Optional<Object> multiDexClassListTask;
        DexingType dexingType;
        boolean isTestCoverageEnabled;
        Preconditions.checkNotNull((Object)variantScope.getJavacTask());
        BaseVariantData variantData = variantScope.getVariantData();
        GradleVariantConfiguration config = variantData.getVariantConfiguration();
        TransformManager transformManager = variantScope.getTransformManager();
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config.getBuildType()).isTestCoverageEnabled() && !config.getType().isForTesting() && !variantScope.getInstantRunBuildContext().isInInstantRunMode();
        if (isTestCoverageEnabled) {
            this.createJacocoTransform(variantScope);
        }
        this.maybeCreateDesugarTask(variantScope, config.getMinSdkVersion(), transformManager);
        AndroidConfig extension = variantScope.getGlobalScope().getExtension();
        this.createMergeJavaResTransform(variantScope);
        List<Transform> customTransforms = extension.getTransforms();
        List<List<Object>> customTransformsDependencies = extension.getTransformsDependencies();
        int count = customTransforms.size();
        for (int i = 0; i < count; ++i) {
            Transform transform2 = customTransforms.get(i);
            List<Object> deps = customTransformsDependencies.get(i);
            transformManager.addTransform(this.taskFactory, variantScope, transform2).ifPresent(t -> {
                if (!deps.isEmpty()) {
                    t.dependsOn(new Object[]{deps});
                }
                if (transform2.getScopes().isEmpty()) {
                    variantScope.getAssembleTask().dependsOn(new Object[]{t});
                }
            });
        }
        for (String jar2 : TaskManager.getAdvancedProfilingTransforms(this.projectOptions)) {
            if (!((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable() || !variantData.getType().equals((Object)VariantType.DEFAULT) || jar2 == null) continue;
            transformManager.addTransform(this.taskFactory, variantScope, new CustomClassTransform(jar2));
        }
        this.maybeCreateJavaCodeShrinkerTransform(variantScope);
        this.maybeCreateResourcesShrinkerTransform(variantScope);
        PreColdSwapTask preColdSwapTask = null;
        if (variantScope.getInstantRunBuildContext().isInInstantRunMode()) {
            DefaultTask allActionsAnchorTask = this.createInstantRunAllActionsTasks(variantScope);
            assert (variantScope.getInstantRunTaskManager() != null);
            preColdSwapTask = variantScope.getInstantRunTaskManager().createPreColdswapTask(this.projectOptions);
            preColdSwapTask.dependsOn(new Object[]{allActionsAnchorTask});
            extension.getDexOptions().setPreDexLibraries(true);
            variantScope.getInstantRunTaskManager().createSlicerTask();
            extension.getDexOptions().setJumboMode(true);
        }
        if ((dexingType = variantScope.getDexingType()) == DexingType.LEGACY_MULTIDEX && variantScope.getVariantConfiguration().isMultiDexEnabled() && variantScope.getVariantConfiguration().getMinSdkVersionWithTargetDeviceApi().getFeatureLevel() >= 21) {
            dexingType = DexingType.NATIVE_MULTIDEX;
        }
        if (dexingType == DexingType.LEGACY_MULTIDEX) {
            boolean proguardInPipeline;
            boolean bl2 = proguardInPipeline = variantScope.getCodeShrinker() == CodeShrinker.PROGUARD;
            if (!proguardInPipeline && !this.usingIncrementalDexing(variantScope)) {
                JarMergingTransform jarMergingTransform = new JarMergingTransform(TransformManager.SCOPE_FULL_PROJECT);
                transformManager.addTransform(this.taskFactory, variantScope, jarMergingTransform).ifPresent(variantScope::addColdSwapBuildTask);
            }
            Object multiDexTransform = this.usingIncrementalDexing(variantScope) ? (this.projectOptions.get(BooleanOption.ENABLE_D8_MAIN_DEX_LIST) ? new D8MainDexListTransform(variantScope) : new MainDexListTransform(variantScope, extension.getDexOptions())) : new MultiDexTransform(variantScope, extension.getDexOptions());
            multiDexClassListTask = transformManager.addTransform(this.taskFactory, variantScope, multiDexTransform);
            multiDexClassListTask.ifPresent(variantScope::addColdSwapBuildTask);
        } else {
            multiDexClassListTask = Optional.empty();
        }
        if (this.usingIncrementalDexing(variantScope)) {
            this.createNewDexTasks(variantScope, multiDexClassListTask.orElse(null), dexingType);
        } else {
            this.createDexTasks(variantScope, multiDexClassListTask.orElse(null), dexingType);
        }
        if (preColdSwapTask != null) {
            for (DefaultTask task : variantScope.getColdSwapBuildTasks()) {
                task.dependsOn(new Object[]{preColdSwapTask});
            }
        }
        File intermediatesDir = variantScope.getGlobalScope().getIntermediatesDir();
        this.createPipelineToPublishTask(variantScope, transformManager.getPipelineOutputAsFileCollection(StreamFilter.DEX), FileUtils.join((File)intermediatesDir, (String[])new String[]{"bundling", "dex"}), TaskOutputHolder.TaskOutputType.PUBLISHED_DEX);
        this.createPipelineToPublishTask(variantScope, transformManager.getPipelineOutputAsFileCollection(StreamFilter.RESOURCES), FileUtils.join((File)intermediatesDir, (String[])new String[]{"bundling", "java-res"}), TaskOutputHolder.TaskOutputType.PUBLISHED_JAVA_RES);
        this.createPipelineToPublishTask(variantScope, transformManager.getPipelineOutputAsFileCollection(StreamFilter.NATIVE_LIBS), FileUtils.join((File)intermediatesDir, (String[])new String[]{"bundling", "native-libs"}), TaskOutputHolder.TaskOutputType.PUBLISHED_NATIVE_LIBS);
    }

    private void createPipelineToPublishTask(VariantScope variantScope, FileCollection fileCollection, File outputFile, TaskOutputHolder.TaskOutputType outputType) {
        PipelineToPublicationTask task = this.taskFactory.create(new PipelineToPublicationTask.ConfigAction(variantScope, fileCollection, outputFile, outputType));
        variantScope.addTaskOutput(outputType, outputFile, task.getName());
    }

    private void maybeCreateDesugarTask(VariantScope variantScope, AndroidVersion minSdk, TransformManager transformManager) {
        if (variantScope.getJava8LangSupportType() == VariantScope.Java8LangSupport.DESUGAR) {
            FileCache userCache = this.getUserIntermediatesCache();
            FixStackFramesTransform fixFrames = new FixStackFramesTransform(() -> this.androidBuilder.getBootClasspath(true), System.getProperty("sun.boot.class.path"), userCache);
            transformManager.addTransform(this.taskFactory, variantScope, fixFrames);
            DesugarTransform desugarTransform = new DesugarTransform(() -> this.androidBuilder.getBootClasspath(true), System.getProperty("sun.boot.class.path"), userCache, minSdk.getFeatureLevel(), this.androidBuilder.getJavaProcessExecutor(), this.project.getLogger().isEnabled(LogLevel.INFO), this.projectOptions.get(BooleanOption.ENABLE_GRADLE_WORKERS), variantScope.getGlobalScope().getTmpFolder().toPath(), TaskManager.getProjectVariantId(variantScope), this.projectOptions.get(BooleanOption.ENABLE_INCREMENTAL_DESUGARING));
            transformManager.addTransform(this.taskFactory, variantScope, desugarTransform);
            if (minSdk.getFeatureLevel() < 19) {
                String taskName = variantScope.getTaskName("extractTryWithResourcesSupportJar");
                ExtractTryWithResourcesSupportJar extractTryWithResources = this.taskFactory.create(new ExtractTryWithResourcesSupportJar.ConfigAction(variantScope.getTryWithResourceRuntimeSupportJar(), taskName, variantScope.getFullVariantName()));
                variantScope.getTryWithResourceRuntimeSupportJar().builtBy(new Object[]{extractTryWithResources});
                transformManager.addStream(OriginalStream.builder(this.project, "runtime-deps-try-with-resources").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setFileCollection((FileCollection)variantScope.getTryWithResourceRuntimeSupportJar()).build());
            }
        }
    }

    private void createNewDexTasks(VariantScope variantScope, TransformTask multiDexClassListTask, DexingType dexingType) {
        DexOptions dexOptions;
        TransformManager transformManager = variantScope.getTransformManager();
        if (variantScope.getVariantData().getType().isForTesting()) {
            dexOptions = DefaultDexOptions.copyOf((com.android.builder.core.DexOptions)this.extension.getDexOptions());
            dexOptions.setAdditionalParameters((List)ImmutableList.of());
        } else {
            dexOptions = this.extension.getDexOptions();
        }
        boolean minified = this.runJavaCodeShrinker(variantScope);
        FileCache userLevelCache = this.getUserDexCache(minified, dexOptions.getPreDexLibraries());
        DexArchiveBuilderTransform preDexTransform = new DexArchiveBuilderTransformBuilder().setAndroidJarClasspath(() -> variantScope.getGlobalScope().getAndroidBuilder().getBootClasspath(false)).setDexOptions((com.android.builder.core.DexOptions)dexOptions).setMessageReceiver(variantScope.getGlobalScope().getMessageReceiver()).setUserLevelCache(userLevelCache).setMinSdkVersion(variantScope.getMinSdkVersion().getFeatureLevel()).setDexer(variantScope.getDexer()).setUseGradleWorkers(this.projectOptions.get(BooleanOption.ENABLE_GRADLE_WORKERS)).setInBufferSize(this.projectOptions.get(IntegerOption.DEXING_READ_BUFFER_SIZE)).setOutBufferSize(this.projectOptions.get(IntegerOption.DEXING_WRITE_BUFFER_SIZE)).setIsDebuggable(((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable()).setJava8LangSupportType(variantScope.getJava8LangSupportType()).setEnableIncrementalDesugaring(this.projectOptions.get(BooleanOption.ENABLE_INCREMENTAL_DESUGARING)).setProjectVariant(TaskManager.getProjectVariantId(variantScope)).createDexArchiveBuilderTransform();
        transformManager.addTransform(this.taskFactory, variantScope, preDexTransform).ifPresent(variantScope::addColdSwapBuildTask);
        boolean isDebuggable = ((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable();
        if (dexingType != DexingType.LEGACY_MULTIDEX && variantScope.getCodeShrinker() == null && this.extension.getTransforms().isEmpty()) {
            ExternalLibsMergerTransform externalLibsMergerTransform = new ExternalLibsMergerTransform(dexingType, variantScope.getDexMerger(), variantScope.getMinSdkVersion().getFeatureLevel(), isDebuggable, variantScope.getGlobalScope().getMessageReceiver(), DexMergerTransformCallable::new);
            transformManager.addTransform(this.taskFactory, variantScope, externalLibsMergerTransform);
        }
        DexMergerTransform dexTransform = new DexMergerTransform(dexingType, (FileCollection)(dexingType == DexingType.LEGACY_MULTIDEX ? this.project.files(new Object[]{variantScope.getMainDexListFile()}) : null), variantScope.getGlobalScope().getMessageReceiver(), variantScope.getDexMerger(), variantScope.getMinSdkVersion().getFeatureLevel(), isDebuggable);
        Optional<TransformTask> dexTask = transformManager.addTransform(this.taskFactory, variantScope, dexTransform);
        dexTask.ifPresent(t -> {
            if (multiDexClassListTask != null) {
                t.dependsOn(new Object[]{multiDexClassListTask});
            }
            variantScope.addColdSwapBuildTask((DefaultTask)t);
        });
    }

    private static String getProjectVariantId(VariantScope variantScope) {
        return variantScope.getGlobalScope().getProject().getName() + ":" + variantScope.getFullVariantName();
    }

    private boolean usingIncrementalDexing(VariantScope variantScope) {
        if (!this.projectOptions.get(BooleanOption.ENABLE_DEX_ARCHIVE)) {
            return false;
        }
        if (((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable()) {
            return true;
        }
        return this.projectOptions.get(BooleanOption.ENABLE_D8);
    }

    private FileCache getUserDexCache(boolean isMinifiedEnabled, boolean preDexLibraries) {
        if (!preDexLibraries || isMinifiedEnabled) {
            return null;
        }
        return this.getUserIntermediatesCache();
    }

    private FileCache getUserIntermediatesCache() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_INTERMEDIATE_ARTIFACTS_CACHE)) {
            return this.globalScope.getBuildCache();
        }
        return null;
    }

    private void createDexTasks(VariantScope variantScope, TransformTask multiDexClassListTask, DexingType dexingType) {
        boolean preDexEnabled;
        DexOptions dexOptions;
        TransformManager transformManager = variantScope.getTransformManager();
        AndroidBuilder androidBuilder = variantScope.getGlobalScope().getAndroidBuilder();
        if (variantScope.getVariantData().getType().isForTesting()) {
            dexOptions = DefaultDexOptions.copyOf((com.android.builder.core.DexOptions)this.extension.getDexOptions());
            dexOptions.setAdditionalParameters((List)ImmutableList.of());
        } else {
            dexOptions = this.extension.getDexOptions();
        }
        boolean cachePreDex = dexingType.isPreDex() && dexOptions.getPreDexLibraries() && !this.runJavaCodeShrinker(variantScope);
        boolean bl = preDexEnabled = variantScope.getInstantRunBuildContext().isInInstantRunMode() || cachePreDex;
        if (preDexEnabled) {
            FileCache buildCache = cachePreDex && this.projectOptions.get(BooleanOption.ENABLE_INTERMEDIATE_ARTIFACTS_CACHE) ? this.buildCache : null;
            PreDexTransform preDexTransform = new PreDexTransform((com.android.builder.core.DexOptions)dexOptions, androidBuilder, buildCache, dexingType, variantScope.getMinSdkVersion().getFeatureLevel());
            transformManager.addTransform(this.taskFactory, variantScope, preDexTransform).ifPresent(variantScope::addColdSwapBuildTask);
        }
        if (!preDexEnabled || dexingType != DexingType.NATIVE_MULTIDEX) {
            DexTransform dexTransform = new DexTransform((com.android.builder.core.DexOptions)dexOptions, dexingType, preDexEnabled, (FileCollection)this.project.files(new Object[]{variantScope.getMainDexListFile()}), (TargetInfo)Preconditions.checkNotNull((Object)androidBuilder.getTargetInfo(), (Object)"Target Info not set."), androidBuilder.getDexByteCodeConverter(), variantScope.getGlobalScope().getMessageReceiver(), variantScope.getMinSdkVersion().getFeatureLevel());
            Optional<TransformTask> dexTask = transformManager.addTransform(this.taskFactory, variantScope, dexTransform);
            dexTask.ifPresent(t -> {
                if (multiDexClassListTask != null) {
                    t.dependsOn(new Object[]{multiDexClassListTask});
                }
                variantScope.addColdSwapBuildTask((DefaultTask)t);
            });
        }
    }

    private boolean runJavaCodeShrinker(VariantScope variantScope) {
        return variantScope.getCodeShrinker() != null || this.isTestedAppObfuscated(variantScope);
    }

    protected boolean isTestedAppObfuscated(VariantScope variantScope) {
        return false;
    }

    private DefaultTask createInstantRunAllActionsTasks(VariantScope variantScope) {
        DefaultTask allActionAnchorTask = this.taskFactory.create(new InstantRunAnchorTaskConfigAction(variantScope));
        TransformManager transformManager = variantScope.getTransformManager();
        ExtractJarsTransform extractJarsTransform = new ExtractJarsTransform((Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES), (Set<QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.SUB_PROJECTS));
        Optional<TransformTask> extractJarsTask = transformManager.addTransform(this.taskFactory, variantScope, extractJarsTransform);
        InstantRunTaskManager instantRunTaskManager = new InstantRunTaskManager(this.getLogger(), variantScope, variantScope.getTransformManager(), this.taskFactory, this.recorder);
        FileCollection instantRunMergedManifests = variantScope.getOutput(TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS);
        variantScope.setInstantRunTaskManager(instantRunTaskManager);
        AndroidVersion minSdkForDx = variantScope.getMinSdkVersion();
        BuildInfoLoaderTask buildInfoLoaderTask = instantRunTaskManager.createInstantRunAllTasks((com.android.builder.core.DexOptions)variantScope.getGlobalScope().getExtension().getDexOptions(), () -> ((AndroidBuilder)this.androidBuilder).getDexByteCodeConverter(), extractJarsTask.orElse(null), (Task)allActionAnchorTask, this.getResMergingScopes(variantScope), instantRunMergedManifests, true, minSdkForDx.getFeatureLevel());
        if (variantScope.getSourceGenTask() != null) {
            variantScope.getSourceGenTask().dependsOn(new Object[]{buildInfoLoaderTask});
        }
        return allActionAnchorTask;
    }

    protected void handleJacocoDependencies(VariantScope variantScope) {
        boolean isTestCoverageEnabled;
        GradleVariantConfiguration config = variantScope.getVariantConfiguration();
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config.getBuildType()).isTestCoverageEnabled() && !variantScope.getInstantRunBuildContext().isInInstantRunMode() && (!config.getType().isForTesting() || config.getTestedConfig() != null && config.getTestedConfig().getType() == VariantType.LIBRARY);
        if (isTestCoverageEnabled) {
            if (variantScope.getDexer() == DexerTool.DX) {
                this.androidBuilder.getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, String.format("Jacoco version is downgraded to %s because dx is used. This is due to -P%s=false flag. See https://issuetracker.google.com/37116789 for more details.", "0.7.4.201502262128", BooleanOption.ENABLE_D8.getPropertyName()));
            }
            String jacocoAgentRuntimeDependency = JacocoConfigurations.getAgentRuntimeDependency(this.getJacocoVersion(variantScope));
            this.project.getDependencies().add(variantScope.getVariantDependencies().getRuntimeClasspath().getName(), (Object)jacocoAgentRuntimeDependency);
            variantScope.getVariantDependencies().getRuntimeClasspath().resolutionStrategy(r -> r.force(new Object[]{jacocoAgentRuntimeDependency}));
        }
    }

    public String getJacocoVersion(VariantScope scope) {
        if (scope.getDexer() == DexerTool.DX) {
            return "0.7.4.201502262128";
        }
        return this.extension.getJacoco().getVersion();
    }

    public void createJacocoTransform(VariantScope variantScope) {
        JacocoTransform jacocoTransform = new JacocoTransform(JacocoConfigurations.getJacocoAntTaskConfiguration(this.project, this.getJacocoVersion(variantScope)));
        variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, jacocoTransform);
    }

    private void createDataBindingMergeArtifactsTask(VariantScope variantScope) {
        BaseVariantData testedVariantData;
        boolean isTest;
        if (!this.extension.getDataBinding().isEnabled()) {
            return;
        }
        BaseVariantData variantData = variantScope.getVariantData();
        VariantType type = variantData.getType();
        boolean bl = isTest = type == VariantType.ANDROID_TEST || type == VariantType.UNIT_TEST;
        if (isTest && !this.extension.getDataBinding().isEnabledForTests() && (testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData())).getType() != VariantType.LIBRARY) {
            return;
        }
        File outFolder = new File(variantScope.getBuildFolderForDataBindingCompiler(), "dependent-lib-artifacts");
        Optional<TransformTask> dataBindingMergeTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, new DataBindingMergeArtifactsTransform(this.getLogger(), outFolder));
        dataBindingMergeTask.ifPresent(task -> variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_DEPENDENCY_ARTIFACTS, outFolder, task.getName()));
    }

    private void createDataBindingMergeBaseClassesTask(VariantScope variantScope) {
        BaseVariantData testedVariantData;
        boolean isTest;
        BaseVariantData variantData = variantScope.getVariantData();
        VariantType type = variantData.getType();
        boolean bl = isTest = type == VariantType.ANDROID_TEST || type == VariantType.UNIT_TEST;
        if (isTest && !this.extension.getDataBinding().isEnabledForTests() && (testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData())).getType() != VariantType.LIBRARY) {
            return;
        }
        File outFolder = variantScope.getIntermediateDir(TaskOutputHolder.TaskOutputType.DATA_BINDING_BASE_CLASS_LOGS_DEPENDENCY_ARTIFACTS);
        Optional<TransformTask> mergeBaseClassesTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, new DataBindingMergeGenClassLogTransform(this.getLogger(), outFolder));
        mergeBaseClassesTask.ifPresent(task -> variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_BASE_CLASS_LOGS_DEPENDENCY_ARTIFACTS, outFolder, task.getName()));
    }

    protected void createDataBindingTasksIfNecessary(VariantScope scope, MergeType mergeType) {
        BaseVariantData testedVariantData;
        boolean isTest;
        if (!this.extension.getDataBinding().isEnabled()) {
            return;
        }
        this.createDataBindingMergeBaseClassesTask(scope);
        this.createDataBindingMergeArtifactsTask(scope);
        VariantType type = scope.getVariantData().getType();
        boolean bl = isTest = type == VariantType.ANDROID_TEST || type == VariantType.UNIT_TEST;
        if (isTest && !this.extension.getDataBinding().isEnabledForTests() && (testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)scope.getTestedVariantData())).getType() != VariantType.LIBRARY) {
            return;
        }
        this.dataBindingBuilder.setDebugLogEnabled(this.getLogger().isDebugEnabled());
        DataBindingExportBuildInfoTask exportBuildInfo = this.taskFactory.create(new DataBindingExportBuildInfoTask.ConfigAction(scope, mergeType));
        exportBuildInfo.dependsOn(new Object[]{scope.getSourceGenTask()});
        scope.setDataBindingExportBuildInfoTask(exportBuildInfo);
        File baseClassOutFolder = new File(this.globalScope.getGeneratedDir(), "source/dataBinding/baseClasses/" + scope.getVariantConfiguration().getDirName());
        File baseClassLogFolder = scope.getIntermediateDir(TaskOutputHolder.TaskOutputType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT);
        DataBindingGenBaseClassesTask.ConfigAction genBaseClassConfigAction = new DataBindingGenBaseClassesTask.ConfigAction(scope, baseClassOutFolder, baseClassLogFolder);
        DataBindingGenBaseClassesTask generateBaseClasses = this.taskFactory.create(genBaseClassConfigAction);
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_BASE_CLASS_SOURCE_OUT, baseClassOutFolder, generateBaseClasses.getName());
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT, baseClassLogFolder, generateBaseClasses.getName());
        generateBaseClasses.dependsOn(new Object[]{scope.getVariantData().mergeResourcesTask});
        this.setDataBindingAnnotationProcessorParams(scope);
    }

    private void setDataBindingAnnotationProcessorParams(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        JavaCompileOptions javaCompileOptions = variantConfiguration.getJavaCompileOptions();
        com.android.build.gradle.api.AnnotationProcessorOptions processorOptions = javaCompileOptions.getAnnotationProcessorOptions();
        if (processorOptions instanceof AnnotationProcessorOptions) {
            boolean isTest;
            BaseVariantData artifactVariantData;
            AnnotationProcessorOptions ots = (AnnotationProcessorOptions)processorOptions;
            if (!ots.getClassNames().isEmpty() && !ots.getClassNames().contains("android.databinding.annotationprocessor.ProcessDataBinding")) {
                ots.className("android.databinding.annotationprocessor.ProcessDataBinding");
            }
            String packageName = variantConfiguration.getOriginalApplicationId();
            if (variantData.getType() == VariantType.ANDROID_TEST) {
                artifactVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)scope.getTestedVariantData());
                isTest = true;
            } else {
                artifactVariantData = variantData;
                isTest = false;
            }
            DataBindingCompilerArgs.Type type = artifactVariantData.getType() == VariantType.LIBRARY ? DataBindingCompilerArgs.Type.LIBRARY : DataBindingCompilerArgs.Type.APPLICATION;
            int minApi = variantConfiguration.getMinSdkVersion().getApiLevel();
            File classLogDir = scope.getOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT).getSingleFile();
            DataBindingCompilerArgs args = DataBindingCompilerArgs.builder().bundleFolder(scope.getBundleArtifactFolderForDataBinding()).enabledForTests(this.extension.getDataBinding().isEnabledForTests()).enableDebugLogs(this.getLogger().isDebugEnabled()).buildFolder(scope.getBuildFolderForDataBindingCompiler()).sdkDir(scope.getGlobalScope().getSdkHandler().getSdkFolder()).xmlOutDir(scope.getLayoutInfoOutputForDataBinding()).classLogDir(classLogDir).exportClassListTo(variantData.getType().isExportDataBindingClassList() ? scope.getGeneratedClassListOutputFileForDataBinding() : null).printEncodedErrorLogs(this.dataBindingBuilder.getPrintMachineReadableOutput()).modulePackage(packageName).minApi(minApi).testVariant(isTest).type(type).enableV2(scope.getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_DATA_BINDING_V2)).build();
            ots.arguments(args.toMap());
        } else {
            this.getLogger().error("Cannot setup data binding for %s because java compiler options is not an instance of AnnotationProcessorOptions", (Object)processorOptions);
        }
    }

    public void createPackagingTask(VariantScope variantScope, BuildInfoWriterTask fullBuildInfoGeneratorTask) {
        CoreSigningConfig signingConfig;
        ApkVariantData variantData = (ApkVariantData)variantScope.getVariantData();
        boolean signedApk = variantData.isSigned();
        TaskOutputHolder.TaskOutputType manifestType = variantScope.getInstantRunBuildContext().isInInstantRunMode() ? TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS : TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS;
        boolean splitsArePossible = variantScope.getVariantData().getMultiOutputPolicy() == MultiOutputPolicy.SPLITS;
        FileCollection manifests = variantScope.getOutput(manifestType);
        File finalApkLocation = variantScope.getApkLocation();
        File outputDirectory = splitsArePossible ? variantScope.getFullApkPackagesOutputDirectory() : finalApkLocation;
        TaskOutputHolder.TaskOutputType taskOutputType = splitsArePossible ? TaskOutputHolder.TaskOutputType.FULL_APK : TaskOutputHolder.TaskOutputType.APK;
        boolean useSeparateApkForResources = variantScope.getInstantRunBuildContext().useSeparateApkForResources();
        TaskOutputHolder.TaskOutputType resourceFilesInputType = variantScope.useResourceShrinker() ? TaskOutputHolder.TaskOutputType.SHRUNK_PROCESSED_RES : TaskOutputHolder.TaskOutputType.PROCESSED_RES;
        PackageApplication packageApp = this.taskFactory.create(new PackageApplication.StandardConfigAction(variantScope, outputDirectory, useSeparateApkForResources ? TaskOutputHolder.TaskOutputType.INSTANT_RUN_MAIN_APK_RESOURCES : resourceFilesInputType, manifests, manifestType, variantScope.getOutputScope(), this.globalScope.getBuildCache(), taskOutputType));
        variantScope.addTaskOutput(taskOutputType, outputDirectory, packageApp.getName());
        AndroidBuilderTask packageInstantRunResources = null;
        if (variantScope.getInstantRunBuildContext().isInInstantRunMode()) {
            if (useSeparateApkForResources) {
                packageInstantRunResources = this.taskFactory.create(new InstantRunResourcesApkBuilder.ConfigAction(resourceFilesInputType, variantScope.getOutput(resourceFilesInputType), variantScope));
                packageInstantRunResources.dependsOn(new Object[]{this.getValidateSigningTask(variantScope)});
            } else {
                packageInstantRunResources = this.taskFactory.create(new PackageApplication.InstantRunResourcesConfigAction(variantScope.getInstantRunResourcesFile(), variantScope, resourceFilesInputType, manifests, TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS, this.globalScope.getBuildCache(), variantScope.getOutputScope()));
            }
            packageApp.dependsOn(new Object[]{packageInstantRunResources});
        }
        Consumer<Task> configureResourcesAndAssetsDependencies = task -> {
            task.dependsOn(new Object[]{variantScope.getMergeAssetsTask()});
            if (variantScope.getProcessResourcesTask() != null) {
                task.dependsOn(new Object[]{variantScope.getProcessResourcesTask()});
            }
        };
        configureResourcesAndAssetsDependencies.accept((Task)packageApp);
        if (packageInstantRunResources != null) {
            configureResourcesAndAssetsDependencies.accept((Task)packageInstantRunResources);
        }
        if ((signingConfig = variantScope.getVariantConfiguration().getSigningConfig()) != null) {
            packageApp.dependsOn(new Object[]{this.getValidateSigningTask(variantScope)});
        }
        if (variantScope.getJavacTask() != null) {
            packageApp.dependsOn(new Object[]{variantScope.getJavacTask()});
        }
        if (variantData.packageSplitResourcesTask != null) {
            packageApp.dependsOn(new Object[]{variantData.packageSplitResourcesTask});
        }
        if (variantData.packageSplitAbiTask != null) {
            packageApp.dependsOn(new Object[]{variantData.packageSplitAbiTask});
        }
        if (variantScope.getJavacTask() != null) {
            packageApp.dependsOn(new Object[]{variantScope.getJavacTask()});
        }
        variantScope.setPackageApplicationTask(packageApp);
        variantScope.getAssembleTask().dependsOn(new Object[]{packageApp.getName()});
        Preconditions.checkState((variantScope.getAssembleTask() != null ? 1 : 0) != 0);
        if (fullBuildInfoGeneratorTask != null) {
            fullBuildInfoGeneratorTask.mustRunAfter(new Object[]{packageApp.getName()});
            if (packageInstantRunResources != null) {
                fullBuildInfoGeneratorTask.mustRunAfter(new Object[]{packageInstantRunResources});
            }
            variantScope.getAssembleTask().dependsOn(new Object[]{fullBuildInfoGeneratorTask.getName()});
        }
        if (splitsArePossible) {
            CopyOutputs copyOutputsTask = this.taskFactory.create(new CopyOutputs.ConfigAction(variantScope, finalApkLocation));
            variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.APK, finalApkLocation, copyOutputsTask.getName());
            variantScope.getAssembleTask().dependsOn(new Object[]{copyOutputsTask});
        }
        if (signedApk) {
            InstallVariantTask installTask = this.taskFactory.create(new InstallVariantTask.ConfigAction(variantScope));
            installTask.dependsOn(new Object[]{variantScope.getAssembleTask()});
        }
        this.maybeCreateLintVitalTask(variantData);
        UninstallTask uninstallTask = this.taskFactory.create(new UninstallTask.ConfigAction(variantScope));
        this.taskFactory.configure(UNINSTALL_ALL, (Action<? super Task>)((Action)uninstallAll -> uninstallAll.dependsOn(new Object[]{uninstallTask.getName()})));
    }

    protected Task getValidateSigningTask(VariantScope variantScope) {
        File defaultDebugKeystoreLocation = GradleKeystoreHelper.getDefaultDebugKeystoreLocation();
        ValidateSigningTask.ConfigAction configAction = new ValidateSigningTask.ConfigAction(variantScope, defaultDebugKeystoreLocation);
        Object validateSigningTask = this.taskFactory.findByName(configAction.getName());
        if (validateSigningTask == null) {
            validateSigningTask = this.taskFactory.create(configAction);
        }
        return validateSigningTask;
    }

    public DefaultTask createAssembleTask(BaseVariantData variantData) {
        return this.taskFactory.create(variantData.getScope().getTaskName("assemble"), (Action<DefaultTask>)((Action)task -> variantData.addTask(TaskContainer.TaskKind.ASSEMBLE, (Task)task)));
    }

    public DefaultTask createAssembleTask(VariantDimensionData dimensionData) {
        String sourceSetName = StringHelper.capitalize((String)dimensionData.getSourceSet().getName());
        return this.taskFactory.create("assemble" + sourceSetName, (Action<DefaultTask>)((Action)assembleTask -> {
            assembleTask.setDescription("Assembles all " + sourceSetName + " builds.");
            assembleTask.setGroup(BUILD_GROUP);
        }));
    }

    protected void maybeCreateJavaCodeShrinkerTransform(VariantScope variantScope) {
        CodeShrinker codeShrinker = variantScope.getCodeShrinker();
        if (codeShrinker != null) {
            this.doCreateJavaCodeShrinkerTransform(variantScope, codeShrinker, null);
        }
    }

    protected final void doCreateJavaCodeShrinkerTransform(VariantScope variantScope, CodeShrinker codeShrinker, FileCollection mappingFileCollection) {
        Optional<TransformTask> transformTask;
        switch (codeShrinker) {
            case PROGUARD: {
                transformTask = this.createProguardTransform(variantScope, mappingFileCollection);
                break;
            }
            case ANDROID_GRADLE: {
                transformTask = this.createBuiltInShrinkerTransform(variantScope);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown value " + (Object)((Object)codeShrinker)));
            }
        }
        if (variantScope.getPostprocessingFeatures() != null && transformTask.isPresent()) {
            CheckProguardFiles checkFilesTask = this.taskFactory.create(new CheckProguardFiles.ConfigAction(variantScope));
            transformTask.get().dependsOn(new Object[]{checkFilesTask});
        }
    }

    private Optional<TransformTask> createBuiltInShrinkerTransform(VariantScope scope) {
        BuiltInShrinkerTransform transform2 = new BuiltInShrinkerTransform(scope);
        this.applyProguardConfig(transform2, scope);
        if (scope.getInstantRunBuildContext().isInInstantRunMode()) {
            transform2.keep("class ** extends android.app.Application {*;}");
            transform2.keep("class com.android.tools.ir.** {*;}");
        }
        return scope.getTransformManager().addTransform(this.taskFactory, scope, transform2);
    }

    private Optional<TransformTask> createProguardTransform(VariantScope variantScope, FileCollection mappingFileCollection) {
        if (variantScope.getInstantRunBuildContext().isInInstantRunMode()) {
            this.logger.warn("ProGuard is disabled for variant {} because it is not compatible with Instant Run. See http://d.android.com/r/studio-ui/shrink-code-with-ir.html for details on how to enable a code shrinker that's compatible with Instant Run.", (Object)variantScope.getVariantConfiguration().getFullName());
            return Optional.empty();
        }
        BaseVariantData testedVariantData = variantScope.getTestedVariantData();
        ProGuardTransform transform2 = new ProGuardTransform(variantScope);
        if (testedVariantData != null) {
            TaskManager.applyProguardDefaultsForTest(transform2);
            Object[] objectArray = new Object[2];
            objectArray[0] = TaskInputHelper.bypassFileCallable(testedVariantData.getScope()::getTestProguardFiles);
            objectArray[1] = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROGUARD_RULES);
            transform2.setConfigurationFiles((FileCollection)this.project.files(objectArray));
            VariantScope testedScope = testedVariantData.getScope();
            transform2.applyTestedMapping(testedScope.hasOutput(TaskOutputHolder.TaskOutputType.APK_MAPPING) ? testedScope.getOutput(TaskOutputHolder.TaskOutputType.APK_MAPPING) : null);
        } else if (this.isTestedAppObfuscated(variantScope)) {
            TaskManager.applyProguardDefaultsForTest(transform2);
            Object[] objectArray = new Object[2];
            objectArray[0] = TaskInputHelper.bypassFileCallable(variantScope::getTestProguardFiles);
            objectArray[1] = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROGUARD_RULES);
            transform2.setConfigurationFiles((FileCollection)this.project.files(objectArray));
            transform2.applyTestedMapping(mappingFileCollection);
        } else {
            this.applyProguardConfig(transform2, variantScope);
            if (mappingFileCollection != null) {
                transform2.applyTestedMapping(mappingFileCollection);
            }
        }
        Optional<TransformTask> task = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, transform2);
        task.ifPresent(t -> {
            variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.APK_MAPPING, Preconditions.checkNotNull((Object)transform2.getMappingFile()), t.getName());
            if (mappingFileCollection != null) {
                t.dependsOn(new Object[]{mappingFileCollection});
            }
            if (testedVariantData != null) {
                t.dependsOn(new Object[]{testedVariantData.getScope().getAssembleTask()});
            }
        });
        return task;
    }

    private static void applyProguardDefaultsForTest(ProGuardTransform transform2) {
        transform2.setActions(new PostprocessingFeatures(false, true, false));
        transform2.keep("class * {*;}");
        transform2.keep("interface * {*;}");
        transform2.keep("enum * {*;}");
        transform2.keepattributes();
    }

    protected void maybeCreateResourcesShrinkerTransform(VariantScope scope) {
        if (!scope.useResourceShrinker()) {
            return;
        }
        File shrinkerOutput = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res_stripped", scope.getVariantConfiguration().getDirName()});
        ShrinkResourcesTransform shrinkResTransform = new ShrinkResourcesTransform(scope.getVariantData(), scope.getOutput(TaskOutputHolder.TaskOutputType.PROCESSED_RES), shrinkerOutput, AaptGeneration.fromProjectOptions(this.projectOptions), this.logger);
        Optional<TransformTask> shrinkTask = scope.getTransformManager().addTransform(this.taskFactory, scope, shrinkResTransform);
        if (shrinkTask.isPresent()) {
            scope.addTaskOutput(TaskOutputHolder.TaskOutputType.SHRUNK_PROCESSED_RES, shrinkerOutput, shrinkTask.get().getName());
        } else {
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "Internal error, could not add the ShrinkResourcesTransform");
        }
    }

    private void applyProguardConfig(ProguardConfigurable transform2, VariantScope scope) {
        GradleVariantConfiguration variantConfig = scope.getVariantConfiguration();
        PostprocessingFeatures postprocessingFeatures = scope.getPostprocessingFeatures();
        if (postprocessingFeatures != null) {
            transform2.setActions(postprocessingFeatures);
        }
        Supplier<Collection<File>> proguardConfigFiles = () -> {
            HashSet proguardFiles = Sets.newHashSet(scope.getProguardFiles());
            proguardFiles.add(scope.getProcessAndroidResourcesProguardOutputFile());
            return proguardFiles;
        };
        transform2.setConfigurationFiles((FileCollection)this.project.files(new Object[]{TaskInputHelper.bypassFileCallable(proguardConfigFiles), scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROGUARD_RULES)}));
        if (scope.getVariantData().getType() == VariantType.LIBRARY) {
            transform2.keep("class **.R");
            transform2.keep("class **.R$*");
        }
        if (variantConfig.isTestCoverageEnabled()) {
            transform2.keep("class com.vladium.** {*;}");
            transform2.keep("class org.jacoco.** {*;}");
            transform2.keep("interface org.jacoco.** {*;}");
            transform2.dontwarn("org.jacoco.**");
        }
    }

    public void createReportTasks(List<VariantScope> variantScopes) {
        this.taskFactory.create("androidDependencies", DependencyReportTask.class, task -> {
            task.setDescription("Displays the Android dependencies of the project.");
            task.setVariants(variantScopes);
            task.setGroup(ANDROID_GROUP);
        });
        this.taskFactory.create("signingReport", SigningReportTask.class, task -> {
            task.setDescription("Displays the signing info for each variant.");
            task.setVariants(variantScopes);
            task.setGroup(ANDROID_GROUP);
        });
    }

    public void createAnchorTasks(VariantScope scope) {
        this.createPreBuildTasks(scope);
        BaseVariantData variantData = scope.getVariantData();
        scope.setSourceGenTask(this.taskFactory.create(scope.getTaskName("generate", "Sources"), Task.class, task -> {
            variantData.sourceGenTask = task;
            task.dependsOn(new Object[]{"prepareLintJar"});
        }));
        scope.setResourceGenTask(this.taskFactory.create(scope.getTaskName("generate", "Resources"), Task.class, task -> {
            variantData.resourceGenTask = task;
        }));
        scope.setAssetGenTask(this.taskFactory.create(scope.getTaskName("generate", "Assets"), Task.class, task -> {
            variantData.assetGenTask = task;
        }));
        if (!variantData.getType().isForTesting() && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled()) {
            scope.setCoverageReportTask(this.taskFactory.create(scope.getTaskName("create", "CoverageReport"), Task.class, task -> {
                task.setGroup("verification");
                task.setDescription(String.format("Creates test coverage reports for the %s variant.", variantData.getName()));
            }));
        }
        this.createCompileAnchorTask(scope);
    }

    protected DefaultTask createVariantPreBuildTask(VariantScope scope) {
        return this.createDefaultPreBuildTask(scope);
    }

    protected DefaultTask createDefaultPreBuildTask(VariantScope scope) {
        return this.taskFactory.create(scope.getTaskName("pre", "Build"), (Action<DefaultTask>)((Action)task -> {
            scope.getVariantData().preBuildTask = task;
        }));
    }

    private void createPreBuildTasks(VariantScope scope) {
        scope.setPreBuildTask(this.createVariantPreBuildTask(scope));
        scope.getPreBuildTask().dependsOn(new Object[]{MAIN_PREBUILD});
        if (this.runJavaCodeShrinker(scope)) {
            scope.getPreBuildTask().dependsOn(new Object[]{EXTRACT_PROGUARD_FILES});
        }
    }

    private void createCompileAnchorTask(final VariantScope scope) {
        final BaseVariantData variantData = scope.getVariantData();
        scope.setCompileTask(this.taskFactory.create(new TaskConfigAction<Task>(){

            @Override
            public String getName() {
                return scope.getTaskName("compile", "Sources");
            }

            @Override
            public Class<Task> getType() {
                return Task.class;
            }

            @Override
            public void execute(Task task) {
                variantData.compileTask = task;
                variantData.compileTask.setGroup(TaskManager.BUILD_GROUP);
            }
        }));
        scope.getAssembleTask().dependsOn(new Object[]{scope.getCompileTask()});
    }

    public void createCheckManifestTask(VariantScope scope) {
        scope.setCheckManifestTask(this.taskFactory.create(this.getCheckManifestConfig(scope)));
        scope.getCheckManifestTask().dependsOn(new Object[]{scope.getPreBuildTask()});
    }

    protected CheckManifest.ConfigAction getCheckManifestConfig(VariantScope scope) {
        return new CheckManifest.ConfigAction(scope, false);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void addDataBindingDependenciesIfNecessary(DataBindingOptions options, List<VariantScope> variantScopes) {
        if (!options.isEnabled()) {
            return;
        }
        String version = (String)MoreObjects.firstNonNull((Object)options.getVersion(), (Object)this.dataBindingBuilder.getCompilerVersion());
        this.project.getDependencies().add("api", (Object)("com.android.databinding:baseLibrary:" + this.dataBindingBuilder.getBaseLibraryVersion(version)));
        this.project.getDependencies().add("annotationProcessor", (Object)("com.android.databinding:compiler:" + version));
        if (options.isEnabledForTests() || this instanceof LibraryTaskManager) {
            this.project.getDependencies().add("androidTestAnnotationProcessor", (Object)("com.android.databinding:compiler:" + version));
        }
        if (options.getAddDefaultAdapters()) {
            this.project.getDependencies().add("api", (Object)("com.android.databinding:library:" + this.dataBindingBuilder.getLibraryVersion(version)));
            this.project.getDependencies().add("api", (Object)("com.android.databinding:adapters:" + this.dataBindingBuilder.getBaseAdaptersVersion(version)));
        }
        this.project.getPluginManager().withPlugin("org.jetbrains.kotlin.kapt", appliedPlugin -> this.configureKotlinKaptTasksForDataBinding(this.project, variantScopes, version));
    }

    private void configureKotlinKaptTasksForDataBinding(Project project, List<VariantScope> variantScopes, String version) {
        DependencySet kaptDeps = project.getConfigurations().getByName("kapt").getAllDependencies();
        kaptDeps.forEach(dependency -> {
            if (Objects.equals(dependency.getGroup() + ":" + dependency.getName(), "com.android.databinding:compiler") && !Objects.equals(dependency.getVersion(), version)) {
                String depString = dependency.getGroup() + ":" + dependency.getName() + ":" + dependency.getVersion();
                this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "Data Binding annotation processor version needs to match the Android Gradle Plugin version. You can remove the kapt dependency " + depString + " and Android Gradle Plugin will inject the right version.");
            }
        });
        project.getDependencies().add("kapt", (Object)("com.android.databinding:compiler:" + version));
        Class<?> kaptTaskClass = null;
        try {
            kaptTaskClass = Class.forName("org.jetbrains.kotlin.gradle.internal.KaptTask");
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Kotlin plugin is applied to the project " + project.getPath() + " but we cannot find the KaptTask. Make sure you apply the kotlin-kapt plugin because it is necessary to use kotlin with data binding.");
        }
        if (kaptTaskClass == null) {
            return;
        }
        Map<String, VariantScope> kaptTaskLookup = variantScopes.stream().collect(Collectors.toMap(variantScope -> variantScope.getVariantData().getTaskName("kapt", "Kotlin"), variantScope -> variantScope));
        project.getTasks().withType(kaptTaskClass, kaptTask -> {
            VariantScope matchingScope = (VariantScope)kaptTaskLookup.get(kaptTask.getName());
            if (matchingScope != null) {
                TaskManager.configureKaptTaskInScope(matchingScope, kaptTask);
            }
        });
    }

    private static void configureKaptTaskInScope(VariantScope scope, Task kaptTask) {
        if (scope.hasOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_DEPENDENCY_ARTIFACTS)) {
            kaptTask.getInputs().files(new Object[]{scope.getOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_DEPENDENCY_ARTIFACTS)}).withPathSensitivity(PathSensitivity.RELATIVE).withPropertyName("dataBindingDependencyArtifacts");
        }
        if (scope.hasOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT)) {
            kaptTask.getInputs().files(new Object[]{scope.getOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT)}).withPathSensitivity(PathSensitivity.RELATIVE).withPropertyName("dataBindingClassLogDir");
        }
        kaptTask.getOutputs().files(new Object[]{scope.getBundleArtifactFolderForDataBinding()}).withPropertyName("dataBindingArtifactOutputDir");
        if (!scope.hasOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_ARTIFACT)) {
            scope.addTaskOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_ARTIFACT, scope.getBundleArtifactFolderForDataBinding(), kaptTask.getName());
        }
    }

    protected void configureTestData(AbstractTestDataImpl testData) {
        testData.setAnimationsDisabled(this.extension.getTestOptions().getAnimationsDisabled());
    }

    public static enum MergeType {
        MERGE{

            @Override
            public TaskOutputHolder.TaskOutputType getOutputType() {
                return TaskOutputHolder.TaskOutputType.MERGED_RES;
            }
        }
        ,
        PACKAGE{

            @Override
            public TaskOutputHolder.TaskOutputType getOutputType() {
                return TaskOutputHolder.TaskOutputType.PACKAGED_RES;
            }
        };


        public abstract TaskOutputHolder.TaskOutputType getOutputType();
    }

    public static class ConfigAttrTask
    extends DefaultTask {
        boolean consumable = false;
        boolean resolvable = false;

        @TaskAction
        public void run() {
            for (Configuration config : this.getProject().getConfigurations()) {
                AttributeContainer attributes2 = config.getAttributes();
                if ((!this.consumable || !config.isCanBeConsumed()) && (!this.resolvable || !config.isCanBeResolved())) continue;
                System.out.println(config.getName());
                System.out.println("\tcanBeResolved: " + config.isCanBeResolved());
                System.out.println("\tcanBeConsumed: " + config.isCanBeConsumed());
                for (Attribute attr : attributes2.keySet()) {
                    System.out.println("\t" + attr.getName() + ": " + attributes2.getAttribute(attr));
                }
                if (!this.consumable || !config.isCanBeConsumed()) continue;
                for (PublishArtifact artifact : config.getArtifacts()) {
                    System.out.println("\tArtifact: " + artifact.getName() + " (" + artifact.getFile().getName() + ")");
                }
                for (ConfigurationVariant cv : config.getOutgoing().getVariants()) {
                    System.out.println("\tConfigurationVariant: " + cv.getName());
                    for (PublishArtifact pa : cv.getArtifacts()) {
                        System.out.println("\t\tArtifact: " + pa.getFile());
                        System.out.println("\t\tType:" + pa.getType());
                    }
                }
            }
        }
    }
}

