/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.json;

import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonStreamingParser;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;

public class AndroidBuildGradleJsons {
    public static NativeBuildConfigValueMini parseToMiniConfig(JsonReader reader) throws IOException {
        try (MiniConfigBuildingParser parser = new MiniConfigBuildingParser(reader);){
            parser.parse();
            NativeBuildConfigValueMini nativeBuildConfigValueMini = parser.miniConfig;
            return nativeBuildConfigValueMini;
        }
    }

    public static NativeBuildConfigValueMini getNativeBuildMiniConfig(File json) throws IOException {
        NativeBuildConfigValueMini result;
        File persistedMiniConfig = ExternalNativeBuildTaskUtils.getJsonMiniConfigFile(json);
        if (ExternalNativeBuildTaskUtils.fileIsUpToDate(json, persistedMiniConfig)) {
            try (JsonReader reader = new JsonReader((Reader)new FileReader(persistedMiniConfig));){
                NativeBuildConfigValueMini nativeBuildConfigValueMini = AndroidBuildGradleJsons.parseToMiniConfig(reader);
                return nativeBuildConfigValueMini;
            }
        }
        try (JsonReader reader = new JsonReader((Reader)new FileReader(json));){
            result = AndroidBuildGradleJsons.parseToMiniConfig(reader);
        }
        AndroidBuildGradleJsons.writeNativeBuildMiniConfigValueToJsonFile(persistedMiniConfig, result);
        return result;
    }

    public static List<NativeBuildConfigValueMini> getNativeBuildMiniConfigs(List<File> jsons) throws IOException {
        ArrayList miniConfigs = Lists.newArrayList();
        for (File json : jsons) {
            miniConfigs.add(AndroidBuildGradleJsons.getNativeBuildMiniConfig(json));
        }
        return miniConfigs;
    }

    public static void writeNativeBuildConfigValueToJsonFile(File outputJson, NativeBuildConfigValue nativeBuildConfigValue) throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).disableHtmlEscaping().setPrettyPrinting().create();
        try (FileWriter jsonWriter = new FileWriter(outputJson);){
            gson.toJson((Object)nativeBuildConfigValue, (Appendable)jsonWriter);
        }
    }

    private static void writeNativeBuildMiniConfigValueToJsonFile(File outputJson, NativeBuildConfigValueMini miniConfig) throws IOException {
        String actualResult = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).setPrettyPrinting().create().toJson((Object)miniConfig);
        Files.write(outputJson.toPath(), actualResult.getBytes(Charsets.UTF_8), new OpenOption[0]);
    }

    private static class MiniConfigBuildingParser
    extends AndroidBuildGradleJsonStreamingParser {
        private final NativeBuildConfigValueMini miniConfig = new NativeBuildConfigValueMini();
        private String libraryName = null;

        MiniConfigBuildingParser(JsonReader reader) {
            super(reader);
        }

        @Override
        protected void beginLibrary(String libraryName) {
            this.libraryName = libraryName;
            this.miniConfig.libraries.put(libraryName, new NativeLibraryValueMini());
        }

        @Override
        protected void visitLibraryAbi(String abi) {
            this.miniConfig.libraries.get((Object)this.libraryName).abi = abi;
        }

        @Override
        protected void visitLibraryArtifactName(String artifactName) {
            this.miniConfig.libraries.get((Object)this.libraryName).artifactName = artifactName;
        }

        @Override
        protected void visitLibraryBuildCommand(String buildCommand) {
            this.miniConfig.libraries.get((Object)this.libraryName).buildCommand = buildCommand;
        }

        @Override
        protected void visitCleanCommands(String cleanCommand) {
            this.miniConfig.cleanCommands.add(cleanCommand);
        }

        @Override
        protected void visitLibraryOutput(String output) {
            this.miniConfig.libraries.get((Object)this.libraryName).output = new File(output);
        }

        @Override
        protected void visitBuildFile(String buildFile) {
            this.miniConfig.buildFiles.add(new File(buildFile));
        }
    }
}

