/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceFile;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceFile;
import com.android.builder.model.SourceProvider;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

public class DefaultAndroidSourceSet
implements AndroidSourceSet,
SourceProvider {
    private final String name;
    private final boolean publishPackage;
    private final AndroidSourceDirectorySet javaSource;
    private final AndroidSourceDirectorySet javaResources;
    private final AndroidSourceFile manifest;
    private final AndroidSourceDirectorySet assets;
    private final AndroidSourceDirectorySet res;
    private final AndroidSourceDirectorySet aidl;
    private final AndroidSourceDirectorySet renderscript;
    private final AndroidSourceDirectorySet jni;
    private final AndroidSourceDirectorySet jniLibs;
    private final AndroidSourceDirectorySet shaders;
    private final String displayName;

    @Inject
    public DefaultAndroidSourceSet(String name, Project project, boolean publishPackage) {
        this.name = name;
        this.publishPackage = publishPackage;
        this.displayName = GUtil.toWords((CharSequence)this.name);
        String javaSrcDisplayName = this.displayName + " Java source";
        this.javaSource = new DefaultAndroidSourceDirectorySet(javaSrcDisplayName, project);
        this.javaSource.getFilter().include(new String[]{"**/*.java"});
        String javaResourcesDisplayName = this.displayName + " Java resources";
        this.javaResources = new DefaultAndroidSourceDirectorySet(javaResourcesDisplayName, project);
        this.javaResources.getFilter().exclude(new String[]{"**/*.java"});
        String manifestDisplayName = this.displayName + " manifest";
        this.manifest = new DefaultAndroidSourceFile(manifestDisplayName, project);
        String assetsDisplayName = this.displayName + " assets";
        this.assets = new DefaultAndroidSourceDirectorySet(assetsDisplayName, project);
        String resourcesDisplayName = this.displayName + " resources";
        this.res = new DefaultAndroidSourceDirectorySet(resourcesDisplayName, project);
        String aidlDisplayName = this.displayName + " aidl";
        this.aidl = new DefaultAndroidSourceDirectorySet(aidlDisplayName, project);
        String renderscriptDisplayName = this.displayName + " renderscript";
        this.renderscript = new DefaultAndroidSourceDirectorySet(renderscriptDisplayName, project);
        String jniDisplayName = this.displayName + " jni";
        this.jni = new DefaultAndroidSourceDirectorySet(jniDisplayName, project);
        String libsDisplayName = this.displayName + " jniLibs";
        this.jniLibs = new DefaultAndroidSourceDirectorySet(libsDisplayName, project);
        String shaderDisplayName = this.displayName + " shaders";
        this.shaders = new DefaultAndroidSourceDirectorySet(shaderDisplayName, project);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "source set " + this.getDisplayName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getApiConfigurationName() {
        if (this.name.equals("main")) {
            return "api";
        }
        return this.name + "Api";
    }

    @Override
    public String getCompileOnlyConfigurationName() {
        if (this.name.equals("main")) {
            return "compileOnly";
        }
        return this.name + "CompileOnly";
    }

    @Override
    public String getImplementationConfigurationName() {
        if (this.name.equals("main")) {
            return "implementation";
        }
        return this.name + "Implementation";
    }

    @Override
    public String getRuntimeOnlyConfigurationName() {
        if (this.name.equals("main")) {
            return "runtimeOnly";
        }
        return this.name + "RuntimeOnly";
    }

    @Override
    public String getCompileConfigurationName() {
        if (this.name.equals("main")) {
            return "compile";
        }
        return this.name + "Compile";
    }

    @Override
    public String getPackageConfigurationName() {
        if (this.publishPackage) {
            if (this.name.equals("main")) {
                return "publish";
            }
            return this.name + "Publish";
        }
        if (this.name.equals("main")) {
            return "apk";
        }
        return this.name + "Apk";
    }

    @Override
    public String getProvidedConfigurationName() {
        if (this.name.equals("main")) {
            return "provided";
        }
        return this.name + "Provided";
    }

    @Override
    public String getWearAppConfigurationName() {
        if (this.name.equals("main")) {
            return "wearApp";
        }
        return this.name + "WearApp";
    }

    @Override
    public String getAnnotationProcessorConfigurationName() {
        if (this.name.equals("main")) {
            return "annotationProcessor";
        }
        return this.name + "AnnotationProcessor";
    }

    @Override
    public AndroidSourceFile getManifest() {
        return this.manifest;
    }

    @Override
    public AndroidSourceSet manifest(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getManifest());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getRes() {
        return this.res;
    }

    @Override
    public AndroidSourceSet res(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRes());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getAssets() {
        return this.assets;
    }

    @Override
    public AndroidSourceSet assets(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAssets());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getAidl() {
        return this.aidl;
    }

    @Override
    public AndroidSourceSet aidl(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAidl());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getRenderscript() {
        return this.renderscript;
    }

    @Override
    public AndroidSourceSet renderscript(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRenderscript());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getJni() {
        return this.jni;
    }

    @Override
    public AndroidSourceSet jni(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJni());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getJniLibs() {
        return this.jniLibs;
    }

    @Override
    public AndroidSourceSet jniLibs(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJniLibs());
        return this;
    }

    @Override
    public AndroidSourceSet shaders(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getShaders());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getShaders() {
        return this.shaders;
    }

    @Override
    public AndroidSourceDirectorySet getJava() {
        return this.javaSource;
    }

    @Override
    public AndroidSourceSet java(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJava());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getResources() {
        return this.javaResources;
    }

    @Override
    public AndroidSourceSet resources(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getResources());
        return this;
    }

    @Override
    public AndroidSourceSet setRoot(String path) {
        this.javaSource.setSrcDirs(Collections.singletonList(path + "/java"));
        this.javaResources.setSrcDirs(Collections.singletonList(path + "/resources"));
        this.res.setSrcDirs(Collections.singletonList(path + "/" + "res"));
        this.assets.setSrcDirs(Collections.singletonList(path + "/" + "assets"));
        this.manifest.srcFile(path + "/" + "AndroidManifest.xml");
        this.aidl.setSrcDirs(Collections.singletonList(path + "/aidl"));
        this.renderscript.setSrcDirs(Collections.singletonList(path + "/rs"));
        this.jni.setSrcDirs(Collections.singletonList(path + "/jni"));
        this.jniLibs.setSrcDirs(Collections.singletonList(path + "/jniLibs"));
        this.shaders.setSrcDirs(Collections.singletonList(path + "/shaders"));
        return this;
    }

    public Set<File> getJavaDirectories() {
        return this.getJava().getSrcDirs();
    }

    public Set<File> getResourcesDirectories() {
        return this.getResources().getSrcDirs();
    }

    public File getManifestFile() {
        return this.getManifest().getSrcFile();
    }

    public Set<File> getAidlDirectories() {
        return this.getAidl().getSrcDirs();
    }

    public Set<File> getRenderscriptDirectories() {
        return this.getRenderscript().getSrcDirs();
    }

    public Set<File> getCDirectories() {
        return this.getJni().getSrcDirs();
    }

    public Set<File> getCppDirectories() {
        return this.getJni().getSrcDirs();
    }

    public Set<File> getResDirectories() {
        return this.getRes().getSrcDirs();
    }

    public Set<File> getAssetsDirectories() {
        return this.getAssets().getSrcDirs();
    }

    public Collection<File> getJniLibsDirectories() {
        return this.getJniLibs().getSrcDirs();
    }

    public Collection<File> getShadersDirectories() {
        return this.getShaders().getSrcDirs();
    }
}

