/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.gradle.internal.ide.FilterDataImpl;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.internal.WaitableExecutor;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/scope/ExistingBuildElements;", "", "()V", "ApkInfoAdapter", "Companion", "OutputTypeTypeAdapter", "gradle-core"})
public final class ExistingBuildElements {
    @NotNull
    private static final WaitableExecutor executor;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        WaitableExecutor waitableExecutor = WaitableExecutor.useGlobalSharedThreadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)waitableExecutor, (String)"WaitableExecutor.useGlobalSharedThreadPool()");
        executor = waitableExecutor;
    }

    @JvmStatic
    @NotNull
    public static final BuildElements from(@NotNull TaskOutputHolder.OutputType elementType, @NotNull FileCollection from) {
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return Companion.from(elementType, from);
    }

    @JvmStatic
    @NotNull
    public static final BuildElements from(@NotNull TaskOutputHolder.OutputType elementType, @NotNull File from) {
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return Companion.from(elementType, from);
    }

    @JvmStatic
    @Nullable
    public static final File getMetadataFileIfPresent(@NotNull File folder) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        return Companion.getMetadataFileIfPresent(folder);
    }

    @JvmStatic
    @NotNull
    public static final File getMetadataFile(@NotNull File folder) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        return Companion.getMetadataFile(folder);
    }

    @JvmStatic
    @NotNull
    public static final String persistApkList(@NotNull Collection<? extends ApkInfo> apkInfos) {
        Intrinsics.checkParameterIsNotNull(apkInfos, (String)"apkInfos");
        return Companion.persistApkList(apkInfos);
    }

    @JvmStatic
    @NotNull
    public static final Collection<ApkInfo> loadApkList(@NotNull File file) throws FileNotFoundException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return Companion.loadApkList(file);
    }

    @JvmStatic
    @NotNull
    public static final Collection<BuildOutput> load(@NotNull Path projectPath, @NotNull TaskOutputHolder.OutputType outputType, @NotNull Reader reader) {
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)outputType, (String)"outputType");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        return Companion.load(projectPath, outputType, reader);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0003J\u001a\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0017\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/scope/ExistingBuildElements$ApkInfoAdapter;", "Lcom/google/gson/TypeAdapter;", "Lcom/android/ide/common/build/ApkInfo;", "()V", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "readFilters", "", "filters", "Lcom/google/common/collect/ImmutableList$Builder;", "Lcom/android/build/FilterData;", "write", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "gradle-core"})
    public static final class ApkInfoAdapter
    extends TypeAdapter<ApkInfo> {
        public void write(@NotNull JsonWriter out, @Nullable ApkInfo value) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(value.getType().toString());
            out.name("splits").beginArray();
            for (FilterData filter : value.getFilters()) {
                out.beginObject();
                JsonWriter jsonWriter = out.name("filterType");
                FilterData filterData = filter;
                Intrinsics.checkExpressionValueIsNotNull((Object)filterData, (String)"filter");
                jsonWriter.value(filterData.getFilterType());
                out.name("value").value(filter.getIdentifier());
                out.endObject();
            }
            out.endArray();
            out.name("versionCode").value((long)value.getVersionCode());
            if (value.getVersionName() != null) {
                out.name("versionName").value(value.getVersionName());
            }
            out.name("enabled").value(value.isEnabled());
            if (value.getFilterName() != null) {
                out.name("filterName").value(value.getFilterName());
            }
            if (value.getOutputFileName() != null) {
                out.name("outputFile").value(value.getOutputFileName());
            }
            out.name("fullName").value(value.getFullName());
            out.name("baseName").value(value.getBaseName());
            out.endObject();
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public ApkInfo read(@NotNull JsonReader reader) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            reader.beginObject();
            outputType = null;
            filters = ImmutableList.builder();
            versionCode = 0;
            versionName = null;
            enabled = true;
            outputFile = null;
            fullName = null;
            baseName = null;
            filterName = null;
            while (reader.hasNext()) {
                block16: {
                    block18: {
                        block15: {
                            block13: {
                                block20: {
                                    block17: {
                                        block19: {
                                            block14: {
                                                v0 = var11_11 = reader.nextName();
                                                if (v0 == null) continue;
                                                switch (v0.hashCode()) {
                                                    case -1274275299: {
                                                        if (!var11_11.equals("outputFile")) ** break;
                                                        break block13;
                                                    }
                                                    case -895858535: {
                                                        if (!var11_11.equals("splits")) ** break;
                                                        break block14;
                                                    }
                                                    case -1553252829: {
                                                        if (!var11_11.equals("filterName")) ** break;
                                                        break block15;
                                                    }
                                                    case 1330852282: {
                                                        if (!var11_11.equals("fullName")) ** break;
                                                        break block16;
                                                    }
                                                    case 3575610: {
                                                        if (!var11_11.equals("type")) ** break;
                                                        break;
                                                    }
                                                    case 688906115: {
                                                        if (!var11_11.equals("versionName")) ** break;
                                                        break block17;
                                                    }
                                                    case -1721686788: {
                                                        if (!var11_11.equals("baseName")) ** break;
                                                        break block18;
                                                    }
                                                    case 688591589: {
                                                        if (!var11_11.equals("versionCode")) ** break;
                                                        break block19;
                                                    }
                                                    case -1609594047: {
                                                        if (!var11_11.equals("enabled")) ** break;
                                                        break block20;
                                                    }
                                                }
                                                outputType = reader.nextString();
                                                ** break;
                                            }
                                            v1 = filters;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"filters");
                                            this.readFilters(reader, (ImmutableList.Builder<FilterData>)v1);
                                            ** break;
                                        }
                                        versionCode = reader.nextInt();
                                        ** break;
                                    }
                                    versionName = reader.nextString();
                                    ** break;
                                }
                                enabled = reader.nextBoolean();
                                ** break;
                            }
                            outputFile = reader.nextString();
                            ** break;
                        }
                        filterName = reader.nextString();
                        ** break;
                    }
                    baseName = reader.nextString();
                    ** break;
                }
                fullName = reader.nextString();
lbl70:
                // 19 sources

            }
            reader.endObject();
            filterData = filters.build();
            v2 = outputType;
            if (v2 == null) {
                Intrinsics.throwNpe();
            }
            apkType = VariantOutput.OutputType.valueOf((String)v2);
            v3 = ApkInfo.of((VariantOutput.OutputType)apkType, (Collection)((Collection)filterData), (int)versionCode, (String)versionName, (String)filterName, (String)outputFile, (String)fullName, (String)baseName, (boolean)enabled);
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"ApkInfo.of(\n            \u2026                 enabled)");
            return v3;
        }

        /*
         * Unable to fully structure code
         */
        private final void readFilters(JsonReader reader, ImmutableList.Builder<FilterData> filters) throws IOException {
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                filterType = null;
                value = null;
                while (reader.hasNext()) {
                    block7: {
                        v0 = var5_5 = reader.nextName();
                        if (v0 == null) continue;
                        switch (v0.hashCode()) {
                            case -1553050926: {
                                if (!var5_5.equals("filterType")) ** break;
                                break;
                            }
                            case 111972721: {
                                if (!var5_5.equals("value")) ** break;
                                break block7;
                            }
                        }
                        v1 = reader.nextString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"reader.nextString()");
                        filterType = VariantOutput.FilterType.valueOf((String)v1);
                        ** break;
                    }
                    value = reader.nextString();
lbl22:
                    // 5 sources

                }
                if (filterType != null && value != null) {
                    filters.add((Object)new FilterDataImpl(filterType, value));
                }
                reader.endObject();
            }
            reader.endArray();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0017\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/scope/ExistingBuildElements$OutputTypeTypeAdapter;", "Lcom/google/gson/TypeAdapter;", "Lcom/android/build/gradle/internal/scope/TaskOutputHolder$OutputType;", "()V", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "gradle-core"})
    public static final class OutputTypeTypeAdapter
    extends TypeAdapter<TaskOutputHolder.OutputType> {
        public void write(@NotNull JsonWriter out, @NotNull TaskOutputHolder.OutputType value) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            out.beginObject();
            out.name("type").value(value.name());
            out.endObject();
        }

        @NotNull
        public TaskOutputHolder.OutputType read(@NotNull JsonReader reader) throws IOException {
            Enum enum_;
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            reader.beginObject();
            String string = reader.nextName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.nextName()");
            if (!StringsKt.endsWith$default((String)string, (String)"type", (boolean)false, (int)2, null)) {
                throw (Throwable)new IOException("Invalid format");
            }
            String nextString = reader.nextString();
            try {
                String string2 = nextString;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"nextString");
                enum_ = TaskOutputHolder.TaskOutputType.valueOf(string2);
            }
            catch (IllegalArgumentException e) {
                String string3 = nextString;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"nextString");
                enum_ = TaskOutputHolder.AnchorOutputType.valueOf(string3);
            }
            TaskOutputHolder.OutputType outputType = enum_;
            reader.endObject();
            return outputType;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\u0006\u0010\u001d\u001a\u00020\fH\u0007J\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u0014H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006!"}, d2={"Lcom/android/build/gradle/internal/scope/ExistingBuildElements$Companion;", "", "()V", "executor", "Lcom/android/ide/common/internal/WaitableExecutor;", "getExecutor", "()Lcom/android/ide/common/internal/WaitableExecutor;", "_from", "Lcom/android/build/gradle/internal/scope/BuildElements;", "elementType", "Lcom/android/build/gradle/internal/scope/TaskOutputHolder$OutputType;", "metadataFile", "Ljava/io/File;", "from", "Lorg/gradle/api/file/FileCollection;", "getMetadataFile", "folder", "getMetadataFileIfPresent", "fileCollection", "load", "", "Lcom/android/build/gradle/internal/scope/BuildOutput;", "projectPath", "Ljava/nio/file/Path;", "outputType", "reader", "Ljava/io/Reader;", "loadApkList", "Lcom/android/ide/common/build/ApkInfo;", "file", "persistApkList", "", "apkInfos", "gradle-core"})
    public static final class Companion {
        @NotNull
        public final WaitableExecutor getExecutor() {
            return executor;
        }

        @JvmStatic
        @NotNull
        public final BuildElements from(@NotNull TaskOutputHolder.OutputType elementType, @NotNull FileCollection from) {
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
            File metadataFile = this.getMetadataFileIfPresent(from);
            return this._from(elementType, metadataFile);
        }

        @JvmStatic
        @NotNull
        public final BuildElements from(@NotNull TaskOutputHolder.OutputType elementType, @NotNull File from) {
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
            File metadataFile = this.getMetadataFileIfPresent(from);
            return this._from(elementType, metadataFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final BuildElements _from(TaskOutputHolder.OutputType elementType, File metadataFile) {
            if (metadataFile == null || !metadataFile.exists()) {
                ImmutableList immutableList = ImmutableList.of();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
                return new BuildElements((Collection)immutableList);
            }
            try {
                Closeable closeable = new FileReader(metadataFile);
                Throwable throwable = null;
                try {
                    FileReader reader = (FileReader)closeable;
                    Path path = metadataFile.getParentFile().toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"metadataFile.parentFile.toPath()");
                    BuildElements buildElements = new BuildElements(Companion.load(path, elementType, reader));
                    return buildElements;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                ImmutableList immutableList = ImmutableList.of();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of<BuildOutput>()");
                return new BuildElements((Collection)immutableList);
            }
        }

        private final File getMetadataFileIfPresent(FileCollection fileCollection) {
            Object v3;
            block1: {
                Iterable iterable;
                FileTree fileTree = fileCollection.getAsFileTree();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"fileCollection.asFileTree");
                Set set = fileTree.getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"fileCollection.asFileTree.files");
                Iterable iterable2 = iterable = (Iterable)set;
                for (Object t : iterable2) {
                    File it;
                    File file = it = (File)t;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                    if (!Intrinsics.areEqual((Object)file.getName(), (Object)"output.json")) continue;
                    v3 = t;
                    break block1;
                }
                v3 = null;
            }
            return v3;
        }

        @JvmStatic
        @Nullable
        public final File getMetadataFileIfPresent(@NotNull File folder) {
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            File outputFile = this.getMetadataFile(folder);
            return outputFile.exists() ? outputFile : null;
        }

        @JvmStatic
        @NotNull
        public final File getMetadataFile(@NotNull File folder) {
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            return new File(folder, "output.json");
        }

        @JvmStatic
        @NotNull
        public final String persistApkList(@NotNull Collection<? extends ApkInfo> apkInfos) {
            Intrinsics.checkParameterIsNotNull(apkInfos, (String)"apkInfos");
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeHierarchyAdapter(ApkInfo.class, (Object)new ApkInfoAdapter());
            Gson gson = gsonBuilder.create();
            String string = gson.toJson(apkInfos);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(apkInfos)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final Collection<ApkInfo> loadApkList(@NotNull File file) throws FileNotFoundException {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeHierarchyAdapter(ApkInfo.class, (Object)new ApkInfoAdapter());
            gsonBuilder.registerTypeAdapter((Type)((Object)TaskOutputHolder.OutputType.class), (Object)new OutputTypeTypeAdapter());
            Gson gson = gsonBuilder.create();
            Type recordType2 = new TypeToken<List<? extends ApkInfo>>(){}.getType();
            Object object = gson.fromJson((Reader)new FileReader(file), recordType2);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(FileReader(file), recordType)");
            return (Collection)object;
        }

        @JvmStatic
        @NotNull
        public final Collection<BuildOutput> load(@NotNull Path projectPath, @NotNull TaskOutputHolder.OutputType outputType, @NotNull Reader reader) {
            Collection buildOutputs;
            Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
            Intrinsics.checkParameterIsNotNull((Object)outputType, (String)"outputType");
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter((Type)((Object)ApkInfo.class), (Object)new ApkInfoAdapter());
            gsonBuilder.registerTypeAdapter((Type)((Object)TaskOutputHolder.OutputType.class), (Object)new OutputTypeTypeAdapter());
            Gson gson = gsonBuilder.create();
            Type recordType2 = new TypeToken<List<? extends BuildOutput>>(){}.getType();
            Collection collection = buildOutputs = (Collection)gson.fromJson(reader, recordType2);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"buildOutputs");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<BuildOutput, Boolean>(outputType){
                final /* synthetic */ TaskOutputHolder.OutputType $outputType;

                public final boolean invoke(@NotNull BuildOutput it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getType(), (Object)this.$outputType);
                }
                {
                    this.$outputType = outputType;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<BuildOutput, BuildOutput>(projectPath){
                final /* synthetic */ Path $projectPath;

                @NotNull
                public final BuildOutput invoke(@NotNull BuildOutput buildOutput) {
                    Intrinsics.checkParameterIsNotNull((Object)buildOutput, (String)"buildOutput");
                    return new BuildOutput(buildOutput.getType(), buildOutput.getApkInfo(), this.$projectPath.resolve(buildOutput.getOutputPath()), buildOutput.getProperties());
                }
                {
                    this.$projectPath = path;
                    super(1);
                }
            })));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

