/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.FileUtils;

public class ApplicationId {
    static final String PERSISTED_FILE_NAME = "application-id.json";
    private final String applicationId;

    public ApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void save(File outputDirectory) throws IOException {
        File outputFile = new File(outputDirectory, PERSISTED_FILE_NAME);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        FileUtils.write((File)outputFile, (CharSequence)gson.toJson((Object)this));
    }

    public static ApplicationId load(File input) throws IOException {
        if (!input.getName().equals(PERSISTED_FILE_NAME)) {
            throw new FileNotFoundException("No application declaration present.");
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        try (FileReader fileReader = new FileReader(input);){
            ApplicationId applicationId = (ApplicationId)gson.fromJson((Reader)fileReader, ApplicationId.class);
            return applicationId;
        }
    }

    public static File getOutputFile(File directory) {
        return new File(directory, PERSISTED_FILE_NAME);
    }
}

