/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.internal.pipeline.ImmutableDirectoryInput;
import com.android.build.gradle.internal.pipeline.ImmutableJarInput;
import com.android.build.gradle.internal.pipeline.ImmutableTransformInput;
import com.android.build.gradle.internal.pipeline.IncrementalTransformInput;
import com.android.build.gradle.internal.pipeline.MutableDirectoryInput;
import com.android.build.gradle.internal.pipeline.QualifiedContentImpl;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.pipeline.SubStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.incremental.InputFileDetails;

public class IntermediateFolderUtils {
    private final File rootFolder;
    private final Set<QualifiedContent.ContentType> types;
    private final Set<? super QualifiedContent.Scope> scopes;
    private List<SubStream> subStreams;
    private List<SubStream> removedSubStreams;
    private List<SubStream> outOfScopeStreams;
    private int nextIndex = 0;

    public IntermediateFolderUtils(File rootFolder, Set<QualifiedContent.ContentType> types, Set<? super QualifiedContent.Scope> scopes) {
        this.rootFolder = rootFolder;
        this.types = types;
        this.scopes = scopes;
        this.updateLists(this.makeRestrictedCopies(SubStream.loadSubStreams(rootFolder)));
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public synchronized File getContentLocation(String name, Set<QualifiedContent.ContentType> types, Set<? super QualifiedContent.Scope> scopes, Format format) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(types);
        Preconditions.checkNotNull(scopes);
        Preconditions.checkNotNull((Object)format);
        Preconditions.checkState((!name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((!types.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((!scopes.isEmpty() ? 1 : 0) != 0);
        for (SubStream subStream : this.subStreams) {
            if (!name.equals(subStream.getName()) || !types.equals(subStream.getTypes()) || !scopes.equals(subStream.getScopes()) || format != subStream.getFormat()) continue;
            return new File(this.rootFolder, subStream.getFilename());
        }
        SubStream newSubStream = new SubStream(name, this.nextIndex++, scopes, types, format, true);
        this.subStreams.add(newSubStream);
        return new File(this.rootFolder, newSubStream.getFilename());
    }

    public TransformInput computeNonIncrementalInputFromFolder() {
        ArrayList jarInputs = Lists.newArrayList();
        ArrayList directoryInputs = Lists.newArrayList();
        for (SubStream subStream : this.subStreams) {
            if (subStream.getFormat() == Format.DIRECTORY) {
                directoryInputs.add(new ImmutableDirectoryInput(subStream.getName(), new File(this.rootFolder, subStream.getFilename()), subStream.getTypes(), subStream.getScopes()));
                continue;
            }
            jarInputs.add(new ImmutableJarInput(subStream.getName(), new File(this.rootFolder, subStream.getFilename()), Status.NOTCHANGED, subStream.getTypes(), subStream.getScopes()));
        }
        return new ImmutableTransformInput(jarInputs, directoryInputs, this.rootFolder);
    }

    public Collection<File> getFiles(StreamFilter streamFilter) {
        ArrayList files = Lists.newArrayListWithExpectedSize((int)this.subStreams.size());
        for (SubStream stream : this.subStreams) {
            if (!streamFilter.accept(stream.getTypes(), stream.getScopes())) continue;
            files.add(new File(this.rootFolder, stream.getFilename()));
        }
        return files;
    }

    public IncrementalTransformInput computeIncrementalInputFromFolder() {
        IntermediateTransformInput input = new IntermediateTransformInput(this.rootFolder);
        for (SubStream subStream : this.subStreams) {
            if (subStream.getFormat() == Format.DIRECTORY) {
                input.addFolderInput(new MutableDirectoryInput(subStream.getName(), new File(this.rootFolder, subStream.getFilename()), subStream.getTypes(), subStream.getScopes()));
                continue;
            }
            input.addJarInput(new QualifiedContentImpl(subStream.getName(), new File(this.rootFolder, subStream.getFilename()), subStream.getTypes(), subStream.getScopes()));
        }
        return input;
    }

    static Status inputFileDetailsToStatus(InputFileDetails inputFileDetails) {
        if (inputFileDetails.isAdded()) {
            return Status.ADDED;
        }
        if (inputFileDetails.isModified()) {
            return Status.CHANGED;
        }
        if (inputFileDetails.isRemoved()) {
            return Status.REMOVED;
        }
        return Status.NOTCHANGED;
    }

    public void save() throws IOException {
        ArrayList copyList = Lists.newArrayListWithCapacity((int)this.subStreams.size());
        for (SubStream subStream : this.subStreams) {
            copyList.add(subStream.duplicateWithPresent(new File(this.rootFolder, subStream.getFilename()).exists()));
        }
        SubStream.save(copyList, this.rootFolder);
        this.updateLists(copyList);
    }

    private Collection<SubStream> makeRestrictedCopies(Collection<SubStream> streams) {
        ArrayList list = Lists.newArrayListWithCapacity((int)streams.size());
        this.outOfScopeStreams = Lists.newArrayList();
        for (SubStream subStream : streams) {
            if (subStream.getIndex() >= this.nextIndex) {
                this.nextIndex = subStream.getIndex() + 1;
            }
            if (subStream.isPresent()) {
                Sets.SetView limitedTypes = Sets.intersection(this.types, subStream.getTypes());
                if (!limitedTypes.isEmpty()) {
                    boolean foundUnwanted = false;
                    boolean foundMatch = false;
                    for (QualifiedContent.Scope scope : subStream.getScopes()) {
                        if (this.scopes.contains(scope)) {
                            foundMatch = true;
                            continue;
                        }
                        foundUnwanted = true;
                    }
                    if (foundMatch && foundUnwanted) {
                        List foundScopes = subStream.getScopes().stream().map(Object::toString).sorted().collect(Collectors.toList());
                        throw new RuntimeException(String.format("Unexpected scopes found in folder '%s'. Required: %s. Found: %s", this.rootFolder, Joiner.on((String)", ").join(this.scopes), Joiner.on((String)", ").join(foundScopes)));
                    }
                    if (foundMatch) {
                        if (limitedTypes.size() == subStream.getTypes().size()) {
                            list.add(subStream);
                            continue;
                        }
                        list.add(new SubStream(subStream.getName(), subStream.getIndex(), subStream.getScopes(), (Set<QualifiedContent.ContentType>)limitedTypes, subStream.getFormat(), subStream.isPresent()));
                        this.outOfScopeStreams.add(new SubStream(subStream.getName(), subStream.getIndex(), subStream.getScopes(), IntermediateFolderUtils.minus(subStream.getTypes(), limitedTypes), subStream.getFormat(), subStream.isPresent()));
                        continue;
                    }
                    this.outOfScopeStreams.add(subStream);
                    continue;
                }
                this.outOfScopeStreams.add(subStream);
                continue;
            }
            list.add(subStream);
        }
        return list;
    }

    private static <T> Set<T> minus(Set<T> main, Set<T> minus) {
        HashSet result = Sets.newHashSet(main);
        result.removeAll(minus);
        return result;
    }

    private void updateLists(Collection<SubStream> subStreamList) {
        this.subStreams = subStreamList.stream().filter(SubStream::isPresent).collect(Collectors.toList());
        this.removedSubStreams = subStreamList.stream().filter(subStream -> !subStream.isPresent()).collect(Collectors.toList());
    }

    class IntermediateTransformInput
    extends IncrementalTransformInput {
        private final File inputRoot;
        private List<String> rootLocationSegments = null;

        IntermediateTransformInput(File inputRoot) {
            this.inputRoot = inputRoot;
        }

        @Override
        protected boolean checkRemovedFolder(Set<? super QualifiedContent.Scope> transformScopes, Set<QualifiedContent.ContentType> transformInputTypes, File file, List<String> fileSegments) {
            if (!this.checkRootSegments(fileSegments)) {
                return false;
            }
            if (fileSegments.size() < this.rootLocationSegments.size() + 2) {
                return false;
            }
            int index = this.rootLocationSegments.size();
            String foldername = fileSegments.get(index);
            for (SubStream subStream : IntermediateFolderUtils.this.subStreams) {
                if (!subStream.getFilename().equals(foldername) || subStream.getFormat() != Format.DIRECTORY) continue;
                MutableDirectoryInput folder = new MutableDirectoryInput(subStream.getName(), new File(IntermediateFolderUtils.this.rootFolder, foldername), subStream.getTypes(), subStream.getScopes());
                Logging.getLogger(TransformManager.class).info("Tagged" + file.getAbsolutePath() + " as removed");
                folder.addChangedFile(file, Status.REMOVED);
                this.addFolderInput(folder);
                return true;
            }
            for (SubStream subStream : IntermediateFolderUtils.this.removedSubStreams) {
                if (!subStream.getFilename().equals(foldername) || subStream.getFormat() != Format.DIRECTORY) continue;
                if (!Sets.intersection(transformInputTypes, subStream.getTypes()).isEmpty() && !Sets.intersection(transformScopes, subStream.getScopes()).isEmpty()) {
                    MutableDirectoryInput folder = new MutableDirectoryInput(subStream.getName(), new File(IntermediateFolderUtils.this.rootFolder, foldername), subStream.getTypes(), subStream.getScopes());
                    Logging.getLogger(TransformManager.class).info("Tagged" + file.getAbsolutePath() + " as removed");
                    folder.addChangedFile(file, Status.REMOVED);
                    this.addFolderInput(folder);
                }
                return true;
            }
            for (SubStream subStream : IntermediateFolderUtils.this.outOfScopeStreams) {
                if (!subStream.getFilename().equals(foldername) || subStream.getFormat() != Format.DIRECTORY) continue;
                return true;
            }
            return false;
        }

        @Override
        boolean checkRemovedJarFile(Set<? super QualifiedContent.Scope> transformScopes, Set<QualifiedContent.ContentType> transformInputTypes, File file, List<String> fileSegments) {
            if (!this.checkRootSegments(fileSegments)) {
                return false;
            }
            if (fileSegments.size() != this.rootLocationSegments.size() + 1) {
                return false;
            }
            String filename = file.getName();
            if (!filename.endsWith(".jar")) {
                return false;
            }
            for (SubStream subStream : IntermediateFolderUtils.this.subStreams) {
                if (!subStream.getFilename().equals(filename) || subStream.getFormat() != Format.JAR) continue;
                this.addImmutableJar(new ImmutableJarInput(subStream.getName(), file, Status.REMOVED, subStream.getTypes(), subStream.getScopes()));
                return true;
            }
            for (SubStream subStream : IntermediateFolderUtils.this.removedSubStreams) {
                if (!subStream.getFilename().equals(filename) || subStream.getFormat() != Format.JAR) continue;
                if (!Sets.intersection(transformInputTypes, subStream.getTypes()).isEmpty() && !Sets.intersection(transformScopes, subStream.getScopes()).isEmpty()) {
                    this.addImmutableJar(new ImmutableJarInput(subStream.getName(), file, Status.REMOVED, subStream.getTypes(), subStream.getScopes()));
                }
                return true;
            }
            for (SubStream subStream : IntermediateFolderUtils.this.outOfScopeStreams) {
                if (!subStream.getFilename().equals(filename) || subStream.getFormat() != Format.JAR) continue;
                return true;
            }
            return false;
        }

        private boolean checkRootSegments(List<String> fileSegments) {
            if (this.rootLocationSegments == null) {
                this.rootLocationSegments = Lists.newArrayList((Iterable)Splitter.on((char)File.separatorChar).split((CharSequence)this.inputRoot.getAbsolutePath()));
            }
            if (fileSegments.size() <= this.rootLocationSegments.size()) {
                return false;
            }
            for (int i = this.rootLocationSegments.size() - 1; i >= 0; --i) {
                if (this.rootLocationSegments.get(i).equals(fileSegments.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

