/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import android.databinding.tool.LayoutXmlProcessor;
import com.android.build.VariantOutput;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.dsl.VariantOutputFactory;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.OutputFactory;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.scope.VariantScopeImpl;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.BinaryFileProviderTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.PackageSplitAbi;
import com.android.build.gradle.tasks.PackageSplitRes;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.build.gradle.tasks.ShaderCompile;
import com.android.builder.core.VariantType;
import com.android.builder.model.SourceProvider;
import com.android.builder.profile.Recorder;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.SourceFile;
import com.android.utils.StringHelper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class BaseVariantData
implements TaskContainer {
    protected final TaskManager taskManager;
    private final GradleVariantConfiguration variantConfiguration;
    private VariantDependencies variantDependency;
    private final VariantScope scope;
    public Task preBuildTask;
    public Task sourceGenTask;
    public Task resourceGenTask;
    public Task assetGenTask;
    public CheckManifest checkManifestTask;
    public PackageSplitRes packageSplitResourcesTask;
    public PackageSplitAbi packageSplitAbiTask;
    private Map<TaskContainer.TaskKind, Task> registeredTasks = new ConcurrentHashMap<TaskContainer.TaskKind, Task>();
    public RenderscriptCompile renderscriptCompileTask;
    public AidlCompile aidlCompileTask;
    public MergeResources mergeResourcesTask;
    public ManifestProcessorTask processManifest;
    public MergeSourceSetFolders mergeAssetsTask;
    public GenerateBuildConfig generateBuildConfigTask;
    public GenerateResValues generateResValuesTask;
    public Copy copyApkTask;
    public GenerateApkDataTask generateApkDataTask;
    public ShaderCompile shaderCompileTask;
    public Sync processJavaResourcesTask;
    public NdkCompile ndkCompileTask;
    public JavaCompile javacTask;
    public Collection<ExternalNativeBuildTask> externalNativeBuildTasks = Lists.newArrayList();
    public Task compileTask;
    public Task javaCompilerTask;
    public BinaryFileProviderTask binaryFileProviderTask;
    public Task obfuscationTask;
    private ImmutableList<ConfigurableFileTree> defaultJavaSources;
    private List<File> extraGeneratedSourceFolders = Lists.newArrayList();
    private List<ConfigurableFileTree> extraGeneratedSourceFileTrees;
    private final ConfigurableFileCollection extraGeneratedResFolders;
    private Map<Object, FileCollection> preJavacGeneratedBytecodeMap;
    private FileCollection preJavacGeneratedBytecodeLatest;
    private final ConfigurableFileCollection allPreJavacGeneratedBytecode;
    private final ConfigurableFileCollection allPostJavacGeneratedBytecode;
    private Set<String> densityFilters;
    private Set<String> languageFilters;
    private Set<String> abiFilters;
    private LayoutXmlProcessor layoutXmlProcessor;
    public boolean outputsAreSigned = false;
    private final OutputScope outputScope;
    private final OutputFactory outputFactory;
    public VariantOutputFactory variantOutputFactory;
    private final MultiOutputPolicy multiOutputPolicy;

    public BaseVariantData(GlobalScope globalScope, AndroidConfig androidConfig, TaskManager taskManager, GradleVariantConfiguration variantConfiguration, Recorder recorder) {
        this.variantConfiguration = variantConfiguration;
        this.taskManager = taskManager;
        MultiOutputPolicy multiOutputPolicy = this.multiOutputPolicy = (androidConfig.getGeneratePureSplits() || variantConfiguration.getType() == VariantType.FEATURE) && variantConfiguration.getMinSdkVersionValue() >= 21 ? MultiOutputPolicy.SPLITS : MultiOutputPolicy.MULTI_APK;
        if (androidConfig.getGeneratePureSplits() && this.multiOutputPolicy != MultiOutputPolicy.SPLITS) {
            Logging.getLogger(BaseVariantData.class).warn(String.format("Variant %s, MinSdkVersion %s is too low (<21) to support pure splits, reverting to full APKs", variantConfiguration.getFullName(), variantConfiguration.getMinSdkVersion().getApiLevel()));
        }
        Project project = globalScope.getProject();
        this.scope = new VariantScopeImpl(globalScope, new TransformManager(globalScope.getProject(), globalScope.getErrorHandler(), recorder), this);
        this.outputScope = new OutputScope();
        this.outputFactory = new OutputFactory(globalScope.getProjectBaseName(), variantConfiguration, this.outputScope);
        taskManager.configureScopeForNdk(this.scope);
        this.extraGeneratedResFolders = globalScope.getProject().files(new Object[0]);
        this.preJavacGeneratedBytecodeLatest = globalScope.getProject().files(new Object[0]);
        this.allPreJavacGeneratedBytecode = project.files(new Object[0]);
        this.allPostJavacGeneratedBytecode = project.files(new Object[0]);
    }

    public LayoutXmlProcessor getLayoutXmlProcessor() {
        if (this.layoutXmlProcessor == null) {
            File resourceBlameLogDir = this.scope.getResourceBlameLogDir();
            MergingLog mergingLog = new MergingLog(resourceBlameLogDir);
            this.layoutXmlProcessor = new LayoutXmlProcessor(this.getVariantConfiguration().getOriginalApplicationId(), this.taskManager.getDataBindingBuilder().createJavaFileWriter(this.scope.getClassOutputForDataBinding()), file -> {
                SourceFile input = new SourceFile(file);
                SourceFile original = mergingLog.find(input);
                return original == input ? null : original.getSourceFile();
            });
        }
        return this.layoutXmlProcessor;
    }

    public OutputScope getOutputScope() {
        return this.outputScope;
    }

    public OutputFactory getOutputFactory() {
        return this.outputFactory;
    }

    @Override
    public void addTask(TaskContainer.TaskKind taskKind, Task task) {
        this.registeredTasks.put(taskKind, task);
    }

    @Override
    public Task getTaskByKind(TaskContainer.TaskKind name) {
        return this.registeredTasks.get((Object)name);
    }

    public MultiOutputPolicy getMultiOutputPolicy() {
        return this.multiOutputPolicy;
    }

    public <U extends Task> U getTaskByType(Class<U> taskType) {
        Optional<Task> requestedTask = this.registeredTasks.values().stream().filter(taskType::isInstance).findFirst();
        return (U)(requestedTask.isPresent() ? (Task)taskType.cast(requestedTask.get()) : null);
    }

    public GradleVariantConfiguration getVariantConfiguration() {
        return this.variantConfiguration;
    }

    public void setVariantDependency(VariantDependencies variantDependency) {
        this.variantDependency = variantDependency;
    }

    public VariantDependencies getVariantDependency() {
        return this.variantDependency;
    }

    public abstract String getDescription();

    public String getApplicationId() {
        return this.variantConfiguration.getApplicationId();
    }

    public VariantType getType() {
        return this.variantConfiguration.getType();
    }

    public String getName() {
        return this.variantConfiguration.getFullName();
    }

    public String getTaskName(String prefix, String suffix) {
        return StringHelper.appendCapitalized((String)prefix, (String)this.variantConfiguration.getFullName(), (String)suffix);
    }

    public List<File> getExtraGeneratedSourceFolders() {
        return this.extraGeneratedSourceFolders;
    }

    public FileCollection getExtraGeneratedResFolders() {
        return this.extraGeneratedResFolders;
    }

    public FileCollection getAllPreJavacGeneratedBytecode() {
        return this.allPreJavacGeneratedBytecode;
    }

    public FileCollection getAllPostJavacGeneratedBytecode() {
        return this.allPostJavacGeneratedBytecode;
    }

    public FileCollection getGeneratedBytecode(Object generatorKey) {
        if (generatorKey == null) {
            return this.allPreJavacGeneratedBytecode;
        }
        FileCollection result = this.preJavacGeneratedBytecodeMap.get(generatorKey);
        if (result == null) {
            throw new RuntimeException("Bytecode generator key not found");
        }
        return result;
    }

    public void addJavaSourceFoldersToModel(File generatedSourceFolder) {
        this.extraGeneratedSourceFolders.add(generatedSourceFolder);
    }

    public void addJavaSourceFoldersToModel(File ... generatedSourceFolders) {
        Collections.addAll(this.extraGeneratedSourceFolders, generatedSourceFolders);
    }

    public void addJavaSourceFoldersToModel(Collection<File> generatedSourceFolders) {
        this.extraGeneratedSourceFolders.addAll(generatedSourceFolders);
    }

    public void registerJavaGeneratingTask(Task task, File ... generatedSourceFolders) {
        this.registerJavaGeneratingTask(task, Arrays.asList(generatedSourceFolders));
    }

    public void registerJavaGeneratingTask(Task task, Collection<File> generatedSourceFolders) {
        Preconditions.checkNotNull((Object)this.javacTask);
        this.sourceGenTask.dependsOn(new Object[]{task});
        Project project = this.scope.getGlobalScope().getProject();
        if (this.extraGeneratedSourceFileTrees == null) {
            this.extraGeneratedSourceFileTrees = new ArrayList<ConfigurableFileTree>();
        }
        for (File f : generatedSourceFolders) {
            ConfigurableFileTree fileTree = project.fileTree((Object)f).builtBy(new Object[]{task});
            this.extraGeneratedSourceFileTrees.add(fileTree);
            this.javacTask.source(new Object[]{fileTree});
        }
        this.addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    public void registerExternalAptJavaOutput(ConfigurableFileTree folder) {
        Preconditions.checkNotNull((Object)this.javacTask);
        this.javacTask.source(new Object[]{folder});
        this.addJavaSourceFoldersToModel(folder.getDir());
    }

    public void registerGeneratedResFolders(FileCollection folders) {
        this.extraGeneratedResFolders.from(new Object[]{folders});
    }

    @Deprecated
    public void registerResGeneratingTask(Task task, File ... generatedResFolders) {
        this.registerResGeneratingTask(task, Arrays.asList(generatedResFolders));
    }

    @Deprecated
    public void registerResGeneratingTask(Task task, Collection<File> generatedResFolders) {
        System.out.println("registerResGeneratingTask is deprecated, use registerGeneratedResFolders(FileCollection)");
        Project project = this.scope.getGlobalScope().getProject();
        this.registerGeneratedResFolders((FileCollection)project.files(new Object[]{generatedResFolders}).builtBy(new Object[]{task}));
    }

    public Object registerPreJavacGeneratedBytecode(FileCollection fileCollection) {
        if (this.preJavacGeneratedBytecodeMap == null) {
            this.preJavacGeneratedBytecodeMap = Maps.newHashMap();
        }
        Object key = new Object();
        this.preJavacGeneratedBytecodeMap.put(key, this.preJavacGeneratedBytecodeLatest);
        this.preJavacGeneratedBytecodeLatest = this.preJavacGeneratedBytecodeLatest.plus(fileCollection);
        this.allPreJavacGeneratedBytecode.from(new Object[]{fileCollection});
        return key;
    }

    public void registerPostJavacGeneratedBytecode(FileCollection fileCollection) {
        this.allPostJavacGeneratedBytecode.from(new Object[]{fileCollection});
    }

    public void calculateFilters(Splits splits) {
        ArrayList folders = Lists.newArrayList(this.getGeneratedResFolders());
        folders.addAll(this.variantConfiguration.getSourceFiles(SourceProvider::getResDirectories));
        this.densityFilters = BaseVariantData.getFilters(folders, DiscoverableFilterType.DENSITY, splits);
        this.languageFilters = BaseVariantData.getFilters(folders, DiscoverableFilterType.LANGUAGE, splits);
        this.abiFilters = BaseVariantData.getFilters(folders, DiscoverableFilterType.ABI, splits);
    }

    public Set<String> getFilters(VariantOutput.FilterType filterType) {
        if (this.densityFilters == null || this.languageFilters == null || this.abiFilters == null) {
            throw new IllegalStateException("calculateFilters method not called");
        }
        switch (filterType) {
            case DENSITY: {
                return this.densityFilters;
            }
            case LANGUAGE: {
                return this.languageFilters;
            }
            case ABI: {
                return this.abiFilters;
            }
        }
        throw new RuntimeException("Unhandled filter type");
    }

    private List<File> getGeneratedResFolders() {
        ArrayList generatedResFolders = Lists.newArrayList((Object[])new File[]{this.scope.getRenderscriptResOutputDir(), this.scope.getGeneratedResOutputDir()});
        if (this.extraGeneratedResFolders != null) {
            generatedResFolders.addAll(this.extraGeneratedResFolders.getFiles());
        }
        if (this.scope.getMicroApkTask() != null && ((CoreBuildType)this.getVariantConfiguration().getBuildType()).isEmbedMicroApp()) {
            generatedResFolders.add(this.scope.getMicroApkResDirectory());
        }
        return generatedResFolders;
    }

    public List<String> discoverListOfResourceConfigs() {
        ArrayList<String> resFoldersOnDisk = new ArrayList<String>();
        Set<File> resourceFolders = this.variantConfiguration.getSourceFiles(SourceProvider::getResDirectories);
        resFoldersOnDisk.addAll(BaseVariantData.getAllFilters(resourceFolders, DiscoverableFilterType.LANGUAGE.folderPrefix, DiscoverableFilterType.DENSITY.folderPrefix));
        return resFoldersOnDisk;
    }

    private static Set<String> getFilters(List<File> resourceFolders, DiscoverableFilterType filterType, Splits splits) {
        HashSet<String> filtersList = new HashSet<String>();
        if (filterType.isAuto(splits)) {
            filtersList.addAll(BaseVariantData.getAllFilters(resourceFolders, filterType.folderPrefix));
        } else {
            filtersList.addAll(filterType.getConfiguredFilters(splits));
        }
        return filtersList;
    }

    private static List<String> getAllFilters(Iterable<File> resourceFolders, String ... prefixes) {
        ArrayList<String> providedResFolders = new ArrayList<String>();
        for (File resFolder : resourceFolders) {
            File[] subResFolders = resFolder.listFiles();
            if (subResFolders == null) continue;
            for (File subResFolder : subResFolders) {
                for (String prefix : prefixes) {
                    if (!subResFolder.getName().startsWith(prefix)) continue;
                    providedResFolders.add(subResFolder.getName().substring(prefix.length()));
                }
            }
        }
        return providedResFolders;
    }

    public List<ConfigurableFileTree> getJavaSources() {
        if (this.extraGeneratedSourceFileTrees == null || this.extraGeneratedSourceFileTrees.isEmpty()) {
            return this.getDefaultJavaSources();
        }
        ImmutableList.Builder sourceSets = ImmutableList.builder();
        sourceSets.addAll(this.getDefaultJavaSources());
        sourceSets.addAll(this.extraGeneratedSourceFileTrees);
        return sourceSets.build();
    }

    private List<ConfigurableFileTree> getDefaultJavaSources() {
        if (this.defaultJavaSources == null) {
            Project project = this.scope.getGlobalScope().getProject();
            ImmutableList.Builder sourceSets = ImmutableList.builder();
            List<SourceProvider> providers = this.variantConfiguration.getSortedSourceProviders();
            for (SourceProvider provider : providers) {
                sourceSets.addAll(((AndroidSourceSet)provider).getJava().getSourceDirectoryTrees());
            }
            if (this.scope.hasOutput(TaskOutputHolder.TaskOutputType.NOT_NAMESPACED_R_CLASS_SOURCES)) {
                FileCollection rClassSource = this.scope.getOutput(TaskOutputHolder.TaskOutputType.NOT_NAMESPACED_R_CLASS_SOURCES);
                sourceSets.add((Object)project.fileTree((Object)rClassSource.getSingleFile()).builtBy(new Object[]{rClassSource}));
            }
            if (this.scope.getGenerateBuildConfigTask() != null) {
                sourceSets.add((Object)project.fileTree((Object)this.scope.getBuildConfigSourceOutputDir()).builtBy(new Object[]{this.scope.getGenerateBuildConfigTask().getName()}));
            }
            if (this.scope.getAidlCompileTask() != null) {
                sourceSets.add((Object)project.fileTree((Object)this.scope.getAidlSourceOutputDir()).builtBy(new Object[]{this.scope.getAidlCompileTask().getName()}));
            }
            if (this.scope.getGlobalScope().getExtension().getDataBinding().isEnabled() && this.scope.getDataBindingExportBuildInfoTask() != null) {
                sourceSets.add((Object)project.fileTree((Object)this.scope.getClassOutputForDataBinding()).builtBy(new Object[]{this.scope.getDataBindingExportBuildInfoTask().getName()}));
                FileCollection baseClassSource = this.scope.getOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_BASE_CLASS_SOURCE_OUT);
                sourceSets.add((Object)project.fileTree((Object)baseClassSource.getSingleFile()).builtBy(new Object[]{baseClassSource}));
            }
            if (!this.variantConfiguration.getRenderscriptNdkModeEnabled() && this.scope.getRenderscriptCompileTask() != null) {
                sourceSets.add((Object)project.fileTree((Object)this.scope.getRenderscriptSourceOutputDir()).builtBy(new Object[]{this.scope.getRenderscriptCompileTask().getName()}));
            }
            this.defaultJavaSources = sourceSets.build();
        }
        return this.defaultJavaSources;
    }

    public List<File> getJavaSourceFoldersForCoverage() {
        ArrayList sourceFolders = Lists.newArrayList();
        List<SourceProvider> providers = this.variantConfiguration.getSortedSourceProviders();
        for (SourceProvider provider : providers) {
            for (File sourceFolder : provider.getJavaDirectories()) {
                if (!sourceFolder.isDirectory()) continue;
                sourceFolders.add(sourceFolder);
            }
        }
        File sourceFolder = this.aidlCompileTask.getSourceOutputDir();
        if (sourceFolder.isDirectory()) {
            sourceFolders.add(sourceFolder);
        }
        if (!this.variantConfiguration.getRenderscriptNdkModeEnabled() && (sourceFolder = this.renderscriptCompileTask.getSourceOutputDir()).isDirectory()) {
            sourceFolders.add(sourceFolder);
        }
        return sourceFolders;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.variantConfiguration.getFullName()).toString();
    }

    public VariantScope getScope() {
        return this.scope;
    }

    public File getJavaResourcesForUnitTesting() {
        if (this.processJavaResourcesTask != null) {
            return this.processJavaResourcesTask.getOutputs().getFiles().getSingleFile();
        }
        return this.scope.getSourceFoldersJavaResDestinationDir();
    }

    private static enum DiscoverableFilterType {
        DENSITY("drawable-"){

            @Override
            Collection<String> getConfiguredFilters(Splits splits) {
                return splits.getDensityFilters();
            }

            @Override
            boolean isAuto(Splits splits) {
                return splits.getDensity().isAuto();
            }
        }
        ,
        LANGUAGE("values-"){

            @Override
            Collection<String> getConfiguredFilters(Splits splits) {
                return splits.getLanguageFilters();
            }

            @Override
            boolean isAuto(Splits splits) {
                return splits.getLanguage().isAuto();
            }
        }
        ,
        ABI(""){

            @Override
            Collection<String> getConfiguredFilters(Splits splits) {
                return splits.getAbiFilters();
            }

            @Override
            boolean isAuto(Splits splits) {
                return false;
            }
        };

        private String folderPrefix;

        private DiscoverableFilterType(String folderPrefix) {
            this.folderPrefix = folderPrefix;
        }

        abstract Collection<String> getConfiguredFilters(Splits var1);

        abstract boolean isAuto(Splits var1);
    }
}

