/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.shrinker.ClassLookupException;
import com.android.build.gradle.shrinker.Dependency;
import com.android.build.gradle.shrinker.DependencyType;
import com.android.build.gradle.shrinker.PostProcessingData;
import com.android.build.gradle.shrinker.RewriteOutputVisitor;
import com.android.build.gradle.shrinker.ShrinkerGraph;
import com.android.build.gradle.shrinker.ShrinkerLogger;
import com.android.build.gradle.shrinker.TypeHierarchyTraverser;
import com.android.build.gradle.shrinker.parser.BytecodeVersion;
import com.android.build.gradle.shrinker.tracing.Trace;
import com.android.build.gradle.shrinker.tracing.Tracer;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public abstract class AbstractShrinker<T> {
    private static final boolean IGNORE_PACKAGE_NAME = Boolean.getBoolean("android.newShrinker.ignorePackageName");
    protected final WaitableExecutor mExecutor;
    protected final ShrinkerGraph<T> mGraph;
    protected final ShrinkerLogger mShrinkerLogger;
    private final BytecodeVersion mBytecodeVersion;

    protected AbstractShrinker(ShrinkerGraph<T> graph, WaitableExecutor executor, ShrinkerLogger shrinkerLogger, BytecodeVersion bytecodeVersion) {
        this.mGraph = graph;
        this.mExecutor = executor;
        this.mShrinkerLogger = shrinkerLogger;
        this.mBytecodeVersion = bytecodeVersion;
    }

    static boolean isSdkPackage(String className) {
        if (IGNORE_PACKAGE_NAME) {
            return false;
        }
        return className.startsWith("java/") || className.startsWith("android/view/") || className.startsWith("android/content/") || className.startsWith("android/graphics/") || className.startsWith("android/os/") || className.startsWith("android/widget/") || className.startsWith("android/app/") || className.startsWith("android/util/") || className.startsWith("android/net/") || className.startsWith("android/database/") || className.startsWith("android/animation/") || className.startsWith("android/preference/") || className.startsWith("android/media/") || className.startsWith("android/text/");
    }

    protected Optional<File> chooseOutputFile(T klass, File classFile, Iterable<TransformInput> inputs, TransformOutputProvider output) {
        String classFilePath = classFile.getAbsolutePath();
        for (TransformInput input : inputs) {
            Iterable directoriesAndJars = Iterables.concat((Iterable)input.getDirectoryInputs(), (Iterable)input.getJarInputs());
            for (QualifiedContent directoryOrJar : directoriesAndJars) {
                File file = directoryOrJar.getFile();
                if (!classFilePath.startsWith(file.getAbsolutePath())) continue;
                File outputDir = output.getContentLocation(directoryOrJar.getName(), directoryOrJar.getContentTypes(), directoryOrJar.getScopes(), Format.DIRECTORY);
                return Optional.of(new File(outputDir, this.mGraph.getClassName(klass) + ".class"));
            }
        }
        return Optional.empty();
    }

    protected static Collection<File> getAllDirectories(TransformInput input) {
        return input.getDirectoryInputs().stream().map(QualifiedContent::getFile).collect(Collectors.toList());
    }

    protected static Collection<File> getAllJars(TransformInput input) {
        return input.getJarInputs().stream().map(QualifiedContent::getFile).collect(Collectors.toList());
    }

    protected void incrementCounter(T node, DependencyType dependencyType, CounterSet counterSet, Tracer<T> tracer, Trace<T> trace) {
        if (this.mGraph.incrementAndCheck(node, dependencyType, counterSet)) {
            trace = trace.with(node, dependencyType);
            tracer.nodeReached(node, trace);
            for (Dependency<T> dependency : this.mGraph.getDependencies(node)) {
                this.incrementCounter(dependency.target, dependency.type, counterSet, tracer, trace);
            }
        }
    }

    protected void resolveReferences(Iterable<PostProcessingData.UnresolvedReference<T>> unresolvedReferences) {
        for (PostProcessingData.UnresolvedReference<T> unresolvedReference : unresolvedReferences) {
            this.mExecutor.execute(() -> {
                Object target = unresolvedReference.target;
                Object source = unresolvedReference.method;
                T startClass = this.mGraph.getOwnerClass(target);
                if (unresolvedReference.invokespecial) {
                    T sourceClass = this.mGraph.getOwnerClass(source);
                    try {
                        startClass = this.mGraph.getSuperclass(sourceClass);
                        Preconditions.checkState((startClass != null ? 1 : 0) != 0);
                    }
                    catch (ClassLookupException e) {
                        this.mShrinkerLogger.invalidClassReference(this.mGraph.getClassName(sourceClass), e.getClassName());
                    }
                }
                Verify.verifyNotNull(startClass);
                if (!this.mGraph.isClassKnown(startClass)) {
                    this.mShrinkerLogger.invalidClassReference(this.mGraph.getFullMemberName(source), this.mGraph.getClassName(startClass));
                    return null;
                }
                TypeHierarchyTraverser<T> traverser = TypeHierarchyTraverser.superclassesAndInterfaces(this.mGraph, this.mShrinkerLogger);
                for (Object currentClass : traverser.preOrderTraversal(startClass)) {
                    T matchingMethod = this.mGraph.findMatchingMethod(currentClass, target);
                    if (matchingMethod == null) continue;
                    if (this.isProgramClass(this.mGraph.getOwnerClass(matchingMethod))) {
                        this.mGraph.addDependency(source, currentClass, unresolvedReference.dependencyType);
                        this.mGraph.addDependency(source, matchingMethod, unresolvedReference.dependencyType);
                    }
                    return null;
                }
                this.mShrinkerLogger.invalidMemberReference(this.mGraph.getFullMemberName(source), this.mGraph.getFullMemberName(target));
                return null;
            });
        }
    }

    protected boolean isProgramClass(T klass) {
        return this.mGraph.isProgramClass(klass);
    }

    protected byte[] rewrite(String className, File classFile, Set<String> membersToKeep, Predicate<String> keepInterface) throws IOException {
        byte[] bytes;
        if (Files.getFileExtension((String)classFile.getName()).equals("class")) {
            bytes = Files.toByteArray((File)classFile);
        } else {
            try (JarFile jarFile = new JarFile(classFile);){
                JarEntry jarEntry = jarFile.getJarEntry(className + ".class");
                bytes = ByteStreams.toByteArray((InputStream)jarFile.getInputStream(jarEntry));
            }
        }
        ClassReader classReader = new ClassReader(bytes);
        ClassWriter classWriter = new ClassWriter(0);
        RewriteOutputVisitor filter = new RewriteOutputVisitor(membersToKeep, keepInterface, this.mBytecodeVersion, (ClassVisitor)classWriter);
        classReader.accept((ClassVisitor)filter, 0);
        return classWriter.toByteArray();
    }

    protected void setCounters(CounterSet counterSet, Tracer<T> tracer) {
        Map<T, DependencyType> roots = this.mGraph.getRoots(counterSet);
        for (Map.Entry<T, DependencyType> toIncrementEntry : roots.entrySet()) {
            this.mExecutor.execute(() -> {
                this.incrementCounter(toIncrementEntry.getKey(), (DependencyType)((Object)((Object)toIncrementEntry.getValue())), counterSet, tracer, tracer.startTrace());
                return null;
            });
        }
        this.waitForAllTasks();
    }

    protected void updateClassFiles(Iterable<T> classesToWrite, Iterable<File> classFilesToDelete, Iterable<TransformInput> inputs, TransformOutputProvider output) throws IOException {
        for (T klass : classesToWrite) {
            File sourceFile = this.mGraph.getSourceFile(klass);
            Preconditions.checkState((sourceFile != null ? 1 : 0) != 0, (Object)"Program class has no source file.");
            Optional<File> outputFile = this.chooseOutputFile(klass, sourceFile, inputs, output);
            if (!outputFile.isPresent()) continue;
            Files.createParentDirs((File)outputFile.get());
            Predicate<String> keepInterfacePredicate = input -> {
                T iface = this.mGraph.getClassReference((String)input);
                return !this.isProgramClass(iface) || this.mGraph.isReachable(iface, CounterSet.SHRINK);
            };
            this.mExecutor.execute(() -> {
                byte[] newBytes = this.rewrite(this.mGraph.getClassName(klass), sourceFile, this.mGraph.getReachableMembersLocalNames(klass, CounterSet.SHRINK), keepInterfacePredicate);
                Files.write((byte[])newBytes, (File)((File)outputFile.get()));
                return null;
            });
        }
        for (File classFile : classFilesToDelete) {
            FileUtils.delete((File)classFile);
        }
        this.waitForAllTasks();
    }

    protected void waitForAllTasks() {
        try {
            this.mExecutor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void logTime(String section, Stopwatch stopwatch) {
        if (System.getProperty("android.newShrinker.profile") != null) {
            System.out.println(section + ": " + stopwatch);
            stopwatch.reset();
            stopwatch.start();
        }
    }

    public static enum CounterSet {
        SHRINK,
        LEGACY_MULTIDEX;

    }
}

