/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.ide.common.symbols.SymbolIo;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.ArtifactTransform;

public class LibrarySymbolTableTransform
extends ArtifactTransform {
    @Inject
    public LibrarySymbolTableTransform() {
    }

    public List<File> transform(File explodedAar) {
        try {
            Path result = LibrarySymbolTableTransform.transform(explodedAar.toPath(), this.getOutputDirectory().toPath());
            return result != null ? ImmutableList.of((Object)result.toFile()) : ImmutableList.of();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Path transform(Path explodedAar, Path outputDirectory) throws IOException {
        Path manifest = explodedAar.resolve("AndroidManifest.xml");
        if (!Files.exists(manifest, new LinkOption[0])) {
            return null;
        }
        Path rTxt = explodedAar.resolve("R.txt");
        Files.createDirectories(outputDirectory, new FileAttribute[0]);
        Path outputFile = outputDirectory.resolve("package-aware-r.txt");
        SymbolIo.writeSymbolTableWithPackage((Path)rTxt, (Path)manifest, (Path)outputFile);
        return outputFile;
    }
}

