/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.ArtifactTransform;

public class AarTransform
extends ArtifactTransform {
    private final AndroidArtifacts.ArtifactType targetType;
    private final boolean sharedLibSupport;

    @Inject
    public AarTransform(AndroidArtifacts.ArtifactType targetType, boolean sharedLibSupport) {
        this.targetType = targetType;
        this.sharedLibSupport = sharedLibSupport;
    }

    public static AndroidArtifacts.ArtifactType[] getTransformTargets() {
        return new AndroidArtifacts.ArtifactType[]{AndroidArtifacts.ArtifactType.CLASSES, AndroidArtifacts.ArtifactType.SHARED_CLASSES, AndroidArtifacts.ArtifactType.JAVA_RES, AndroidArtifacts.ArtifactType.SHARED_JAVA_RES, AndroidArtifacts.ArtifactType.JAR, AndroidArtifacts.ArtifactType.MANIFEST, AndroidArtifacts.ArtifactType.ANDROID_RES, AndroidArtifacts.ArtifactType.ASSETS, AndroidArtifacts.ArtifactType.SHARED_ASSETS, AndroidArtifacts.ArtifactType.JNI, AndroidArtifacts.ArtifactType.SHARED_JNI, AndroidArtifacts.ArtifactType.AIDL, AndroidArtifacts.ArtifactType.RENDERSCRIPT, AndroidArtifacts.ArtifactType.PROGUARD_RULES, AndroidArtifacts.ArtifactType.LINT, AndroidArtifacts.ArtifactType.ANNOTATIONS, AndroidArtifacts.ArtifactType.PUBLIC_RES, AndroidArtifacts.ArtifactType.SYMBOL_LIST, AndroidArtifacts.ArtifactType.DATA_BINDING_ARTIFACT, AndroidArtifacts.ArtifactType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT, AndroidArtifacts.ArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR, AndroidArtifacts.ArtifactType.RES_STATIC_LIBRARY, AndroidArtifacts.ArtifactType.RES_SHARED_STATIC_LIBRARY};
    }

    public List<File> transform(File input) {
        switch (this.targetType) {
            case CLASSES: 
            case JAVA_RES: 
            case JAR: {
                return this.isShared(input) ? Collections.emptyList() : AarTransform.getJars(input);
            }
            case SHARED_CLASSES: 
            case SHARED_JAVA_RES: {
                return this.isShared(input) ? AarTransform.getJars(input) : Collections.emptyList();
            }
            case LINT: {
                return AarTransform.listIfExists(FileUtils.join((File)input, (String[])new String[]{"jars", "lint.jar"}));
            }
            case MANIFEST: {
                if (this.isShared(input)) {
                    return AarTransform.listIfExists(Stream.of(new File(input, "AndroidManifest.xml"), new File(input, "SharedLibraryAndroidManifest.xml")));
                }
                return AarTransform.listIfExists(new File(input, "AndroidManifest.xml"));
            }
            case ANDROID_RES: {
                return AarTransform.listIfExists(new File(input, "res"));
            }
            case ASSETS: {
                return AarTransform.listIfExists(new File(input, "assets"));
            }
            case JNI: {
                return AarTransform.listIfExists(new File(input, "jni"));
            }
            case AIDL: {
                return AarTransform.listIfExists(new File(input, "aidl"));
            }
            case RENDERSCRIPT: {
                return AarTransform.listIfExists(new File(input, "rs"));
            }
            case PROGUARD_RULES: {
                return AarTransform.listIfExists(new File(input, "proguard.txt"));
            }
            case ANNOTATIONS: {
                return AarTransform.listIfExists(new File(input, "annotations.zip"));
            }
            case PUBLIC_RES: {
                return AarTransform.listIfExists(new File(input, "public.txt"));
            }
            case SYMBOL_LIST: {
                return AarTransform.listIfExists(new File(input, "R.txt"));
            }
            case RES_STATIC_LIBRARY: {
                return this.isShared(input) ? Collections.emptyList() : AarTransform.listIfExists(new File(input, "res.apk"));
            }
            case RES_SHARED_STATIC_LIBRARY: {
                return this.isShared(input) ? AarTransform.listIfExists(new File(input, "shared.apk")) : Collections.emptyList();
            }
            case COMPILE_ONLY_NAMESPACED_R_CLASS_JAR: {
                return AarTransform.listIfExists(new File(input, "R.jar"));
            }
            case DATA_BINDING_ARTIFACT: {
                return AarTransform.listIfExists(new File(input, "data-binding"));
            }
            case DATA_BINDING_BASE_CLASS_LOG_ARTIFACT: {
                return AarTransform.listIfExists(new File(input, "data-binding-base-class-log"));
            }
        }
        throw new RuntimeException("Unsupported type in AarTransform: " + (Object)((Object)this.targetType));
    }

    private static List<File> getJars(File explodedAar) {
        File localJarFolder;
        File[] jars;
        ArrayList files = Lists.newArrayList();
        File jarFolder = new File(explodedAar, "jars");
        File file = FileUtils.join((File)jarFolder, (String[])new String[]{"classes.jar"});
        if (file.isFile()) {
            files.add(file);
        }
        if ((jars = (localJarFolder = new File(jarFolder, "libs")).listFiles((dir, name) -> name.endsWith(".jar"))) != null) {
            files.addAll(Arrays.asList(jars));
        }
        return files;
    }

    private boolean isShared(File explodedAar) {
        return this.sharedLibSupport && new File(explodedAar, "SharedLibraryAndroidManifest.xml").exists();
    }

    private static List<File> listIfExists(File file) {
        return file.exists() ? Collections.singletonList(file) : Collections.emptyList();
    }

    private static List<File> listIfExists(Stream<File> files) {
        return files.filter(File::exists).collect(Collectors.toList());
    }
}

