/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public abstract class ProcessAndroidResources
extends IncrementalTask {
    protected OutputScope outputScope;
    protected FileCollection manifestFiles;

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getManifestFiles() {
        return this.manifestFiles;
    }

    protected void setManifestFiles(FileCollection manifestFiles) {
        this.manifestFiles = manifestFiles;
    }

    public abstract File getSourceOutputDir();

    public File getManifestFile() {
        File manifestDirectory = (File)Iterables.getFirst((Iterable)this.manifestFiles.getFiles(), null);
        Preconditions.checkNotNull((Object)manifestDirectory);
        Preconditions.checkNotNull((Object)this.outputScope.getMainSplit());
        return FileUtils.join((File)manifestDirectory, (String[])new String[]{this.outputScope.getMainSplit().getDirName(), "AndroidManifest.xml"});
    }
}

