/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.packaging;

import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.packaging.PackagingFileAction;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.stream.Collectors;

public class ParsedPackagingOptions {
    private final ImmutableSet<PathMatcher> excludes;
    private final ImmutableSet<PathMatcher> pickFirsts;
    private final ImmutableSet<PathMatcher> merges;
    private final ImmutableSet<String> excludePatterns;
    private final ImmutableSet<String> pickFirstPatterns;
    private final ImmutableSet<String> mergePatterns;

    public ParsedPackagingOptions(PackagingOptions packagingOptions) {
        if (packagingOptions == null) {
            packagingOptions = new PackagingOptions();
        }
        this.excludePatterns = ImmutableSet.copyOf(packagingOptions.getExcludes());
        this.pickFirstPatterns = ImmutableSet.copyOf(packagingOptions.getPickFirsts());
        this.mergePatterns = ImmutableSet.copyOf(packagingOptions.getMerges());
        this.excludes = ImmutableSet.copyOf((Collection)packagingOptions.getExcludes().stream().map(ParsedPackagingOptions::compileGlob).collect(Collectors.toSet()));
        this.pickFirsts = ImmutableSet.copyOf((Collection)packagingOptions.getPickFirsts().stream().map(ParsedPackagingOptions::compileGlob).collect(Collectors.toSet()));
        this.merges = ImmutableSet.copyOf((Collection)packagingOptions.getMerges().stream().map(ParsedPackagingOptions::compileGlob).collect(Collectors.toSet()));
    }

    private static PathMatcher compileGlob(String pattern) {
        FileSystem fs = FileSystems.getDefault();
        if (!pattern.startsWith("/") && !pattern.startsWith("*")) {
            pattern = "/" + pattern;
        }
        return fs.getPathMatcher("glob:" + pattern);
    }

    public PackagingFileAction getAction(String archivePath) {
        String absPath = archivePath;
        if (!absPath.startsWith("/")) {
            absPath = "/" + absPath;
        }
        Path path = Paths.get(absPath.replace('/', File.separatorChar), new String[0]);
        if (this.pickFirsts.stream().anyMatch(m -> m.matches(path))) {
            return PackagingFileAction.PICK_FIRST;
        }
        if (this.merges.stream().anyMatch(m -> m.matches(path))) {
            return PackagingFileAction.MERGE;
        }
        if (this.excludes.stream().anyMatch(m -> m.matches(path))) {
            return PackagingFileAction.EXCLUDE;
        }
        return PackagingFileAction.NONE;
    }

    public ImmutableSet<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public ImmutableSet<String> getPickFirstPatterns() {
        return this.pickFirstPatterns;
    }

    public ImmutableSet<String> getMergePatterns() {
        return this.mergePatterns;
    }
}

