/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactImpl;
import com.android.build.gradle.internal.scope.MissingBuildableArtifactException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001+B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0018\u001a\u00020\u0005J%\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001cJ\u001e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J$\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0013H\u0002J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010'\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0002J$\u0010*\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0018\u001a\u00020\u0005R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/build/gradle/internal/scope/BuildArtifactHolder;", "", "project", "Lorg/gradle/api/Project;", "variantName", "", "rootOutputDir", "Ljava/io/File;", "variantDirName", "initialArtifactTypes", "", "Lcom/android/build/api/artifact/BuildArtifactType;", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "(Lorg/gradle/api/Project;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Ljava/util/List;Lcom/android/builder/errors/EvalIssueReporter;)V", "artifactRecordMap", "", "Lcom/android/build/gradle/internal/scope/BuildArtifactHolder$ArtifactRecord;", "appendArtifact", "Lcom/android/build/api/artifact/BuildableArtifact;", "artifactType", "Lcom/android/build/api/artifact/ArtifactType;", "filenames", "", "taskName", "createFile", "kotlin.jvm.PlatformType", "filename", "createFile$gradle_core", "createFirstArtifactFiles", "createOutput", "", "artifact", "getArtifactFiles", "getHistory", "getTaskName", "prefix", "hasArtifact", "", "initializeFirstArtifactFiles", "collection", "Lorg/gradle/api/file/FileCollection;", "replaceArtifact", "ArtifactRecord", "gradle-core"})
public final class BuildArtifactHolder {
    private final Map<BuildArtifactType, ArtifactRecord> artifactRecordMap;
    private final Project project;
    private final String variantName;
    private final File rootOutputDir;
    private final String variantDirName;
    private final EvalIssueReporter issueReporter;

    @NotNull
    public final String getTaskName(@NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        return prefix + StringsKt.capitalize((String)this.variantName);
    }

    @NotNull
    public final BuildableArtifact getArtifactFiles(@NotNull ArtifactType artifactType) {
        Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
        Map<BuildArtifactType, ArtifactRecord> map = this.artifactRecordMap;
        ArtifactRecord artifactRecord = map.get(artifactType);
        if (artifactRecord == null) {
            throw (Throwable)new MissingBuildableArtifactException(artifactType);
        }
        ArtifactRecord output = artifactRecord;
        return output.getLast();
    }

    public final boolean hasArtifact(@NotNull ArtifactType artifactType) {
        Map<BuildArtifactType, ArtifactRecord> map;
        Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
        Map<BuildArtifactType, ArtifactRecord> map2 = map = this.artifactRecordMap;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map2.containsKey(artifactType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BuildableArtifact replaceArtifact(@NotNull ArtifactType artifactType, @NotNull Collection<String> filenames, @NotNull String taskName) {
        Collection<File> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
        Intrinsics.checkParameterIsNotNull(filenames, (String)"filenames");
        Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
        Iterable iterable = filenames;
        int n = 0;
        Object[] objectArray2 = objectArray = new Object[1];
        Project project = this.project;
        void var6_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            File file = this.createFile$gradle_core(taskName, (String)it);
            collection.add(file);
        }
        collection = (List)destination$iv$iv;
        objectArray[n] = collection;
        ConfigurableFileCollection collection2 = project.files(objectArray2).builtBy(new Object[]{taskName});
        BuildableArtifactImpl files = new BuildableArtifactImpl((FileCollection)collection2, this.issueReporter);
        this.createOutput(artifactType, files);
        return files;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BuildableArtifact appendArtifact(@NotNull ArtifactType artifactType, @NotNull Collection<String> filenames, @NotNull String taskName) {
        Collection<File> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
        Intrinsics.checkParameterIsNotNull(filenames, (String)"filenames");
        Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
        BuildableArtifact originalOutput = this.getArtifactFiles(artifactType);
        Iterable iterable = filenames;
        int n = 0;
        Object[] objectArray2 = objectArray = new Object[2];
        Project project = this.project;
        void var7_10 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            File file = this.createFile$gradle_core(taskName, (String)it);
            collection.add(file);
        }
        collection = (List)destination$iv$iv;
        objectArray[n] = collection;
        objectArray2[1] = originalOutput;
        ConfigurableFileCollection collection2 = project.files(objectArray2).builtBy(new Object[]{taskName, originalOutput});
        BuildableArtifactImpl files = new BuildableArtifactImpl((FileCollection)collection2, this.issueReporter);
        this.createOutput(artifactType, files);
        return files;
    }

    private final void createOutput(ArtifactType artifactType, BuildableArtifact artifact) {
        Map<BuildArtifactType, ArtifactRecord> map = this.artifactRecordMap;
        ArtifactRecord artifactRecord = map.get(artifactType);
        if (artifactRecord == null) {
            throw (Throwable)new MissingBuildableArtifactException(artifactType);
        }
        ArtifactRecord output = artifactRecord;
        output.setLast(artifact);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BuildableArtifact createFirstArtifactFiles(@NotNull ArtifactType artifactType, @NotNull Collection<String> filenames, @NotNull String taskName) {
        Collection<File> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
        Intrinsics.checkParameterIsNotNull(filenames, (String)"filenames");
        Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
        Iterable iterable = filenames;
        int n = 0;
        Object[] objectArray2 = objectArray = new Object[1];
        Project project = this.project;
        void var6_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            File file = this.createFile$gradle_core(artifactType.name(), (String)it);
            collection.add(file);
        }
        collection = (List)destination$iv$iv;
        objectArray[n] = collection;
        ConfigurableFileCollection collection2 = project.files(objectArray2);
        collection2.builtBy(new Object[]{taskName});
        ConfigurableFileCollection configurableFileCollection = collection2;
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"collection");
        return this.initializeFirstArtifactFiles(artifactType, (FileCollection)configurableFileCollection);
    }

    @NotNull
    public final BuildableArtifact createFirstArtifactFiles(@NotNull ArtifactType artifactType, @NotNull String filename, @NotNull String taskName) {
        Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
        ConfigurableFileCollection collection = this.project.files(new Object[]{this.createFile$gradle_core(artifactType.name(), filename)});
        collection.builtBy(new Object[]{taskName});
        ConfigurableFileCollection configurableFileCollection = collection;
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"collection");
        return this.initializeFirstArtifactFiles(artifactType, (FileCollection)configurableFileCollection);
    }

    private final BuildableArtifact initializeFirstArtifactFiles(ArtifactType artifactType, FileCollection collection) {
        Map<BuildArtifactType, ArtifactRecord> map = this.artifactRecordMap;
        ArtifactRecord artifactRecord = map.get(artifactType);
        if (artifactRecord == null) {
            throw (Throwable)new MissingBuildableArtifactException(artifactType);
        }
        ArtifactRecord output = artifactRecord;
        if (output.getInitialized()) {
            throw (Throwable)new RuntimeException("Artifact already registered for type: " + artifactType);
        }
        output.modifyFirst(collection);
        return output.getFirst();
    }

    public final File createFile$gradle_core(@NotNull String taskName, @NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        return FileUtils.join((File)this.rootOutputDir, (String[])new String[]{taskName, this.variantDirName, filename});
    }

    @NotNull
    public final List<BuildableArtifact> getHistory(@NotNull ArtifactType artifactType) {
        Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
        Map<BuildArtifactType, ArtifactRecord> map = this.artifactRecordMap;
        ArtifactRecord artifactRecord = map.get(artifactType);
        if (artifactRecord == null) {
            throw (Throwable)new MissingBuildableArtifactException(artifactType);
        }
        ArtifactRecord record = artifactRecord;
        return record.getHistory();
    }

    /*
     * WARNING - void declaration
     */
    public BuildArtifactHolder(@NotNull Project project, @NotNull String variantName, @NotNull File rootOutputDir, @NotNull String variantDirName, @NotNull List<? extends BuildArtifactType> initialArtifactTypes, @NotNull EvalIssueReporter issueReporter) {
        Map map;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)rootOutputDir, (String)"rootOutputDir");
        Intrinsics.checkParameterIsNotNull((Object)variantDirName, (String)"variantDirName");
        Intrinsics.checkParameterIsNotNull(initialArtifactTypes, (String)"initialArtifactTypes");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        this.project = project;
        this.variantName = variantName;
        this.rootOutputDir = rootOutputDir;
        this.variantDirName = variantDirName;
        this.issueReporter = issueReporter;
        Iterable iterable = initialArtifactTypes;
        BuildArtifactHolder buildArtifactHolder = this;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var9_10 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map2 = destination$iv$iv;
            BuildArtifactType it = (BuildArtifactType)element$iv$iv;
            Pair pair = TuplesKt.to((Object)it, (Object)new ArtifactRecord(new BuildableArtifactImpl(null, this.issueReporter)));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        buildArtifactHolder.artifactRecordMap = map = destination$iv$iv;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0007\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/scope/BuildArtifactHolder$ArtifactRecord;", "", "first", "Lcom/android/build/gradle/internal/api/artifact/BuildableArtifactImpl;", "(Lcom/android/build/gradle/internal/api/artifact/BuildableArtifactImpl;)V", "Lcom/android/build/api/artifact/BuildableArtifact;", "getFirst", "()Lcom/android/build/api/artifact/BuildableArtifact;", "history", "", "getHistory", "()Ljava/util/List;", "setHistory", "(Ljava/util/List;)V", "initialized", "", "getInitialized", "()Z", "setInitialized", "(Z)V", "value", "last", "getLast", "setLast", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "modifyFirst", "", "collection", "Lorg/gradle/api/file/FileCollection;", "gradle-core"})
    private static final class ArtifactRecord {
        private boolean initialized;
        @NotNull
        private List<BuildableArtifact> history;

        public final boolean getInitialized() {
            return this.initialized;
        }

        public final void setInitialized(boolean bl) {
            this.initialized = bl;
        }

        @NotNull
        public final List<BuildableArtifact> getHistory() {
            return this.history;
        }

        public final void setHistory(@NotNull List<BuildableArtifact> list) {
            Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
            this.history = list;
        }

        @NotNull
        public final BuildableArtifact getLast() {
            return (BuildableArtifact)CollectionsKt.last(this.history);
        }

        public final void setLast(@NotNull BuildableArtifact value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.history.add(value);
        }

        @NotNull
        public final BuildableArtifact getFirst() {
            return (BuildableArtifact)CollectionsKt.first(this.history);
        }

        public final void modifyFirst(@NotNull FileCollection collection) {
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            this.initialized = true;
            Object object = CollectionsKt.first(this.history);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.api.artifact.BuildableArtifactImpl");
            }
            ((BuildableArtifactImpl)object).setFileCollection$gradle_core(collection);
        }

        public ArtifactRecord(@NotNull BuildableArtifactImpl first) {
            Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
            this.history = CollectionsKt.mutableListOf((Object[])new BuildableArtifact[]{first});
        }
    }
}

