/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class FeatureSplitPackageIds {
    static final String OUTPUT_FILE_NAME = "package_ids.json";
    public static final int BASE_ID = 128;
    private final Set<SplitPackageId> featureSplits;

    public FeatureSplitPackageIds() {
        this.featureSplits = new HashSet<SplitPackageId>();
    }

    private FeatureSplitPackageIds(Set<SplitPackageId> featureSplits) {
        this.featureSplits = featureSplits;
    }

    public synchronized void addFeatureSplit(String featureSplit) {
        this.featureSplits.add(new SplitPackageId(featureSplit, 128 + this.featureSplits.size()));
    }

    public Integer getIdFor(String featureSplit) {
        Optional<SplitPackageId> splitPacakgeId = this.featureSplits.stream().filter(splitPackageId -> splitPackageId.splitIdentifier.equals(featureSplit)).findFirst();
        return splitPacakgeId.isPresent() ? Integer.valueOf(splitPacakgeId.get().id) : null;
    }

    public void save(File outputDirectory) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        File outputFile = FeatureSplitPackageIds.getOutputFile(outputDirectory);
        Files.write((CharSequence)gson.toJson(this.featureSplits), (File)outputFile, (Charset)Charsets.UTF_8);
    }

    public static FeatureSplitPackageIds load(Set<File> files) throws IOException {
        File outputFile = FeatureSplitPackageIds.getOutputFile(files);
        if (outputFile == null) {
            throw new FileNotFoundException("Cannot find package ids json file");
        }
        return FeatureSplitPackageIds.load(outputFile);
    }

    public static FeatureSplitPackageIds load(File input) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        Type typeToken = new TypeToken<HashSet<SplitPackageId>>(){}.getType();
        try (FileReader fileReader = new FileReader(input);){
            Set featureIds = (Set)gson.fromJson((Reader)fileReader, typeToken);
            FeatureSplitPackageIds featureSplitPackageIds = new FeatureSplitPackageIds(featureIds);
            return featureSplitPackageIds;
        }
    }

    public static File getOutputFile(File outputDirectory) {
        return new File(outputDirectory, OUTPUT_FILE_NAME);
    }

    public static File getOutputFile(Set<File> files) {
        for (File file : files) {
            if (!file.getName().equals(OUTPUT_FILE_NAME)) continue;
            return file;
        }
        return null;
    }

    private static class SplitPackageId {
        final String splitIdentifier;
        final int id;

        SplitPackageId(String splitIdentifier, int id) {
            this.splitIdentifier = splitIdentifier;
            this.id = id;
        }
    }
}

