/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.core.DexByteCodeConverter;
import com.android.builder.core.DexOptions;
import com.android.builder.dexing.DexingType;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileCollection;

public class DexTransform
extends Transform {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DexTransform.class);
    private final DexOptions dexOptions;
    private final DexingType dexingType;
    private boolean preDexEnabled;
    private final FileCollection mainDexListFile;
    private final TargetInfo targetInfo;
    private final DexByteCodeConverter dexByteCodeConverter;
    private final MessageReceiver messageReceiver;
    private final int minSdkVersion;

    public DexTransform(DexOptions dexOptions, DexingType dexingType, boolean preDexEnabled, FileCollection mainDexListFile, TargetInfo targetInfo, DexByteCodeConverter dexByteCodeConverter, MessageReceiver messageReceiver, int minSdkVersion) {
        this.dexOptions = dexOptions;
        this.dexingType = dexingType;
        this.preDexEnabled = preDexEnabled;
        this.mainDexListFile = mainDexListFile;
        this.targetInfo = targetInfo;
        this.dexByteCodeConverter = dexByteCodeConverter;
        this.messageReceiver = messageReceiver;
        this.minSdkVersion = minSdkVersion;
    }

    public String getName() {
        return "dex";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        if (!this.preDexEnabled) {
            return TransformManager.CONTENT_CLASS;
        }
        return TransformManager.CONTENT_DEX;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return TransformManager.CONTENT_DEX;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_WITH_IR_FOR_DEXING;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        if (this.mainDexListFile != null) {
            return ImmutableList.of((Object)SecondaryFile.nonIncremental((FileCollection)this.mainDexListFile));
        }
        return ImmutableList.of();
    }

    public Map<String, Object> getParameterInputs() {
        try {
            HashMap params = Maps.newHashMapWithExpectedSize((int)8);
            params.put("optimize", true);
            params.put("predex", this.preDexEnabled);
            params.put("jumbo", this.dexOptions.getJumboMode());
            params.put("dexing-mode", this.dexingType.name());
            params.put("java-max-heap-size", this.dexOptions.getJavaMaxHeapSize());
            params.put("additional-parameters", Iterables.toString((Iterable)this.dexOptions.getAdditionalParameters()));
            BuildToolInfo buildTools = this.targetInfo.getBuildTools();
            params.put("build-tools", buildTools.getRevision().toString());
            params.put("min-sdk-version", this.minSdkVersion);
            return params;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isIncremental() {
        return false;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, IOException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        if (!this.dexOptions.getKeepRuntimeAnnotatedClasses() && this.mainDexListFile == null) {
            logger.info("DexOptions.keepRuntimeAnnotatedClasses has no affect in native multidex.", new Object[0]);
        }
        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)logger), new MessageReceiver[]{this.messageReceiver});
        outputProvider.deleteAll();
        try {
            Collection<File> transformInputs = TransformInputUtil.getAllFiles(transformInvocation.getInputs());
            File outputDir = outputProvider.getContentLocation("main", this.getOutputTypes(), TransformManager.SCOPE_FULL_PROJECT, Format.DIRECTORY);
            FileUtils.cleanOutputDir((File)outputDir);
            File mainDexList = null;
            if (this.mainDexListFile != null && this.dexingType == DexingType.LEGACY_MULTIDEX) {
                mainDexList = this.mainDexListFile.getSingleFile();
            }
            this.dexByteCodeConverter.convertByteCode(transformInputs, outputDir, this.dexingType.isMultiDex(), mainDexList, this.dexOptions, (ProcessOutputHandler)outputHandler, this.minSdkVersion);
        }
        catch (Exception e) {
            throw new TransformException((Throwable)e);
        }
    }
}

