/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AppPreBuildTask;
import com.android.build.gradle.internal.tasks.ApplicationId;
import com.android.build.gradle.internal.tasks.ApplicationIdWriterTask;
import com.android.build.gradle.internal.tasks.TestPreBuildTask;
import com.android.build.gradle.internal.transforms.InstantRunDependenciesApkBuilder;
import com.android.build.gradle.internal.transforms.InstantRunSliceSplitApkBuilder;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.BuildArtifactReportTask;
import com.android.build.gradle.tasks.MainApkListPersistence;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.android.ide.common.build.ApkInfo;
import com.android.utils.FileUtils;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class ApplicationTaskManager
extends TaskManager {
    public ApplicationTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        BaseVariantData variantData = variantScope.getVariantData();
        assert (variantData instanceof ApplicationVariantData);
        this.createAnchorTasks(variantScope);
        this.createCheckManifestTask(variantScope);
        this.handleMicroApp(variantScope);
        this.createDependencyStreams(variantScope);
        this.createApplicationIdWriterTask(variantScope);
        this.taskFactory.create(new MainApkListPersistence.ConfigAction(variantScope));
        this.taskFactory.create(new BuildArtifactReportTask.ConfigAction(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeApkManifestsTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createGenerateResValuesTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createRenderscriptTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeResourcesTask(variantScope, true));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_SHADER_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createShaderTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeAssetsTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createBuildConfigTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_PROCESS_RES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createApkProcessResTask(variantScope);
            this.createProcessJavaResTask(variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_AIDL_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createAidlTask(variantScope));
        if (!this.isComponentModelPlugin()) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_NDK_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createNdkTasks(variantScope));
        } else if (variantData.compileTask != null) {
            variantData.compileTask.dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        } else {
            variantScope.getCompileTask().dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_EXTERNAL_NATIVE_BUILD_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createExternalNativeBuildJsonGenerators(variantScope);
            this.createExternalNativeBuildTasks(variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_JNILIBS_FOLDERS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeJniLibFoldersTasks(variantScope));
        this.createDataBindingTasksIfNecessary(variantScope, TaskManager.MergeType.MERGE);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_COMPILE_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.addCompileTask(variantScope));
        ApplicationTaskManager.createStripNativeLibraryTask(this.taskFactory, variantScope);
        if (variantScope.getVariantData().getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS)) {
            if (this.extension.getBuildToolsRevision().getMajor() < 21) {
                throw new RuntimeException("Pure splits can only be used with buildtools 21 and later");
            }
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_SPLIT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createSplitTasks(variantScope));
        }
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_PACKAGING_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            BuildInfoWriterTask buildInfoWriterTask = this.createInstantRunPackagingTasks(variantScope);
            this.createPackagingTask(variantScope, buildInfoWriterTask);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_LINT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createLintTasks(variantScope));
    }

    private void addCompileTask(VariantScope variantScope) {
        JavaCompile javacTask = this.createJavacTask(variantScope);
        VariantScope.Java8LangSupport java8LangSupport = variantScope.getJava8LangSupportType();
        if (java8LangSupport == VariantScope.Java8LangSupport.INVALID) {
            return;
        }
        String pluginName = null;
        if (java8LangSupport == VariantScope.Java8LangSupport.RETROLAMBDA) {
            pluginName = "me.tatarka.retrolambda";
        }
        if (pluginName != null) {
            String warningMsg = String.format("One of the plugins you are using supports Java 8 language features. To try the support built into the Android plugin, remove the following from your build.gradle:\n    apply plugin: '%s'\nTo learn more, go to https://d.android.com/r/tools/java-8-support-message.html\n", pluginName);
            this.androidBuilder.getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, warningMsg);
        }
        this.addJavacClassesStream(variantScope);
        ApplicationTaskManager.setJavaCompilerTask((Task)javacTask, variantScope);
        this.createPostCompilationTasks(variantScope);
    }

    private BuildInfoWriterTask createInstantRunPackagingTasks(VariantScope variantScope) {
        if (!variantScope.getInstantRunBuildContext().isInInstantRunMode() || variantScope.getInstantRunTaskManager() == null) {
            return null;
        }
        BuildInfoWriterTask buildInfoGeneratorTask = this.taskFactory.create(new BuildInfoWriterTask.ConfigAction(variantScope, this.getLogger()));
        variantScope.getInstantRunTaskManager().configureBuildInfoWriterTask(buildInfoGeneratorTask, new Task[0]);
        InternalArtifactType resourcesWithMainManifest = variantScope.getInstantRunBuildContext().useSeparateApkForResources() ? InternalArtifactType.INSTANT_RUN_MAIN_APK_RESOURCES : InternalArtifactType.PROCESSED_RES;
        InstantRunDependenciesApkBuilder dependenciesApkBuilder = new InstantRunDependenciesApkBuilder(this.getLogger(), this.project, variantScope.getInstantRunBuildContext(), variantScope.getGlobalScope().getAndroidBuilder(), variantScope.getVariantConfiguration().getApplicationId(), variantScope.getVariantConfiguration().getSigningConfig(), AaptGeneration.fromProjectOptions(this.projectOptions), DslAdaptersKt.convert(this.globalScope.getExtension().getAaptOptions()), new File(variantScope.getInstantRunSplitApkOutputFolder(), "dep"), new File(variantScope.getIncrementalDir("ir_dep"), variantScope.getDirName()), new File(ApplicationTaskManager.getIncrementalFolder(variantScope, "InstantRunDependenciesApkBuilder"), "aapt-temp"), variantScope.getOutput(InternalArtifactType.PROCESSED_RES), variantScope.getOutput(resourcesWithMainManifest), variantScope.getOutput(InternalArtifactType.APK_LIST), (ApkInfo)variantScope.getOutputScope().getMainSplit());
        Optional<TransformTask> dependenciesApkBuilderTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, dependenciesApkBuilder);
        dependenciesApkBuilderTask.ifPresent(task -> task.dependsOn(new Object[]{this.getValidateSigningTask(variantScope)}));
        InstantRunSliceSplitApkBuilder slicesApkBuilder = new InstantRunSliceSplitApkBuilder(this.getLogger(), this.project, variantScope.getInstantRunBuildContext(), variantScope.getGlobalScope().getAndroidBuilder(), variantScope.getVariantConfiguration().getApplicationId(), variantScope.getVariantConfiguration().getSigningConfig(), AaptGeneration.fromProjectOptions(this.projectOptions), DslAdaptersKt.convert(this.globalScope.getExtension().getAaptOptions()), new File(variantScope.getInstantRunSplitApkOutputFolder(), "slices"), ApplicationTaskManager.getIncrementalFolder(variantScope, "ir_slices"), new File(ApplicationTaskManager.getIncrementalFolder(variantScope, "InstantRunSliceSplitApkBuilder"), "aapt-temp"), this.globalScope.getProjectOptions().get(OptionalBooleanOption.SERIAL_AAPT2), variantScope.getOutput(InternalArtifactType.PROCESSED_RES), variantScope.getOutput(resourcesWithMainManifest), variantScope.getOutput(InternalArtifactType.APK_LIST), (ApkInfo)variantScope.getOutputScope().getMainSplit());
        Optional<TransformTask> transformTaskAndroidTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, slicesApkBuilder);
        if (transformTaskAndroidTask.isPresent()) {
            TransformTask splitApk = transformTaskAndroidTask.get();
            splitApk.dependsOn(new Object[]{this.getValidateSigningTask(variantScope)});
            variantScope.getAssembleTask().dependsOn(new Object[]{splitApk});
            buildInfoGeneratorTask.mustRunAfter(new Object[]{splitApk.getName()});
        }
        variantScope.getAssembleTask().dependsOn(new Object[]{buildInfoGeneratorTask});
        return buildInfoGeneratorTask;
    }

    @Override
    protected void postJavacCreation(final VariantScope scope) {
        final FileCollection javacOutput = scope.getOutput(InternalArtifactType.JAVAC);
        final FileCollection preJavacGeneratedBytecode = scope.getVariantData().getAllPreJavacGeneratedBytecode();
        final FileCollection postJavacGeneratedBytecode = scope.getVariantData().getAllPostJavacGeneratedBytecode();
        final File dest = new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"intermediates", "classes-jar", scope.getVariantConfiguration().getDirName()}));
        Jar task = this.taskFactory.create(new TaskConfigAction<Jar>(){

            @Override
            public String getName() {
                return scope.getTaskName("bundleAppClasses");
            }

            @Override
            public Class<Jar> getType() {
                return Jar.class;
            }

            @Override
            public void execute(Jar task) {
                task.from(new Object[]{javacOutput});
                task.from(new Object[]{preJavacGeneratedBytecode});
                task.from(new Object[]{postJavacGeneratedBytecode});
                task.setDestinationDir(dest);
                task.setArchiveName("classes.jar");
            }
        });
        scope.addTaskOutput(InternalArtifactType.APP_CLASSES, new File(dest, "classes.jar"), task.getName());
        ConfigurableFileCollection fileCollection = scope.createAnchorOutput(TaskOutputHolder.AnchorOutputType.ALL_CLASSES);
        fileCollection.from(new Object[]{javacOutput});
        fileCollection.from(new Object[]{preJavacGeneratedBytecode});
        fileCollection.from(new Object[]{postJavacGeneratedBytecode});
    }

    @Override
    protected DefaultTask createVariantPreBuildTask(VariantScope scope) {
        switch (scope.getVariantConfiguration().getType()) {
            case DEFAULT: {
                return this.taskFactory.create(new AppPreBuildTask.ConfigAction(scope));
            }
            case ANDROID_TEST: {
                return this.taskFactory.create(new TestPreBuildTask.ConfigAction(scope));
            }
        }
        return super.createVariantPreBuildTask(scope);
    }

    protected Set<QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    private void handleMicroApp(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        Boolean unbundledWearApp = variantConfiguration.getMergedFlavor().getWearAppUnbundled();
        if (!Boolean.TRUE.equals(unbundledWearApp) && ((CoreBuildType)variantConfiguration.getBuildType()).isEmbedMicroApp()) {
            Configuration wearApp = variantData.getVariantDependency().getWearAppConfiguration();
            assert (wearApp != null) : "Wear app with no wearApp configuration";
            if (!wearApp.getAllDependencies().isEmpty()) {
                Action setApkArtifact = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.APK.getType());
                FileCollection files = wearApp.getIncoming().artifactView(config -> {
                    ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config.attributes(setApkArtifact);
                }).getFiles();
                this.createGenerateMicroApkDataTask(scope, files);
            }
        } else if (Boolean.TRUE.equals(unbundledWearApp)) {
            this.createGenerateMicroApkDataTask(scope, null);
        }
    }

    private void createApplicationIdWriterTask(VariantScope variantScope) {
        File applicationIdOutputDirectory = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"applicationId", variantScope.getVariantConfiguration().getDirName()});
        ApplicationIdWriterTask writeTask = this.taskFactory.create(new ApplicationIdWriterTask.ConfigAction(variantScope, applicationIdOutputDirectory));
        variantScope.addTaskOutput(InternalArtifactType.METADATA_APP_ID_DECLARATION, ApplicationId.getOutputFile(applicationIdOutputDirectory), writeTask.getName());
    }

    private static File getIncrementalFolder(VariantScope variantScope, String taskName) {
        return new File(variantScope.getIncrementalDir(taskName), variantScope.getDirName());
    }
}

