/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;

public class StripDebugSymbolTransform
extends Transform {
    private final Project project;
    private final Map<Abi, File> stripExecutables = Maps.newHashMap();
    private final Set<PathMatcher> excludeMatchers;
    private final boolean isLibrary;

    public StripDebugSymbolTransform(Project project, NdkHandler ndkHandler, Set<String> excludePattern, boolean isLibrary) {
        this.excludeMatchers = (Set)excludePattern.stream().map(StripDebugSymbolTransform::compileGlob).collect(ImmutableCollectors.toImmutableSet());
        this.isLibrary = isLibrary;
        Preconditions.checkArgument((boolean)ndkHandler.isConfigured());
        for (Abi abi : ndkHandler.getSupportedAbis()) {
            this.stripExecutables.put(abi, ndkHandler.getStripExecutable(abi));
        }
        this.project = project;
    }

    public String getName() {
        return "stripDebugSymbol";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.NATIVE_LIBS));
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        if (this.isLibrary) {
            return TransformManager.PROJECT_ONLY;
        }
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean isCacheable() {
        return true;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        return this.stripExecutables.values().stream().map(SecondaryFile::nonIncremental).collect(Collectors.toList());
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        boolean isIncremental = transformInvocation.isIncremental();
        if (!isIncremental) {
            outputProvider.deleteAll();
        }
        for (TransformInput transformInput : transformInvocation.getInputs()) {
            for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                File folder = directoryInput.getFile();
                File output = outputProvider.getContentLocation(directoryInput.getName(), this.getInputTypes(), directoryInput.getScopes(), Format.DIRECTORY);
                if (isIncremental) {
                    for (Map.Entry fileStatus : directoryInput.getChangedFiles().entrySet()) {
                        File input = (File)fileStatus.getKey();
                        if (input.isDirectory()) continue;
                        String abiName = input.getParentFile().getName();
                        Abi abi = Abi.getByName(abiName);
                        String path = FileUtils.relativePossiblyNonExistingPath((File)input, (File)folder);
                        File strippedLib = new File(output, FileUtils.relativePossiblyNonExistingPath((File)input, (File)folder));
                        switch ((Status)fileStatus.getValue()) {
                            case ADDED: 
                            case CHANGED: {
                                if (this.excludeMatchers.stream().anyMatch(m -> m.matches(Paths.get(path, new String[0])))) {
                                    FileUtils.mkdirs((File)strippedLib.getParentFile());
                                    FileUtils.copyFile((File)input, (File)strippedLib);
                                    break;
                                }
                                this.stripFile(input, strippedLib, abi);
                                break;
                            }
                            case REMOVED: {
                                FileUtils.deletePath((File)new File(output, path));
                                break;
                            }
                        }
                    }
                    continue;
                }
                for (File input : FileUtils.getAllFiles((File)folder)) {
                    if (input.isDirectory()) continue;
                    String abiName = input.getParentFile().getName();
                    Abi abi = Abi.getByName(abiName);
                    String path = FileUtils.relativePath((File)input, (File)folder);
                    File strippedLib = new File(output, path);
                    if (this.excludeMatchers.stream().anyMatch(m -> m.matches(Paths.get(path, new String[0])))) {
                        FileUtils.mkdirs((File)strippedLib.getParentFile());
                        FileUtils.copyFile((File)input, (File)strippedLib);
                        continue;
                    }
                    this.stripFile(input, strippedLib, abi);
                }
            }
            for (JarInput jarInput : transformInput.getJarInputs()) {
                File outFile = outputProvider.getContentLocation(jarInput.getName(), this.getInputTypes(), jarInput.getScopes(), Format.JAR);
                if (!isIncremental || jarInput.getStatus() == Status.ADDED || jarInput.getStatus() == Status.CHANGED) {
                    FileUtils.mkdirs((File)outFile.getParentFile());
                    FileUtils.copyFile((File)jarInput.getFile(), (File)outFile);
                    continue;
                }
                if (jarInput.getStatus() != Status.REMOVED) continue;
                FileUtils.deleteIfExists((File)outFile);
            }
        }
    }

    private void stripFile(File input, File output, Abi abi) throws IOException {
        FileUtils.mkdirs((File)output.getParentFile());
        if (abi == null) {
            FileUtils.copyFile((File)input, (File)output);
            return;
        }
        File exe = this.stripExecutables.get((Object)abi);
        if (exe == null || !exe.isFile()) {
            FileUtils.copyFile((File)input, (File)output);
            return;
        }
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(exe);
        builder.addArgs("--strip-unneeded");
        builder.addArgs("-o");
        builder.addArgs(output.toString());
        builder.addArgs(input.toString());
        LoggerWrapper logger = new LoggerWrapper(this.project.getLogger());
        ProcessResult result = new GradleProcessExecutor(this.project).execute(builder.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)logger));
        if (result.getExitValue() != 0) {
            logger.warning("Unable to strip library '%s', packaging it as is.", new Object[]{input.getAbsolutePath()});
            FileUtils.copyFile((File)input, (File)output);
        }
    }

    private static PathMatcher compileGlob(String pattern) {
        FileSystem fs = FileSystems.getDefault();
        if (!pattern.startsWith("/") && !pattern.startsWith("*")) {
            pattern = "/" + pattern;
        }
        return fs.getPathMatcher("glob:" + pattern);
    }
}

