/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api.artifact;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.artifact.InputArtifactProvider;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactImpl;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.builder.errors.EvalIssueReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/api/artifact/InputArtifactProviderImpl;", "Lcom/android/build/api/artifact/InputArtifactProvider;", "artifactsHolder", "Lcom/android/build/gradle/internal/scope/BuildArtifactsHolder;", "inputTypes", "", "Lcom/android/build/api/artifact/ArtifactType;", "dslScope", "Lcom/android/build/gradle/internal/api/dsl/DslScope;", "(Lcom/android/build/gradle/internal/scope/BuildArtifactsHolder;Ljava/util/Collection;Lcom/android/build/gradle/internal/api/dsl/DslScope;)V", "artifact", "Lcom/android/build/api/artifact/BuildableArtifact;", "getArtifact", "()Lcom/android/build/api/artifact/BuildableArtifact;", "collections", "", "type", "Lcom/android/build/api/artifact/BuildArtifactType;", "gradle-core"})
public final class InputArtifactProviderImpl
implements InputArtifactProvider {
    private final List<BuildableArtifact> collections;
    private BuildArtifactsHolder artifactsHolder;
    private Collection<? extends ArtifactType> inputTypes;
    private final DslScope dslScope;

    @NotNull
    public BuildableArtifact getArtifact() {
        BuildableArtifact buildableArtifact;
        if (this.collections.isEmpty()) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "No artifacts was defined for input.");
            buildableArtifact = new BuildableArtifactImpl(null, this.dslScope);
        } else if (this.collections.size() > 1) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "Multiple inputs types was defined.");
            buildableArtifact = new BuildableArtifactImpl(null, this.dslScope);
        } else {
            buildableArtifact = (BuildableArtifact)CollectionsKt.single(this.collections);
        }
        return buildableArtifact;
    }

    @NotNull
    public BuildableArtifact getArtifact(@NotNull BuildArtifactType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        int index = CollectionsKt.indexOf((Iterable)this.inputTypes, (Object)type);
        if (index == -1) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "Artifact was not defined for input of type: " + type + '.');
            return new BuildableArtifactImpl(null, this.dslScope);
        }
        return this.collections.get(CollectionsKt.indexOf((Iterable)this.inputTypes, (Object)type));
    }

    /*
     * WARNING - void declaration
     */
    public InputArtifactProviderImpl(@NotNull BuildArtifactsHolder artifactsHolder, @NotNull Collection<? extends ArtifactType> inputTypes, @NotNull DslScope dslScope) {
        Collection<BuildableArtifact> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)artifactsHolder, (String)"artifactsHolder");
        Intrinsics.checkParameterIsNotNull(inputTypes, (String)"inputTypes");
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        this.artifactsHolder = artifactsHolder;
        this.inputTypes = inputTypes;
        this.dslScope = dslScope;
        Iterable iterable = this.inputTypes;
        InputArtifactProviderImpl inputArtifactProviderImpl = this;
        void var5_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ArtifactType artifactType = (ArtifactType)item$iv$iv;
            collection = destination$iv$iv;
            BuildableArtifact buildableArtifact = this.artifactsHolder.getArtifactFiles((ArtifactType)it);
            collection.add(buildableArtifact);
        }
        collection = (List)destination$iv$iv;
        inputArtifactProviderImpl.collections = collection;
    }
}

