/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import android.databinding.tool.LayoutXmlProcessor;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.aapt.WorkerExecutorResourceCompilationService;
import com.android.build.gradle.internal.api.sourcesets.FilesProvider;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.namespaced.NamespaceRemover;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.build.gradle.tasks.ResourceException;
import com.android.build.gradle.tasks.WorkerExecutorAdapter;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.VectorDrawablesOptions;
import com.android.builder.png.VectorDrawableRenderer;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MergingLogRewriter;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.Aapt2OutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.res2.CopyToOutputDirectoryResourceCompilationService;
import com.android.ide.common.res2.FileStatus;
import com.android.ide.common.res2.FileValidity;
import com.android.ide.common.res2.GeneratedResourceSet;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergedResourceWriter;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NoOpResourcePreprocessor;
import com.android.ide.common.res2.QueueableResourceCompilationService;
import com.android.ide.common.res2.QueueableResourceCompiler;
import com.android.ide.common.res2.ResourceCompilationService;
import com.android.ide.common.res2.ResourceMerger;
import com.android.ide.common.res2.ResourcePreprocessor;
import com.android.ide.common.res2.ResourceSet;
import com.android.ide.common.res2.SingleFileProcessor;
import com.android.ide.common.vectordrawable.ResourcesNotSupportedException;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.resources.Density;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.bind.JAXBException;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class MergeResources
extends IncrementalTask {
    private File outputDir;
    private File generatedPngsOutputDir;
    private FilesProvider filesProvider;
    private File publicFile;
    private boolean processResources;
    private boolean crunchPng;
    private boolean validateEnabled;
    private File blameLogFolder;
    private Supplier<Collection<File>> sourceFolderInputs;
    private Map<String, BuildableArtifact> resources;
    private List<ResourceSet> processedInputs;
    private ArtifactCollection libraries;
    private FileCollection renderscriptResOutputDir;
    private FileCollection generatedResOutputDir;
    private FileCollection microApkResDirectory;
    private FileCollection extraGeneratedResFolders;
    private final FileValidity<ResourceSet> fileValidity = new FileValidity();
    private boolean disableVectorDrawables;
    private boolean vectorSupportLibraryIsUsed;
    private Collection<String> generatedDensities;
    private int minSdk;
    private VariantScope variantScope;
    private AaptGeneration aaptGeneration;
    private SingleFileProcessor dataBindingLayoutProcessor;
    private File dataBindingLayoutInfoOutFolder;
    private File mergedNotCompiledResourcesOutputDirectory;
    private boolean pseudoLocalesEnabled;
    private ImmutableSet<Flag> flags;
    private final WorkerExecutor workerExecutor;
    private final WorkerExecutorFacade<MergedResourceWriter.FileGenerationParameters> workerExecutorFacade;

    private static ResourceCompilationService getResourceProcessor(AaptGeneration aaptGeneration, AndroidBuilder builder, WorkerExecutor workerExecutor, boolean crunchPng, VariantScope scope, File intermediateDir, MergingLog blameLog, ImmutableSet<Flag> flags, boolean processResources) {
        if (flags.contains((Object)Flag.REMOVE_RESOURCE_NAMESPACES)) {
            return NamespaceRemover.INSTANCE;
        }
        if (!processResources) {
            return CopyToOutputDirectoryResourceCompilationService.INSTANCE;
        }
        if (aaptGeneration == AaptGeneration.AAPT_V2_DAEMON_SHARED_POOL) {
            return new WorkerExecutorResourceCompilationService(Objects.requireNonNull(workerExecutor), builder.getBuildToolInfo().getRevision());
        }
        return new QueueableResourceCompilationService((QueueableResourceCompiler)AaptGradleFactory.make(aaptGeneration, builder, MergeResources.createProcessOutputHandler(aaptGeneration, builder, blameLog), crunchPng, intermediateDir, scope.getGlobalScope().getExtension().getAaptOptions().getCruncherProcesses()));
    }

    private static ProcessOutputHandler createProcessOutputHandler(AaptGeneration aaptGeneration, AndroidBuilder builder, MergingLog blameLog) {
        if (blameLog == null) {
            return null;
        }
        AaptOutputParser parsers = aaptGeneration == AaptGeneration.AAPT_V1 ? new AaptOutputParser() : new Aapt2OutputParser();
        MessageReceiver[] messageReceiverArray = new MessageReceiver[1];
        messageReceiverArray[0] = new MergingLogRewriter(arg_0 -> ((MergingLog)blameLog).find(arg_0), builder.getMessageReceiver());
        return new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)parsers, builder.getLogger()), messageReceiverArray);
    }

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @Override
    protected boolean isIncremental() {
        return true;
    }

    @OutputDirectory
    @Optional
    public File getDataBindingLayoutInfoOutFolder() {
        return this.dataBindingLayoutInfoOutFolder;
    }

    @Inject
    public MergeResources(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
        this.workerExecutorFacade = new WorkerExecutorAdapter<MergedResourceWriter.FileGenerationParameters>(workerExecutor, FileGenerationWorkAction.class);
    }

    @Override
    protected void doFullTaskAction() throws IOException, JAXBException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        File destinationDir = this.getOutputDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        if (this.dataBindingLayoutInfoOutFolder != null) {
            FileUtils.deleteDirectoryContents((File)this.dataBindingLayoutInfoOutFolder);
        }
        List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor);
        ResourceMerger merger = new ResourceMerger(this.minSdk);
        MergingLog mergingLog = null;
        if (this.blameLogFolder != null) {
            FileUtils.cleanOutputDir((File)this.blameLogFolder);
            mergingLog = new MergingLog(this.blameLogFolder);
        }
        try (ResourceCompilationService resourceCompiler = MergeResources.getResourceProcessor(this.aaptGeneration, this.getBuilder(), this.workerExecutor, this.crunchPng, this.variantScope, this.getAaptTempDir(), mergingLog, this.flags, this.processResources);){
            for (ResourceSet resourceSet : resourceSets) {
                resourceSet.loadFromFiles(this.getILogger());
                merger.addDataSet(resourceSet);
            }
            MergedResourceWriter writer = new MergedResourceWriter(this.workerExecutorFacade, destinationDir, this.getPublicFile(), mergingLog, preprocessor, resourceCompiler, this.getIncrementalFolder(), this.dataBindingLayoutProcessor, this.mergedNotCompiledResourcesOutputDirectory, this.pseudoLocalesEnabled, this.getCrunchPng());
            merger.mergeData((MergeConsumer)writer, false);
            if (this.dataBindingLayoutProcessor != null) {
                this.dataBindingLayoutProcessor.end();
            }
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
        }
        catch (MergingException e) {
            System.out.println(e.getMessage());
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException, JAXBException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        ResourceMerger merger = new ResourceMerger(this.minSdk);
        try {
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true)) {
                this.doFullTaskAction();
                return;
            }
            for (Object resourceSet : merger.getDataSets()) {
                resourceSet.setPreprocessor(preprocessor);
            }
            List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor);
            if (!merger.checkValidUpdate(resourceSets)) {
                this.getLogger().info("Changed Resource sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            for (Map.Entry entry : changedInputs.entrySet()) {
                File changedFile = (File)entry.getKey();
                merger.findDataSetContaining(changedFile, this.fileValidity);
                if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
                    this.doFullTaskAction();
                    return;
                }
                if (this.fileValidity.getStatus() != FileValidity.FileStatus.VALID_FILE || ((ResourceSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, (FileStatus)entry.getValue(), this.getILogger())) continue;
                this.getLogger().info(String.format("Failed to process %s event! Full task run", entry.getValue()));
                this.doFullTaskAction();
                return;
            }
            MergingLog mergingLog = this.getBlameLogFolder() != null ? new MergingLog(this.getBlameLogFolder()) : null;
            try (ResourceCompilationService resourceCompilationService = MergeResources.getResourceProcessor(this.aaptGeneration, this.getBuilder(), this.workerExecutor, this.crunchPng, this.variantScope, this.getAaptTempDir(), mergingLog, this.flags, this.processResources);){
                MergedResourceWriter writer = new MergedResourceWriter(this.workerExecutorFacade, this.getOutputDir(), this.getPublicFile(), mergingLog, preprocessor, resourceCompilationService, this.getIncrementalFolder(), this.dataBindingLayoutProcessor, this.mergedNotCompiledResourcesOutputDirectory, this.pseudoLocalesEnabled, this.getCrunchPng());
                merger.mergeData((MergeConsumer)writer, false);
                if (this.dataBindingLayoutProcessor != null) {
                    this.dataBindingLayoutProcessor.end();
                }
                merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
            }
        }
        catch (MergingException e) {
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
        finally {
            this.cleanup();
        }
    }

    private ResourcePreprocessor getPreprocessor() {
        if (this.disableVectorDrawables) {
            return NoOpResourcePreprocessor.INSTANCE;
        }
        Collection densities = this.getGeneratedDensities().stream().map(Density::getEnum).collect(Collectors.toList());
        return new MergeResourcesVectorDrawableRenderer(this.minSdk, this.vectorSupportLibraryIsUsed, this.generatedPngsOutputDir, densities, LoggerWrapper.supplierFor(MergeResources.class));
    }

    private List<ResourceSet> getConfiguredResourceSets(ResourcePreprocessor preprocessor) {
        if (this.processedInputs == null) {
            this.processedInputs = this.computeResourceSetList();
            ArrayList<GeneratedResourceSet> generatedSets = new ArrayList<GeneratedResourceSet>(this.processedInputs.size());
            for (ResourceSet resourceSet : this.processedInputs) {
                resourceSet.setPreprocessor(preprocessor);
                GeneratedResourceSet generatedSet = new GeneratedResourceSet(resourceSet);
                resourceSet.setGeneratedSet((ResourceSet)generatedSet);
                generatedSets.add(generatedSet);
            }
            for (int i = 0; i < generatedSets.size(); ++i) {
                this.processedInputs.add(2 * i, (ResourceSet)generatedSets.get(i));
            }
        }
        return this.processedInputs;
    }

    private void cleanup() {
        this.fileValidity.clear();
        this.processedInputs = null;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getRenderscriptResOutputDir() {
        return this.renderscriptResOutputDir;
    }

    @VisibleForTesting
    void setRenderscriptResOutputDir(FileCollection renderscriptResOutputDir) {
        this.renderscriptResOutputDir = renderscriptResOutputDir;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getGeneratedResOutputDir() {
        return this.generatedResOutputDir;
    }

    @VisibleForTesting
    void setGeneratedResOutputDir(FileCollection generatedResOutputDir) {
        this.generatedResOutputDir = generatedResOutputDir;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getMicroApkResDirectory() {
        return this.microApkResDirectory;
    }

    @VisibleForTesting
    void setMicroApkResDirectory(FileCollection microApkResDirectory) {
        this.microApkResDirectory = microApkResDirectory;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getExtraGeneratedResFolders() {
        return this.extraGeneratedResFolders;
    }

    @VisibleForTesting
    void setExtraGeneratedResFolders(FileCollection extraGeneratedResFolders) {
        this.extraGeneratedResFolders = extraGeneratedResFolders;
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getLibraries() {
        if (this.libraries != null) {
            return this.libraries.getArtifactFiles();
        }
        return null;
    }

    @VisibleForTesting
    void setLibraries(ArtifactCollection libraries) {
        this.libraries = libraries;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Collection<File> getSourceFolderInputs() {
        return this.sourceFolderInputs.get();
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Input
    public boolean getCrunchPng() {
        return this.crunchPng;
    }

    @Input
    public boolean getProcessResources() {
        return this.processResources;
    }

    @Optional
    @OutputFile
    public File getPublicFile() {
        return this.publicFile;
    }

    public void setPublicFile(File publicFile) {
        this.publicFile = publicFile;
    }

    @Input
    public boolean isValidateEnabled() {
        return this.validateEnabled;
    }

    @OutputDirectory
    @Optional
    public File getBlameLogFolder() {
        return this.blameLogFolder;
    }

    public void setBlameLogFolder(File blameLogFolder) {
        this.blameLogFolder = blameLogFolder;
    }

    @OutputDirectory
    public File getGeneratedPngsOutputDir() {
        return this.generatedPngsOutputDir;
    }

    @Input
    public Collection<String> getGeneratedDensities() {
        return this.generatedDensities;
    }

    @Input
    public int getMinSdk() {
        return this.minSdk;
    }

    @Input
    public boolean isVectorSupportLibraryUsed() {
        return this.vectorSupportLibraryIsUsed;
    }

    @Input
    public String getAaptGeneration() {
        return this.aaptGeneration.name();
    }

    @OutputDirectory
    @Optional
    public File getMergedNotCompiledResourcesOutputDirectory() {
        return this.mergedNotCompiledResourcesOutputDirectory;
    }

    @Input
    public boolean isPseudoLocalesEnabled() {
        return this.pseudoLocalesEnabled;
    }

    @Input
    public String getFlags() {
        return this.flags.stream().map(Enum::name).sorted().collect(Collectors.joining(","));
    }

    @InputFiles
    public Collection<BuildableArtifact> getResources() {
        return this.resources.values();
    }

    @VisibleForTesting
    public void setResources(Map<String, BuildableArtifact> resources) {
        this.resources = resources;
    }

    private List<ResourceSet> getResSet() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<String, BuildableArtifact> entry : this.resources.entrySet()) {
            ResourceSet resourceSet = new ResourceSet(entry.getKey(), ResourceNamespace.RES_AUTO, null, this.validateEnabled);
            resourceSet.addSources((Collection)entry.getValue().getFiles());
            builder.add((Object)resourceSet);
        }
        return builder.build();
    }

    @VisibleForTesting
    List<ResourceSet> computeResourceSetList() {
        List<ResourceSet> sourceFolderSets = this.getResSet();
        int size = sourceFolderSets.size() + 4;
        if (this.libraries != null) {
            size += this.libraries.getArtifacts().size();
        }
        ArrayList<ResourceSet> resourceSetList = new ArrayList<ResourceSet>(size);
        if (this.libraries != null) {
            Set libArtifacts = this.libraries.getArtifacts();
            for (ResolvedArtifactResult artifact : libArtifacts) {
                ResourceSet resourceSet = new ResourceSet(MergeManifests.getArtifactName(artifact), ResourceNamespace.RES_AUTO, null, this.validateEnabled);
                resourceSet.setFromDependency(true);
                resourceSet.addSource(artifact.getFile());
                resourceSetList.add(0, resourceSet);
            }
        }
        resourceSetList.addAll(sourceFolderSets);
        ArrayList generatedResFolders = new ArrayList();
        generatedResFolders.addAll(this.renderscriptResOutputDir.getFiles());
        generatedResFolders.addAll(this.generatedResOutputDir.getFiles());
        FileCollection extraFolders = this.getExtraGeneratedResFolders();
        if (extraFolders != null) {
            generatedResFolders.addAll(extraFolders.getFiles());
        }
        if (this.microApkResDirectory != null) {
            generatedResFolders.addAll(this.microApkResDirectory.getFiles());
        }
        ResourceSet mainResourceSet = sourceFolderSets.get(0);
        assert (mainResourceSet.getConfigName().equals("main"));
        mainResourceSet.addSources(generatedResFolders);
        return resourceSetList;
    }

    private File getAaptTempDir() {
        return FileUtils.mkdirs((File)new File(this.getIncrementalFolder(), "aapt-temp"));
    }

    public static enum Flag {
        REMOVE_RESOURCE_NAMESPACES;

    }

    public static class ConfigAction
    implements TaskConfigAction<MergeResources> {
        private final VariantScope scope;
        private final String taskNamePrefix;
        private final File outputLocation;
        private final File mergedNotCompiledOutputDirectory;
        private final boolean includeDependencies;
        private final boolean processResources;
        private final boolean processVectorDrawables;
        private final ImmutableSet<Flag> flags;

        public ConfigAction(VariantScope scope, String taskNamePrefix, File outputLocation, File mergedNotCompiledOutputDirectory, boolean includeDependencies, boolean processResources, boolean processVectorDrawables, ImmutableSet<Flag> flags) {
            this.scope = scope;
            this.taskNamePrefix = taskNamePrefix;
            this.outputLocation = outputLocation;
            this.mergedNotCompiledOutputDirectory = mergedNotCompiledOutputDirectory;
            this.includeDependencies = includeDependencies;
            this.processResources = processResources;
            this.processVectorDrawables = processVectorDrawables;
            this.flags = flags;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName(this.taskNamePrefix, "Resources");
        }

        @Override
        public Class<MergeResources> getType() {
            return MergeResources.class;
        }

        @Override
        public void execute(final MergeResources mergeResourcesTask) {
            final BaseVariantData variantData = this.scope.getVariantData();
            Project project = this.scope.getGlobalScope().getProject();
            mergeResourcesTask.filesProvider = this.scope.getGlobalScope().getFilesProvider();
            mergeResourcesTask.minSdk = variantData.getVariantConfiguration().getMinSdkVersion().getApiLevel();
            mergeResourcesTask.aaptGeneration = AaptGeneration.fromProjectOptions(this.scope.getGlobalScope().getProjectOptions());
            mergeResourcesTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            mergeResourcesTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            mergeResourcesTask.setIncrementalFolder(this.scope.getIncrementalDir(this.getName()));
            mergeResourcesTask.variantScope = this.scope;
            if (this.includeDependencies) {
                mergeResourcesTask.setBlameLogFolder(this.scope.getResourceBlameLogDir());
            }
            mergeResourcesTask.processResources = this.processResources;
            mergeResourcesTask.crunchPng = this.scope.isCrunchPngs();
            VectorDrawablesOptions vectorDrawablesOptions = variantData.getVariantConfiguration().getMergedFlavor().getVectorDrawables();
            mergeResourcesTask.generatedDensities = vectorDrawablesOptions.getGeneratedDensities();
            if (mergeResourcesTask.generatedDensities == null) {
                mergeResourcesTask.generatedDensities = Collections.emptySet();
            }
            mergeResourcesTask.disableVectorDrawables = !this.processVectorDrawables || mergeResourcesTask.generatedDensities.isEmpty();
            mergeResourcesTask.vectorSupportLibraryIsUsed = Boolean.TRUE.equals(vectorDrawablesOptions.getUseSupportLibrary());
            boolean validateEnabled = !this.scope.getGlobalScope().getProjectOptions().get(BooleanOption.DISABLE_RESOURCE_VALIDATION);
            mergeResourcesTask.validateEnabled = validateEnabled;
            if (this.includeDependencies) {
                mergeResourcesTask.libraries = this.scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_RES);
            }
            mergeResourcesTask.resources = variantData.getAndroidResources();
            mergeResourcesTask.sourceFolderInputs = TaskInputHelper.bypassFileSupplier(() -> variantData.getVariantConfiguration().getSourceFiles(SourceProvider::getResDirectories));
            mergeResourcesTask.extraGeneratedResFolders = variantData.getExtraGeneratedResFolders();
            mergeResourcesTask.renderscriptResOutputDir = (FileCollection)project.files(new Object[]{this.scope.getRenderscriptResOutputDir()});
            mergeResourcesTask.generatedResOutputDir = (FileCollection)project.files(new Object[]{this.scope.getGeneratedResOutputDir()});
            if (this.scope.getMicroApkTask() != null && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isEmbedMicroApp()) {
                mergeResourcesTask.microApkResDirectory = (FileCollection)project.files(new Object[]{this.scope.getMicroApkResDirectory()});
            }
            mergeResourcesTask.outputDir = this.outputLocation;
            mergeResourcesTask.generatedPngsOutputDir = this.scope.getGeneratedPngsOutputDir();
            variantData.mergeResourcesTask = mergeResourcesTask;
            if (this.scope.getGlobalScope().getExtension().getDataBinding().isEnabled()) {
                mergeResourcesTask.dataBindingLayoutInfoOutFolder = this.scope.getLayoutInfoOutputForDataBinding();
                mergeResourcesTask.dataBindingLayoutProcessor = new SingleFileProcessor(){
                    final LayoutXmlProcessor processor;
                    {
                        this.processor = variantData.getLayoutXmlProcessor();
                    }

                    public boolean processSingleFile(File file, File out) throws Exception {
                        return this.processor.processSingleFile(file, out);
                    }

                    public void processRemovedFile(File file) {
                        this.processor.processRemovedFile(file);
                    }

                    public void end() throws JAXBException {
                        this.processor.writeLayoutInfoFiles(mergeResourcesTask.dataBindingLayoutInfoOutFolder);
                    }
                };
            }
            mergeResourcesTask.mergedNotCompiledResourcesOutputDirectory = this.mergedNotCompiledOutputDirectory;
            mergeResourcesTask.pseudoLocalesEnabled = ((CoreBuildType)this.scope.getVariantData().getVariantConfiguration().getBuildType()).isPseudoLocalesEnabled();
            mergeResourcesTask.flags = this.flags;
        }
    }

    private static class MergeResourcesVectorDrawableRenderer
    extends VectorDrawableRenderer {
        public MergeResourcesVectorDrawableRenderer(int minSdk, boolean supportLibraryIsUsed, File outputDir, Collection<Density> densities, Supplier<ILogger> loggerSupplier) {
            super(minSdk, supportLibraryIsUsed, outputDir, densities, loggerSupplier);
        }

        public void generateFile(File toBeGenerated, File original) throws IOException {
            try {
                super.generateFile(toBeGenerated, original);
            }
            catch (ResourcesNotSupportedException e) {
                throw new GradleException(String.format("Can't process attribute %1$s=\"%2$s\": references to other resources are not supported by build-time PNG generation. See http://developer.android.com/tools/help/vector-asset-studio.html for details.", e.getName(), e.getValue()));
            }
        }
    }

    public static class FileGenerationWorkAction
    implements Runnable {
        private final MergedResourceWriter.FileGenerationWorkAction workAction;

        @Inject
        public FileGenerationWorkAction(MergedResourceWriter.FileGenerationParameters workItem) {
            this.workAction = new MergedResourceWriter.FileGenerationWorkAction(workItem);
        }

        @Override
        public void run() {
            this.workAction.run();
        }
    }
}

