/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.gnumake;

import com.android.build.gradle.external.gnumake.AbstractOsFileConventions;
import com.android.build.gradle.external.gnumake.BuildStepInfo;
import com.android.build.gradle.external.gnumake.FlowAnalyzer;
import com.android.build.gradle.external.gnumake.OsFileConventions;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValue;
import com.android.build.gradle.internal.cxx.json.NativeSourceFileValue;
import com.android.build.gradle.internal.cxx.json.NativeToolchainValue;
import com.android.utils.NativeSourceFileExtensions;
import com.android.utils.NdkUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NativeBuildConfigValueBuilder {
    private static final List<String> STRIP_FLAGS_WITH_ARG = Arrays.asList("-c", "-o", "-MF", "-MT", "-MQ");
    private static final List<String> STRIP_FLAGS_WITHOUT_ARG = Lists.newArrayList((Object[])new String[]{"-M", "-MM", "-MD", "-MG", "-MP", "-MMD"});
    private final Map<String, String> toolChainToCCompiler = new HashMap<String, String>();
    private final Map<String, String> toolChainToCppCompiler = new HashMap<String, String>();
    private final Set<String> cFileExtensions = new HashSet<String>();
    private final Set<String> cppFileExtensions = new HashSet<String>();
    private final File androidMk;
    private final File executionRootPath;
    private final List<Output> outputs;
    private final OsFileConventions fileConventions;

    public NativeBuildConfigValueBuilder(File androidMk, File executionRootPath) {
        this(androidMk, executionRootPath, AbstractOsFileConventions.createForCurrentHost());
    }

    NativeBuildConfigValueBuilder(File androidMk, File executionRootPath, OsFileConventions fileConventions) {
        this.androidMk = androidMk;
        this.executionRootPath = executionRootPath;
        this.outputs = new ArrayList<Output>();
        this.fileConventions = fileConventions;
    }

    public NativeBuildConfigValueBuilder addCommands(String buildCommand, String cleanCommand, String variantName, String commands) {
        ListMultimap<String, List<BuildStepInfo>> outputs = FlowAnalyzer.analyze(commands, this.fileConventions);
        for (Map.Entry entry : outputs.entries()) {
            this.outputs.add(new Output((String)entry.getKey(), (List)entry.getValue(), buildCommand, cleanCommand, variantName));
        }
        return this;
    }

    public NativeBuildConfigValue build() {
        this.findLibraryNames();
        this.findToolchainNames();
        this.findToolChainCompilers();
        NativeBuildConfigValue config2 = new NativeBuildConfigValue();
        Collections.sort(this.outputs, Comparator.comparing(o -> ((Output)o).libraryName));
        config2.cleanCommands = this.generateCleanCommands();
        config2.buildFiles = Lists.newArrayList((Object[])new File[]{this.androidMk});
        config2.libraries = this.generateLibraries();
        config2.toolchains = this.generateToolchains();
        config2.cFileExtensions = NativeBuildConfigValueBuilder.generateExtensions(this.cFileExtensions);
        config2.cppFileExtensions = NativeBuildConfigValueBuilder.generateExtensions(this.cppFileExtensions);
        return config2;
    }

    private static Collection<String> generateExtensions(Set<String> extensionSet) {
        ArrayList extensionList = Lists.newArrayList(extensionSet);
        Collections.sort(extensionList);
        return extensionList;
    }

    private void findLibraryNames() {
        for (Output output : this.outputs) {
            String parentFile = this.fileConventions.getFileParent(output.outputFileName);
            String abi = this.fileConventions.getFileName(parentFile);
            output.artifactName = NdkUtils.getTargetNameFromBuildOutputFileName((String)this.fileConventions.getFileName(output.outputFileName));
            output.libraryName = String.format("%s-%s-%s", output.artifactName, output.variantName, abi);
        }
    }

    private void findToolChainCompilers() {
        for (Output output : this.outputs) {
            String toolchain = output.toolchain;
            HashSet<String> cCompilers = new HashSet<String>();
            HashSet<String> cppCompilers = new HashSet<String>();
            HashMap<String, HashSet<String>> compilerToWeirdExtensions = new HashMap<String, HashSet<String>>();
            for (BuildStepInfo command : output.commandInputs) {
                String compilerCommand = command.getCommand().executable;
                String extension = Files.getFileExtension((String)command.getOnlyInput());
                if (NativeSourceFileExtensions.C_FILE_EXTENSIONS.contains(extension)) {
                    this.cFileExtensions.add(extension);
                    cCompilers.add(compilerCommand);
                    continue;
                }
                if (NativeSourceFileExtensions.CPP_FILE_EXTENSIONS.contains(extension)) {
                    this.cppFileExtensions.add(extension);
                    cppCompilers.add(compilerCommand);
                    continue;
                }
                HashSet<String> extensions = (HashSet<String>)compilerToWeirdExtensions.get(compilerCommand);
                if (extensions == null) {
                    extensions = new HashSet<String>();
                    compilerToWeirdExtensions.put(compilerCommand, extensions);
                }
                extensions.add(extension);
            }
            if (cCompilers.size() > 1) {
                throw new RuntimeException("Too many c compilers in toolchain.");
            }
            if (cppCompilers.size() > 1) {
                throw new RuntimeException("Too many cpp compilers in toolchain.");
            }
            String cCompiler = null;
            String cppCompiler = null;
            if (cCompilers.size() == 1) {
                cCompiler = (String)cCompilers.iterator().next();
                this.toolChainToCCompiler.put(toolchain, cCompiler);
            }
            if (cppCompilers.size() == 1) {
                cppCompiler = (String)cppCompilers.iterator().next();
                this.toolChainToCppCompiler.put(toolchain, cppCompiler);
            }
            for (String compiler : compilerToWeirdExtensions.keySet()) {
                if (compiler.equals(cCompiler)) {
                    this.cFileExtensions.addAll((Collection)compilerToWeirdExtensions.get(compiler));
                    continue;
                }
                if (!compiler.equals(cppCompiler)) continue;
                this.cppFileExtensions.addAll((Collection)compilerToWeirdExtensions.get(compiler));
            }
        }
    }

    private String findToolChainName(String outputFileName) {
        return "toolchain-" + this.fileConventions.getFileName(this.fileConventions.getFileParent(outputFileName));
    }

    private void findToolchainNames() {
        for (Output output : this.outputs) {
            output.toolchain = this.findToolChainName(output.outputFileName);
        }
    }

    private List<String> generateCleanCommands() {
        HashSet cleanCommands = Sets.newHashSet();
        for (Output output : this.outputs) {
            cleanCommands.add(output.cleanCommand);
        }
        return Lists.newArrayList((Iterable)cleanCommands);
    }

    private Map<String, NativeLibraryValue> generateLibraries() {
        HashMap<String, NativeLibraryValue> librariesMap = new HashMap<String, NativeLibraryValue>();
        for (Output output : this.outputs) {
            NativeLibraryValue value = new NativeLibraryValue();
            librariesMap.put(output.libraryName, value);
            value.buildCommand = output.buildCommand + " " + output.outputFileName;
            value.abi = this.fileConventions.getFileName(this.fileConventions.getFileParent(output.outputFileName));
            value.artifactName = output.artifactName;
            value.toolchain = output.toolchain;
            value.output = this.fileConventions.toFile(output.outputFileName);
            value.files = new ArrayList<NativeSourceFileValue>();
            for (BuildStepInfo input : output.commandInputs) {
                NativeSourceFileValue file = new NativeSourceFileValue();
                value.files.add(file);
                file.src = this.fileConventions.toFile(input.getOnlyInput());
                if (!this.fileConventions.isPathAbsolute(input.getOnlyInput())) {
                    file.src = this.fileConventions.toFile(this.executionRootPath, input.getOnlyInput());
                }
                ArrayList<String> flags = new ArrayList<String>();
                for (int i = 0; i < input.getCommand().escapedFlags.size(); ++i) {
                    String arg = input.getCommand().escapedFlags.get(i);
                    if (STRIP_FLAGS_WITH_ARG.contains(arg)) {
                        ++i;
                        continue;
                    }
                    if (NativeBuildConfigValueBuilder.startsWithStripFlag(arg) || STRIP_FLAGS_WITHOUT_ARG.contains(arg)) continue;
                    flags.add(input.getCommand().rawFlags.get(i));
                }
                file.flags = Joiner.on((String)" ").join(flags);
            }
        }
        return librariesMap;
    }

    private static boolean startsWithStripFlag(String arg) {
        for (String flag : STRIP_FLAGS_WITH_ARG) {
            if (!arg.startsWith(flag)) continue;
            return true;
        }
        return false;
    }

    private Map<String, NativeToolchainValue> generateToolchains() {
        Set toolchainSet = this.outputs.stream().map(output -> ((Output)output).toolchain).collect(Collectors.toSet());
        ArrayList toolchains = new ArrayList(toolchainSet);
        Collections.sort(toolchains);
        HashMap<String, NativeToolchainValue> toolchainsMap = new HashMap<String, NativeToolchainValue>();
        for (String toolchain : toolchains) {
            NativeToolchainValue toolchainValue = new NativeToolchainValue();
            toolchainsMap.put(toolchain, toolchainValue);
            if (this.toolChainToCCompiler.containsKey(toolchain)) {
                toolchainValue.cCompilerExecutable = this.fileConventions.toFile(this.toolChainToCCompiler.get(toolchain));
            }
            if (!this.toolChainToCppCompiler.containsKey(toolchain)) continue;
            toolchainValue.cppCompilerExecutable = this.fileConventions.toFile(this.toolChainToCppCompiler.get(toolchain));
        }
        return toolchainsMap;
    }

    private static class Output {
        private final String outputFileName;
        private final List<BuildStepInfo> commandInputs;
        private final String buildCommand;
        private final String cleanCommand;
        private final String variantName;
        private String artifactName;
        private String libraryName;
        private String toolchain;

        private Output(String outputFileName, List<BuildStepInfo> commandInputs, String buildCommand, String cleanCommand, String variantName) {
            this.outputFileName = outputFileName;
            this.commandInputs = commandInputs;
            this.buildCommand = buildCommand;
            this.cleanCommand = cleanCommand;
            this.variantName = variantName;
        }
    }
}

