/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.ApplicationTaskManager;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.feature.BundleFeatureClasses;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class FeatureTaskManager
extends ApplicationTaskManager {
    public FeatureTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        super.createTasksForVariantScope(variantScope);
        AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)variantScope.getGlobalScope().getExtension().getCompileSdkVersion());
        if (androidVersion == null || androidVersion.getApiLevel() < 26) {
            String message = "Feature modules require compileSdkVersion set to 26 or higher.";
            if (androidVersion != null) {
                message = message + " compileSdkVersion is set to " + androidVersion.getApiString();
            }
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, message);
        }
        if (AaptGeneration.fromProjectOptions(this.projectOptions) == AaptGeneration.AAPT_V1 && !this.extension.getBaseFeature().booleanValue()) {
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "Non-base feature modules require AAPTv2 to build.");
        }
        if (this.extension.getDataBinding().isEnabled() && !this.extension.getBaseFeature().booleanValue()) {
            String bindingV2 = BooleanOption.ENABLE_DATA_BINDING_V2.getPropertyName();
            String experimentalBinding = BooleanOption.ENABLE_EXPERIMENTAL_FEATURE_DATABINDING.getPropertyName();
            if (this.projectOptions.get(BooleanOption.ENABLE_EXPERIMENTAL_FEATURE_DATABINDING)) {
                if (this.projectOptions.get(BooleanOption.ENABLE_DATA_BINDING_V2)) {
                    this.androidBuilder.getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, "Data binding support for non-base features is experimental and is not supported.");
                } else {
                    this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "To use data binding in non-base features, you must enable data binding v2 by adding " + bindingV2 + "=true to your gradle.properties file.");
                }
            } else {
                this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "Currently, data binding does not work for non-base features. Move data binding code to the base feature module.\nSee https://issuetracker.google.com/63814741.\nTo enable data binding with non-base features, set the " + experimentalBinding + " and " + bindingV2 + " properties to true.");
            }
        }
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
        File classesJar = new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"intermediates", "classes-jar", scope.getVariantConfiguration().getDirName(), "classes.jar"}));
        BundleFeatureClasses task = this.taskFactory.create(new BundleFeatureClasses.ConfigAction(scope, classesJar));
        scope.addTaskOutput(InternalArtifactType.FEATURE_CLASSES, classesJar, task.getName());
    }
}

