/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api.artifact;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.OutputFileProvider;
import com.android.build.gradle.internal.api.artifact.BuildArtifactSpec;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.builder.errors.EvalIssueReporter;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\nH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R*\u0010\u0014\u001a\u001e\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00110\u00110\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/api/artifact/OutputFileProviderImpl;", "Lcom/android/build/api/artifact/OutputFileProvider;", "artifactsHolder", "Lcom/android/build/gradle/internal/scope/BuildArtifactsHolder;", "replacedArtifacts", "", "Lcom/android/build/api/artifact/ArtifactType;", "appendedArtifacts", "filenamesMap", "Lcom/google/common/collect/Multimap;", "", "unassociatedFilenames", "taskName", "dslScope", "Lcom/android/build/gradle/internal/api/dsl/DslScope;", "(Lcom/android/build/gradle/internal/scope/BuildArtifactsHolder;Ljava/util/Collection;Ljava/util/Collection;Lcom/google/common/collect/Multimap;Ljava/util/Collection;Ljava/lang/String;Lcom/android/build/gradle/internal/api/dsl/DslScope;)V", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "fileMap", "", "kotlin.jvm.PlatformType", "filename", "gradle-core"})
public final class OutputFileProviderImpl
implements OutputFileProvider {
    private final Map<String, File> fileMap;
    private final DslScope dslScope;

    @NotNull
    public File getFile() {
        File file;
        if (this.fileMap.values().isEmpty()) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "No output file was defined.");
            file = new File("");
        } else if (this.fileMap.values().size() > 1) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "Multiple output files was defined.");
            file = new File("");
        } else {
            Object object = CollectionsKt.single((Iterable)this.fileMap.values());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"fileMap.values.single()");
            file = (File)object;
        }
        return file;
    }

    @NotNull
    public File getFile(@NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        File file = this.fileMap.get(filename);
        if (file == null) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "Multiple output files was defined.");
            return new File("");
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    public OutputFileProviderImpl(@NotNull BuildArtifactsHolder artifactsHolder, @NotNull Collection<? extends ArtifactType> replacedArtifacts, @NotNull Collection<? extends ArtifactType> appendedArtifacts, @NotNull Multimap<ArtifactType, String> filenamesMap, @NotNull Collection<String> unassociatedFilenames, @NotNull String taskName, @NotNull DslScope dslScope) {
        Map map;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)artifactsHolder, (String)"artifactsHolder");
        Intrinsics.checkParameterIsNotNull(replacedArtifacts, (String)"replacedArtifacts");
        Intrinsics.checkParameterIsNotNull(appendedArtifacts, (String)"appendedArtifacts");
        Intrinsics.checkParameterIsNotNull(filenamesMap, (String)"filenamesMap");
        Intrinsics.checkParameterIsNotNull(unassociatedFilenames, (String)"unassociatedFilenames");
        Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        this.dslScope = dslScope;
        Collection collection = filenamesMap.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filenamesMap.values()");
        Iterable iterable = CollectionsKt.union((Iterable)collection, (Iterable)unassociatedFilenames);
        OutputFileProviderImpl outputFileProviderImpl = this;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
        Iterable iterable2 = iterable;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it;
            Map map2 = destination$iv$iv;
            String string = it = (String)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            Pair pair = TuplesKt.to((Object)it, (Object)artifactsHolder.createFile$gradle_core(taskName, string));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        outputFileProviderImpl.fileMap = map = destination$iv$iv;
        for (ArtifactType artifactType : replacedArtifacts) {
            BuildArtifactSpec spec = BuildArtifactSpec.Companion.get(artifactType);
            Collection files = filenamesMap.get((Object)artifactType);
            if (!spec.getAppendable() && files.isEmpty()) {
                this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "An output file must be created for OutputType '" + artifactType + "'.");
            }
            Collection collection2 = files;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"files");
            artifactsHolder.replaceArtifact(artifactType, collection2, taskName);
        }
        for (ArtifactType artifactType : appendedArtifacts) {
            Collection collection3 = filenamesMap.get((Object)artifactType);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"filenamesMap[artifactType]");
            artifactsHolder.appendArtifact(artifactType, collection3, taskName);
        }
    }
}

