/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.stripping;

import com.android.build.gradle.internal.core.Abi;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bJ0\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00050\rR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/cxx/stripping/SymbolStripExecutableFinder;", "", "stripExecutables", "", "Lcom/android/build/gradle/internal/core/Abi;", "Ljava/io/File;", "(Ljava/util/Map;)V", "executables", "", "stripToolExecutableFile", "input", "abi", "reportAndFallback", "Lkotlin/Function1;", "", "gradle-core"})
public final class SymbolStripExecutableFinder {
    private final Map<Abi, File> stripExecutables;

    @NotNull
    public final Collection<File> executables() {
        return this.stripExecutables.values();
    }

    @Nullable
    public final File stripToolExecutableFile(@NotNull File input, @Nullable Abi abi, @NotNull Function1<? super String, ? extends File> reportAndFallback) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(reportAndFallback, (String)"reportAndFallback");
        if (abi == null) {
            return (File)reportAndFallback.invoke((Object)("Unable to strip library '" + input.getAbsolutePath() + "' due to " + "unknown ABI."));
        }
        File file = this.stripExecutables.get((Object)abi);
        if (file == null) {
            return (File)reportAndFallback.invoke((Object)("Unable to strip library '" + input.getAbsolutePath() + "' due to missing strip " + "tool for ABI '" + (Object)((Object)abi) + "'."));
        }
        return file;
    }

    public SymbolStripExecutableFinder(@NotNull Map<Abi, ? extends File> stripExecutables) {
        Intrinsics.checkParameterIsNotNull(stripExecutables, (String)"stripExecutables");
        this.stripExecutables = stripExecutables;
    }
}

