/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildMode;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.builder.model.Version;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.sdklib.AndroidVersion;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InstantRunBuildContext {
    private static final Logger LOG = Logging.getLogger(InstantRunBuildContext.class);
    static final String TAG_INSTANT_RUN = "instant-run";
    static final String TAG_BUILD = "build";
    static final String TAG_ARTIFACT = "artifact";
    static final String TAG_TASK = "task";
    static final String ATTR_PLUGIN_VERSION = "plugin-version";
    static final String ATTR_NAME = "name";
    static final String ATTR_DURATION = "duration";
    static final String ATTR_TIMESTAMP = "timestamp";
    static final String ATTR_VERIFIER = "verifier";
    static final String ATTR_TYPE = "type";
    static final String ATTR_LOCATION = "location";
    static final String ATTR_API_LEVEL = "api-level";
    static final String ATTR_DENSITY = "density";
    static final String ATTR_FORMAT = "format";
    static final String ATTR_ABI = "abi";
    static final String ATTR_TOKEN = "token";
    static final String ATTR_BUILD_MODE = "build-mode";
    static final String ATTR_IR_ELIGIBILITY = "ir-eligibility";
    static final String CURRENT_FORMAT = "10";
    private final long[] taskStartTime = new long[TaskType.values().length];
    private final long[] taskDurationInMs = new long[TaskType.values().length];
    private final InstantRunPatchingPolicy patchingPolicy;
    private final AndroidVersion androidVersion;
    private final String density;
    private final String abi;
    private final boolean createSeparateApkForResources;
    private final Build currentBuild;
    private final TreeMap<Long, Build> previousBuilds = new TreeMap();
    private final boolean isInstantRunMode;
    private final AtomicLong token = new AtomicLong(0L);
    private final AtomicBoolean buildHasFailed = new AtomicBoolean(false);
    private static final BuildIdAllocator defaultBuildIdAllocator = System::currentTimeMillis;

    public InstantRunBuildContext(boolean isInstantRunMode, AaptGeneration aaptGeneration, AndroidVersion androidVersion, String targetAbi, String density, boolean createSeparateApkForResources) {
        this(defaultBuildIdAllocator, isInstantRunMode, aaptGeneration, androidVersion, targetAbi, density, createSeparateApkForResources);
    }

    @VisibleForTesting
    InstantRunBuildContext(BuildIdAllocator buildIdAllocator, boolean isInstantRunMode, AaptGeneration aaptGeneration, AndroidVersion androidVersion, String targetAbi, String density, boolean createSeparateApkForResources) {
        this.currentBuild = new Build(buildIdAllocator.allocatedBuildId(), InstantRunVerifierStatus.NO_CHANGES, InstantRunBuildMode.HOT_WARM, null);
        this.isInstantRunMode = isInstantRunMode;
        this.androidVersion = androidVersion;
        this.patchingPolicy = isInstantRunMode ? InstantRunPatchingPolicy.getPatchingPolicy(androidVersion, aaptGeneration != AaptGeneration.AAPT_V1, createSeparateApkForResources) : InstantRunPatchingPolicy.UNKNOWN_PATCHING_POLICY;
        this.abi = targetAbi;
        this.density = density;
        this.createSeparateApkForResources = createSeparateApkForResources;
    }

    public boolean isInInstantRunMode() {
        return this.isInstantRunMode;
    }

    public void setBuildHasFailed() {
        this.buildHasFailed.set(true);
    }

    public boolean getBuildHasFailed() {
        return this.buildHasFailed.get();
    }

    public long getBuildId() {
        return this.currentBuild.buildId;
    }

    public void startRecording(TaskType taskType) {
        this.taskStartTime[taskType.ordinal()] = System.currentTimeMillis();
    }

    public long stopRecording(TaskType taskType) {
        long duration;
        this.taskDurationInMs[taskType.ordinal()] = duration = System.currentTimeMillis() - this.taskStartTime[taskType.ordinal()];
        return duration;
    }

    public void setVerifierStatus(InstantRunVerifierStatus verifierStatus) {
        LOG.info("Receiving verifier result: {}. Current Verifier/Build mode is {}/{}.", new Object[]{verifierStatus, this.currentBuild.getVerifierStatus(), this.currentBuild.buildMode});
        InstantRunBuildMode newBuildMode = this.currentBuild.buildMode.combine(verifierStatus.getInstantRunBuildModeForPatchingPolicy(this.patchingPolicy));
        this.currentBuild.allStatuses.add(verifierStatus);
        if (this.currentBuild.getVerifierStatus() == InstantRunVerifierStatus.NO_CHANGES || this.currentBuild.getVerifierStatus() == InstantRunVerifierStatus.COMPATIBLE || newBuildMode != this.currentBuild.buildMode) {
            this.currentBuild.verifierStatus = verifierStatus;
            this.currentBuild.buildMode = newBuildMode;
        }
        Preconditions.checkNotNull((Object)((Object)this.patchingPolicy), (Object)"setApiLevel should be called before setVerifierStatus");
        LOG.info("Verifier result is now : {}. Build mode is now {}.", (Object)this.currentBuild.getVerifierStatus(), (Object)this.currentBuild.buildMode);
    }

    public void setInstantRunEligibilityStatus(InstantRunVerifierStatus verifierStatus) {
        this.currentBuild.eligibilityStatus = verifierStatus;
    }

    public InstantRunVerifierStatus getVerifierResult() {
        return this.currentBuild.getVerifierStatus();
    }

    public boolean hasVerifierStatusBeenSet(InstantRunVerifierStatus status) {
        return this.currentBuild.allStatuses.contains((Object)status);
    }

    public boolean hasPassedVerification() {
        return this.currentBuild.buildMode == InstantRunBuildMode.HOT_WARM;
    }

    public AndroidVersion getAndroidVersion() {
        return this.androidVersion;
    }

    public String getDensity() {
        return this.density;
    }

    public InstantRunPatchingPolicy getPatchingPolicy() {
        return this.patchingPolicy;
    }

    public boolean useSeparateApkForResources() {
        return this.isInInstantRunMode() && this.getPatchingPolicy() == InstantRunPatchingPolicy.MULTI_APK_SEPARATE_RESOURCES;
    }

    public InstantRunBuildMode getBuildMode() {
        return this.currentBuild.buildMode;
    }

    public synchronized void addChangedFile(FileType fileType, File file) {
        if (this.currentBuild.getVerifierStatus() == InstantRunVerifierStatus.NO_CHANGES) {
            this.currentBuild.verifierStatus = InstantRunVerifierStatus.COMPATIBLE;
        }
        for (Artifact artifact : this.currentBuild.artifacts) {
            if (artifact.getType() != fileType || !artifact.getLocation().getAbsolutePath().equals(file.getAbsolutePath())) continue;
            return;
        }
        if (fileType == FileType.MAIN) {
            fileType = FileType.SPLIT_MAIN;
            Artifact previousArtifact = this.currentBuild.getArtifactForType(fileType);
            if (previousArtifact != null) {
                this.currentBuild.artifacts.remove(previousArtifact);
            }
            if (this.patchingPolicy != InstantRunPatchingPolicy.MULTI_APK_SEPARATE_RESOURCES) {
                Artifact resourcesApFile = this.currentBuild.getArtifactForType(FileType.RESOURCES);
                while (resourcesApFile != null) {
                    this.currentBuild.artifacts.remove(resourcesApFile);
                    resourcesApFile = this.currentBuild.getArtifactForType(FileType.RESOURCES);
                }
            }
        }
        this.currentBuild.artifacts.add(new Artifact(fileType, file));
    }

    public Build getLastBuild() {
        return this.previousBuilds.isEmpty() ? null : this.previousBuilds.lastEntry().getValue();
    }

    public long getSecretToken() {
        return this.token.get();
    }

    public void setSecretToken(long token) {
        this.token.set(token);
    }

    @VisibleForTesting
    public Collection<Build> getPreviousBuilds() {
        return this.previousBuilds.values();
    }

    private void purge() {
        boolean inMultiAPKOnBefore24;
        LOG.debug("Purge");
        boolean foundColdRestart = false;
        HashSet<String> splitFilesAlreadyFound = new HashSet<String>();
        Long initialFullBuild = this.previousBuilds.firstKey();
        for (Long aBuildId : new ArrayList<Long>(this.previousBuilds.descendingKeySet())) {
            Object resourceApArtifact;
            Build previousBuild = this.previousBuilds.get(aBuildId);
            LOG.debug("===================================================\nPurge: build {}\nVerifier status: {}\n===================================================\n", (Object)aBuildId, (Object)previousBuild.verifierStatus);
            if (previousBuild.buildId == initialFullBuild) {
                LOG.debug(" --- Skipping initial build.");
                continue;
            }
            if (previousBuild.verifierStatus == InstantRunVerifierStatus.COMPATIBLE) {
                if (foundColdRestart) {
                    LOG.debug("Removed this hot swap build as there are newer cold swaps.");
                    this.previousBuilds.remove(aBuildId);
                    continue;
                }
            } else if (previousBuild.verifierStatus != InstantRunVerifierStatus.NO_CHANGES) {
                LOG.debug("This is a cold swap build. Older hot swaps will be removed.");
                foundColdRestart = true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Artifacts for build: Size: {}\n  * {}", (Object)previousBuild.artifacts.size(), (Object)previousBuild.artifacts.stream().map(Artifact::toString).collect(Collectors.joining("\n  * ")));
            }
            if (foundColdRestart && (resourceApArtifact = previousBuild.getArtifactForType(FileType.RESOURCES)) != null) {
                previousBuild.artifacts.remove(resourceApArtifact);
                LOG.debug("Removing resources from this build as superseded by later cold swap.");
            }
            resourceApArtifact = new ArrayList(previousBuild.artifacts).iterator();
            while (resourceApArtifact.hasNext()) {
                Artifact artifact2 = (Artifact)resourceApArtifact.next();
                if (!artifact2.isAccumulative()) continue;
                if (splitFilesAlreadyFound.contains(artifact2.getLocation().getAbsolutePath())) {
                    LOG.debug("Found split is superseded by the same split in a newer build", (Object)artifact2.getLocation().getAbsolutePath());
                    previousBuild.artifacts.remove(artifact2);
                    continue;
                }
                LOG.debug("Found split {}, will be removed from older builds.", (Object)artifact2.getLocation().getAbsolutePath());
                splitFilesAlreadyFound.add(artifact2.getLocation().getAbsolutePath());
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Artifacts after purge: Size: {}\n  * {}", (Object)previousBuild.artifacts.size(), (Object)previousBuild.artifacts.stream().map(Artifact::toString).collect(Collectors.joining("\n  * ")));
        }
        LOG.debug("Purge: SplitFilesAlreadyFound: {} ", (Object)splitFilesAlreadyFound.stream().collect(Collectors.joining("\n")));
        for (Long aBuildId : new ArrayList<Long>(this.previousBuilds.descendingKeySet())) {
            Build aBuild = this.previousBuilds.get(aBuildId);
            if (!aBuild.artifacts.isEmpty() || aBuild.buildId == this.currentBuild.buildId) continue;
            LOG.debug("Removing empty build: {}", (Object)aBuildId);
            this.previousBuilds.remove(aBuildId);
        }
        boolean bl = inMultiAPKOnBefore24 = this.patchingPolicy == InstantRunPatchingPolicy.MULTI_APK && this.androidVersion.getFeatureLevel() < 24;
        if (inMultiAPKOnBefore24) {
            boolean anySplitInCurrentBuild;
            LOG.debug("Adding split main if a split is present as deploying to a device < 24");
            if (this.currentBuild.getArtifactForType(FileType.SPLIT_MAIN) == null && (anySplitInCurrentBuild = this.currentBuild.artifacts.stream().anyMatch(artifact -> ((Artifact)artifact).fileType == FileType.SPLIT))) {
                LOG.debug("No split main and a split, re-adding split main.");
                for (Build previousBuild : this.previousBuilds.values()) {
                    Artifact main = previousBuild.getArtifactForType(FileType.SPLIT_MAIN);
                    if (main == null) continue;
                    this.currentBuild.artifacts.add(main);
                    break;
                }
            }
        }
        switch (this.currentBuild.buildMode) {
            case HOT_WARM: {
                break;
            }
            case COLD: {
                if (this.previousBuilds.keySet().size() != 2 || this.previousBuilds.get(initialFullBuild).artifacts.size() != this.currentBuild.artifacts.size()) break;
                this.currentBuild.buildMode = InstantRunBuildMode.FULL;
                this.collapseMainArtifactsIntoCurrentBuild();
                break;
            }
            case FULL: {
                this.collapseMainArtifactsIntoCurrentBuild();
            }
        }
    }

    private void collapseMainArtifactsIntoCurrentBuild() {
        LOG.debug("=======================================\ncollapseMainArtifactsIntoCurrentBuild\n=======================================");
        HashSet splitLocations = Sets.newHashSet();
        Artifact main = null;
        for (Build build : this.previousBuilds.values()) {
            for (Artifact artifact : build.artifacts) {
                if (artifact.fileType == FileType.SPLIT) {
                    splitLocations.add(artifact.location.getAbsolutePath());
                    continue;
                }
                if (artifact.fileType != FileType.SPLIT_MAIN) continue;
                main = artifact;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Split locations  Count:{}.\n{}", (Object)splitLocations.size(), (Object)splitLocations.stream().collect(Collectors.joining("\n")));
        }
        for (Object artifact : this.currentBuild.artifacts) {
            if (((Artifact)artifact).fileType == FileType.SPLIT) {
                if (((Artifact)artifact).location.getName().startsWith("resources")) {
                    splitLocations.removeIf(splitLocation -> new File((String)splitLocation).getName().startsWith("resources"));
                    continue;
                }
                splitLocations.remove(((Artifact)artifact).location.getAbsolutePath());
                continue;
            }
            if (((Artifact)artifact).fileType != FileType.SPLIT_MAIN) continue;
            main = null;
        }
        if (InstantRunPatchingPolicy.MULTI_APK_SEPARATE_RESOURCES != this.patchingPolicy) {
            String resourceApkName = null;
            for (String splitLocation2 : splitLocations) {
                String apkFileName = new File(splitLocation2).getName();
                if (!apkFileName.startsWith("resources")) continue;
                resourceApkName = splitLocation2;
            }
            if (resourceApkName != null) {
                splitLocations.remove(resourceApkName);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Split locations, current build removed  Count: {}.\n{}", (Object)splitLocations.size(), (Object)splitLocations.stream().collect(Collectors.joining("\n")));
        }
        for (String splitLocation3 : splitLocations) {
            this.currentBuild.artifacts.add(new Artifact(FileType.SPLIT, new File(splitLocation3)));
        }
        if (main != null) {
            this.currentBuild.artifacts.add(main);
        }
        if (this.currentBuild.artifacts.isEmpty()) {
            throw new IllegalStateException("Full build with no artifacts. This should not happen.");
        }
    }

    public void loadFromXmlFile(File persistedState) throws IOException, ParserConfigurationException, SAXException {
        if (!persistedState.exists()) {
            this.setVerifierStatus(InstantRunVerifierStatus.INITIAL_BUILD);
            return;
        }
        this.loadFromDocument(XmlUtils.parseUtfXmlFile((File)persistedState, (boolean)false));
    }

    @VisibleForTesting
    public void loadFromXml(String persistedState) throws IOException, SAXException, ParserConfigurationException {
        this.loadFromDocument(XmlUtils.parseDocument((String)persistedState, (boolean)false));
    }

    private synchronized void loadFromDocument(Document document) {
        Element instantRun = document.getDocumentElement();
        if (!Version.ANDROID_GRADLE_PLUGIN_VERSION.equals(instantRun.getAttribute(ATTR_PLUGIN_VERSION))) {
            Logging.getLogger(InstantRunBuildContext.class).quiet("Instant Run: Android plugin version has changed.");
            this.setVerifierStatus(InstantRunVerifierStatus.INITIAL_BUILD);
            return;
        }
        String tokenString = instantRun.getAttribute(ATTR_TOKEN);
        if (!Strings.isNullOrEmpty((String)tokenString)) {
            this.token.set(Long.parseLong(tokenString));
        }
        Build lastBuild = Build.fromXml(instantRun);
        this.previousBuilds.put(lastBuild.buildId, lastBuild);
        NodeList buildNodes = instantRun.getChildNodes();
        for (int i = 0; i < buildNodes.getLength(); ++i) {
            Node buildNode = buildNodes.item(i);
            if (!buildNode.getNodeName().equals(TAG_BUILD)) continue;
            Build build = Build.fromXml(buildNode);
            this.previousBuilds.put(build.buildId, build);
        }
    }

    public void mergeFromFile(File tmpBuildInfoFile) throws IOException, SAXException, ParserConfigurationException {
        this.mergeFrom(XmlUtils.parseUtfXmlFile((File)tmpBuildInfoFile, (boolean)false));
    }

    public void mergeFrom(String tmpBuildInfo) throws IOException, SAXException, ParserConfigurationException {
        this.mergeFrom(XmlUtils.parseDocument((String)tmpBuildInfo, (boolean)false));
    }

    private void mergeFrom(Document document) throws IOException {
        Element instantRun = document.getDocumentElement();
        Build lastBuild = Build.fromXml(instantRun);
        for (Artifact previousArtifact : lastBuild.getArtifacts()) {
            this.mergeArtifact(previousArtifact);
        }
    }

    private void mergeArtifact(Artifact stashedArtifact) {
        for (Artifact artifact : this.currentBuild.artifacts) {
            if (artifact.getType() != stashedArtifact.getType() || !artifact.getLocation().getAbsolutePath().equals(stashedArtifact.getLocation().getAbsolutePath())) continue;
            return;
        }
        this.currentBuild.getArtifacts().add(stashedArtifact);
    }

    public synchronized void close() {
        this.previousBuilds.put(this.currentBuild.buildId, this.currentBuild);
        this.purge();
    }

    public String toXml() throws ParserConfigurationException {
        return this.toXml(this.currentBuild.buildMode == InstantRunBuildMode.FULL ? PersistenceMode.FULL_BUILD : PersistenceMode.INCREMENTAL_BUILD);
    }

    @VisibleForTesting
    String toXml(PersistenceMode persistenceMode) throws ParserConfigurationException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.toXml(document, persistenceMode);
        String xml = XmlPrettyPrinter.prettyPrint((Node)document, (boolean)true);
        LOG.debug("build-info.xml save version :  {} patching : {} content : \n {} ", new Object[]{this.androidVersion, this.patchingPolicy, xml});
        return xml;
    }

    private void toXml(Document document, PersistenceMode persistenceMode) {
        Element instantRun = document.createElement(TAG_INSTANT_RUN);
        document.appendChild(instantRun);
        for (TaskType taskType : TaskType.values()) {
            Element taskTypeNode = document.createElement(TAG_TASK);
            taskTypeNode.setAttribute(ATTR_NAME, (String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_HYPHEN).convert((Object)taskType.name()));
            taskTypeNode.setAttribute(ATTR_DURATION, String.valueOf(this.taskDurationInMs[taskType.ordinal()]));
            instantRun.appendChild(taskTypeNode);
        }
        if (LOG.isDebugEnabled()) {
            instantRun.setAttribute("pid", ManagementFactory.getRuntimeMXBean().getName());
            instantRun.setAttribute("version", this.androidVersion.getApiString());
        }
        if (this.isInInstantRunMode()) {
            instantRun.setAttribute(ATTR_API_LEVEL, String.valueOf(this.getAndroidVersion().getFeatureLevel()));
            if (this.density != null) {
                instantRun.setAttribute(ATTR_DENSITY, this.density);
            }
            if (this.abi != null) {
                instantRun.setAttribute(ATTR_ABI, this.abi);
            }
            instantRun.setAttribute(ATTR_TOKEN, this.token.toString());
        } else {
            this.currentBuild.buildMode = InstantRunBuildMode.FULL;
            this.currentBuild.verifierStatus = InstantRunVerifierStatus.NOT_RUN;
        }
        this.currentBuild.toXml(document, instantRun);
        instantRun.setAttribute(ATTR_FORMAT, CURRENT_FORMAT);
        instantRun.setAttribute(ATTR_PLUGIN_VERSION, Version.ANDROID_GRADLE_PLUGIN_VERSION);
        switch (persistenceMode) {
            case FULL_BUILD: {
                if (this.previousBuilds.isEmpty()) break;
                instantRun.appendChild(this.previousBuilds.lastEntry().getValue().toXml(document));
                break;
            }
            case INCREMENTAL_BUILD: {
                for (Build build : this.previousBuilds.values()) {
                    instantRun.appendChild(build.toXml(document));
                }
                break;
            }
            case TEMP_BUILD: {
                break;
            }
            default: {
                throw new RuntimeException("PersistenceMode not handled" + (Object)((Object)persistenceMode));
            }
        }
    }

    public void writeTmpBuildInfo(File tmpBuildInfo) throws ParserConfigurationException, IOException {
        Files.createParentDirs((File)tmpBuildInfo);
        Files.write((CharSequence)this.toXml(PersistenceMode.TEMP_BUILD), (File)tmpBuildInfo, (Charset)Charsets.UTF_8);
    }

    @VisibleForTesting
    static interface BuildIdAllocator {
        public long allocatedBuildId();
    }

    @VisibleForTesting
    static enum PersistenceMode {
        FULL_BUILD,
        INCREMENTAL_BUILD,
        TEMP_BUILD;

    }

    public static class Artifact {
        private final FileType fileType;
        private File location;

        public Artifact(FileType fileType, File location) {
            this.fileType = fileType;
            this.location = location;
        }

        public Node toXml(Document document) {
            Element artifact = document.createElement(InstantRunBuildContext.TAG_ARTIFACT);
            artifact.setAttribute(InstantRunBuildContext.ATTR_TYPE, this.fileType.name());
            artifact.setAttribute(InstantRunBuildContext.ATTR_LOCATION, this.location.getAbsolutePath());
            return artifact;
        }

        public static Artifact fromXml(Node artifactNode) {
            NamedNodeMap attributes2 = artifactNode.getAttributes();
            return new Artifact(FileType.valueOf(attributes2.getNamedItem(InstantRunBuildContext.ATTR_TYPE).getNodeValue()), new File(attributes2.getNamedItem(InstantRunBuildContext.ATTR_LOCATION).getNodeValue()));
        }

        public File getLocation() {
            return this.location;
        }

        public boolean isAccumulative() {
            return this.fileType != FileType.RELOAD_DEX;
        }

        public void setLocation(File location) {
            this.location = location;
        }

        public FileType getType() {
            return this.fileType;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("fileType", (Object)this.fileType).add(InstantRunBuildContext.ATTR_LOCATION, (Object)this.location).toString();
        }
    }

    public static class Build {
        private final long buildId;
        private InstantRunVerifierStatus verifierStatus;
        private List<InstantRunVerifierStatus> allStatuses = new ArrayList<InstantRunVerifierStatus>();
        private InstantRunVerifierStatus eligibilityStatus;
        private InstantRunBuildMode buildMode;
        private final List<Artifact> artifacts = new ArrayList<Artifact>();

        public Build(long buildId, InstantRunVerifierStatus verifierStatus, InstantRunBuildMode buildMode, InstantRunVerifierStatus eligibilityStatus) {
            this.buildId = buildId;
            this.verifierStatus = verifierStatus;
            this.buildMode = buildMode;
            this.eligibilityStatus = eligibilityStatus;
        }

        public Artifact getArtifactForType(FileType fileType) {
            for (Artifact artifact : this.artifacts) {
                if (artifact.fileType != fileType) continue;
                return artifact;
            }
            return null;
        }

        private Element toXml(Document document) {
            Element build = document.createElement(InstantRunBuildContext.TAG_BUILD);
            this.toXml(document, build);
            return build;
        }

        private void toXml(Document document, Element element) {
            element.setAttribute(InstantRunBuildContext.ATTR_TIMESTAMP, String.valueOf(this.buildId));
            element.setAttribute(InstantRunBuildContext.ATTR_VERIFIER, this.verifierStatus.name());
            element.setAttribute(InstantRunBuildContext.ATTR_BUILD_MODE, this.buildMode.name());
            if (this.eligibilityStatus != null) {
                element.setAttribute(InstantRunBuildContext.ATTR_IR_ELIGIBILITY, this.eligibilityStatus.name());
            }
            for (Artifact artifact : this.artifacts) {
                element.appendChild(artifact.toXml(document));
            }
        }

        public static Build fromXml(Node buildNode) {
            NamedNodeMap attributes2 = buildNode.getAttributes();
            Node verifierAttribute = attributes2.getNamedItem(InstantRunBuildContext.ATTR_VERIFIER);
            Node buildModeAttribute = attributes2.getNamedItem(InstantRunBuildContext.ATTR_BUILD_MODE);
            Node eligibilityAttribute = attributes2.getNamedItem(InstantRunBuildContext.ATTR_IR_ELIGIBILITY);
            InstantRunVerifierStatus eligibility = eligibilityAttribute == null ? null : InstantRunVerifierStatus.valueOf(eligibilityAttribute.getNodeValue());
            Build build = new Build(Long.parseLong(attributes2.getNamedItem(InstantRunBuildContext.ATTR_TIMESTAMP).getNodeValue()), InstantRunVerifierStatus.valueOf(verifierAttribute.getNodeValue()), InstantRunBuildMode.valueOf(buildModeAttribute.getNodeValue()), eligibility);
            NodeList childNodes = buildNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node artifactNode = childNodes.item(i);
                if (!artifactNode.getNodeName().equals(InstantRunBuildContext.TAG_ARTIFACT)) continue;
                Artifact artifact = Artifact.fromXml(artifactNode);
                build.artifacts.add(artifact);
            }
            return build;
        }

        public long getBuildId() {
            return this.buildId;
        }

        public List<Artifact> getArtifacts() {
            return this.artifacts;
        }

        public InstantRunVerifierStatus getVerifierStatus() {
            return this.verifierStatus;
        }

        public InstantRunBuildMode getBuildMode() {
            return this.buildMode;
        }
    }

    public static enum TaskType {
        JAVAC,
        INSTANT_RUN_DEX,
        INSTANT_RUN_TRANSFORM,
        VERIFIER;

    }
}

