/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.packaging;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.builder.signing.DefaultSigningConfig;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.prefs.AndroidLocation;
import com.android.utils.ILogger;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"createDefaultDebugStore", "", "defaultDebugKeystoreLocation", "Ljava/io/File;", "logger", "Lorg/gradle/api/logging/Logger;", "getDefaultDebugKeystoreLocation", "gradle-core"})
@JvmName(name="GradleKeystoreHelper")
public final class GradleKeystoreHelper {
    @NotNull
    public static final File getDefaultDebugKeystoreLocation() {
        File file;
        try {
            file = new File(KeystoreHelper.defaultDebugKeystoreLocation());
        }
        catch (AndroidLocation.AndroidLocationException e) {
            throw (Throwable)new InvalidUserDataException("Failed to get default debug keystore location.", (Throwable)e);
        }
        return file;
    }

    public static final void createDefaultDebugStore(@NotNull File defaultDebugKeystoreLocation, @NotNull Logger logger) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)defaultDebugKeystoreLocation, (String)"defaultDebugKeystoreLocation");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        DefaultSigningConfig signingConfig = DefaultSigningConfig.debugSigningConfig((File)defaultDebugKeystoreLocation);
        logger.info("Creating default debug keystore at {}", (Object)defaultDebugKeystoreLocation.getAbsolutePath());
        try {
            DefaultSigningConfig defaultSigningConfig = signingConfig;
            Intrinsics.checkExpressionValueIsNotNull((Object)defaultSigningConfig, (String)"signingConfig");
            String string = defaultSigningConfig.getStoreType();
            File file = signingConfig.getStoreFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
            String string2 = signingConfig.getStorePassword();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = signingConfig.getKeyPassword();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            String string4 = signingConfig.getKeyAlias();
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            if (!KeystoreHelper.createDebugStore((String)string, (File)file, (String)string2, (String)string3, (String)string4, (ILogger)new LoggerWrapper(logger))) {
                throw (Throwable)new IOException("Unable to create missing debug keystore.");
            }
        }
        catch (KeytoolException e) {
            throw (Throwable)new IOException(e);
        }
    }
}

