/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.Aapt2ErrorUtils;
import com.android.build.gradle.internal.res.namespaced.Aapt2DaemonManagerService;
import com.android.build.gradle.internal.res.namespaced.Aapt2MavenUtils;
import com.android.build.gradle.internal.res.namespaced.Aapt2ServiceKey;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputFactory;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.SplitList;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitPackageIds;
import com.android.build.gradle.internal.transforms.InstantRunSliceSplitApkBuilder;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.BlockingResourceLinker;
import com.android.builder.internal.aapt.v2.Aapt2DaemonManager;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MergingLogRewriter;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.Aapt2OutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.symbols.SymbolIo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.tooling.BuildException;

@CacheableTask
public class LinkApplicationAndroidResourcesTask
extends ProcessAndroidResources {
    private static final String IR_APK_FILE_NAME = "resources";
    private static final Logger LOG = Logging.getLogger(LinkApplicationAndroidResourcesTask.class);
    private File sourceOutputDir;
    private Supplier<File> textSymbolOutputDir = () -> null;
    private File symbolsWithPackageNameOutputFile;
    private File proguardOutputFile;
    private File mainDexListProguardOutputFile;
    private FileCollection dependenciesFileCollection;
    private FileCollection sharedLibraryDependencies;
    private ArtifactCollection packageIdsFiles;
    private MultiOutputPolicy multiOutputPolicy;
    private VariantType type;
    private AaptGeneration aaptGeneration;
    private FileCollection aapt2FromMaven;
    private boolean debuggable;
    private boolean pseudoLocalesEnabled;
    private AaptOptions aaptOptions;
    private File mergeBlameLogFolder;
    private InstantRunBuildContext buildContext;
    private FileCollection featureResourcePackages;
    private String originalApplicationId;
    private String buildTargetDensity;
    private File resPackageOutputFolder;
    private String projectBaseName;
    private InternalArtifactType taskInputType;
    private boolean isNamespaced = false;
    private VariantScope variantScope;
    FileCollection splitListInput;
    private OutputScope outputScope;
    private OutputFactory outputFactory;
    private boolean enableAapt2;
    private String applicationId;
    private File supportDirectory;
    private FileCollection apkList;
    FileCollection manifestFiles;
    private FileCollection inputResourcesDir;
    boolean isLibrary;

    @Input
    public InternalArtifactType getTaskInputType() {
        return this.taskInputType;
    }

    @Input
    public InstantRunPatchingPolicy getPatchingPolicy() {
        return this.buildContext.getPatchingPolicy();
    }

    @Input
    public String getProjectBaseName() {
        return this.projectBaseName;
    }

    @Internal
    private Set<String> getSplits(SplitList splitList) throws IOException {
        return SplitList.getSplits(splitList, this.multiOutputPolicy);
    }

    @Input
    public String getApplicationId() {
        return this.applicationId;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getApkList() {
        return this.apkList;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        BuildElements manifestBuildElements = ExistingBuildElements.from((ArtifactType)this.taskInputType, this.manifestFiles);
        Set packageIdFileSet = this.packageIdsFiles != null ? this.packageIdsFiles.getArtifactFiles().getAsFileTree().getFiles() : null;
        Set featureResourcePackages = this.featureResourcePackages.getFiles();
        SplitList splitList = this.splitListInput == null ? SplitList.EMPTY : SplitList.load(this.splitListInput);
        Set dependencies = this.dependenciesFileCollection != null ? this.dependenciesFileCollection.getFiles() : Collections.emptySet();
        Set imports = this.sharedLibraryDependencies != null ? this.sharedLibraryDependencies.getFiles() : Collections.emptySet();
        ImmutableList.Builder buildOutputs = ImmutableList.builder();
        try (Aapt aapt = this.makeAapt();){
            ApkInfo apkInfo;
            Aapt2ServiceKey aapt2ServiceKey = this.aaptGeneration == AaptGeneration.AAPT_V2_DAEMON_SHARED_POOL ? Aapt2DaemonManagerService.registerAaptService(this.aapt2FromMaven, this.getBuildTools(), this.getILogger()) : null;
            List unprocessedManifest = manifestBuildElements.stream().collect(Collectors.toList());
            for (BuildOutput manifestBuildOutput : manifestBuildElements) {
                apkInfo = manifestBuildOutput.getApkInfo();
                boolean codeGen = apkInfo.getType() == VariantOutput.OutputType.MAIN || apkInfo.getFilter(VariantOutput.FilterType.DENSITY) == null;
                if (!codeGen) continue;
                unprocessedManifest.remove(manifestBuildOutput);
                buildOutputs.add((Object)this.invokeAaptForSplit(manifestBuildOutput, dependencies, imports, packageIdFileSet, splitList, featureResourcePackages, apkInfo, true, aapt, aapt2ServiceKey));
                break;
            }
            for (BuildOutput manifestBuildOutput : unprocessedManifest) {
                apkInfo = manifestBuildOutput.getApkInfo();
                if (!apkInfo.requiresAapt()) continue;
                executor.execute(() -> this.invokeAaptForSplit(manifestBuildOutput, dependencies, imports, packageIdFileSet, splitList, featureResourcePackages, apkInfo, false, aapt, aapt2ServiceKey));
            }
            List taskResults = executor.waitForAllTasks();
            taskResults.forEach(taskResult -> {
                if (taskResult.getException() != null) {
                    throw new BuildException(taskResult.getException().getMessage(), taskResult.getException());
                }
                buildOutputs.add(taskResult.getValue());
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (this.multiOutputPolicy == MultiOutputPolicy.SPLITS) {
            splitList.forEach((filterType, filters) -> {
                if (filterType != VariantOutput.FilterType.DENSITY && filterType != VariantOutput.FilterType.LANGUAGE) {
                    return;
                }
                filters.forEach(filter -> {
                    ApkData configurationApkData = this.outputFactory.addConfigurationSplit(filterType, filter.getValue(), "", filter.getDisplayName());
                    configurationApkData.setVersionCode(this.variantScope.getVariantConfiguration().getVersionCode());
                    configurationApkData.setVersionName(this.variantScope.getVariantConfiguration().getVersionName());
                    this.variantScope.getVariantData().variantOutputFactory.create(configurationApkData);
                    File packagedResForSplit = LinkApplicationAndroidResourcesTask.findPackagedResForSplit(this.resPackageOutputFolder, configurationApkData);
                    if (packagedResForSplit != null) {
                        configurationApkData.setOutputFileName(packagedResForSplit.getName());
                        buildOutputs.add((Object)new BuildOutput(InternalArtifactType.DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES, (ApkInfo)configurationApkData, packagedResForSplit));
                    } else {
                        this.getLogger().warn("Cannot find output for " + configurationApkData);
                    }
                });
            });
        }
        new BuildElements((Collection<BuildOutput>)buildOutputs.build()).save(this.resPackageOutputFolder);
    }

    BuildOutput invokeAaptForSplit(BuildOutput manifestOutput, Set<File> dependencies, Set<File> imports, Set<File> packageIdFileSet, SplitList splitList, Set<File> featureResourcePackages, ApkInfo apkData, boolean generateCode, Aapt aapt, Aapt2ServiceKey aapt2ServiceKey) throws IOException {
        FilterData densityFilterData;
        ImmutableList.Builder featurePackagesBuilder = ImmutableList.builder();
        for (File featurePackage : featureResourcePackages) {
            BuildElements buildElements = ExistingBuildElements.from((ArtifactType)InternalArtifactType.PROCESSED_RES, featurePackage);
            if (buildElements.isEmpty()) continue;
            BuildOutput mainBuildOutput = buildElements.element((ApkInfo)this.variantScope.getOutputScope().getMainSplit());
            if (mainBuildOutput != null) {
                featurePackagesBuilder.add((Object)mainBuildOutput.getOutputFile());
                continue;
            }
            throw new IOException("Cannot find PROCESSED_RES output for " + this.variantScope.getOutputScope().getMainSplit());
        }
        File resOutBaseNameFile = new File(this.resPackageOutputFolder, "resources-" + apkData.getFullName() + ".ap_");
        File manifestFile = manifestOutput.getOutputFile();
        String packageForR = null;
        File srcOut = null;
        File symbolOutputDir = null;
        File proguardOutputFile = null;
        File mainDexListProguardOutputFile = null;
        if (generateCode) {
            packageForR = this.originalApplicationId;
            srcOut = this.getSourceOutputDir();
            if (srcOut != null) {
                FileUtils.cleanOutputDir((File)srcOut);
            }
            symbolOutputDir = this.textSymbolOutputDir.get();
            proguardOutputFile = this.getProguardOutputFile();
            mainDexListProguardOutputFile = this.getMainDexListProguardOutputFile();
        }
        String preferredDensity = (densityFilterData = apkData.getFilter(VariantOutput.FilterType.DENSITY)) != null ? densityFilterData.getIdentifier() : (splitList.getFilters("ResConfigs").isEmpty() ? this.buildTargetDensity : null);
        Integer packageId = null;
        if (packageIdFileSet != null && FeatureSplitPackageIds.getOutputFile(packageIdFileSet) != null) {
            FeatureSplitPackageIds featurePackageIds = FeatureSplitPackageIds.load(packageIdFileSet);
            packageId = featurePackageIds.getIdFor(this.getProject().getPath());
        }
        try {
            block28: {
                if (this.buildContext.isInInstantRunMode() && this.buildContext.getPatchingPolicy() == InstantRunPatchingPolicy.MULTI_APK_SEPARATE_RESOURCES) {
                    this.supportDirectory.mkdirs();
                    manifestFile = InstantRunSliceSplitApkBuilder.generateSplitApkManifest(this.supportDirectory, IR_APK_FILE_NAME, this.applicationId, apkData.getVersionName(), apkData.getVersionCode(), manifestOutput.getProperties().get("minSdkVersion"));
                }
                AaptPackageConfig.Builder configBuilder = new AaptPackageConfig.Builder().setManifestFile(manifestFile).setOptions(DslAdaptersKt.convert(this.aaptOptions)).setCustomPackageForR(packageForR).setSymbolOutputDir(symbolOutputDir).setSourceOutputDir(srcOut).setResourceOutputApk(resOutBaseNameFile).setProguardOutputFile(proguardOutputFile).setMainDexListProguardOutputFile(mainDexListProguardOutputFile).setVariantType(this.getType()).setDebuggable(this.getDebuggable()).setPseudoLocalize(this.getPseudoLocalesEnabled()).setResourceConfigs(splitList.getFilters("ResConfigs")).setSplits(this.getSplits(splitList)).setPreferredDensity(preferredDensity).setPackageId(packageId).setDependentFeatures((Collection)featurePackagesBuilder.build()).setImports(imports).setAndroidTarget(this.getBuilder().getTarget());
                if (this.isNamespaced) {
                    configBuilder.setStaticLibraryDependencies(ImmutableList.copyOf(dependencies));
                } else {
                    if (generateCode) {
                        configBuilder.setLibrarySymbolTableFiles(dependencies);
                    }
                    configBuilder.setResourceDir(((FileCollection)Preconditions.checkNotNull((Object)this.getInputResourcesDir())).getSingleFile());
                }
                AaptPackageConfig config2 = configBuilder.build();
                if (this.aaptGeneration == AaptGeneration.AAPT_V2_DAEMON_SHARED_POOL) {
                    Preconditions.checkNotNull((Object)aapt2ServiceKey, (Object)"AAPT2 daemon manager service not initialized");
                    try (Aapt2DaemonManager.LeasedAaptDaemon aaptDaemon = Aapt2DaemonManagerService.getAaptDaemon(aapt2ServiceKey);){
                        AndroidBuilder.processResources((BlockingResourceLinker)aaptDaemon, (AaptPackageConfig)config2, (ILogger)this.getILogger());
                        break block28;
                    }
                    catch (Aapt2Exception e) {
                        throw Aapt2ErrorUtils.rewriteLinkException(e, new MergingLog(this.getMergeBlameLogFolder()));
                    }
                }
                Preconditions.checkNotNull((Object)aapt, (Object)"AAPT needs be instantiated for linking if bypassing AAPT is disabled");
                AndroidBuilder.processResources((BlockingResourceLinker)aapt, (AaptPackageConfig)config2, (ILogger)this.getILogger());
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Aapt output file {}", (Object)resOutBaseNameFile.getAbsolutePath());
            }
            if (generateCode && (this.isLibrary || !dependencies.isEmpty()) && this.symbolsWithPackageNameOutputFile != null) {
                SymbolIo.writeSymbolTableWithPackage((Path)((File)Preconditions.checkNotNull((Object)this.getTextSymbolOutputFile())).toPath(), (Path)manifestFile.toPath(), (Path)this.symbolsWithPackageNameOutputFile.toPath());
            }
            return new BuildOutput((ArtifactType)InternalArtifactType.PROCESSED_RES, apkData, resOutBaseNameFile, manifestOutput.getProperties());
        }
        catch (ProcessException e) {
            throw new BuildException("Failed to process resources, see aapt output above for details.", (Throwable)e);
        }
    }

    private static File findPackagedResForSplit(File outputFolder, ApkData apkData) {
        Pattern resourcePattern = Pattern.compile("resources-" + apkData.getFullName() + ".ap__(.*)");
        if (outputFolder == null) {
            return null;
        }
        File[] files = outputFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                Matcher match = resourcePattern.matcher(file.getName());
                if (!match.matches() || match.group(1).isEmpty() || !LinkApplicationAndroidResourcesTask.isValidSplit((ApkInfo)apkData, match.group(1))) continue;
                return file;
            }
        }
        return null;
    }

    private Aapt makeAapt() {
        AndroidBuilder builder = this.getBuilder();
        if (this.aaptGeneration == AaptGeneration.AAPT_V2_DAEMON_SHARED_POOL) {
            return null;
        }
        MergingLog mergingLog = new MergingLog(this.getMergeBlameLogFolder());
        MessageReceiver[] messageReceiverArray = new MessageReceiver[1];
        messageReceiverArray[0] = new MergingLogRewriter(arg_0 -> ((MergingLog)mergingLog).find(arg_0), builder.getMessageReceiver());
        ParsingProcessOutputHandler processOutputHandler2 = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)(this.aaptGeneration == AaptGeneration.AAPT_V1 ? new AaptOutputParser() : new Aapt2OutputParser()), this.getILogger()), messageReceiverArray);
        return AaptGradleFactory.make(this.aaptGeneration, builder, (ProcessOutputHandler)processOutputHandler2, true, FileUtils.mkdirs((File)new File(this.getIncrementalFolder(), "aapt-temp")), this.aaptOptions.getCruncherProcesses());
    }

    private static boolean isValidSplit(ApkInfo apkData, String splitWithOptionalSuffix) {
        FilterData splitFilter = apkData.getFilter(VariantOutput.FilterType.DENSITY);
        if (splitFilter != null && splitWithOptionalSuffix.startsWith(splitFilter.getIdentifier())) {
            return true;
        }
        String mangledName = LinkApplicationAndroidResourcesTask.unMangleSplitName(splitWithOptionalSuffix);
        splitFilter = apkData.getFilter(VariantOutput.FilterType.LANGUAGE);
        return splitFilter != null && mangledName.equals(splitFilter.getIdentifier());
    }

    public static String unMangleSplitName(String splitWithOptionalSuffix) {
        String mangledName = splitWithOptionalSuffix.replaceAll("_", ",");
        return mangledName.contains("-r") ? mangledName : mangledName.replace("-", "-r");
    }

    public File getManifestFile() {
        File manifestDirectory = (File)Iterables.getFirst((Iterable)this.manifestFiles.getFiles(), null);
        Preconditions.checkNotNull((Object)manifestDirectory);
        Preconditions.checkNotNull((Object)this.outputScope.getMainSplit());
        return FileUtils.join((File)manifestDirectory, (String[])new String[]{this.outputScope.getMainSplit().getDirName(), "AndroidManifest.xml"});
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getManifestFiles() {
        return this.manifestFiles;
    }

    public void setManifestFiles(FileCollection manifestFiles) {
        this.manifestFiles = manifestFiles;
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getPackageIdsFiles() {
        return this.packageIdsFiles != null ? this.packageIdsFiles.getArtifactFiles() : null;
    }

    @Input
    public boolean isInstantRunMode() {
        return this.buildContext.isInInstantRunMode();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getInputResourcesDir() {
        return this.inputResourcesDir;
    }

    @Override
    @OutputDirectory
    @Optional
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @OutputFile
    @Optional
    public File getTextSymbolOutputFile() {
        File outputDir = this.textSymbolOutputDir.get();
        return outputDir != null ? new File(outputDir, "R.txt") : null;
    }

    @OutputFile
    @Optional
    public File getSymbolslWithPackageNameOutputFile() {
        return this.symbolsWithPackageNameOutputFile;
    }

    @OutputFile
    @Optional
    public File getProguardOutputFile() {
        return this.proguardOutputFile;
    }

    public void setProguardOutputFile(File proguardOutputFile) {
        this.proguardOutputFile = proguardOutputFile;
    }

    @OutputFile
    @Optional
    public File getMainDexListProguardOutputFile() {
        return this.mainDexListProguardOutputFile;
    }

    public void setAaptMainDexListProguardOutputFile(File mainDexListProguardOutputFile) {
        this.mainDexListProguardOutputFile = mainDexListProguardOutputFile;
    }

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getDependenciesFileCollection() {
        return this.dependenciesFileCollection;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getSharedLibraryDependencies() {
        return this.sharedLibraryDependencies;
    }

    @Input
    public String getTypeAsString() {
        return this.type.name();
    }

    @Internal
    public VariantType getType() {
        return this.type;
    }

    public void setType(VariantType type) {
        this.type = type;
    }

    @Input
    public String getAaptGeneration() {
        return this.aaptGeneration.name();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getAapt2FromMaven() {
        return this.aapt2FromMaven;
    }

    @Input
    public boolean getDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Input
    public boolean getPseudoLocalesEnabled() {
        return this.pseudoLocalesEnabled;
    }

    public void setPseudoLocalesEnabled(boolean pseudoLocalesEnabled) {
        this.pseudoLocalesEnabled = pseudoLocalesEnabled;
    }

    @Nested
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public void setAaptOptions(AaptOptions aaptOptions) {
        this.aaptOptions = aaptOptions;
    }

    @Internal
    public File getMergeBlameLogFolder() {
        return this.mergeBlameLogFolder;
    }

    public void setMergeBlameLogFolder(File mergeBlameLogFolder) {
        this.mergeBlameLogFolder = mergeBlameLogFolder;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getFeatureResourcePackages() {
        return this.featureResourcePackages;
    }

    @Input
    public MultiOutputPolicy getMultiOutputPolicy() {
        return this.multiOutputPolicy;
    }

    @Input
    public String getOriginalApplicationId() {
        return this.originalApplicationId;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    FileCollection getSplitListInput() {
        return this.splitListInput;
    }

    @Input
    @Optional
    String getBuildTargetDensity() {
        return this.buildTargetDensity;
    }

    @OutputDirectory
    File getResPackageOutputFolder() {
        return this.resPackageOutputFolder;
    }

    @Input
    public boolean isAapt2Enabled() {
        return this.enableAapt2;
    }

    public void setEnableAapt2(boolean enableAapt2) {
        this.enableAapt2 = enableAapt2;
    }

    @Input
    boolean isLibrary() {
        return this.isLibrary;
    }

    @Input
    public boolean isNamespaced() {
        return this.isNamespaced;
    }

    public static final class NamespacedConfigAction
    implements TaskConfigAction<LinkApplicationAndroidResourcesTask> {
        protected final VariantScope variantScope;
        private final File resPackageOutputDir;
        private final File sourceOutputDir;
        private final boolean isLibrary;
        private final boolean generateLegacyMultidexMainDexProguardRules;
        private final String baseName;

        public NamespacedConfigAction(VariantScope scope, File sourceOutputDir, File resPackageOutputDir, boolean isLibrary, boolean generateLegacyMultidexMainDexProguardRules, String baseName) {
            this.variantScope = scope;
            this.resPackageOutputDir = resPackageOutputDir;
            this.sourceOutputDir = sourceOutputDir;
            this.isLibrary = isLibrary;
            this.generateLegacyMultidexMainDexProguardRules = generateLegacyMultidexMainDexProguardRules;
            this.baseName = baseName;
        }

        @Override
        public final String getName() {
            return this.variantScope.getTaskName("process", "Resources");
        }

        @Override
        public final Class<LinkApplicationAndroidResourcesTask> getType() {
            return LinkApplicationAndroidResourcesTask.class;
        }

        @Override
        public final void execute(LinkApplicationAndroidResourcesTask task) {
            BaseVariantData variantData = this.variantScope.getVariantData();
            ProjectOptions projectOptions = this.variantScope.getGlobalScope().getProjectOptions();
            GradleVariantConfiguration config2 = variantData.getVariantConfiguration();
            task.setAndroidBuilder(this.variantScope.getGlobalScope().getAndroidBuilder());
            task.setVariantName(config2.getFullName());
            task.resPackageOutputFolder = this.resPackageOutputDir;
            task.aaptGeneration = AaptGeneration.fromProjectOptions(projectOptions);
            task.aapt2FromMaven = Aapt2MavenUtils.getAapt2FromMaven(this.variantScope.getGlobalScope());
            task.setEnableAapt2(true);
            task.applicationId = config2.getApplicationId();
            task.setIncrementalFolder(this.variantScope.getIncrementalDir(this.getName()));
            if (variantData.getType().getCanHaveSplits()) {
                task.splitListInput = this.variantScope.getOutput(InternalArtifactType.SPLIT_LIST);
            }
            task.multiOutputPolicy = variantData.getMultiOutputPolicy();
            task.apkList = this.variantScope.getOutput(InternalArtifactType.APK_LIST);
            task.sourceOutputDir = this.sourceOutputDir;
            if (this.variantScope.getCodeShrinker() != null) {
                task.setProguardOutputFile(this.variantScope.getProcessAndroidResourcesProguardOutputFile());
            }
            if (this.generateLegacyMultidexMainDexProguardRules) {
                task.setAaptMainDexListProguardOutputFile(this.variantScope.getManifestKeepListProguardFile());
            }
            task.variantScope = this.variantScope;
            task.outputScope = variantData.getOutputScope();
            task.outputFactory = variantData.getOutputFactory();
            task.originalApplicationId = this.variantScope.getVariantConfiguration().getOriginalApplicationId();
            boolean aaptFriendlyManifestsFilePresent = this.variantScope.hasOutput(InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS);
            task.taskInputType = aaptFriendlyManifestsFilePresent ? InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS : (this.variantScope.getInstantRunBuildContext().isInInstantRunMode() ? InternalArtifactType.INSTANT_RUN_MERGED_MANIFESTS : InternalArtifactType.MERGED_MANIFESTS);
            task.setManifestFiles(this.variantScope.getOutput(task.taskInputType));
            ArrayList<FileCollection> dependencies = new ArrayList<FileCollection>(2);
            dependencies.add(this.variantScope.getOutput(InternalArtifactType.RES_STATIC_LIBRARY));
            dependencies.add(this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.RES_STATIC_LIBRARY));
            task.dependenciesFileCollection = (FileCollection)this.variantScope.getGlobalScope().getProject().files(new Object[]{dependencies});
            task.sharedLibraryDependencies = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.RES_SHARED_STATIC_LIBRARY);
            task.setType(config2.getType());
            task.setDebuggable(((CoreBuildType)config2.getBuildType()).isDebuggable());
            task.setAaptOptions(this.variantScope.getGlobalScope().getExtension().getAaptOptions());
            task.setPseudoLocalesEnabled(((CoreBuildType)config2.getBuildType()).isPseudoLocalesEnabled());
            task.buildTargetDensity = projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY);
            task.setMergeBlameLogFolder(this.variantScope.getResourceBlameLogDir());
            task.buildContext = this.variantScope.getInstantRunBuildContext();
            task.featureResourcePackages = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_RESOURCE_PKG);
            if (this.variantScope.getVariantData().getType() == VariantType.FEATURE && !this.variantScope.isBaseFeature()) {
                task.packageIdsFiles = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_IDS_DECLARATION);
            }
            task.projectBaseName = this.baseName;
            task.isLibrary = this.isLibrary;
            task.supportDirectory = new File(this.variantScope.getInstantRunSplitApkOutputFolder(), LinkApplicationAndroidResourcesTask.IR_APK_FILE_NAME);
            task.isNamespaced = true;
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<LinkApplicationAndroidResourcesTask> {
        protected final VariantScope variantScope;
        protected final Supplier<File> symbolLocation;
        private final File symbolsWithPackageNameOutputFile;
        private final File resPackageOutputFolder;
        private final boolean generateLegacyMultidexMainDexProguardRules;
        private final TaskManager.MergeType sourceArtifactType;
        private final String baseName;
        private final boolean isLibrary;

        public ConfigAction(VariantScope scope, Supplier<File> symbolLocation, File symbolsWithPackageNameOutputFile, File resPackageOutputFolder, boolean generateLegacyMultidexMainDexProguardRules, TaskManager.MergeType sourceArtifactType, String baseName, boolean isLibrary) {
            this.variantScope = scope;
            this.symbolLocation = symbolLocation;
            this.symbolsWithPackageNameOutputFile = symbolsWithPackageNameOutputFile;
            this.resPackageOutputFolder = resPackageOutputFolder;
            this.generateLegacyMultidexMainDexProguardRules = generateLegacyMultidexMainDexProguardRules;
            this.baseName = baseName;
            this.sourceArtifactType = sourceArtifactType;
            this.isLibrary = isLibrary;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("process", "Resources");
        }

        @Override
        public Class<LinkApplicationAndroidResourcesTask> getType() {
            return LinkApplicationAndroidResourcesTask.class;
        }

        @Override
        public void execute(LinkApplicationAndroidResourcesTask processResources) {
            BaseVariantData variantData = this.variantScope.getVariantData();
            ProjectOptions projectOptions = this.variantScope.getGlobalScope().getProjectOptions();
            variantData.addTask(TaskContainer.TaskKind.PROCESS_ANDROID_RESOURCES, (Task)processResources);
            GradleVariantConfiguration config2 = variantData.getVariantConfiguration();
            processResources.setAndroidBuilder(this.variantScope.getGlobalScope().getAndroidBuilder());
            processResources.setVariantName(config2.getFullName());
            processResources.resPackageOutputFolder = this.resPackageOutputFolder;
            processResources.aaptGeneration = AaptGeneration.fromProjectOptions(projectOptions);
            processResources.aapt2FromMaven = Aapt2MavenUtils.getAapt2FromMavenIfEnabled(this.variantScope.getGlobalScope());
            if (variantData.getType() == VariantType.LIBRARY) {
                throw new IllegalArgumentException("Use GenerateLibraryRFileTask");
            }
            Preconditions.checkState((this.sourceArtifactType == TaskManager.MergeType.MERGE ? 1 : 0) != 0, (String)"source output type should be MERGE", (Object)((Object)this.sourceArtifactType));
            processResources.setEnableAapt2(projectOptions.get(BooleanOption.ENABLE_AAPT2));
            processResources.applicationId = config2.getApplicationId();
            processResources.setIncrementalFolder(this.variantScope.getIncrementalDir(this.getName()));
            if (variantData.getType().getCanHaveSplits()) {
                processResources.splitListInput = this.variantScope.getOutput(InternalArtifactType.SPLIT_LIST);
            }
            processResources.apkList = this.variantScope.getOutput(InternalArtifactType.APK_LIST);
            processResources.multiOutputPolicy = variantData.getMultiOutputPolicy();
            processResources.dependenciesFileCollection = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.SYMBOL_LIST_WITH_PACKAGE_NAME);
            File sourceOut = this.variantScope.getRClassSourceOutputDir();
            processResources.setSourceOutputDir(sourceOut);
            this.variantScope.addTaskOutput(InternalArtifactType.NOT_NAMESPACED_R_CLASS_SOURCES, sourceOut, this.getName());
            processResources.textSymbolOutputDir = this.symbolLocation;
            processResources.symbolsWithPackageNameOutputFile = this.symbolsWithPackageNameOutputFile;
            if (this.variantScope.getCodeShrinker() != null) {
                processResources.setProguardOutputFile(this.variantScope.getProcessAndroidResourcesProguardOutputFile());
            }
            if (this.generateLegacyMultidexMainDexProguardRules) {
                processResources.setAaptMainDexListProguardOutputFile(this.variantScope.getManifestKeepListProguardFile());
            }
            processResources.variantScope = this.variantScope;
            processResources.outputScope = variantData.getOutputScope();
            processResources.outputFactory = variantData.getOutputFactory();
            processResources.originalApplicationId = this.variantScope.getVariantConfiguration().getOriginalApplicationId();
            boolean aaptFriendlyManifestsFilePresent = this.variantScope.hasOutput(InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS);
            processResources.taskInputType = aaptFriendlyManifestsFilePresent ? InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS : (this.variantScope.getInstantRunBuildContext().isInInstantRunMode() ? InternalArtifactType.INSTANT_RUN_MERGED_MANIFESTS : InternalArtifactType.MERGED_MANIFESTS);
            processResources.setManifestFiles(this.variantScope.getOutput(processResources.taskInputType));
            processResources.inputResourcesDir = this.variantScope.getOutput(this.sourceArtifactType.getOutputType());
            processResources.setType(config2.getType());
            processResources.setDebuggable(((CoreBuildType)config2.getBuildType()).isDebuggable());
            processResources.setAaptOptions(this.variantScope.getGlobalScope().getExtension().getAaptOptions());
            processResources.setPseudoLocalesEnabled(((CoreBuildType)config2.getBuildType()).isPseudoLocalesEnabled());
            processResources.buildTargetDensity = projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY);
            processResources.setMergeBlameLogFolder(this.variantScope.getResourceBlameLogDir());
            processResources.buildContext = this.variantScope.getInstantRunBuildContext();
            processResources.featureResourcePackages = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_RESOURCE_PKG);
            processResources.projectBaseName = this.baseName;
            processResources.isLibrary = this.isLibrary;
            processResources.supportDirectory = new File(this.variantScope.getInstantRunSplitApkOutputFolder(), LinkApplicationAndroidResourcesTask.IR_APK_FILE_NAME);
            if (!this.variantScope.isBaseFeature()) {
                processResources.packageIdsFiles = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_IDS_DECLARATION);
            }
        }
    }
}

