/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.namespaced;

import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.ResourceType;
import com.android.tools.build.apkzlib.zip.CentralDirectoryHeader;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.StoredEntryType;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespaceRewriter;", "", "symbolTables", "Lcom/google/common/collect/ImmutableList;", "Lcom/android/ide/common/symbols/SymbolTable;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lcom/google/common/collect/ImmutableList;Lorg/gradle/api/logging/Logger;)V", "rewriteClass", "", "clazz", "Ljava/nio/file/Path;", "output", "", "originalClass", "rewriteJar", "classesJar", "Ljava/io/File;", "outputJar", "ClassReWriter", "MethodReWriter", "gradle-core"})
public final class NamespaceRewriter {
    private final ImmutableList<SymbolTable> symbolTables;
    private final Logger logger;

    public final void rewriteClass(@NotNull Path clazz, @NotNull Path output) {
        Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        byte[] originalClass = Files.readAllBytes(clazz);
        Intrinsics.checkExpressionValueIsNotNull((Object)originalClass, (String)"originalClass");
        byte[] rewrittenClass = this.rewriteClass(originalClass);
        Files.write(output, rewrittenClass, new OpenOption[0]);
    }

    @NotNull
    public final byte[] rewriteClass(@NotNull byte[] originalClass) {
        Intrinsics.checkParameterIsNotNull((Object)originalClass, (String)"originalClass");
        ClassWriter cw = new ClassWriter(0);
        ClassReWriter crw = new ClassReWriter(327680, (ClassVisitor)cw, this.symbolTables, this.logger);
        ClassReader cr = new ClassReader(originalClass);
        cr.accept((ClassVisitor)crw, 0);
        crw.writeInnerRClasses();
        byte[] byArray = cw.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cw.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rewriteJar(@NotNull File classesJar, @NotNull File outputJar) {
        Intrinsics.checkParameterIsNotNull((Object)classesJar, (String)"classesJar");
        Intrinsics.checkParameterIsNotNull((Object)outputJar, (String)"outputJar");
        Closeable closeable = (Closeable)new ZFile(classesJar);
        Throwable throwable = null;
        try {
            ZFile classes = (ZFile)closeable;
            Closeable closeable2 = (Closeable)new ZFile(outputJar);
            Throwable throwable2 = null;
            try {
                ZFile output = (ZFile)closeable2;
                Set set = classes.entries();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"classes.entries()");
                Iterable $receiver$iv = set;
                for (Object element$iv : $receiver$iv) {
                    StoredEntry entry;
                    StoredEntry storedEntry = entry = (StoredEntry)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)storedEntry, (String)"entry");
                    if (!Intrinsics.areEqual((Object)storedEntry.getType(), (Object)StoredEntryType.FILE)) continue;
                    byte[] byArray = entry.read();
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"entry.read()");
                    byte[] outputBytes = this.rewriteClass(byArray);
                    CentralDirectoryHeader centralDirectoryHeader = entry.getCentralDirectoryHeader();
                    Intrinsics.checkExpressionValueIsNotNull((Object)centralDirectoryHeader, (String)"entry.centralDirectoryHeader");
                    byte[] byArray2 = outputBytes;
                    String string = centralDirectoryHeader.getName();
                    ZFile zFile = output;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                    zFile.add(string, (InputStream)byteArrayInputStream);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public NamespaceRewriter(@NotNull ImmutableList<SymbolTable> symbolTables, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull(symbolTables, (String)"symbolTables");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.symbolTables = symbolTables;
        this.logger = logger;
    }

    public /* synthetic */ NamespaceRewriter(ImmutableList immutableList, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Logger logger2 = Logging.getLogger(NamespaceRewriter.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logging.getLogger(NamespaceRewriter::class.java)");
            logger = logger2;
        }
        this((ImmutableList<SymbolTable>)immutableList, logger);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rJ.\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016JE\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0010\u0010\u001c\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020\u000fR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespaceRewriter$ClassReWriter;", "Lorg/objectweb/asm/ClassVisitor;", "api", "", "cv", "symbolTables", "Lcom/google/common/collect/ImmutableList;", "Lcom/android/ide/common/symbols/SymbolTable;", "logger", "Lorg/gradle/api/logging/Logger;", "(ILorg/objectweb/asm/ClassVisitor;Lcom/google/common/collect/ImmutableList;Lorg/gradle/api/logging/Logger;)V", "innerClasses", "Ljava/util/HashSet;", "", "addInnerClass", "", "innerClass", "findPackage", "type", "name", "visitInnerClass", "outerName", "innerName", "access", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "desc", "signature", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "writeInnerRClasses", "gradle-core"})
    private static final class ClassReWriter
    extends ClassVisitor {
        private final HashSet<String> innerClasses;
        private final ImmutableList<SymbolTable> symbolTables;
        private final Logger logger;

        public void visitInnerClass(@Nullable String name, @Nullable String outerName, @Nullable String innerName, int access) {
            String string = outerName;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (!StringsKt.endsWith$default((String)string, (String)"/R", (boolean)false, (int)2, null)) {
                this.cv.visitInnerClass(name, outerName, innerName, access);
            }
        }

        @NotNull
        public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String desc, @Nullable String signature, @Nullable String[] exceptions) {
            return new MethodReWriter(this.api, this.cv.visitMethod(access, name, desc, signature, exceptions), this);
        }

        public final void writeInnerRClasses() {
            Iterator<String> iterator = this.innerClasses.iterator();
            while (iterator.hasNext()) {
                String string;
                String innerClass;
                String string2 = innerClass = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"innerClass");
                String string3 = string2;
                int n = 0;
                int n2 = StringsKt.lastIndexOf$default((CharSequence)innerClass, (char)'$', (int)0, (boolean)false, (int)6, null);
                String string4 = innerClass;
                ClassVisitor classVisitor = this.cv;
                String string5 = string3;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string7 = string6;
                string3 = innerClass;
                n = StringsKt.lastIndexOf$default((CharSequence)innerClass, (char)'$', (int)0, (boolean)false, (int)6, null) + 1;
                n2 = innerClass.length();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                classVisitor.visitInnerClass(string4, string7, string, 9);
            }
        }

        @NotNull
        public final String findPackage(@NotNull String type, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            ArrayList<String> packages = null;
            String result = null;
            for (SymbolTable table : this.symbolTables) {
                if (!table.getSymbols().contains((Object)ResourceType.getEnum((String)type), (Object)name)) continue;
                if (result == null) {
                    result = table.getTablePackage();
                    continue;
                }
                if (packages == null) {
                    packages = new ArrayList<String>();
                }
                packages.add(table.getTablePackage());
            }
            if (result == null) {
                String string = "In package " + ((SymbolTable)this.symbolTables.get(0)).getTablePackage() + " found unknown symbol of type " + "" + type + " and name " + name + '.';
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (packages != null && !packages.isEmpty()) {
                this.logger.warn("In package " + ((SymbolTable)this.symbolTables.get(0)).getTablePackage() + " multiple options found " + "in its dependencies for resource " + type + ' ' + name + ". " + "Using " + result + ", other available: " + Joiner.on((String)", ").join((Iterable)packages));
            }
            return result;
        }

        public final void addInnerClass(@NotNull String innerClass) {
            Intrinsics.checkParameterIsNotNull((Object)innerClass, (String)"innerClass");
            this.innerClasses.add(innerClass);
        }

        public ClassReWriter(int api, @Nullable ClassVisitor cv, @NotNull ImmutableList<SymbolTable> symbolTables, @NotNull Logger logger) {
            Intrinsics.checkParameterIsNotNull(symbolTables, (String)"symbolTables");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            super(api, cv);
            this.symbolTables = symbolTables;
            this.logger = logger;
            this.innerClasses = new HashSet();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespaceRewriter$MethodReWriter;", "Lorg/objectweb/asm/MethodVisitor;", "api", "", "mv", "crw", "Lcom/android/build/gradle/internal/res/namespaced/NamespaceRewriter$ClassReWriter;", "(ILorg/objectweb/asm/MethodVisitor;Lcom/android/build/gradle/internal/res/namespaced/NamespaceRewriter$ClassReWriter;)V", "visitFieldInsn", "", "opcode", "owner", "", "name", "desc", "gradle-core"})
    private static final class MethodReWriter
    extends MethodVisitor {
        private final ClassReWriter crw;

        public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @Nullable String desc) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            if (StringsKt.contains$default((CharSequence)owner, (CharSequence)"/R$", (boolean)false, (int)2, null)) {
                String string = owner;
                int n = StringsKt.lastIndexOf$default((CharSequence)owner, (char)'$', (int)0, (boolean)false, (int)6, null) + 1;
                int n2 = owner.length();
                String string2 = string.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String type = string2;
                String newPkg = StringsKt.replace$default((String)this.crw.findPackage(type, name), (char)'.', (char)'/', (boolean)false, (int)4, null);
                String newOwner = "" + newPkg + "/R$" + type;
                this.crw.addInnerClass(newOwner);
                this.mv.visitFieldInsn(opcode, newOwner, name, desc);
            } else {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        public MethodReWriter(int api, @Nullable MethodVisitor mv, @NotNull ClassReWriter crw) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)crw), (String)"crw");
            super(api, mv);
            this.crw = crw;
        }
    }
}

