/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.api.sourcesets.FilesProvider;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskOutputAlreadyRegisteredException;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.TaskOutputHolderImpl;
import com.android.build.gradle.internal.scope.TransformGlobalScope;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.OptionalCompilationStep;
import com.android.builder.utils.FileCache;
import com.android.ide.common.blame.MessageReceiver;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class GlobalScope
extends TaskOutputHolderImpl
implements TransformGlobalScope,
TaskOutputHolder {
    private final Project project;
    private final FilesProvider filesProvider;
    private final AndroidBuilder androidBuilder;
    private final AndroidConfig extension;
    private final SdkHandler sdkHandler;
    private final NdkHandler ndkHandler;
    private final ToolingModelBuilderRegistry toolingRegistry;
    private final Set<OptionalCompilationStep> optionalCompilationSteps;
    private final ProjectOptions projectOptions;
    private final FileCache buildCache;
    private final DslScope dslScope;
    private Configuration lintChecks;
    private File mockableAndroidJarFile;
    private ConfigurableFileCollection java8LangSupportJar = null;

    public GlobalScope(Project project, FilesProvider filesProvider, ProjectOptions projectOptions, DslScope dslScope, AndroidBuilder androidBuilder, AndroidConfig extension, SdkHandler sdkHandler, NdkHandler ndkHandler, ToolingModelBuilderRegistry toolingRegistry, FileCache buildCache) {
        this.project = (Project)Preconditions.checkNotNull((Object)project);
        this.dslScope = (DslScope)Preconditions.checkNotNull((Object)dslScope);
        this.filesProvider = filesProvider;
        this.androidBuilder = (AndroidBuilder)Preconditions.checkNotNull((Object)androidBuilder);
        this.extension = (AndroidConfig)Preconditions.checkNotNull((Object)extension);
        this.sdkHandler = (SdkHandler)Preconditions.checkNotNull((Object)sdkHandler);
        this.ndkHandler = (NdkHandler)Preconditions.checkNotNull((Object)ndkHandler);
        this.toolingRegistry = (ToolingModelBuilderRegistry)Preconditions.checkNotNull((Object)toolingRegistry);
        this.optionalCompilationSteps = (Set)Preconditions.checkNotNull(projectOptions.getOptionalCompilationSteps());
        this.projectOptions = (ProjectOptions)Preconditions.checkNotNull((Object)projectOptions);
        this.buildCache = buildCache;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public FilesProvider getFilesProvider() {
        return this.filesProvider;
    }

    public AndroidConfig getExtension() {
        return this.extension;
    }

    public AndroidBuilder getAndroidBuilder() {
        return this.androidBuilder;
    }

    public String getProjectBaseName() {
        return (String)this.project.property("archivesBaseName");
    }

    public SdkHandler getSdkHandler() {
        return this.sdkHandler;
    }

    public NdkHandler getNdkHandler() {
        return this.ndkHandler;
    }

    public ToolingModelBuilderRegistry getToolingRegistry() {
        return this.toolingRegistry;
    }

    @Override
    public File getBuildDir() {
        return this.project.getBuildDir();
    }

    public File getIntermediatesDir() {
        return new File(this.getBuildDir(), "intermediates");
    }

    public File getGeneratedDir() {
        return new File(this.getBuildDir(), "generated");
    }

    public File getReportsDir() {
        return new File(this.getBuildDir(), "reports");
    }

    public File getTestResultsFolder() {
        return new File(this.getBuildDir(), "test-results");
    }

    public File getTestReportFolder() {
        return new File(this.getBuildDir(), "reports/tests");
    }

    public File getTmpFolder() {
        return new File(this.getIntermediatesDir(), "tmp");
    }

    public File getMockableAndroidJarFile() {
        if (this.mockableAndroidJarFile == null) {
            CharMatcher safeCharacters = CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.anyOf((CharSequence)"-."));
            String sdkName = safeCharacters.negate().replaceFrom((CharSequence)this.getExtension().getCompileSdkVersion(), '-');
            StringBuilder suffix = new StringBuilder();
            if (this.getExtension().getTestOptions().getUnitTests().isReturnDefaultValues()) {
                suffix.append(".default-values");
            }
            suffix.append(".v3");
            suffix.append(".jar");
            File outDir = new File(this.getProject().getBuildDir(), "generated");
            this.mockableAndroidJarFile = new File(outDir, "mockable-" + sdkName + suffix);
        }
        return this.mockableAndroidJarFile;
    }

    public File getOutputsDir() {
        return new File(this.getBuildDir(), "outputs");
    }

    @Override
    public boolean isActive(OptionalCompilationStep step) {
        return this.optionalCompilationSteps.contains(step);
    }

    public String getArchivesBaseName() {
        return (String)this.getProject().getProperties().get("archivesBaseName");
    }

    public File getJacocoAgentOutputDirectory() {
        return new File(this.getIntermediatesDir(), "jacoco");
    }

    public File getJacocoAgent() {
        return new File(this.getJacocoAgentOutputDirectory(), "jacocoagent.jar");
    }

    @Override
    public ProjectOptions getProjectOptions() {
        return this.projectOptions;
    }

    @Override
    public FileCache getBuildCache() {
        return this.buildCache;
    }

    public void setLintChecks(Configuration lintChecks) {
        this.lintChecks = lintChecks;
    }

    public SyncIssueHandler getErrorHandler() {
        return (SyncIssueHandler)this.androidBuilder.getIssueReporter();
    }

    public DslScope getDslScope() {
        return this.dslScope;
    }

    public MessageReceiver getMessageReceiver() {
        return this.androidBuilder.getMessageReceiver();
    }

    public boolean isInExectionPhase() {
        return this.project.getState().getExecuted();
    }

    public FileCollection getLocalCustomLintChecks() {
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
        return this.lintChecks.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    @Override
    public ConfigurableFileCollection addTaskOutput(ArtifactType outputType, Object file, String taskName) throws TaskOutputAlreadyRegisteredException {
        try {
            return super.addTaskOutput(outputType, file, taskName);
        }
        catch (TaskOutputAlreadyRegisteredException e) {
            throw new RuntimeException(String.format("OutputType '%s' already registered in global scope", e.getOutputType()), e);
        }
    }
}

