/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.ApplicationId;
import com.android.builder.core.VariantType;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class ApplicationIdWriterTask
extends AndroidVariantTask {
    private String applicationId;
    private FileCollection packageManifest;
    private File outputDirectory;

    @Input
    public String getApplicationId() {
        return this.applicationId;
    }

    @InputFiles
    @Optional
    public FileCollection getPackageManifest() {
        return this.packageManifest;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    public void fullTaskAction() throws IOException {
        String packageId = this.packageManifest != null && !this.packageManifest.isEmpty() ? ApplicationId.load(this.packageManifest.getSingleFile()).getApplicationId() : this.applicationId;
        ApplicationId declaration = new ApplicationId(packageId);
        declaration.save(this.outputDirectory);
    }

    public static class ConfigAction
    implements TaskConfigAction<ApplicationIdWriterTask> {
        protected final VariantScope variantScope;

        public ConfigAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("write", "ApplicationId");
        }

        @Override
        public Class<ApplicationIdWriterTask> getType() {
            return ApplicationIdWriterTask.class;
        }

        @Override
        public void execute(ApplicationIdWriterTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.applicationId = this.variantScope.getVariantConfiguration().getApplicationId();
            task.outputDirectory = FileUtils.join((File)this.variantScope.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"applicationId", this.variantScope.getVariantConfiguration().getDirName()});
            this.variantScope.addTaskOutput(InternalArtifactType.FEATURE_APPLICATION_ID_DECLARATION, ApplicationId.getOutputFile(task.outputDirectory), this.getName());
            if (this.variantScope.getVariantConfiguration().getType() == VariantType.FEATURE) {
                task.packageManifest = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.METADATA_APP_ID_DECLARATION);
            } else {
                this.variantScope.addTaskOutput(InternalArtifactType.METADATA_APP_ID_DECLARATION, ApplicationId.getOutputFile(task.outputDirectory), this.getName());
            }
        }
    }
}

