/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.builder.errors.EvalIssueReporter;
import java.io.File;
import java.util.HashMap;
import org.gradle.api.Project;

public class MergeConsumerProguardFilesConfigAction
implements TaskConfigAction<MergeFileTask> {
    private final Project project;
    private final VariantScope variantScope;
    private final File outputFile;

    public MergeConsumerProguardFilesConfigAction(Project project, VariantScope variantScope, File outputFile) {
        this.project = project;
        this.variantScope = variantScope;
        this.outputFile = outputFile;
    }

    @Override
    public String getName() {
        return this.variantScope.getTaskName("merge", "ConsumerProguardFiles");
    }

    @Override
    public Class<MergeFileTask> getType() {
        return MergeFileTask.class;
    }

    @Override
    public void execute(MergeFileTask mergeProguardFiles) {
        mergeProguardFiles.setVariantName(this.variantScope.getVariantConfiguration().getFullName());
        mergeProguardFiles.setOutputFile(this.outputFile);
        mergeProguardFiles.setInputFiles(this.project.files(new Object[]{this.variantScope.getConsumerProguardFiles()}).getFiles());
        HashMap<File, String> defaultFiles = new HashMap<File, String>();
        for (String knownFileName : ProguardFiles.KNOWN_FILE_NAMES) {
            defaultFiles.put(ProguardFiles.getDefaultProguardFile(knownFileName, this.project), knownFileName);
        }
        SyncIssueHandler issueReporter = this.variantScope.getGlobalScope().getErrorHandler();
        for (File consumerFile : mergeProguardFiles.getInputFiles()) {
            if (!defaultFiles.containsKey(consumerFile)) continue;
            issueReporter.reportError(EvalIssueReporter.Type.GENERIC, String.format("Default file %s should not be used as a consumer configuration file.", defaultFiles.get(consumerFile)));
        }
    }
}

