/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.model.SigningConfig;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;

public class SigningReportTask
extends DefaultTask {
    private Set<VariantScope> variants = Sets.newHashSet();

    @TaskAction
    public void generate() throws IOException {
        StyledTextOutput textOutput = ((StyledTextOutputFactory)this.getServices().get(StyledTextOutputFactory.class)).create(((Object)((Object)this)).getClass());
        HashMap cache = Maps.newHashMap();
        for (VariantScope variant : this.variants) {
            textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Variant: ");
            textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)variant.getFullVariantName());
            textOutput.println();
            CoreSigningConfig signingConfig = variant.getVariantConfiguration().getSigningConfig();
            if (signingConfig == null) {
                textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Config: ");
                textOutput.withStyle(StyledTextOutput.Style.Normal).text((Object)"none");
                textOutput.println();
            } else {
                SigningInfo signingInfo = SigningReportTask.getSigningInfo(signingConfig, cache);
                textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Config: ");
                textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)signingConfig.getName());
                textOutput.println();
                textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Store: ");
                textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)signingConfig.getStoreFile());
                textOutput.println();
                textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Alias: ");
                textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)signingConfig.getKeyAlias());
                textOutput.println();
                if (signingInfo.isValid()) {
                    if (signingInfo.error != null) {
                        textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Error: ");
                        textOutput.withStyle(StyledTextOutput.Style.Failure).text((Object)signingInfo.error);
                        textOutput.println();
                    } else {
                        textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"MD5: ");
                        textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)signingInfo.md5);
                        textOutput.println();
                        textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"SHA1: ");
                        textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)signingInfo.sha1);
                        textOutput.println();
                        textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Valid until: ");
                        DateFormat df = DateFormat.getDateInstance(0);
                        textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)df.format(signingInfo.notAfter));
                        textOutput.println();
                    }
                }
            }
            textOutput.withStyle(StyledTextOutput.Style.Normal).text((Object)"----------");
            textOutput.println();
        }
    }

    public void setVariants(Collection<VariantScope> variants) {
        this.variants.addAll(variants);
    }

    private static SigningInfo getSigningInfo(SigningConfig signingConfig, Map<SigningConfig, SigningInfo> cache) {
        SigningInfo signingInfo = cache.get(signingConfig);
        if (signingInfo == null) {
            signingInfo = new SigningInfo();
            if (signingConfig.isSigningReady()) {
                try {
                    CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)signingConfig.getStoreFile(), (String)signingConfig.getStorePassword(), (String)signingConfig.getKeyPassword(), (String)signingConfig.getKeyAlias());
                    signingInfo.md5 = SigningReportTask.getFingerprint(certificateInfo.getCertificate(), "MD5");
                    signingInfo.sha1 = SigningReportTask.getFingerprint(certificateInfo.getCertificate(), "SHA1");
                    signingInfo.notAfter = certificateInfo.getCertificate().getNotAfter();
                }
                catch (KeytoolException e) {
                    signingInfo.error = e.getMessage();
                }
                catch (FileNotFoundException e) {
                    signingInfo.error = "Missing keystore";
                }
            }
            cache.put(signingConfig, signingInfo);
        }
        return signingInfo;
    }

    public static String getFingerprint(Certificate cert, String hashAlgorithm) {
        if (cert == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(hashAlgorithm);
            return SigningReportTask.toHexadecimalString(digest.digest(cert.getEncoded()));
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            return null;
        }
    }

    private static String toHexadecimalString(byte[] value) {
        StringBuilder sb = new StringBuilder();
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            int num = value[i] & 0xFF;
            if (num < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(num));
            if (i >= len - 1) continue;
            sb.append(':');
        }
        return sb.toString().toUpperCase(Locale.US);
    }

    private static final class SigningInfo {
        String md5;
        String sha1;
        Date notAfter;
        String error;

        private SigningInfo() {
        }

        boolean isValid() {
            return this.md5 != null || this.error != null;
        }
    }
}

