/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.android.utils.StringHelper;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.regex.Pattern;

public class FeatureVariantData
extends ApkVariantData
implements TestedVariantData {
    private static final Pattern FEATURE_REPLACEMENT = Pattern.compile("-");
    private static final Pattern FEATURE_EXCLUSION = Pattern.compile("[^a-zA-Z0-9_]");
    private final Map<VariantType, TestVariantData> testVariants = Maps.newEnumMap(VariantType.class);
    private final String featureName;

    public FeatureVariantData(GlobalScope globalScope, AndroidConfig androidConfig, TaskManager taskManager, GradleVariantConfiguration config2, Recorder recorder) {
        super(globalScope, androidConfig, taskManager, config2, recorder);
        String splitName = FEATURE_REPLACEMENT.matcher(this.getScope().getGlobalScope().getProjectBaseName()).replaceAll("_");
        this.featureName = FEATURE_EXCLUSION.matcher(splitName).replaceAll("");
        this.getOutputFactory().addMainApk();
    }

    @Override
    public String getDescription() {
        VariantConfiguration config2 = this.getVariantConfiguration();
        if (config2.hasFlavors()) {
            StringBuilder sb = new StringBuilder(50);
            StringHelper.appendCapitalized((StringBuilder)sb, (String)((CoreBuildType)config2.getBuildType()).getName());
            sb.append(" feature split build for flavor ");
            StringHelper.appendCapitalized((StringBuilder)sb, (String)config2.getFlavorName());
            return sb.toString();
        }
        return StringHelper.capitalizeWithSuffix((String)((CoreBuildType)config2.getBuildType()).getName(), (String)" feature split build");
    }

    @Override
    public TestVariantData getTestVariantData(VariantType type) {
        return this.testVariants.get(type);
    }

    @Override
    public void setTestVariantData(TestVariantData testVariantData, VariantType type) {
        this.testVariants.put(type, testVariantData);
    }

    public String getFeatureName() {
        return this.featureName;
    }
}

