/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.incremental.ByteCodeUtils;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.Pair;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import org.jf.dexlib2.dexbacked.DexBackedAnnotationElement;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedField;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction11n;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21c;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21ih;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21s;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction31c;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction31i;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction35c;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction3rc;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ResourceUsageAnalyzer {
    private static final String ANDROID_RES = "android_res/";
    public static final boolean REPLACE_DELETED_WITH_EMPTY = true;
    public static final boolean TWO_PASS_AAPT = false;
    static final String NO_MATCH = "-nomatch-";
    private final File mResourceClassDir;
    private final File mProguardMapping;
    private final Iterable<File> mClasses;
    private final File mMergedManifest;
    private final File mMergedResourceDir;
    private final File mReportFile;
    private final StringWriter mDebugOutput;
    private final PrintWriter mDebugPrinter;
    private boolean mVerbose;
    private boolean mDebug;
    private boolean mDryRun;
    private List<ResourceUsageModel.Resource> mUnused;
    private Map<String, Pair<ResourceType, Map<String, String>>> mResourceObfuscation = Maps.newHashMapWithExpectedSize((int)30);
    private String mSuggestionsAdapter;
    private String mResourcesWrapper;
    public static final byte[] TINY_PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 1, 0, 0, 0, 1, 8, 0, 0, 0, 0, 58, 126, -101, 85, 0, 0, 0, 10, 73, 68, 65, 84, 120, -38, 99, 96, 0, 0, 0, 2, 0, 1, -27, 39, -34, -4, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    public static final long TINY_PNG_CRC = 2293408688L;
    public static final byte[] TINY_9PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 3, 0, 0, 0, 3, 8, 6, 0, 0, 0, 86, 40, -75, -65, 0, 0, 0, 20, 73, 68, 65, 84, 120, -38, 99, 96, -128, -128, -1, 12, 48, 6, 8, -96, 8, -128, 8, 0, -107, -111, 7, -7, -64, -82, 8, 0, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    public static final long TINY_9PNG_CRC = 289995143L;
    public static final byte[] TINY_XML = new byte[]{3, 0, 8, 0, 104, 0, 0, 0, 1, 0, 28, 0, 36, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 120, 0, 2, 1, 16, 0, 36, 0, 0, 0, 1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 20, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 16, 0, 24, 0, 0, 0, 1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0};
    public static final long TINY_XML_CRC = 3622196803L;
    public static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private Set<String> mStrings;
    private boolean mFoundGetIdentifier;
    private boolean mFoundWebContent;
    private final ResourceShrinkerUsageModel mModel = new ResourceShrinkerUsageModel();

    public ResourceUsageAnalyzer(File rDir, Iterable<File> classes, File manifest, File mapping, File resources, File reportFile) {
        this.mResourceClassDir = rDir;
        this.mProguardMapping = mapping;
        this.mClasses = classes;
        this.mMergedManifest = manifest;
        this.mMergedResourceDir = resources;
        this.mReportFile = reportFile;
        if (reportFile != null || this.mDebug) {
            this.mDebugOutput = new StringWriter(8192);
            this.mDebugPrinter = new PrintWriter(this.mDebugOutput);
        } else {
            this.mDebugOutput = null;
            this.mDebugPrinter = null;
        }
    }

    public void dispose() {
        if (this.mDebugOutput != null) {
            File dir;
            String output = this.mDebugOutput.toString();
            if (this.mDebug) {
                System.out.println(output);
            }
            if (this.mReportFile != null && (dir = this.mReportFile.getParentFile()) != null && (dir.exists() || dir.mkdir()) && dir.canWrite()) {
                try {
                    Files.write((CharSequence)output, (File)this.mReportFile, (Charset)Charsets.UTF_8);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void analyze() throws IOException, ParserConfigurationException, SAXException {
        this.gatherResourceValues(this.mResourceClassDir);
        this.recordMapping(this.mProguardMapping);
        for (File jarOrDir : this.mClasses) {
            this.recordClassUsages(jarOrDir);
        }
        this.recordManifestUsages(this.mMergedManifest);
        this.recordResources(this.mMergedResourceDir);
        this.keepPossiblyReferencedResources();
        this.dumpReferences();
        this.mModel.processToolsAttributes();
        this.mUnused = this.mModel.findUnused();
    }

    public boolean isDryRun() {
        return this.mDryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.mDryRun = dryRun;
    }

    public boolean isVerbose() {
        return this.mVerbose;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public boolean isDebug() {
        return this.mDebug;
    }

    public void setDebug(boolean verbose) {
        this.mDebug = verbose;
    }

    public void rewriteResourceZip(File source, File dest) throws IOException {
        boolean deleted;
        if (dest.exists() && !(deleted = dest.delete())) {
            throw new IOException("Could not delete " + dest);
        }
        try (JarInputStream zis = new JarInputStream(new BufferedInputStream(new FileInputStream(source)));
             JarOutputStream zos = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));){
            zos.setLevel(9);
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                boolean directory = entry.isDirectory();
                ResourceUsageModel.Resource resource = this.getResourceByJarPath(name);
                if (resource == null || resource.isReachable()) {
                    ResourceUsageAnalyzer.copyToOutput(zis, zos, entry, name, directory);
                } else if (!directory && !name.equals("res/raw/keep.xml")) {
                    this.replaceWithDummyEntry(zos, entry, name);
                } else if (this.isVerbose() || this.mDebugPrinter != null) {
                    String message = "Skipped unused resource " + name + ": " + entry.getSize() + " bytes";
                    if (this.isVerbose()) {
                        System.out.println(message);
                    }
                    if (this.mDebugPrinter != null) {
                        this.mDebugPrinter.println(message);
                    }
                }
                entry = zis.getNextEntry();
            }
            zos.flush();
        }
        long before = source.length();
        long after = dest.length();
        if (after > before) {
            String message = "Resource shrinking did not work (grew from " + before + " to " + after + "); using original instead";
            if (this.isVerbose()) {
                System.out.println(message);
            }
            if (this.mDebugPrinter != null) {
                this.mDebugPrinter.println(message);
            }
            Files.copy((File)source, (File)dest);
        }
    }

    private void replaceWithDummyEntry(JarOutputStream zos, ZipEntry entry, String name) throws IOException {
        long crc;
        byte[] bytes;
        if (name.endsWith(".9.png")) {
            bytes = TINY_9PNG;
            crc = 289995143L;
        } else if (name.endsWith(".png")) {
            bytes = TINY_PNG;
            crc = 2293408688L;
        } else if (name.endsWith(".xml")) {
            bytes = TINY_XML;
            crc = 3622196803L;
        } else {
            bytes = new byte[]{};
            crc = 0L;
        }
        JarEntry outEntry = new JarEntry(name);
        if (entry.getTime() != -1L) {
            outEntry.setTime(entry.getTime());
        }
        if (entry.getMethod() == 0) {
            outEntry.setMethod(0);
            outEntry.setSize(bytes.length);
            outEntry.setCrc(crc);
        }
        zos.putNextEntry(outEntry);
        zos.write(bytes);
        zos.closeEntry();
        if (this.isVerbose() || this.mDebugPrinter != null) {
            String message = "Skipped unused resource " + name + ": " + entry.getSize() + " bytes (replaced with small dummy file of size " + bytes.length + " bytes)";
            if (this.isVerbose()) {
                System.out.println(message);
            }
            if (this.mDebugPrinter != null) {
                this.mDebugPrinter.println(message);
            }
        }
    }

    private static void copyToOutput(JarInputStream zis, JarOutputStream zos, ZipEntry entry, String name, boolean directory) throws IOException {
        byte[] bytes;
        JarEntry outEntry;
        if (entry.getMethod() == 0) {
            outEntry = new JarEntry(entry);
        } else {
            outEntry = new JarEntry(name);
            if (entry.getTime() != -1L) {
                outEntry.setTime(entry.getTime());
            }
        }
        zos.putNextEntry(outEntry);
        if (!directory && (bytes = ByteStreams.toByteArray((InputStream)zis)) != null) {
            zos.write(bytes);
        }
        zos.closeEntry();
    }

    public void emitWhitelist(Path destination) throws IOException {
        File destinationFile = destination.toFile();
        if (!destinationFile.exists()) {
            destinationFile.getParentFile().mkdirs();
            boolean success = destinationFile.createNewFile();
            if (!success) {
                throw new IOException("Could not create " + destination);
            }
        }
        Files.write((CharSequence)this.mModel.dumpWhitelistedResources(), (File)destinationFile, (Charset)Charsets.UTF_8);
    }

    public void removeUnused(File destination) throws IOException, ParserConfigurationException, SAXException {
        assert (false);
    }

    private static void filteredCopy(File source, File destination, Set<File> skip, Map<File, String> replace) throws IOException {
        assert (false);
    }

    private void stripUnused(Element element, List<String> removed) {
        assert (false);
    }

    private ResourceUsageModel.Resource getResourceByJarPath(String path) {
        if (!path.startsWith("res/")) {
            return null;
        }
        int folderStart = 4;
        int folderEnd = path.indexOf(47, folderStart);
        if (folderEnd == -1) {
            return null;
        }
        String folderName = path.substring(folderStart, folderEnd);
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
        if (folderType == null) {
            return null;
        }
        int nameStart = folderEnd + 1;
        int nameEnd = path.indexOf(46, nameStart);
        if (nameEnd == -1) {
            nameEnd = path.length();
        }
        String name = path.substring(nameStart, nameEnd);
        for (ResourceType type : FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)) {
            ResourceUsageModel.Resource resource;
            if (type == ResourceType.ID || (resource = this.mModel.getResource(type, name)) == null) continue;
            return resource;
        }
        return null;
    }

    private void dumpReferences() {
        if (this.mDebugPrinter != null) {
            this.mDebugPrinter.print(this.mModel.dumpReferences());
        }
    }

    private void keepPossiblyReferencedResources() {
        if (!this.mFoundGetIdentifier && !this.mFoundWebContent || this.mStrings == null) {
            return;
        }
        if (!this.mModel.isSafeMode()) {
            return;
        }
        if (this.mDebugPrinter != null) {
            ArrayList<String> strings = new ArrayList<String>(this.mStrings);
            Collections.sort(strings);
            this.mDebugPrinter.println("android.content.res.Resources#getIdentifier present: " + this.mFoundGetIdentifier);
            this.mDebugPrinter.println("Web content present: " + this.mFoundWebContent);
            this.mDebugPrinter.println("Referenced Strings:");
            for (String s : strings) {
                if ((s = s.trim().replace("\n", "\\n")).length() > 40) {
                    s = s.substring(0, 37) + "...";
                } else if (s.isEmpty()) continue;
                this.mDebugPrinter.println("  " + s);
            }
        }
        int shortest = Integer.MAX_VALUE;
        HashSet names = Sets.newHashSetWithExpectedSize((int)50);
        for (ResourceUsageModel.Resource resource : this.mModel.getResources()) {
            String name = resource.name;
            names.add(name);
            int length = name.length();
            if (length >= shortest) continue;
            shortest = length;
        }
        for (String string : this.mStrings) {
            ResourceUsageModel.Resource resource;
            String name;
            if (string.length() < shortest) continue;
            if (this.mFoundWebContent) {
                int dot;
                String name2;
                ResourceUsageModel.Resource resource2 = this.mModel.getResourceFromFilePath(string);
                if (resource2 != null) {
                    ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource2);
                    continue;
                }
                int start = 0;
                int slash = string.lastIndexOf(47);
                if (slash != -1) {
                    start = slash + 1;
                }
                if (names.contains(name2 = string.substring(start, (dot = string.indexOf(46, start)) != -1 ? dot : string.length()))) {
                    for (Map map : this.mModel.getResourceMaps()) {
                        resource2 = (ResourceUsageModel.Resource)map.get(name2);
                        if (this.mDebug && resource2 != null) {
                            this.mDebugPrinter.println("Marking " + resource2 + " used because it matches string pool constant " + string);
                        }
                        ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource2);
                        this.mModel.addResourceToWhitelist(resource2);
                    }
                }
            }
            int n = string.length();
            boolean justName = true;
            boolean formatting = false;
            boolean haveSlash = false;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '/') {
                    haveSlash = true;
                    justName = false;
                    continue;
                }
                if (c == '.' || c == ':' || c == '%') {
                    justName = false;
                    if (c != '%') continue;
                    formatting = true;
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) continue;
                assert (false) : string;
                break;
            }
            if (justName) {
                name = string;
                for (Object resource3 : this.mModel.getResources()) {
                    if (!((ResourceUsageModel.Resource)resource3).name.startsWith(name)) continue;
                    if (this.mDebugPrinter != null) {
                        this.mDebugPrinter.println("Marking " + resource3 + " used because its prefix matches string pool constant " + string);
                    }
                    ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource3);
                }
            } else {
                if (!haveSlash) {
                    if (!formatting) continue;
                    try {
                        Object resource3;
                        Pattern pattern = Pattern.compile(ResourceUsageAnalyzer.convertFormatStringToRegexp(string));
                        resource3 = this.mModel.getResources().iterator();
                        while (resource3.hasNext()) {
                            resource = (ResourceUsageModel.Resource)resource3.next();
                            if (!pattern.matcher(resource.name).matches()) continue;
                            if (this.mDebugPrinter != null) {
                                this.mDebugPrinter.println("Marking " + resource + " used because it format-string matches string pool constant " + string);
                            }
                            ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource);
                        }
                        continue;
                    }
                    catch (PatternSyntaxException pattern) {
                        continue;
                    }
                }
                int slash = string.indexOf(47);
                assert (slash != -1);
                name = string.substring(slash + 1);
                if (name.isEmpty() || !names.contains(name)) continue;
                if (slash > 0) {
                    int colon = string.indexOf(58);
                    String typeName = string.substring(colon != -1 ? colon + 1 : 0, slash);
                    ResourceType type = ResourceType.getEnum((String)typeName);
                    if (type == null) continue;
                    ResourceUsageModel.Resource resource4 = this.mModel.getResource(type, name);
                    if (this.mDebug && resource4 != null) {
                        this.mDebugPrinter.println("Marking " + resource4 + " used because it matches string pool constant " + string);
                    }
                    ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource4);
                    continue;
                }
            }
            if (names.contains(name)) {
                for (Map map : this.mModel.getResourceMaps()) {
                    resource = (ResourceUsageModel.Resource)map.get(name);
                    if (this.mDebug && resource != null) {
                        this.mDebugPrinter.println("Marking " + resource + " used because it matches string pool constant " + string);
                    }
                    ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource);
                }
                continue;
            }
            if (!Character.isDigit(name.charAt(0))) continue;
            try {
                int id = Integer.parseInt(name);
                if (id == 0) continue;
                ResourceUsageModel.markReachable((ResourceUsageModel.Resource)this.mModel.getResource(id));
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
    }

    static String convertFormatStringToRegexp(String formatString) {
        StringBuilder regexp = new StringBuilder();
        int from = 0;
        boolean hasEscapedLetters = false;
        Matcher matcher = FORMAT.matcher(formatString);
        int length = formatString.length();
        while (matcher.find(from)) {
            int start = matcher.start();
            int end = matcher.end();
            if (start == 0 && end == length) {
                return NO_MATCH;
            }
            if (start > from) {
                hasEscapedLetters |= ResourceUsageAnalyzer.appendEscapedPattern(formatString, regexp, from, start);
            }
            String pattern = ".*";
            String conversion = matcher.group(6);
            String timePrefix = matcher.group(5);
            if (timePrefix == null && conversion != null && conversion.length() == 1) {
                String width;
                char type = conversion.charAt(0);
                switch (type) {
                    case 'S': 
                    case 'T': 
                    case 's': 
                    case 't': {
                        break;
                    }
                    case '%': {
                        pattern = "%";
                        break;
                    }
                    case 'n': {
                        pattern = "\n";
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        pattern = ".";
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        pattern = "\\p{XDigit}+";
                        break;
                    }
                    case 'd': 
                    case 'o': {
                        pattern = "\\p{Digit}+";
                        break;
                    }
                    case 'b': {
                        pattern = "(true|false)";
                        break;
                    }
                    case 'B': {
                        pattern = "(TRUE|FALSE)";
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        pattern = "(null|\\p{XDigit}+)";
                        break;
                    }
                    case 'f': {
                        pattern = "-?[\\p{XDigit},.]+";
                        break;
                    }
                    case 'e': {
                        pattern = "-?\\p{Digit}+[,.]\\p{Digit}+e\\+?\\p{Digit}+";
                        break;
                    }
                    case 'E': {
                        pattern = "-?\\p{Digit}+[,.]\\p{Digit}+E\\+?\\p{Digit}+";
                        break;
                    }
                    case 'a': {
                        pattern = "0x[\\p{XDigit},.+p]+";
                        break;
                    }
                    case 'A': {
                        pattern = "0X[\\p{XDigit},.+P]+";
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        pattern = "-?[\\p{XDigit},.+eE]+";
                    }
                }
                if (!".*".equals(pattern) && (width = matcher.group(3)) != null) {
                    String flags = matcher.group(2);
                    pattern = "0".equals(flags) ? "0*" + pattern : " " + pattern;
                }
                int regexLength = regexp.length();
                if (!".*".equals(pattern) || regexLength < 2 || regexp.charAt(regexLength - 1) != '*' || regexp.charAt(regexLength - 2) != '.') {
                    regexp.append(pattern);
                }
            }
            from = end;
        }
        if (from < length) {
            hasEscapedLetters |= ResourceUsageAnalyzer.appendEscapedPattern(formatString, regexp, from, length);
        }
        if (!hasEscapedLetters) {
            return NO_MATCH;
        }
        return regexp.toString();
    }

    private static boolean appendEscapedPattern(String formatString, StringBuilder regexp, int from, int to) {
        regexp.append(Pattern.quote(formatString.substring(from, to)));
        for (int i = from; i < to; ++i) {
            if (!Character.isLetter(formatString.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private void recordResources(File resDir) throws IOException, SAXException, ParserConfigurationException {
        File[] resourceFolders = resDir.listFiles();
        if (resourceFolders != null) {
            for (File folder : resourceFolders) {
                ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folder.getName());
                if (folderType == null) continue;
                this.recordResources(folderType, folder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordResources(ResourceFolderType folderType, File folder) throws ParserConfigurationException, SAXException, IOException {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                String path = file.getPath();
                this.mModel.file = file;
                try {
                    boolean isXml = SdkUtils.endsWithIgnoreCase((String)path, (String)".xml");
                    if (isXml) {
                        String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                        Document document = XmlUtils.parseDocument((String)xml, (boolean)true);
                        this.mModel.visitXmlDocument(file, folderType, document);
                        continue;
                    }
                    this.mModel.visitBinaryResource(folderType, file);
                }
                finally {
                    this.mModel.file = null;
                }
            }
        }
    }

    void recordMapping(File mapping) throws IOException {
        if (mapping == null || !mapping.exists()) {
            return;
        }
        String ARROW = " -> ";
        String RESOURCE = ".R$";
        HashMap nameMap = null;
        for (String line : Files.readLines((File)mapping, (Charset)Charsets.UTF_8)) {
            String typeName;
            ResourceType type;
            int end;
            if (line.startsWith(" ") || line.startsWith("\t")) {
                int i;
                if (nameMap == null) continue;
                int n = line.length();
                for (i = 0; i < n && Character.isWhitespace(line.charAt(i)); ++i) {
                }
                if (i >= n || !line.startsWith("int", i)) continue;
                int start = line.indexOf(32, i + 3) + 1;
                int arrow = line.indexOf(" -> ");
                if (start <= 0 || arrow == -1 || (end = line.indexOf(32, start + 1)) == -1) continue;
                String oldName = line.substring(start, end);
                String newName = line.substring(arrow + " -> ".length()).trim();
                if (newName.equals(oldName)) continue;
                nameMap.put(newName, oldName);
                continue;
            }
            nameMap = null;
            int index = line.indexOf(".R$");
            if (index == -1) {
                if (line.startsWith("android.support.v7.widget.SuggestionsAdapter ")) {
                    this.mSuggestionsAdapter = line.substring(line.indexOf(" -> ") + " -> ".length(), line.indexOf(58) != -1 ? line.indexOf(58) : line.length()).trim().replace('.', '/') + ".class";
                    continue;
                }
                if (!line.startsWith("android.support.v7.internal.widget.ResourcesWrapper ") && !line.startsWith("android.support.v7.widget.ResourcesWrapper ") && (this.mResourcesWrapper != null || !line.startsWith("android.support.v7.widget.TintContextWrapper$TintResources "))) continue;
                this.mResourcesWrapper = line.substring(line.indexOf(" -> ") + " -> ".length(), line.indexOf(58) != -1 ? line.indexOf(58) : line.length()).trim().replace('.', '/') + ".class";
                continue;
            }
            int arrow = line.indexOf(" -> ", index + 3);
            if (arrow == -1 || (type = ResourceType.getEnum((String)(typeName = line.substring(index + ".R$".length(), arrow)))) == null) continue;
            end = line.indexOf(58, arrow + " -> ".length());
            if (end == -1) {
                end = line.length();
            }
            String target = line.substring(arrow + " -> ".length(), end).trim();
            String ownerName = ByteCodeUtils.toInternalName(target);
            nameMap = Maps.newHashMap();
            Pair pair = Pair.of((Object)type, (Object)nameMap);
            this.mResourceObfuscation.put(ownerName, (Pair<ResourceType, Map<String, String>>)pair);
            this.mResourceObfuscation.put(ownerName + ".class", (Pair<ResourceType, Map<String, String>>)pair);
        }
    }

    private void recordManifestUsages(File manifest) throws IOException, ParserConfigurationException, SAXException {
        String xml = Files.toString((File)manifest, (Charset)Charsets.UTF_8);
        Document document = XmlUtils.parseDocument((String)xml, (boolean)true);
        this.mModel.visitXmlDocument(manifest, null, document);
    }

    private void referencedString(String string) {
        if (string.isEmpty() || string.length() > 80) {
            return;
        }
        boolean haveIdentifierChar = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean identifierChar = Character.isJavaIdentifierPart(c);
            if (!identifierChar && c != '.' && c != ':' && c != '/' && c != '%') {
                return;
            }
            if (!identifierChar) continue;
            haveIdentifierChar = true;
        }
        if (!haveIdentifierChar) {
            return;
        }
        if (this.mStrings == null) {
            this.mStrings = Sets.newHashSetWithExpectedSize((int)300);
        }
        this.mStrings.add(string);
        if (!this.mFoundWebContent && string.contains(ANDROID_RES)) {
            this.mFoundWebContent = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordClassUsages(File file) throws IOException {
        block12: {
            block13: {
                block11: {
                    if (!file.isDirectory()) break block11;
                    File[] children = file.listFiles();
                    if (children != null) {
                        for (File child : children) {
                            this.recordClassUsages(child);
                        }
                    }
                    break block12;
                }
                if (!file.isFile()) break block12;
                if (!file.getPath().endsWith(".class") && !file.getPath().endsWith(".dex")) break block13;
                byte[] bytes = Files.toByteArray((File)file);
                this.recordClassUsages(file, file.getName(), bytes);
                break block12;
            }
            if (file.getPath().endsWith(".jar")) {
                ZipInputStream zis = null;
                try {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        zis = new ZipInputStream(fis);
                        ZipEntry entry = zis.getNextEntry();
                        while (entry != null) {
                            byte[] bytes;
                            String name = entry.getName();
                            if ((name.endsWith(".class") && !this.isResourceClass(name) || name.endsWith(".dex")) && (bytes = ByteStreams.toByteArray((InputStream)zis)) != null) {
                                this.recordClassUsages(file, name, bytes);
                            }
                            entry = zis.getNextEntry();
                        }
                    }
                    finally {
                        Closeables.close((Closeable)fis, (boolean)true);
                    }
                }
                catch (Throwable throwable) {
                    Closeables.close(zis, (boolean)true);
                    throw throwable;
                }
                Closeables.close((Closeable)zis, (boolean)true);
            }
        }
    }

    private void recordClassUsages(File file, String name, byte[] bytes) {
        if (name.endsWith(".class")) {
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept((ClassVisitor)new UsageVisitor(file, name), 6);
        } else {
            assert (name.endsWith(".dex"));
            new DexFileUsageVisitor(bytes, file).visit();
        }
    }

    boolean isResourceClass(String name) {
        if (this.mResourceObfuscation.containsKey(name)) {
            return true;
        }
        assert (name.endsWith(".class")) : name;
        int index = name.lastIndexOf(47);
        if (index != -1 && name.startsWith("R$", index + 1)) {
            String typeName = name.substring(index + 3, name.length() - ".class".length());
            return ResourceType.getEnum((String)typeName) != null;
        }
        return false;
    }

    ResourceUsageModel.Resource getResourceFromCode(String owner, String name) {
        Pair<ResourceType, Map<String, String>> pair = this.mResourceObfuscation.get(owner);
        if (pair != null) {
            ResourceType type = (ResourceType)pair.getFirst();
            Map nameMap = (Map)pair.getSecond();
            String renamedField = (String)nameMap.get(name);
            if (renamedField != null) {
                name = renamedField;
            }
            return this.mModel.getResource(type, name);
        }
        return null;
    }

    private void gatherResourceValues(File file) throws IOException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.gatherResourceValues(child);
                }
            }
        } else if (file.isFile() && file.getName().equals("R.java")) {
            this.parseResourceClass(file);
        }
    }

    private void parseResourceClass(File file) throws IOException {
        String typeName;
        ResourceType type;
        int start;
        int end;
        String s = Files.toString((File)file, (Charset)Charsets.UTF_8);
        String pkg = null;
        int index = s.indexOf("package ");
        if (index != -1) {
            int end2 = s.indexOf(59, index);
            pkg = s.substring(index + "package ".length(), end2).trim().replace('.', '/');
        }
        index = 0;
        int length = s.length();
        String classDeclaration = "public static final class ";
        block0: while ((index = s.indexOf(classDeclaration, index)) != -1 && (end = s.indexOf(32, start = index + classDeclaration.length())) != -1 && (type = ResourceType.getEnum((String)(typeName = s.substring(start, end)))) != null) {
            if (pkg != null) {
                String owner = pkg + "/R$" + type.getName();
                Pair pair = this.mResourceObfuscation.get(owner);
                if (pair == null) {
                    HashMap nameMap = Maps.newHashMap();
                    pair = Pair.of((Object)type, (Object)nameMap);
                }
                this.mResourceObfuscation.put(owner, pair);
            }
            for (index = end; index < length - 1; ++index) {
                char c = s.charAt(index);
                if (Character.isWhitespace(c)) continue;
                if (c == '/') {
                    char next = s.charAt(index + 1);
                    if (next == '*') {
                        for (end = index + 2; end < length - 2; ++end) {
                            c = s.charAt(end);
                            if (c != '*' || s.charAt(end + 1) != '/') continue;
                            ++end;
                            break;
                        }
                        index = end;
                        continue;
                    }
                    if (next == '/' ? !$assertionsDisabled : !$assertionsDisabled) {
                        throw new AssertionError((Object)s.substring(index - 1, index + 50));
                    }
                    continue;
                }
                if (c == 'p' && s.startsWith("public ", index)) {
                    if (type == ResourceType.STYLEABLE) {
                        start = s.indexOf(" int", index);
                        if (s.startsWith(" int[] ", start)) {
                            end = s.indexOf(61, start += " int[] ".length());
                            assert (end != -1);
                            String styleable = s.substring(start, end).trim();
                            this.mModel.addResource(ResourceType.DECLARE_STYLEABLE, styleable, null);
                            this.mModel.addResource(ResourceType.STYLEABLE, styleable, null);
                            index = s.indexOf(59, index);
                            if (index != -1) continue;
                            continue block0;
                        }
                        if (!s.startsWith(" int ", start) || (index = s.indexOf(59, index)) != -1) continue;
                        continue block0;
                    }
                    start = s.indexOf(" int ", index);
                    if (start == -1) continue;
                    end = s.indexOf(61, start += " int ".length());
                    assert (end != -1);
                    String name = s.substring(start, end).trim();
                    start = end + 1;
                    end = s.indexOf(59, start);
                    assert (end != -1);
                    String value = s.substring(start, end).trim();
                    this.mModel.addResource(type, name, value);
                    continue;
                }
                if (c == '}') continue block0;
            }
        }
    }

    public int getUnusedResourceCount() {
        return this.mUnused.size();
    }

    ResourceUsageModel getModel() {
        return this.mModel;
    }

    private void referencedInt(String context, int value, File file, String currentClass) {
        ResourceUsageModel.Resource resource = this.mModel.getResource(value);
        if (ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource) && this.mDebug) {
            assert (this.mDebugPrinter != null) : "mDebug is true, but mDebugPrinter is null.";
            this.mDebugPrinter.println("Marking " + resource + " reachable: referenced from " + context + " in " + file + ":" + currentClass);
        }
    }

    private void referencedMethodInvocation(String owner, String name, String desc, String currentClass) {
        if (owner.equals("android/content/res/Resources") && name.equals("getIdentifier") && desc.equals("(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I")) {
            if (currentClass.equals(this.mResourcesWrapper) || currentClass.equals(this.mSuggestionsAdapter)) {
                return;
            }
            this.mFoundGetIdentifier = true;
        }
        if (owner.equals("android/webkit/WebView") && name.startsWith("load")) {
            this.mFoundWebContent = true;
        }
    }

    private class ResourceShrinkerUsageModel
    extends ResourceUsageModel {
        public File file;

        private ResourceShrinkerUsageModel() {
        }

        protected boolean ignoreToolsAttributes() {
            return true;
        }

        protected List<ResourceUsageModel.Resource> findRoots(List<ResourceUsageModel.Resource> resources) {
            List roots = super.findRoots(resources);
            if (ResourceUsageAnalyzer.this.mDebugPrinter != null) {
                ResourceUsageAnalyzer.this.mDebugPrinter.println("\nThe root reachable resources are:\n" + Joiner.on((String)",\n   ").join((Iterable)roots));
            }
            return roots;
        }

        protected ResourceUsageModel.Resource declareResource(ResourceType type, String name, Node node) {
            ResourceUsageModel.Resource resource = super.declareResource(type, name, node);
            resource.addLocation(this.file);
            return resource;
        }

        protected void referencedString(String string) {
            ResourceUsageAnalyzer.this.referencedString(string);
            ResourceUsageAnalyzer.this.mFoundWebContent = true;
        }
    }

    private final class DexClassUsageVisitor {
        private final DexBackedClassDef classDef;
        private final String originalClassFile;
        private final File dexFile;

        public DexClassUsageVisitor(DexBackedClassDef classDef, File dexFile) {
            this.classDef = classDef;
            this.originalClassFile = Type.getType((String)classDef.getType()).getInternalName() + ".class";
            this.dexFile = dexFile;
        }

        public void visit() {
            if (ResourceUsageAnalyzer.this.isResourceClass(this.originalClassFile)) {
                return;
            }
            for (DexBackedField field : this.classDef.getStaticFields()) {
                if (field.getInitialValue() == null) continue;
                this.processFieldValue(field.getInitialValue());
            }
            for (DexBackedMethod method : this.classDef.getMethods()) {
                this.processMethod(method);
            }
            for (DexBackedAnnotation annotation : this.classDef.getAnnotations()) {
                for (DexBackedAnnotationElement annotationElement : annotation.getElements()) {
                    EncodedValue value = annotationElement.getValue();
                    this.processAnnotationValue(value);
                }
            }
        }

        private void processFieldValue(EncodedValue value) {
            int type = value.getValueType();
            if (type == 23) {
                ResourceUsageAnalyzer.this.referencedString(((StringEncodedValue)value).getValue());
            } else if (type == 4) {
                int constantValue = ((IntEncodedValue)value).getValue();
                ResourceUsageAnalyzer.this.referencedInt("field", constantValue, this.dexFile, this.originalClassFile);
            } else if (type == 28) {
                ArrayEncodedValue arrayEncodedValue = (ArrayEncodedValue)value;
                for (EncodedValue encodedValue : arrayEncodedValue.getValue()) {
                    if (encodedValue.getValueType() != 4) continue;
                    int constantValue = ((IntEncodedValue)value).getValue();
                    ResourceUsageAnalyzer.this.referencedInt("field", constantValue, this.dexFile, this.originalClassFile);
                }
            }
        }

        private void processMethod(DexBackedMethod method) {
            DexBackedMethodImplementation implementation = method.getImplementation();
            if (implementation != null) {
                for (Instruction instruction : implementation.getInstructions()) {
                    if (this.isIntConstInstruction(instruction)) {
                        this.processIntConstInstruction(instruction);
                        continue;
                    }
                    if (this.isStringConstInstruction(instruction)) {
                        this.processStringConstantInstruction(instruction);
                        continue;
                    }
                    if (this.isGetStatic(instruction)) {
                        this.processGetStatic(instruction);
                        continue;
                    }
                    if (this.isInvokeInstruction(instruction)) {
                        this.processInvokeInstruction(instruction);
                        continue;
                    }
                    if (!this.isInvokeRangeInstruction(instruction)) continue;
                    this.processInvokeRangeInstruction(instruction);
                }
            }
        }

        private void processAnnotationValue(EncodedValue value) {
            block3: {
                int type;
                block5: {
                    block4: {
                        block2: {
                            type = value.getValueType();
                            if (type != 4) break block2;
                            ResourceUsageAnalyzer.this.referencedInt("annotation", ((IntEncodedValue)value).getValue(), this.dexFile, this.originalClassFile);
                            break block3;
                        }
                        if (type != 23) break block4;
                        ResourceUsageAnalyzer.this.referencedString(((StringEncodedValue)value).getValue());
                        break block3;
                    }
                    if (type != 28) break block5;
                    ArrayEncodedValue arrayEncodedValue = (ArrayEncodedValue)value;
                    for (EncodedValue nestedValue : arrayEncodedValue.getValue()) {
                        this.processAnnotationValue(nestedValue);
                    }
                    break block3;
                }
                if (type != 29) break block3;
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)value;
                for (AnnotationElement nestedAnnotation : annotationEncodedValue.getElements()) {
                    this.processAnnotationValue(nestedAnnotation.getValue());
                }
            }
        }

        private boolean isIntConstInstruction(Instruction instruction) {
            Opcode opcode = instruction.getOpcode();
            return opcode == Opcode.CONST_4 || opcode == Opcode.CONST_16 || opcode == Opcode.CONST || opcode == Opcode.CONST_WIDE_32 || opcode == Opcode.CONST_HIGH16 || opcode == Opcode.CONST_WIDE_16;
        }

        private void processIntConstInstruction(Instruction instruction) {
            int constantValue;
            Preconditions.checkArgument((boolean)this.isIntConstInstruction(instruction), (Object)"Not an int constant instruction.");
            switch (instruction.getOpcode()) {
                case CONST: 
                case CONST_WIDE_32: {
                    DexBackedInstruction31i ins31n = (DexBackedInstruction31i)instruction;
                    constantValue = ins31n.getNarrowLiteral();
                    break;
                }
                case CONST_4: {
                    DexBackedInstruction11n ins11n = (DexBackedInstruction11n)instruction;
                    constantValue = ins11n.getNarrowLiteral();
                    break;
                }
                case CONST_16: 
                case CONST_WIDE_16: {
                    DexBackedInstruction21s ins21s = (DexBackedInstruction21s)instruction;
                    constantValue = ins21s.getNarrowLiteral();
                    break;
                }
                case CONST_HIGH16: {
                    DexBackedInstruction21ih ins21ih = (DexBackedInstruction21ih)instruction;
                    constantValue = ins21ih.getNarrowLiteral();
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Not an int const instruction.");
                }
            }
            ResourceUsageAnalyzer.this.referencedInt("constant", constantValue, this.dexFile, this.originalClassFile);
        }

        private boolean isStringConstInstruction(Instruction instruction) {
            Opcode opcode = instruction.getOpcode();
            return opcode == Opcode.CONST_STRING || opcode == Opcode.CONST_STRING_JUMBO;
        }

        private void processStringConstantInstruction(Instruction instruction) {
            String constantValue;
            Preconditions.checkArgument((boolean)this.isStringConstInstruction(instruction), (Object)"Not a string constant instruction");
            switch (instruction.getOpcode()) {
                case CONST_STRING: {
                    DexBackedInstruction21c ins21c = (DexBackedInstruction21c)instruction;
                    assert (ins21c.getReference() instanceof StringReference);
                    constantValue = ((StringReference)ins21c.getReference()).getString();
                    break;
                }
                case CONST_STRING_JUMBO: {
                    DexBackedInstruction31c ins31c = (DexBackedInstruction31c)instruction;
                    assert (ins31c.getReference() instanceof StringReference);
                    constantValue = ((StringReference)ins31c.getReference()).getString();
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Not a string constant instruction.");
                }
            }
            ResourceUsageAnalyzer.this.referencedString(constantValue);
        }

        private boolean isGetStatic(Instruction instruction) {
            Opcode opcode = instruction.getOpcode();
            return opcode == Opcode.SGET || opcode == Opcode.SGET_BOOLEAN || opcode == Opcode.SGET_BYTE || opcode == Opcode.SGET_CHAR || opcode == Opcode.SGET_OBJECT || opcode == Opcode.SGET_SHORT || opcode == Opcode.SGET_WIDE;
        }

        private void processGetStatic(Instruction instruction) {
            Preconditions.checkArgument((boolean)this.isGetStatic(instruction), (Object)"Not a get static instruction");
            DexBackedInstruction21c ins21c = (DexBackedInstruction21c)instruction;
            assert (ins21c.getReferenceType() == 2);
            FieldReference field = (FieldReference)ins21c.getReference();
            String ownerDescriptor = Type.getType((String)field.getDefiningClass()).getInternalName();
            ResourceUsageModel.Resource resource = ResourceUsageAnalyzer.this.getResourceFromCode(ownerDescriptor, field.getName());
            if (resource != null) {
                ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource);
            }
        }

        private boolean isInvokeInstruction(Instruction instruction) {
            Opcode opcode = instruction.getOpcode();
            return opcode == Opcode.INVOKE_VIRTUAL || opcode == Opcode.INVOKE_SUPER || opcode == Opcode.INVOKE_DIRECT || opcode == Opcode.INVOKE_STATIC || opcode == Opcode.INVOKE_INTERFACE;
        }

        private void processInvokeInstruction(Instruction instruction) {
            Preconditions.checkArgument((boolean)this.isInvokeInstruction(instruction), (Object)"Not an invoke instruction.");
            DexBackedInstruction35c ins35c = (DexBackedInstruction35c)instruction;
            MethodReference method = (MethodReference)ins35c.getReference();
            this.markMethodInvocation(method);
        }

        private boolean isInvokeRangeInstruction(Instruction instruction) {
            Opcode opcode = instruction.getOpcode();
            return opcode == Opcode.INVOKE_VIRTUAL_RANGE || opcode == Opcode.INVOKE_SUPER_RANGE || opcode == Opcode.INVOKE_DIRECT_RANGE || opcode == Opcode.INVOKE_STATIC_RANGE || opcode == Opcode.INVOKE_INTERFACE_RANGE;
        }

        private void processInvokeRangeInstruction(Instruction instruction) {
            Preconditions.checkArgument((boolean)this.isInvokeRangeInstruction(instruction), (Object)"Not an invoke-range instruction.");
            DexBackedInstruction3rc ins3rc = (DexBackedInstruction3rc)instruction;
            MethodReference method = (MethodReference)ins3rc.getReference();
            this.markMethodInvocation(method);
        }

        private void markMethodInvocation(MethodReference method) {
            String owner = Type.getType((String)method.getDefiningClass()).getInternalName();
            String name = method.getName();
            String descriptor = "(" + method.getParameterTypes().stream().collect(Collectors.joining("")) + ")" + method.getReturnType();
            ResourceUsageAnalyzer.this.referencedMethodInvocation(owner, name, descriptor, this.originalClassFile);
        }
    }

    private class DexFileUsageVisitor {
        private final byte[] bytes;
        private final File dexFile;

        public DexFileUsageVisitor(byte[] bytes, File dexFile) {
            this.bytes = bytes;
            this.dexFile = dexFile;
        }

        public void visit() {
            DexBackedDexFile dexBackedDexFile = new DexBackedDexFile(Opcodes.getDefault(), this.bytes);
            for (DexBackedClassDef classDef : dexBackedDexFile.getClasses()) {
                new DexClassUsageVisitor(classDef, this.dexFile).visit();
            }
        }
    }

    private class UsageVisitor
    extends ClassVisitor {
        private final File mJarFile;
        private final String mCurrentClass;

        public UsageVisitor(File jarFile, String name) {
            super(327680);
            this.mJarFile = jarFile;
            this.mCurrentClass = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(327680){

                public void visitLdcInsn(Object cst) {
                    UsageVisitor.this.handleCodeConstant(cst, "ldc");
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    ResourceUsageModel.Resource resource;
                    if (opcode == 178 && (resource = ResourceUsageAnalyzer.this.getResourceFromCode(owner, name)) != null) {
                        ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource);
                    }
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    ResourceUsageAnalyzer.this.referencedMethodInvocation(owner, name, desc, UsageVisitor.this.mCurrentClass);
                }

                public AnnotationVisitor visitAnnotationDefault() {
                    return new AnnotationUsageVisitor();
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return new AnnotationUsageVisitor();
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    return new AnnotationUsageVisitor();
                }
            };
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationUsageVisitor();
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.handleCodeConstant(value, "field");
            return new FieldVisitor(327680){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return new AnnotationUsageVisitor();
                }
            };
        }

        private void handleCodeConstant(Object cst, String context) {
            if (cst instanceof Integer) {
                Integer value = (Integer)cst;
                ResourceUsageAnalyzer.this.referencedInt(context, value, this.mJarFile, this.mCurrentClass);
            } else if (cst instanceof int[]) {
                int[] values;
                for (int value : values = (int[])cst) {
                    ResourceUsageAnalyzer.this.referencedInt(context, value, this.mJarFile, this.mCurrentClass);
                }
            } else if (cst instanceof String) {
                String string = (String)cst;
                ResourceUsageAnalyzer.this.referencedString(string);
            }
        }

        private class AnnotationUsageVisitor
        extends AnnotationVisitor {
            public AnnotationUsageVisitor() {
                super(327680);
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return new AnnotationUsageVisitor();
            }

            public AnnotationVisitor visitArray(String name) {
                return new AnnotationUsageVisitor();
            }

            public void visit(String name, Object value) {
                UsageVisitor.this.handleCodeConstant(value, "annotation");
                super.visit(name, value);
            }
        }
    }
}

