/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.builder.dependency.DependencyMutableData;
import com.android.builder.dependency.level2.Dependency;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface MutableDependencyDataMap {
    public static final MutableDependencyDataMap EMPTY = new MutableDependencyDataMap(){

        @Override
        public void skip(Dependency dependency) {
            throw new RuntimeException(String.format("cannot set skipped attribute on a dependency with another scope than Package : %1$s", dependency));
        }

        @Override
        public boolean isSkipped(Dependency library) {
            return false;
        }

        @Override
        public void setProvided(Dependency dependency) {
            throw new RuntimeException(String.format("cannot set skipped attribute on a dependency with another scope than Compile : %1$s", dependency));
        }

        @Override
        public boolean isProvided(Dependency dependency) {
            return false;
        }

        @Override
        public List<String> getProvidedList() {
            return ImmutableList.of();
        }

        @Override
        public List<String> getSkippedList() {
            return ImmutableList.of();
        }
    };

    public static MutableDependencyDataMap newInstance() {
        return new MutableDependencyDataMap(){
            Map<Dependency, DependencyMutableData> dataMap = new HashMap<Dependency, DependencyMutableData>();

            private synchronized DependencyMutableData getFor(Dependency library) {
                return this.dataMap.computeIfAbsent(library, k -> new DependencyMutableData());
            }

            @Override
            public boolean isSkipped(Dependency dependency) {
                DependencyMutableData dependencyMutableData = this.dataMap.get(dependency);
                return dependencyMutableData != null && dependencyMutableData.isSkipped();
            }

            @Override
            public void skip(Dependency dependency) {
                this.getFor(dependency).skip();
            }

            @Override
            public void setProvided(Dependency dependency) {
                this.getFor(dependency).setProvided(true);
            }

            @Override
            public boolean isProvided(Dependency dependency) {
                DependencyMutableData dependencyMutableData = this.dataMap.get(dependency);
                return dependencyMutableData != null && dependencyMutableData.isProvided();
            }

            @Override
            public List<String> getProvidedList() {
                ArrayList providedList = Lists.newArrayListWithExpectedSize((int)this.dataMap.size());
                for (Map.Entry<Dependency, DependencyMutableData> entry : this.dataMap.entrySet()) {
                    if (!entry.getValue().isProvided()) continue;
                    providedList.add(entry.getKey().getAddress().toString());
                }
                return providedList;
            }

            @Override
            public List<String> getSkippedList() {
                ArrayList skippedList = Lists.newArrayListWithExpectedSize((int)this.dataMap.size());
                for (Map.Entry<Dependency, DependencyMutableData> entry : this.dataMap.entrySet()) {
                    if (!entry.getValue().isSkipped()) continue;
                    skippedList.add(entry.getKey().getAddress().toString());
                }
                return skippedList;
            }
        };
    }

    public void skip(Dependency var1);

    public boolean isSkipped(Dependency var1);

    public void setProvided(Dependency var1);

    public boolean isProvided(Dependency var1);

    public List<String> getProvidedList();

    public List<String> getSkippedList();
}

