/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.incremental.BuildInfoLoaderTask;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.InstantRunDex;
import com.android.build.gradle.internal.transforms.InstantRunSlicer;
import com.android.build.gradle.internal.transforms.InstantRunTransform;
import com.android.build.gradle.internal.transforms.InstantRunVerifierTransform;
import com.android.build.gradle.internal.transforms.NoChangesVerifierTransform;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.CheckManifestInInstantRunMode;
import com.android.build.gradle.tasks.PreColdSwapTask;
import com.android.build.gradle.tasks.ir.FastDeployRuntimeExtractorTask;
import com.android.build.gradle.tasks.ir.GenerateInstantRunAppInfoTask;
import com.android.build.gradle.tasks.ir.InstantRunMainApkResourcesBuilder;
import com.android.builder.core.DexByteCodeConverter;
import com.android.builder.core.DexOptions;
import com.android.builder.model.OptionalCompilationStep;
import com.android.builder.profile.Recorder;
import com.android.ide.common.internal.WaitableExecutor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionAdapter;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskState;

public class InstantRunTaskManager {
    private TransformTask verifierTask;
    private TransformTask reloadDexTask;
    private BuildInfoLoaderTask buildInfoLoaderTask;
    private final Logger logger;
    private final VariantScope variantScope;
    private final TransformManager transformManager;
    private final TaskFactory taskFactory;
    private final Recorder recorder;

    public InstantRunTaskManager(Logger logger, VariantScope instantRunVariantScope, TransformManager transformManager, TaskFactory taskFactory, Recorder recorder) {
        this.logger = logger;
        this.variantScope = instantRunVariantScope;
        this.transformManager = transformManager;
        this.taskFactory = taskFactory;
        this.recorder = recorder;
    }

    public BuildInfoLoaderTask createInstantRunAllTasks(DexOptions dexOptions, Supplier<DexByteCodeConverter> dexByteCodeConverter, Task preTask, Task anchorTask, Set<? super QualifiedContent.Scope> resMergingScopes, BuildableArtifact instantRunMergedManifests, boolean addDependencyChangeChecker, int minSdkForDx) {
        InternalArtifactType resourceFilesInputType;
        Project project = this.variantScope.getGlobalScope().getProject();
        TransformVariantScope transformVariantScope = this.variantScope.getTransformVariantScope();
        this.buildInfoLoaderTask = this.taskFactory.create(new BuildInfoLoaderTask.ConfigAction(this.variantScope, this.logger));
        InstantRunVerifierTransform verifierTransform = new InstantRunVerifierTransform(this.variantScope, this.recorder);
        Optional<TransformTask> verifierTaskOptional = this.transformManager.addTransform(this.taskFactory, transformVariantScope, verifierTransform);
        this.verifierTask = verifierTaskOptional.orElse(null);
        verifierTaskOptional.ifPresent(t -> {
            if (preTask != null) {
                t.dependsOn(new Object[]{preTask});
            }
        });
        NoChangesVerifierTransform javaResourcesVerifierTransform = new NoChangesVerifierTransform("javaResourcesVerifier", this.variantScope.getInstantRunBuildContext(), (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.RESOURCES, (Object)((Object)ExtendedContentType.NATIVE_LIBS)), resMergingScopes, InstantRunVerifierStatus.JAVA_RESOURCES_CHANGED);
        Optional<TransformTask> javaResourcesVerifierTask = this.transformManager.addTransform(this.taskFactory, transformVariantScope, javaResourcesVerifierTransform);
        javaResourcesVerifierTask.ifPresent(t -> {
            if (this.verifierTask != null) {
                t.dependsOn(new Object[]{this.verifierTask});
            }
        });
        InstantRunTransform instantRunTransform = new InstantRunTransform(WaitableExecutor.useGlobalSharedThreadPool(), this.variantScope);
        Optional<TransformTask> instantRunTask = this.transformManager.addTransform(this.taskFactory, transformVariantScope, instantRunTransform);
        InternalArtifactType internalArtifactType = resourceFilesInputType = this.variantScope.useResourceShrinker() ? InternalArtifactType.SHRUNK_PROCESSED_RES : InternalArtifactType.PROCESSED_RES;
        if (this.variantScope.getInstantRunBuildContext().useSeparateApkForResources()) {
            this.taskFactory.create(new InstantRunMainApkResourcesBuilder.ConfigAction(this.variantScope, resourceFilesInputType));
        }
        CheckManifestInInstantRunMode checkManifestTask = this.taskFactory.create(new CheckManifestInInstantRunMode.ConfigAction(this.variantScope));
        instantRunTask.ifPresent(t -> t.dependsOn(new Object[]{this.buildInfoLoaderTask, this.verifierTask, javaResourcesVerifierTask.orElse(null), checkManifestTask}));
        if (addDependencyChangeChecker) {
            NoChangesVerifierTransform dependenciesVerifierTransform = new NoChangesVerifierTransform("dependencyChecker", this.variantScope.getInstantRunBuildContext(), (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES), (Set<? super QualifiedContent.Scope>)Sets.immutableEnumSet((Enum)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Enum[])new QualifiedContent.Scope[0]), InstantRunVerifierStatus.DEPENDENCY_CHANGED);
            Optional<TransformTask> dependenciesVerifierTask = this.transformManager.addTransform(this.taskFactory, transformVariantScope, dependenciesVerifierTransform);
            dependenciesVerifierTask.ifPresent(t -> {
                if (this.verifierTask != null) {
                    t.dependsOn(new Object[]{this.verifierTask});
                }
            });
            instantRunTask.ifPresent(t -> dependenciesVerifierTask.ifPresent(xva$0 -> t.dependsOn(new Object[]{xva$0})));
        }
        FastDeployRuntimeExtractorTask extractorTask = this.taskFactory.create(new FastDeployRuntimeExtractorTask.ConfigAction(this.variantScope));
        extractorTask.dependsOn(new Object[]{this.buildInfoLoaderTask});
        this.transformManager.addStream(OriginalStream.builder(project, "main-split-from-extractor").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.MAIN_SPLIT).setJar(this.variantScope.getIncrementalRuntimeSupportJar()).setDependency((Object)extractorTask).build());
        GenerateInstantRunAppInfoTask generateInstantRunAppInfoTask = this.taskFactory.create(new GenerateInstantRunAppInfoTask.ConfigAction(transformVariantScope, this.variantScope, instantRunMergedManifests));
        this.transformManager.addStream(OriginalStream.builder(project, "main-split-from-injector").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.MAIN_SPLIT).setJar(generateInstantRunAppInfoTask.getOutputFile()).setDependency((Object)generateInstantRunAppInfoTask).build());
        instantRunTask.ifPresent(xva$0 -> anchorTask.dependsOn(new Object[]{xva$0}));
        InstantRunDex reloadDexTransform = new InstantRunDex(this.variantScope, dexByteCodeConverter, dexOptions, this.logger, minSdkForDx);
        this.reloadDexTask = this.transformManager.addTransform(this.taskFactory, transformVariantScope, reloadDexTransform).orElse(null);
        if (this.reloadDexTask != null) {
            anchorTask.dependsOn(new Object[]{this.reloadDexTask});
        }
        return this.buildInfoLoaderTask;
    }

    public PreColdSwapTask createPreColdswapTask(ProjectOptions projectOptions) {
        TransformVariantScope transformVariantScope = this.variantScope.getTransformVariantScope();
        InstantRunBuildContext context = this.variantScope.getInstantRunBuildContext();
        if (transformVariantScope.getGlobalScope().isActive(OptionalCompilationStep.FULL_APK)) {
            context.setVerifierStatus(InstantRunVerifierStatus.FULL_BUILD_REQUESTED);
        } else if (transformVariantScope.getGlobalScope().isActive(OptionalCompilationStep.RESTART_ONLY)) {
            context.setVerifierStatus(InstantRunVerifierStatus.COLD_SWAP_REQUESTED);
        }
        PreColdSwapTask preColdSwapTask = this.taskFactory.create(new PreColdSwapTask.ConfigAction("preColdswap", transformVariantScope, this.variantScope));
        if (this.verifierTask != null) {
            preColdSwapTask.dependsOn(new Object[]{this.verifierTask});
        }
        return preColdSwapTask;
    }

    public void createSlicerTask() {
        TransformVariantScope transformVariantScope = this.variantScope.getTransformVariantScope();
        InstantRunSlicer slicer = new InstantRunSlicer(this.logger, this.variantScope);
        Optional<TransformTask> slicing = this.transformManager.addTransform(this.taskFactory, transformVariantScope, slicer);
        slicing.ifPresent(this.variantScope::addColdSwapBuildTask);
    }

    public void configureBuildInfoWriterTask(BuildInfoWriterTask buildInfoWriterTask, Task ... dependencies) {
        Preconditions.checkNotNull((Object)((Object)this.buildInfoLoaderTask), (Object)"createInstantRunAllTasks() should have been called first ");
        this.buildInfoLoaderTask.finalizedBy(new Object[]{buildInfoWriterTask.getName()});
        if (this.reloadDexTask != null) {
            buildInfoWriterTask.mustRunAfter(new Object[]{this.reloadDexTask.getName()});
        }
        if (dependencies != null) {
            for (Task dependency : dependencies) {
                buildInfoWriterTask.mustRunAfter(new Object[]{dependency.getName()});
            }
        }
        this.variantScope.getGlobalScope().getProject().getGradle().getTaskGraph().addTaskExecutionListener((TaskExecutionListener)new TaskExecutionAdapter(){

            public void afterExecute(Task task, TaskState state) {
                if (state.getFailure() != null) {
                    InstantRunTaskManager.this.variantScope.getInstantRunBuildContext().setBuildHasFailed();
                }
            }
        });
    }
}

