/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import java.io.File;
import java.util.HashMap;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class MergeConsumerProguardFilesConfigAction
implements TaskConfigAction<MergeFileTask> {
    private final VariantScope variantScope;

    public MergeConsumerProguardFilesConfigAction(VariantScope variantScope) {
        this.variantScope = variantScope;
    }

    @Override
    public String getName() {
        return this.variantScope.getTaskName("merge", "ConsumerProguardFiles");
    }

    @Override
    public Class<MergeFileTask> getType() {
        return MergeFileTask.class;
    }

    @Override
    public void execute(MergeFileTask mergeProguardFiles) {
        Project project = this.variantScope.getGlobalScope().getProject();
        mergeProguardFiles.setVariantName(this.variantScope.getVariantConfiguration().getFullName());
        mergeProguardFiles.setOutputFile(this.variantScope.getBuildArtifactsHolder().appendArtifact((ArtifactType)InternalArtifactType.CONSUMER_PROGUARD_FILE, (Task)mergeProguardFiles, "proguard.txt"));
        mergeProguardFiles.setInputFiles(project.files(new Object[]{this.variantScope.getConsumerProguardFiles()}).getFiles());
        HashMap<File, String> defaultFiles = new HashMap<File, String>();
        for (String knownFileName : ProguardFiles.KNOWN_FILE_NAMES) {
            defaultFiles.put(ProguardFiles.getDefaultProguardFile(knownFileName, project), knownFileName);
        }
        SyncIssueHandler issueReporter = this.variantScope.getGlobalScope().getErrorHandler();
        for (File consumerFile : mergeProguardFiles.getInputFiles()) {
            if (!defaultFiles.containsKey(consumerFile)) continue;
            issueReporter.reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException(String.format("Default file %s should not be used as a consumer configuration file.", defaultFiles.get(consumerFile))));
        }
    }
}

