/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.regex.Pattern;

public class ApplicationVariantData
extends ApkVariantData
implements TestedVariantData {
    private final Map<VariantType, TestVariantData> testVariants = Maps.newHashMap();
    private static final Pattern FEATURE_REPLACEMENT = Pattern.compile("-");
    private static final Pattern FEATURE_EXCLUSION = Pattern.compile("[^a-zA-Z0-9_]");
    private final String featureName;

    public ApplicationVariantData(GlobalScope globalScope, AndroidConfig androidConfig, TaskManager taskManager, GradleVariantConfiguration config2, Recorder recorder) {
        super(globalScope, androidConfig, taskManager, config2, recorder);
        String splitName = FEATURE_REPLACEMENT.matcher(this.getScope().getGlobalScope().getProjectBaseName()).replaceAll("_");
        this.featureName = FEATURE_EXCLUSION.matcher(splitName).replaceAll("");
    }

    @Override
    public void setTestVariantData(TestVariantData testVariantData, VariantType type) {
        this.testVariants.put(type, testVariantData);
    }

    @Override
    public TestVariantData getTestVariantData(VariantType type) {
        return this.testVariants.get(type);
    }

    public String getFeatureName() {
        return this.featureName;
    }
}

