/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.MergeConsumerProguardFilesConfigAction;
import com.android.build.gradle.internal.tasks.PackageRenderscriptConfigAction;
import com.android.build.gradle.internal.transforms.LibraryAarJarsTransform;
import com.android.build.gradle.internal.transforms.LibraryBaseTransform;
import com.android.build.gradle.internal.transforms.LibraryIntermediateJarsTransform;
import com.android.build.gradle.internal.transforms.LibraryJniLibsTransform;
import com.android.build.gradle.internal.variant.VariantHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.AndroidZip;
import com.android.build.gradle.tasks.BuildArtifactReportTask;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.VerifyLibraryResourcesTask;
import com.android.build.gradle.tasks.ZipMergingTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class LibraryTaskManager
extends TaskManager {
    private Task assembleDefault;

    public LibraryTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(final VariantScope variantScope) {
        final GradleVariantConfiguration variantConfig = variantScope.getVariantConfiguration();
        GlobalScope globalScope = variantScope.getGlobalScope();
        String projectPath = this.project.getPath();
        String variantName = variantScope.getFullVariantName();
        this.createAnchorTasks(variantScope);
        this.createDependencyStreams(variantScope);
        this.createCheckManifestTask(variantScope);
        this.taskFactory.create(new BuildArtifactReportTask.BuildArtifactReportConfigAction(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, projectPath, variantName, () -> this.createGenerateResValuesTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, projectPath, variantName, () -> this.createMergeLibManifestsTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, projectPath, variantName, () -> this.createRenderscriptTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, projectPath, variantName, () -> this.createMergeResourcesTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_SHADER_TASK, projectPath, variantName, () -> this.createShaderTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, projectPath, variantName, () -> {
            this.createMergeAssetsTask(variantScope);
            this.createLibraryAssetsTask(variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, projectPath, variantName, () -> this.createBuildConfigTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_PROCESS_RES_TASK, projectPath, variantName, () -> {
            this.createProcessResTask(variantScope, new File(globalScope.getIntermediatesDir(), "symbols/" + variantScope.getVariantData().getVariantConfiguration().getDirName()), variantScope.getProcessResourcePackageOutputDirectory(), null, TaskManager.MergeType.PACKAGE, globalScope.getProjectBaseName());
            if (!((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable() && !Boolean.TRUE.equals(variantScope.getGlobalScope().getExtension().getAaptOptions().getNamespaced())) {
                this.createVerifyLibraryResTask(variantScope, TaskManager.MergeType.MERGE);
            }
            this.createProcessJavaResTask(variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_AIDL_TASK, projectPath, variantName, () -> this.createAidlTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_COMPILE_TASK, projectPath, variantName, () -> {
            this.createDataBindingTasksIfNecessary(variantScope, TaskManager.MergeType.PACKAGE);
            JavaCompile javacTask = this.createJavacTask(variantScope);
            this.addJavacClassesStream(variantScope);
            TaskManager.setJavaCompilerTask((Task)javacTask, variantScope);
        });
        if (!this.isComponentModelPlugin()) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_NDK_TASK, projectPath, variantName, () -> this.createNdkTasks(variantScope));
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantScope.getVariantData()));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_EXTERNAL_NATIVE_BUILD_TASK, projectPath, variantName, () -> {
            this.createExternalNativeBuildJsonGenerators(variantScope);
            this.createExternalNativeBuildTasks(variantScope);
        });
        this.createMergeJniLibFoldersTasks(variantScope);
        LibraryTaskManager.createStripNativeLibraryTask(this.taskFactory, variantScope);
        this.taskFactory.create(new PackageRenderscriptConfigAction(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_PROGUARD_FILE_TASK, projectPath, variantName, () -> this.taskFactory.create(new MergeConsumerProguardFilesConfigAction(variantScope)));
        if (this.projectOptions.get(BooleanOption.ENABLE_EXTRACT_ANNOTATIONS)) {
            this.taskFactory.create(new ExtractAnnotations.ConfigAction(this.extension, variantScope));
        }
        final boolean instrumented = ((CoreBuildType)variantConfig.getBuildType()).isTestCoverageEnabled() && !variantScope.getInstantRunBuildContext().isInInstantRunMode();
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_POST_COMPILATION_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                TransformManager transformManager = variantScope.getTransformManager();
                if (instrumented) {
                    LibraryTaskManager.this.createJacocoTransform(variantScope);
                }
                List<Transform> customTransforms = LibraryTaskManager.this.extension.getTransforms();
                List<List<Object>> customTransformsDependencies = LibraryTaskManager.this.extension.getTransformsDependencies();
                int count = customTransforms.size();
                for (int i = 0; i < count; ++i) {
                    Transform transform2 = customTransforms.get(i);
                    Sets.SetView difference = Sets.difference((Set)transform2.getScopes(), TransformManager.PROJECT_ONLY);
                    if (!difference.isEmpty()) {
                        String scopes = difference.toString();
                        LibraryTaskManager.this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException(String.format("Transforms with scopes '%s' cannot be applied to library projects.", scopes)));
                    }
                    List<Object> deps = customTransformsDependencies.get(i);
                    transformManager.addTransform(LibraryTaskManager.this.taskFactory, variantScope, transform2).ifPresent(t -> {
                        if (!deps.isEmpty()) {
                            t.dependsOn(new Object[]{deps});
                        }
                        if (transform2.getScopes().isEmpty()) {
                            variantScope.getAssembleTask().dependsOn(new Object[]{t});
                        }
                    });
                }
                String packageName = variantConfig.getPackageFromManifest();
                File jarOutputFolder = variantScope.getIntermediateJarOutputFolder();
                File mainClassJar = new File(jarOutputFolder, "classes.jar");
                File mainResJar = new File(jarOutputFolder, "res.jar");
                LibraryIntermediateJarsTransform intermediateTransform = new LibraryIntermediateJarsTransform(mainClassJar, mainResJar, null, packageName, LibraryTaskManager.this.extension.getPackageBuildConfig());
                LibraryTaskManager.this.excludeDataBindingClassesIfNecessary(variantScope, intermediateTransform);
                Optional<TransformTask> intermediateTransformTask = transformManager.addTransform(LibraryTaskManager.this.taskFactory, variantScope, intermediateTransform);
                BuildArtifactsHolder artifacts = variantScope.getBuildArtifactsHolder();
                intermediateTransformTask.ifPresent(t -> {
                    artifacts.appendArtifact((ArtifactType)InternalArtifactType.LIBRARY_CLASSES, (Collection<? extends File>)ImmutableList.of((Object)mainClassJar), (Task)t);
                    artifacts.appendArtifact((ArtifactType)InternalArtifactType.LIBRARY_JAVA_RES, (Collection<? extends File>)ImmutableList.of((Object)mainResJar), (Task)t);
                });
                LibraryTaskManager.this.taskFactory.create(new ZipMergingTask.ConfigAction(variantScope));
                File intermediateJniLibsFolder = new File(jarOutputFolder, "jni");
                LibraryJniLibsTransform intermediateJniTransform = new LibraryJniLibsTransform("intermediateJniLibs", intermediateJniLibsFolder, TransformManager.PROJECT_ONLY);
                Optional<TransformTask> task = transformManager.addTransform(LibraryTaskManager.this.taskFactory, variantScope, intermediateJniTransform);
                task.ifPresent(t -> variantScope.getBuildArtifactsHolder().appendArtifact((ArtifactType)InternalArtifactType.LIBRARY_JNI, (Collection<? extends File>)ImmutableList.of((Object)intermediateJniLibsFolder), (Task)t));
                LibraryTaskManager.this.createMergeJavaResTransform(variantScope);
                LibraryTaskManager.this.maybeCreateJavaCodeShrinkerTransform(variantScope);
                LibraryTaskManager.this.maybeCreateResourcesShrinkerTransform(variantScope);
                File classesJar = variantScope.getAarClassesJar();
                File libsDirectory = variantScope.getAarLibsDirectory();
                LibraryAarJarsTransform transform3 = new LibraryAarJarsTransform(classesJar, libsDirectory, artifacts.hasArtifact(InternalArtifactType.ANNOTATIONS_TYPEDEF_FILE) ? artifacts.getFinalArtifactFiles(InternalArtifactType.ANNOTATIONS_TYPEDEF_FILE) : null, packageName, LibraryTaskManager.this.extension.getPackageBuildConfig());
                LibraryTaskManager.this.excludeDataBindingClassesIfNecessary(variantScope, transform3);
                Optional<TransformTask> libraryJarTransformTask = transformManager.addTransform(LibraryTaskManager.this.taskFactory, variantScope, transform3);
                libraryJarTransformTask.ifPresent(t -> {
                    variantScope.getBuildArtifactsHolder().appendArtifact((ArtifactType)InternalArtifactType.AAR_MAIN_JAR, (Collection<? extends File>)ImmutableList.of((Object)classesJar), (Task)t);
                    variantScope.getBuildArtifactsHolder().appendArtifact((ArtifactType)InternalArtifactType.AAR_LIBS_DIRECTORY, (Collection<? extends File>)ImmutableList.of((Object)libsDirectory), (Task)t);
                });
                File jniLibsFolder = variantScope.getIntermediateDir(InternalArtifactType.LIBRARY_AND_LOCAL_JARS_JNI);
                LibraryJniLibsTransform jniTransform = new LibraryJniLibsTransform("syncJniLibs", jniLibsFolder, TransformManager.SCOPE_FULL_LIBRARY_WITH_LOCAL_JARS);
                Optional<TransformTask> jniPackagingTask = transformManager.addTransform(LibraryTaskManager.this.taskFactory, variantScope, jniTransform);
                jniPackagingTask.ifPresent(t -> variantScope.getBuildArtifactsHolder().appendArtifact((ArtifactType)InternalArtifactType.LIBRARY_AND_LOCAL_JARS_JNI, (Collection<? extends File>)ImmutableList.of((Object)jniLibsFolder), (Task)t));
                return null;
            }
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_LINT_TASK, projectPath, variantName, () -> this.createLintTasks(variantScope));
        this.createBundleTask(variantScope);
    }

    private void createBundleTask(VariantScope variantScope) {
        AndroidZip bundle = this.taskFactory.create(new AndroidZip.ConfigAction(this.extension, variantScope));
        variantScope.getAssembleTask().dependsOn(new Object[]{bundle});
        if (this.extension.getDefaultPublishConfig().equals(variantScope.getVariantConfiguration().getFullName())) {
            VariantHelper.setupArchivesConfig(this.project, variantScope.getVariantDependencies().getRuntimeClasspath());
            this.project.getArtifacts().add("default", (Object)bundle);
        }
    }

    @Override
    protected void createDependencyStreams(VariantScope variantScope) {
        super.createDependencyStreams(variantScope);
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "local-deps-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.LOCAL_DEPS).setFileCollection(variantScope.getLocalPackagedJars()).build());
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "local-deps-native").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES, ExtendedContentType.NATIVE_LIBS}).addScope(InternalScope.LOCAL_DEPS).setFileCollection(variantScope.getLocalPackagedJars()).build());
    }

    private void createMergeResourcesTask(VariantScope variantScope) {
        ImmutableSet flags = Boolean.TRUE.equals(variantScope.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) ? Sets.immutableEnumSet((Enum)MergeResources.Flag.REMOVE_RESOURCE_NAMESPACES, (Enum[])new MergeResources.Flag[0]) : ImmutableSet.of();
        MergeResources mergeResourceTask = this.basicCreateMergeResourcesTask(variantScope, TaskManager.MergeType.PACKAGE, variantScope.getIntermediateDir(InternalArtifactType.PACKAGED_RES), false, false, false, (ImmutableSet<MergeResources.Flag>)flags);
        this.createMergeResourcesTask(variantScope, false);
        mergeResourceTask.setPublicFile(variantScope.getBuildArtifactsHolder().appendArtifact((ArtifactType)InternalArtifactType.PUBLIC_RES, (Task)mergeResourceTask, "public.txt"));
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
        ConfigurableFileCollection fileCollection = scope.createAnchorOutput(TaskOutputHolder.AnchorOutputType.ALL_CLASSES);
        fileCollection.from(new Object[]{scope.getBuildArtifactsHolder().getArtifactFiles(InternalArtifactType.JAVAC)});
        fileCollection.from(new Object[]{scope.getVariantData().getAllPreJavacGeneratedBytecode()});
        fileCollection.from(new Object[]{scope.getVariantData().getAllPostJavacGeneratedBytecode()});
    }

    private void excludeDataBindingClassesIfNecessary(VariantScope variantScope, LibraryBaseTransform transform2) {
        if (!this.extension.getDataBinding().isEnabled()) {
            return;
        }
        transform2.addExcludeListProvider(() -> {
            File excludeFile = variantScope.getVariantData().getType().isExportDataBindingClassList() ? variantScope.getGeneratedClassListOutputFileForDataBinding() : null;
            File dataBindingFolder = variantScope.getBuildFolderForDataBindingCompiler();
            return this.dataBindingBuilder.getJarExcludeList(variantScope.getVariantData().getLayoutXmlProcessor(), excludeFile, dataBindingFolder);
        });
    }

    public void createLibraryAssetsTask(VariantScope scope) {
        MergeSourceSetFolders mergeAssetsTask = this.taskFactory.create(new MergeSourceSetFolders.LibraryAssetConfigAction(scope));
        mergeAssetsTask.dependsOn(new Object[]{scope.getAssetGenTask()});
        scope.setMergeAssetsTask(mergeAssetsTask);
    }

    @Override
    protected Set<? super QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        if (variantScope.getTestedVariantData() != null) {
            return TransformManager.SCOPE_FULL_PROJECT;
        }
        return TransformManager.PROJECT_ONLY;
    }

    @Override
    protected boolean isLibrary() {
        return true;
    }

    private Task getAssembleDefault() {
        if (this.assembleDefault == null) {
            this.assembleDefault = (Task)this.project.getTasks().findByName("assembleDefault");
        }
        return this.assembleDefault;
    }

    public void createVerifyLibraryResTask(VariantScope scope, TaskManager.MergeType mergeType) {
        VerifyLibraryResourcesTask verifyLibraryResources = this.taskFactory.create(new VerifyLibraryResourcesTask.ConfigAction(scope, mergeType));
        scope.getAssembleTask().dependsOn(new Object[]{verifyLibraryResources});
    }
}

