/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorCombo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.VariantFilter;
import com.android.build.gradle.internal.api.artifact.BuildArtifactSpec;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.AarTransform;
import com.android.build.gradle.internal.dependency.AlternateCompatibilityRule;
import com.android.build.gradle.internal.dependency.AlternateDisambiguationRule;
import com.android.build.gradle.internal.dependency.AndroidTypeAttr;
import com.android.build.gradle.internal.dependency.AndroidTypeAttrCompatRule;
import com.android.build.gradle.internal.dependency.AndroidTypeAttrDisambRule;
import com.android.build.gradle.internal.dependency.ExtractAarTransform;
import com.android.build.gradle.internal.dependency.JarTransform;
import com.android.build.gradle.internal.dependency.LibraryDefinedSymbolTableTransform;
import com.android.build.gradle.internal.dependency.LibrarySymbolTableTransform;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BaseFlavor;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SigningOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.DefaultProductFlavor;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.SourceProvider;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.Recorder;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.ApiVersion;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.model.ObjectFactory;

public class VariantManager
implements VariantModel {
    private static final String MULTIDEX_VERSION = "1.0.2";
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX = "com.android.support:multidex:1.0.2";
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION = "com.android.support:multidex-instrumentation:1.0.2";
    private final Project project;
    private final ProjectOptions projectOptions;
    private final AndroidBuilder androidBuilder;
    private final AndroidConfig extension;
    private final VariantFactory variantFactory;
    private final TaskManager taskManager;
    private final SourceSetManager sourceSetManager;
    private final Recorder recorder;
    private final ProductFlavorData<CoreProductFlavor> defaultConfigData;
    private final Map<String, BuildTypeData> buildTypes;
    private final VariantFilter variantFilter;
    private final List<VariantScope> variantScopes;
    private final Map<String, ProductFlavorData<CoreProductFlavor>> productFlavors;
    private final Map<String, com.android.builder.model.SigningConfig> signingConfigs;
    private final Map<File, ManifestAttributeSupplier> manifestParserMap;
    protected final GlobalScope globalScope;
    private final CoreSigningConfig signingOverride;
    private final BooleanSupplier isInExecutionPhase;

    public VariantManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, AndroidConfig extension, VariantFactory variantFactory, TaskManager taskManager, SourceSetManager sourceSetManager, Recorder recorder) {
        this.globalScope = globalScope;
        this.extension = extension;
        this.androidBuilder = androidBuilder;
        this.project = project;
        this.projectOptions = projectOptions;
        this.variantFactory = variantFactory;
        this.taskManager = taskManager;
        this.sourceSetManager = sourceSetManager;
        this.recorder = recorder;
        this.signingOverride = this.createSigningOverride();
        this.variantFilter = new VariantFilter(new ReadOnlyObjectProvider());
        this.buildTypes = Maps.newHashMap();
        this.variantScopes = Lists.newArrayList();
        this.productFlavors = Maps.newHashMap();
        this.signingConfigs = Maps.newHashMap();
        this.manifestParserMap = Maps.newHashMap();
        this.isInExecutionPhase = () -> globalScope.isInExectionPhase();
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName("main");
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName("androidTest");
            unitTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName("test");
        }
        this.defaultConfigData = new ProductFlavorData<CoreProductFlavor>(extension.getDefaultConfig(), mainSourceSet, androidTestSourceSet, unitTestSourceSet);
    }

    public void addVariant(BaseVariantData variantData) {
        this.variantScopes.add(variantData.getScope());
    }

    @Override
    public ProductFlavorData<CoreProductFlavor> getDefaultConfig() {
        return this.defaultConfigData;
    }

    @Override
    public Map<String, BuildTypeData> getBuildTypes() {
        return this.buildTypes;
    }

    @Override
    public Map<String, ProductFlavorData<CoreProductFlavor>> getProductFlavors() {
        return this.productFlavors;
    }

    public Map<String, com.android.builder.model.SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public void addSigningConfig(com.android.builder.model.SigningConfig signingConfig) {
        this.signingConfigs.put(signingConfig.getName(), signingConfig);
    }

    public void addBuildType(CoreBuildType buildType) {
        String name = buildType.getName();
        VariantManager.checkName(name, "BuildType");
        if (this.productFlavors.containsKey(name)) {
            throw new RuntimeException("BuildType names cannot collide with ProductFlavor names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpSourceSet(name);
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            if (buildType.getName().equals(this.extension.getTestBuildType())) {
                androidTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantManager.computeSourceSetName(buildType.getName(), (VariantType)VariantTypeImpl.ANDROID_TEST));
            }
            unitTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantManager.computeSourceSetName(buildType.getName(), (VariantType)VariantTypeImpl.UNIT_TEST));
        }
        BuildTypeData buildTypeData = new BuildTypeData(buildType, mainSourceSet, androidTestSourceSet, unitTestSourceSet);
        this.buildTypes.put(name, buildTypeData);
    }

    public void addProductFlavor(CoreProductFlavor productFlavor) {
        String name = productFlavor.getName();
        VariantManager.checkName(name, "ProductFlavor");
        if (this.buildTypes.containsKey(name)) {
            throw new RuntimeException("ProductFlavor names cannot collide with BuildType names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpSourceSet(productFlavor.getName());
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantManager.computeSourceSetName(productFlavor.getName(), (VariantType)VariantTypeImpl.ANDROID_TEST));
            unitTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantManager.computeSourceSetName(productFlavor.getName(), (VariantType)VariantTypeImpl.UNIT_TEST));
        }
        ProductFlavorData<CoreProductFlavor> productFlavorData = new ProductFlavorData<CoreProductFlavor>(productFlavor, mainSourceSet, androidTestSourceSet, unitTestSourceSet);
        this.productFlavors.put(productFlavor.getName(), productFlavorData);
    }

    public List<VariantScope> getVariantScopes() {
        return this.variantScopes;
    }

    @Deprecated
    public List<BaseVariantData> getVariantDataList() {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)this.variantScopes.size());
        for (VariantScope variantScope : this.variantScopes) {
            result.add(variantScope.getVariantData());
        }
        return result;
    }

    public void createAndroidTasks() {
        this.variantFactory.validateModel(this);
        this.variantFactory.preVariantWork(this.project);
        if (this.variantScopes.isEmpty()) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.VARIANT_MANAGER_CREATE_VARIANTS, this.project.getPath(), null, this::populateVariantDataList);
        }
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.VARIANT_MANAGER_CREATE_TESTS_TASKS, this.project.getPath(), null, () -> this.taskManager.createTopLevelTestTasks(!this.productFlavors.isEmpty()));
        for (VariantScope variantScope : this.variantScopes) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.VARIANT_MANAGER_CREATE_TASKS_FOR_VARIANT, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createTasksForVariantData(variantScope));
        }
        this.taskManager.createSourceSetArtifactReportTask(this.globalScope);
        this.taskManager.createReportTasks(this.variantScopes);
    }

    private void createAssembleTaskForVariantData(BaseVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        if (variantData.getType().isTestComponent()) {
            variantScope.setAssembleTask(this.taskManager.createAssembleTask(variantData));
        } else {
            BuildTypeData buildTypeData = this.buildTypes.get(((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).getName());
            Preconditions.checkNotNull((Object)buildTypeData.getAssembleTask());
            if (this.productFlavors.isEmpty()) {
                variantScope.setAssembleTask(buildTypeData.getAssembleTask());
                variantData.addTask(TaskContainer.TaskKind.ASSEMBLE, (Task)buildTypeData.getAssembleTask());
            } else {
                variantScope.setAssembleTask(this.taskManager.createAssembleTask(variantData));
                buildTypeData.getAssembleTask().dependsOn(new Object[]{variantScope.getAssembleTask()});
                GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
                for (CoreProductFlavor flavor : variantConfig.getProductFlavors()) {
                    ProductFlavorData<CoreProductFlavor> productFlavorData = this.productFlavors.get(flavor.getName());
                    DefaultTask flavorAssembleTask = productFlavorData.getAssembleTask();
                    if (flavorAssembleTask == null) {
                        flavorAssembleTask = this.taskManager.createAssembleTask(productFlavorData);
                        productFlavorData.setAssembleTask(flavorAssembleTask);
                    }
                    flavorAssembleTask.dependsOn(new Object[]{variantScope.getAssembleTask()});
                }
                if (variantConfig.getProductFlavors().size() > 1) {
                    String name = StringHelper.capitalize((String)variantConfig.getFlavorName());
                    String variantAssembleTaskName = StringHelper.appendCapitalized((String)"assemble", (String)name);
                    if (!this.taskManager.getTaskFactory().containsKey(variantAssembleTaskName)) {
                        Task task = this.taskManager.getTaskFactory().create(variantAssembleTaskName);
                        task.setDescription("Assembles all builds for flavor combination: " + name);
                        task.setGroup("Build");
                        task.dependsOn(new Object[]{variantScope.getAssembleTask().getName()});
                    }
                    this.taskManager.getTaskFactory().configure("assemble", (Action<? super Task>)((Action)task1 -> task1.dependsOn(new Object[]{variantAssembleTaskName})));
                }
            }
        }
    }

    public void createTasksForVariantData(VariantScope variantScope) {
        BaseVariantData variantData = variantScope.getVariantData();
        VariantType variantType = variantData.getType();
        GradleVariantConfiguration variantConfig = variantScope.getVariantConfiguration();
        BuildTypeData buildTypeData = this.buildTypes.get(((CoreBuildType)variantConfig.getBuildType()).getName());
        if (buildTypeData.getAssembleTask() == null) {
            buildTypeData.setAssembleTask(this.taskManager.createAssembleTask(buildTypeData));
        }
        this.taskManager.getTaskFactory().configure("assemble", (Action<? super Task>)((Action)task -> {
            assert (buildTypeData.getAssembleTask() != null);
            task.dependsOn(new Object[]{buildTypeData.getAssembleTask().getName()});
        }));
        this.createAssembleTaskForVariantData(variantData);
        if (variantType.isTestComponent()) {
            DefaultAndroidSourceSet buildTypeConfigurationProvider;
            BaseVariantData testedVariantData = (BaseVariantData)((Object)((TestVariantData)variantData).getTestedVariantData());
            List testProductFlavors = variantConfig.getProductFlavors();
            ArrayList testVariantSourceSets = Lists.newArrayListWithExpectedSize((int)(4 + testProductFlavors.size()));
            if (!testProductFlavors.isEmpty()) {
                testVariantSourceSets.add((DefaultAndroidSourceSet)variantConfig.getVariantSourceProvider());
            }
            if ((buildTypeConfigurationProvider = buildTypeData.getTestSourceSet(variantType)) != null) {
                testVariantSourceSets.add(buildTypeConfigurationProvider);
            }
            if (testProductFlavors.size() > 1) {
                testVariantSourceSets.add((DefaultAndroidSourceSet)variantConfig.getMultiFlavorSourceProvider());
            }
            for (CoreProductFlavor productFlavor : testProductFlavors) {
                testVariantSourceSets.add(this.productFlavors.get(productFlavor.getName()).getTestSourceSet(variantType));
            }
            testVariantSourceSets.add(this.defaultConfigData.getTestSourceSet(variantType));
            AndroidTypeAttr consumeAndroidTypeAttr = this.instantiateAndroidTypeAttr(testedVariantData.getVariantConfiguration().getType().getConsumeType());
            VariantDependencies.Builder builder = VariantDependencies.builder(this.project, variantScope.getGlobalScope().getErrorHandler(), variantConfig).setConsumeType(consumeAndroidTypeAttr).addSourceSets(testVariantSourceSets).setFlavorSelection(this.getFlavorSelection(variantConfig)).setTestedVariantDependencies(testedVariantData.getVariantDependency());
            VariantDependencies variantDep = builder.build();
            variantData.setVariantDependency(variantDep);
            if (testedVariantData.getVariantConfiguration().getRenderscriptSupportModeEnabled()) {
                this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)this.project.files(new Object[]{this.androidBuilder.getRenderScriptSupportJar()}));
            }
            if (variantType.isApk()) {
                if (variantConfig.isLegacyMultiDexMode()) {
                    this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION);
                    this.project.getDependencies().add(variantDep.getRuntimeClasspath().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION);
                }
                this.taskManager.createAndroidTestVariantTasks((TestVariantData)variantData);
            } else {
                this.taskManager.createUnitTestVariantTasks((TestVariantData)variantData);
            }
        } else {
            this.taskManager.createTasksForVariantScope(variantScope);
            this.publishBuildArtifacts(variantScope);
        }
    }

    private void publishBuildArtifacts(VariantScope variantScope) {
        BuildArtifactsHolder buildArtifactsHolder = variantScope.getBuildArtifactsHolder();
        for (PublishingSpecs.OutputSpec outputSpec : variantScope.getPublishingSpec().getOutputs()) {
            ArtifactType buildArtifactType = outputSpec.getOutputType();
            if (!buildArtifactsHolder.hasArtifact(buildArtifactType)) continue;
            BuildableArtifact artifact = buildArtifactsHolder.getFinalArtifactFiles(buildArtifactType);
            if (BuildArtifactSpec.Companion.has(buildArtifactType) && BuildArtifactSpec.Companion.get(buildArtifactType).getAppendable()) {
                throw new RuntimeException(String.format("Appendable ArtifactType '%1s' cannot be published.", buildArtifactType.name()));
            }
            variantScope.publishIntermediateArtifact(artifact, outputSpec.getArtifactType(), (Collection<AndroidArtifacts.PublishedConfigType>)outputSpec.getPublishedConfigTypes());
        }
    }

    private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getFlavorSelection(GradleVariantConfiguration config2) {
        com.android.builder.model.ProductFlavor mergedFlavors = config2.getMergedFlavor();
        if (mergedFlavors instanceof DefaultProductFlavor) {
            ObjectFactory factory = this.project.getObjects();
            return ((DefaultProductFlavor)mergedFlavors).getMissingDimensionStrategies().entrySet().stream().collect(Collectors.toMap(entry -> Attribute.of((String)((String)entry.getKey()), ProductFlavorAttr.class), entry -> (ProductFlavorAttr)factory.named(ProductFlavorAttr.class, ((DefaultProductFlavor.DimensionRequest)entry.getValue()).getRequested())));
        }
        return ImmutableMap.of();
    }

    AndroidTypeAttr instantiateAndroidTypeAttr(String androidTypeAttrString) {
        return (AndroidTypeAttr)this.project.getObjects().named(AndroidTypeAttr.class, androidTypeAttrString);
    }

    public void configureDependencies() {
        DependencyHandler dependencies = this.project.getDependencies();
        String explodedAarType = AndroidArtifacts.ArtifactType.EXPLODED_AAR.getType();
        dependencies.registerTransform(reg -> {
            reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"aar");
            reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)explodedAarType);
            reg.artifactTransform(ExtractAarTransform.class);
        });
        boolean sharedLibSupport = this.globalScope.getProjectOptions().get(BooleanOption.CONSUME_DEPENDENCIES_AS_SHARED_LIBRARIES);
        for (AndroidArtifacts.ArtifactType artifactType : AarTransform.getTransformTargets()) {
            dependencies.registerTransform(reg -> {
                reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)explodedAarType);
                reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)transformTarget.getType());
                reg.artifactTransform(AarTransform.class, config2 -> config2.params(new Object[]{transformTarget, sharedLibSupport}));
            });
        }
        dependencies.registerTransform(reg -> {
            reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)explodedAarType);
            reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.SYMBOL_LIST_WITH_PACKAGE_NAME.getType());
            reg.artifactTransform(LibrarySymbolTableTransform.class);
        });
        if (this.globalScope.getProjectOptions().get(BooleanOption.CONVERT_NON_NAMESPACED_DEPENDENCIES)) {
            dependencies.registerTransform(reg -> {
                reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)explodedAarType);
                reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.DEFINED_ONLY_SYMBOL_LIST.getType());
                reg.artifactTransform(LibraryDefinedSymbolTableTransform.class);
            });
        }
        for (String string : JarTransform.getTransformTargets()) {
            dependencies.registerTransform(reg -> {
                reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
                reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)string);
                reg.artifactTransform(JarTransform.class);
            });
        }
        AttributesSchema attributesSchema = dependencies.getAttributesSchema();
        AttributeMatchingStrategy androidTypeAttrStrategy = attributesSchema.attribute(AndroidTypeAttr.ATTRIBUTE);
        androidTypeAttrStrategy.getCompatibilityRules().add(AndroidTypeAttrCompatRule.class);
        androidTypeAttrStrategy.getDisambiguationRules().add(AndroidTypeAttrDisambRule.class);
        this.setBuildTypeStrategy(attributesSchema);
        this.setupFlavorStrategy(attributesSchema);
    }

    private static <F, T> List<T> convert(Collection<F> values, Function<F, ?> function, Class<T> convertedType) {
        return values.stream().map(function).filter(convertedType::isInstance).map(convertedType::cast).collect(Collectors.toList());
    }

    private void setBuildTypeStrategy(AttributesSchema schema) {
        List<BuildType> dslBuildTypes = VariantManager.convert(this.buildTypes.values(), BuildTypeData::getBuildType, BuildType.class);
        if (dslBuildTypes.isEmpty()) {
            return;
        }
        HashMap alternateMap = Maps.newHashMap();
        for (BuildType buildType : dslBuildTypes) {
            if (buildType.getMatchingFallbacks().isEmpty()) continue;
            alternateMap.put(buildType.getName(), buildType.getMatchingFallbacks());
        }
        if (!alternateMap.isEmpty()) {
            AttributeMatchingStrategy buildTypeStrategy = schema.attribute(BuildTypeAttr.ATTRIBUTE);
            buildTypeStrategy.getCompatibilityRules().add(AlternateCompatibilityRule.BuildTypeRule.class, config2 -> config2.setParams(new Object[]{alternateMap}));
            buildTypeStrategy.getDisambiguationRules().add(AlternateDisambiguationRule.BuildTypeRule.class, config2 -> config2.setParams(new Object[]{alternateMap}));
        }
    }

    private void setupFlavorStrategy(AttributesSchema schema) {
        List<ProductFlavor> flavors = VariantManager.convert(this.productFlavors.values(), ProductFlavorData::getProductFlavor, ProductFlavor.class);
        HashMap alternateMap = Maps.newHashMap();
        for (ProductFlavor productFlavor : flavors) {
            if (!productFlavor.getMatchingFallbacks().isEmpty()) {
                String name = productFlavor.getName();
                String dimension = productFlavor.getDimension();
                Map dimensionMap = alternateMap.computeIfAbsent(dimension, s -> Maps.newHashMap());
                dimensionMap.put(name, productFlavor.getMatchingFallbacks());
            }
            VariantManager.handleMissingDimensions(alternateMap, productFlavor);
        }
        if (this.defaultConfigData.getProductFlavor() instanceof BaseFlavor) {
            VariantManager.handleMissingDimensions(alternateMap, (BaseFlavor)this.defaultConfigData.getProductFlavor());
        }
        for (Map.Entry entry : alternateMap.entrySet()) {
            VariantManager.addFlavorStrategy(schema, (String)entry.getKey(), (Map)entry.getValue());
        }
    }

    public static void addFlavorStrategy(AttributesSchema schema, String dimension, Map<String, List<String>> alternateMap) {
        Attribute attr = Attribute.of((String)dimension, ProductFlavorAttr.class);
        AttributeMatchingStrategy flavorStrategy = schema.attribute(attr);
        flavorStrategy.getCompatibilityRules().add(AlternateCompatibilityRule.ProductFlavorRule.class, config2 -> config2.setParams(new Object[]{alternateMap}));
        flavorStrategy.getDisambiguationRules().add(AlternateDisambiguationRule.ProductFlavorRule.class, config2 -> config2.setParams(new Object[]{alternateMap}));
    }

    private static void handleMissingDimensions(Map<String, Map<String, List<String>>> alternateMap, BaseFlavor flavor) {
        Map missingStrategies = flavor.getMissingDimensionStrategies();
        if (!missingStrategies.isEmpty()) {
            for (Map.Entry entry : missingStrategies.entrySet()) {
                String dimension = (String)entry.getKey();
                Map dimensionMap = alternateMap.computeIfAbsent(dimension, s -> Maps.newHashMap());
                dimensionMap.put(((DefaultProductFlavor.DimensionRequest)entry.getValue()).getRequested(), ((DefaultProductFlavor.DimensionRequest)entry.getValue()).getFallbacks());
            }
        }
    }

    public static String getModifiedName(String name) {
        return "____" + name;
    }

    public void populateVariantDataList() {
        List<String> flavorDimensionList = this.extension.getFlavorDimensionList();
        if (this.productFlavors.isEmpty()) {
            this.configureDependencies();
            this.createVariantDataForProductFlavors(Collections.emptyList());
        } else {
            if (flavorDimensionList == null || flavorDimensionList.isEmpty()) {
                this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.UNNAMED_FLAVOR_DIMENSION, new EvalIssueException("All flavors must now belong to a named flavor dimension. Learn more at https://d.android.com/r/tools/flavorDimensions-missing-error-message.html"));
            } else if (flavorDimensionList.size() == 1) {
                String dimensionName = flavorDimensionList.get(0);
                for (ProductFlavorData<CoreProductFlavor> flavorData : this.productFlavors.values()) {
                    CoreProductFlavor flavor = flavorData.getProductFlavor();
                    if (flavor.getDimension() != null || !(flavor instanceof DefaultProductFlavor)) continue;
                    ((DefaultProductFlavor)flavor).setDimension(dimensionName);
                }
            }
            this.configureDependencies();
            Iterable flavorDsl = Iterables.transform(this.productFlavors.values(), ProductFlavorData::getProductFlavor);
            List flavorComboList = ProductFlavorCombo.createCombinations(flavorDimensionList, flavorDsl);
            for (ProductFlavorCombo flavorCombo : flavorComboList) {
                this.createVariantDataForProductFlavors(flavorCombo.getFlavorList());
            }
        }
    }

    private BaseVariantData createVariantDataForVariantType(com.android.builder.model.BuildType buildType, List<? extends com.android.builder.model.ProductFlavor> productFlavorList, VariantType variantType) {
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        DefaultAndroidSourceSet sourceSet = this.defaultConfigData.getSourceSet();
        GradleVariantConfiguration variantConfig = GradleVariantConfiguration.getBuilderForExtension(this.extension).create(this.globalScope.getProjectOptions(), this.defaultConfigData.getProductFlavor(), sourceSet, this.getParser(sourceSet.getManifestFile()), buildTypeData.getBuildType(), buildTypeData.getSourceSet(), variantType, this.signingOverride, this.globalScope.getErrorHandler(), this.isInExecutionPhase);
        NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer = this.extension.getSourceSets();
        for (com.android.builder.model.ProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<CoreProductFlavor> productFlavorData = this.productFlavors.get(productFlavor.getName());
            String dimensionName = productFlavor.getDimension();
            if (dimensionName == null) {
                dimensionName = "";
            }
            variantConfig.addProductFlavor(productFlavorData.getProductFlavor(), (SourceProvider)productFlavorData.getSourceSet(), dimensionName);
        }
        VariantManager.createCompoundSourceSets(productFlavorList, variantConfig, this.sourceSetManager);
        ArrayList variantSourceSets = Lists.newArrayListWithExpectedSize((int)(productFlavorList.size() + 4));
        if (!productFlavorList.isEmpty()) {
            variantSourceSets.add((DefaultAndroidSourceSet)variantConfig.getVariantSourceProvider());
        }
        variantSourceSets.add(buildTypeData.getSourceSet());
        if (productFlavorList.size() > 1) {
            variantSourceSets.add((DefaultAndroidSourceSet)variantConfig.getMultiFlavorSourceProvider());
        }
        for (com.android.builder.model.ProductFlavor productFlavor : productFlavorList) {
            variantSourceSets.add(this.productFlavors.get(productFlavor.getName()).getSourceSet());
        }
        variantSourceSets.add(this.defaultConfigData.getSourceSet());
        BaseVariantData baseVariantData = this.variantFactory.createVariantData(variantConfig, this.taskManager, this.recorder);
        VariantDependencies.Builder builder = VariantDependencies.builder(this.project, baseVariantData.getScope().getGlobalScope().getErrorHandler(), variantConfig).setConsumeType(this.instantiateAndroidTypeAttr(variantType.getConsumeType())).setFlavorSelection(this.getFlavorSelection(variantConfig)).addSourceSets(variantSourceSets);
        String publishType = variantType.getPublishType();
        if (publishType != null) {
            builder.setPublishType(this.instantiateAndroidTypeAttr(publishType));
        }
        VariantDependencies variantDep = builder.build();
        baseVariantData.setVariantDependency(variantDep);
        if (variantConfig.isLegacyMultiDexMode()) {
            this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX);
            this.project.getDependencies().add(variantDep.getRuntimeClasspath().getName(), (Object)COM_ANDROID_SUPPORT_MULTIDEX);
        }
        if (variantConfig.getRenderscriptSupportModeEnabled()) {
            File renderScriptSupportJar = this.androidBuilder.getRenderScriptSupportJar();
            ConfigurableFileCollection fileCollection = this.project.files(new Object[]{renderScriptSupportJar});
            this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)fileCollection);
            if (variantType.isApk() && !variantType.isForTesting()) {
                this.project.getDependencies().add(variantDep.getRuntimeClasspath().getName(), (Object)fileCollection);
            }
        }
        return baseVariantData;
    }

    private static void createCompoundSourceSets(List<? extends com.android.builder.model.ProductFlavor> productFlavorList, GradleVariantConfiguration variantConfig, SourceSetManager sourceSetManager) {
        if (!productFlavorList.isEmpty()) {
            DefaultAndroidSourceSet variantSourceSet = (DefaultAndroidSourceSet)sourceSetManager.setUpSourceSet(VariantManager.computeSourceSetName(variantConfig.getFullName(), variantConfig.getType()), variantConfig.getType().isTestComponent());
            variantConfig.setVariantSourceProvider(variantSourceSet);
        }
        if (productFlavorList.size() > 1) {
            DefaultAndroidSourceSet multiFlavorSourceSet = (DefaultAndroidSourceSet)sourceSetManager.setUpSourceSet(VariantManager.computeSourceSetName(variantConfig.getFlavorName(), variantConfig.getType()), variantConfig.getType().isTestComponent());
            variantConfig.setMultiFlavorSourceProvider(multiFlavorSourceSet);
        }
    }

    private static String computeSourceSetName(String name, VariantType variantType) {
        if (name.endsWith(variantType.getSuffix())) {
            name = name.substring(0, name.length() - variantType.getSuffix().length());
        }
        if (!variantType.getPrefix().isEmpty()) {
            name = StringHelper.appendCapitalized((String)variantType.getPrefix(), (String)name);
        }
        return name;
    }

    public TestVariantData createTestVariantData(BaseVariantData testedVariantData, VariantType type) {
        DefaultAndroidSourceSet testSourceSet;
        CoreBuildType buildType = (CoreBuildType)testedVariantData.getVariantConfiguration().getBuildType();
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        GradleVariantConfiguration testedConfig = testedVariantData.getVariantConfiguration();
        List productFlavorList = testedConfig.getProductFlavors();
        GradleVariantConfiguration testVariantConfig = testedConfig.getMyTestConfig(testSourceSet, (testSourceSet = this.defaultConfigData.getTestSourceSet(type)) != null ? this.getParser(testSourceSet.getManifestFile()) : null, buildTypeData.getTestSourceSet(type), type, this.isInExecutionPhase);
        for (CoreProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<CoreProductFlavor> data = this.productFlavors.get(productFlavor.getName());
            String dimensionName = productFlavor.getDimension();
            if (dimensionName == null) {
                dimensionName = "";
            }
            testVariantConfig.addProductFlavor(data.getProductFlavor(), (SourceProvider)data.getTestSourceSet(type), dimensionName);
        }
        VariantManager.createCompoundSourceSets(productFlavorList, testVariantConfig, this.sourceSetManager);
        TestVariantData testVariantData = new TestVariantData(this.globalScope, this.extension, this.taskManager, testVariantConfig, (TestedVariantData)((Object)testedVariantData), this.recorder);
        ((TestedVariantData)((Object)testedVariantData)).setTestVariantData(testVariantData, type);
        return testVariantData;
    }

    private void createVariantDataForProductFlavors(List<com.android.builder.model.ProductFlavor> productFlavorList) {
        for (VariantType variantType : this.variantFactory.getVariantConfigurationTypes()) {
            this.createVariantDataForProductFlavorsAndVariantType(productFlavorList, variantType);
        }
    }

    private void createVariantDataForProductFlavorsAndVariantType(List<com.android.builder.model.ProductFlavor> productFlavorList, VariantType variantType) {
        String restrictedVariantName;
        boolean projectMatch;
        boolean restrictVariants;
        TestedAndroidConfig testedExtension;
        BuildTypeData testBuildTypeData = null;
        if (this.extension instanceof TestedAndroidConfig && (testBuildTypeData = this.buildTypes.get((testedExtension = (TestedAndroidConfig)this.extension).getTestBuildType())) == null) {
            throw new RuntimeException(String.format("Test Build Type '%1$s' does not exist.", testedExtension.getTestBuildType()));
        }
        BaseVariantData variantForAndroidTest = null;
        CoreProductFlavor defaultConfig2 = this.defaultConfigData.getProductFlavor();
        Action<com.android.build.api.variant.VariantFilter> variantFilterAction = this.extension.getVariantFilter();
        String restrictedProject = this.projectOptions.get(StringOption.IDE_RESTRICT_VARIANT_PROJECT);
        boolean bl = restrictVariants = restrictedProject != null;
        if (restrictVariants) {
            projectMatch = variantType.isApk() && this.project.getPath().equals(restrictedProject);
            restrictedVariantName = this.projectOptions.get(StringOption.IDE_RESTRICT_VARIANT_NAME);
        } else {
            projectMatch = false;
            restrictedVariantName = null;
        }
        for (BuildTypeData buildTypeData : this.buildTypes.values()) {
            VariantScope.Java8LangSupport supportType;
            boolean ignore = false;
            if (restrictVariants || variantFilterAction != null) {
                this.variantFilter.reset(defaultConfig2, buildTypeData.getBuildType(), variantType, productFlavorList);
                if (restrictVariants) {
                    if (projectMatch) {
                        ignore = !this.variantFilter.getName().equals(restrictedVariantName);
                    }
                } else {
                    variantFilterAction.execute((Object)this.variantFilter);
                    ignore = this.variantFilter.isIgnore();
                }
            }
            if (ignore) continue;
            BaseVariantData variantData = this.createVariantDataForVariantType(buildTypeData.getBuildType(), productFlavorList, variantType);
            this.addVariant(variantData);
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            VariantScope variantScope = variantData.getScope();
            int minSdkVersion = variantConfig.getMinSdkVersion().getApiLevel();
            int targetSdkVersion = variantConfig.getTargetSdkVersion().getApiLevel();
            if (minSdkVersion > 0 && targetSdkVersion > 0 && minSdkVersion > targetSdkVersion) {
                this.globalScope.getDslScope().getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, String.format("minSdkVersion (%d) is greater than targetSdkVersion (%d) for variant \"%s\". Please change the values such that minSdkVersion is less than or equal to targetSdkVersion.", minSdkVersion, targetSdkVersion, variantData.getName()));
            }
            GradleBuildVariant.Builder profileBuilder = ProcessProfileWriter.getOrCreateVariant((String)this.project.getPath(), (String)variantData.getName()).setIsDebug(((CoreBuildType)variantConfig.getBuildType()).isDebuggable()).setMinSdkVersion(AnalyticsUtil.toProto(variantConfig.getMinSdkVersion())).setMinifyEnabled(variantScope.getCodeShrinker() != null).setUseMultidex(variantConfig.isMultiDexEnabled()).setUseLegacyMultidex(variantConfig.isLegacyMultiDexMode()).setVariantType(variantData.getType().getAnalyticsVariantType()).setDexBuilder(AnalyticsUtil.toProto(variantScope.getDexer())).setDexMerger(AnalyticsUtil.toProto(variantScope.getDexMerger())).setTestExecution(AnalyticsUtil.toProto(this.globalScope.getExtension().getTestOptions().getExecutionEnum()));
            if (variantScope.getCodeShrinker() != null) {
                profileBuilder.setCodeShrinker(AnalyticsUtil.toProto(variantScope.getCodeShrinker()));
            }
            if (variantConfig.getTargetSdkVersion().getApiLevel() > 0) {
                profileBuilder.setTargetSdkVersion(AnalyticsUtil.toProto(variantConfig.getTargetSdkVersion()));
            }
            if (variantConfig.getMergedFlavor().getMaxSdkVersion() != null) {
                profileBuilder.setMaxSdkVersion(ApiVersion.newBuilder().setApiLevel((long)variantConfig.getMergedFlavor().getMaxSdkVersion().intValue()));
            }
            if ((supportType = variantData.getScope().getJava8LangSupportType()) != VariantScope.Java8LangSupport.INVALID && supportType != VariantScope.Java8LangSupport.UNUSED) {
                profileBuilder.setJava8LangSupport(AnalyticsUtil.toProto(supportType));
            }
            if (!this.variantFactory.hasTestScope()) continue;
            if (buildTypeData == testBuildTypeData) {
                variantForAndroidTest = variantData;
            }
            if (variantType.isHybrid()) continue;
            TestVariantData unitTestVariantData = this.createTestVariantData(variantData, (VariantType)VariantTypeImpl.UNIT_TEST);
            this.addVariant(unitTestVariantData);
        }
        if (variantForAndroidTest != null && !variantType.isHybrid()) {
            TestVariantData androidTestVariantData = this.createTestVariantData(variantForAndroidTest, (VariantType)VariantTypeImpl.ANDROID_TEST);
            this.addVariant(androidTestVariantData);
        }
    }

    private static void checkName(String name, String displayName) {
        VariantManager.checkPrefix(name, displayName, "androidTest");
        VariantManager.checkPrefix(name, displayName, "test");
        if ("lint".equals(name)) {
            throw new RuntimeException(String.format("%1$s names cannot be %2$s", displayName, "lint"));
        }
    }

    private static void checkPrefix(String name, String displayName, String prefix) {
        if (name.startsWith(prefix)) {
            throw new RuntimeException(String.format("%1$s names cannot start with '%2$s'", displayName, prefix));
        }
    }

    private CoreSigningConfig createSigningOverride() {
        SigningOptions signingOptions = SigningOptions.readSigningOptions(this.projectOptions);
        if (signingOptions != null) {
            SigningConfig signingConfigDsl = new SigningConfig("externalOverride");
            signingConfigDsl.setStoreFile(new File(signingOptions.getStoreFile()));
            signingConfigDsl.setStorePassword(signingOptions.getStorePassword());
            signingConfigDsl.setKeyAlias(signingOptions.getKeyAlias());
            signingConfigDsl.setKeyPassword(signingOptions.getKeyPassword());
            if (signingOptions.getStoreType() != null) {
                signingConfigDsl.setStoreType(signingOptions.getStoreType());
            }
            if (signingOptions.getV1Enabled() != null) {
                signingConfigDsl.setV1SigningEnabled(signingOptions.getV1Enabled());
            }
            if (signingOptions.getV2Enabled() != null) {
                signingConfigDsl.setV2SigningEnabled(signingOptions.getV2Enabled());
            }
            return signingConfigDsl;
        }
        return null;
    }

    private ManifestAttributeSupplier getParser(File file) {
        return this.manifestParserMap.computeIfAbsent(file, f -> new DefaultManifestParser(f, this.isInExecutionPhase));
    }
}

