/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.FileCollection;

public class SplitList {
    public static final String RESOURCE_CONFIGS = "ResConfigs";
    private ImmutableList<Record> records;
    public static final SplitList EMPTY = new SplitList((List<Record>)ImmutableList.of());

    private SplitList(List<Record> records) {
        this.records = ImmutableList.copyOf(records);
    }

    public static SplitList load(FileCollection persistedList) throws IOException {
        String persistedData = FileUtils.readFileToString((File)persistedList.getSingleFile());
        Gson gson = new Gson();
        Type collectionType = new TypeToken<ArrayList<Record>>(){}.getType();
        return new SplitList((List)gson.fromJson(persistedData, collectionType));
    }

    public Set<String> getFilters(VariantOutput.FilterType splitType) {
        return this.getFilters(splitType.name());
    }

    public synchronized Set<String> getFilters(String filterType) {
        Optional<Record> record = this.records.stream().filter(r -> ((Record)r).splitType.equals(filterType)).findFirst();
        return record.isPresent() ? record.get().getValues() : ImmutableSet.of();
    }

    public void forEach(SplitAction action2) {
        this.records.forEach(record -> {
            if (((Record)record).isConfigSplit() && !record.getValues().isEmpty()) {
                action2.apply(VariantOutput.FilterType.valueOf((String)((Record)record).splitType), ((Record)record).filters);
            }
        });
    }

    public Set<String> getResourcesSplit() {
        ImmutableSet.Builder allFilters = ImmutableSet.builder();
        allFilters.addAll(this.getFilters(VariantOutput.FilterType.DENSITY));
        allFilters.addAll(this.getFilters(VariantOutput.FilterType.LANGUAGE));
        return allFilters.build();
    }

    public static Set<String> getSplits(SplitList splitList, MultiOutputPolicy multiOutputPolicy) {
        return multiOutputPolicy == MultiOutputPolicy.SPLITS ? splitList.getResourcesSplit() : ImmutableSet.of();
    }

    public static synchronized void save(File outputFile, Collection<Filter> densityFilters, Collection<Filter> languageFilters, Collection<Filter> abiFilters, Collection<Filter> resourceConfigs) throws IOException {
        ImmutableList records = ImmutableList.of((Object)new Record(VariantOutput.FilterType.DENSITY.name(), densityFilters), (Object)new Record(VariantOutput.FilterType.LANGUAGE.name(), languageFilters), (Object)new Record(VariantOutput.FilterType.ABI.name(), abiFilters), (Object)new Record(RESOURCE_CONFIGS, resourceConfigs));
        Gson gson = new Gson();
        String listOfFilters = gson.toJson((Object)records);
        FileUtils.write((File)outputFile, (CharSequence)listOfFilters);
    }

    public static final class Filter {
        private final String value;
        private final String simplifiedName;

        public Filter(String value, String simplifiedName) {
            this.value = value;
            this.simplifiedName = simplifiedName;
        }

        public Filter(String value) {
            this(value, null);
        }

        public String getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return this.simplifiedName != null ? this.simplifiedName : this.value;
        }
    }

    private static final class Record {
        private final String splitType;
        private final Collection<Filter> filters;

        private Record(String splitType, Collection<Filter> filters) {
            this.splitType = splitType;
            HashSet filterValues = new HashSet();
            filters.forEach(filter -> {
                Preconditions.checkState((!filterValues.contains(filter.getValue()) ? 1 : 0) != 0);
                filterValues.add(filter.getValue());
            });
            this.filters = filters;
        }

        private boolean isConfigSplit() {
            return !this.splitType.equals(SplitList.RESOURCE_CONFIGS);
        }

        public Set<String> getValues() {
            return this.filters.stream().map(filter -> ((Filter)filter).value).collect(Collectors.toSet());
        }
    }

    public static interface SplitAction {
        public void apply(VariantOutput.FilterType var1, Collection<Filter> var2);
    }
}

