/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import java.io.File;
import java.io.IOException;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class FeatureSplitDeclarationWriterTask
extends AndroidVariantTask {
    @Input
    String uniqueIdentifier;
    @Input
    String originalApplicationId;
    @OutputDirectory
    File outputDirectory;

    @TaskAction
    public void fullTaskAction() throws IOException {
        FeatureSplitDeclaration declaration = new FeatureSplitDeclaration(this.uniqueIdentifier, this.originalApplicationId);
        declaration.save(this.outputDirectory);
    }

    public static class ConfigAction
    implements TaskConfigAction<FeatureSplitDeclarationWriterTask> {
        private final VariantScope variantScope;

        public ConfigAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("feature", "Writer");
        }

        @Override
        public Class<FeatureSplitDeclarationWriterTask> getType() {
            return FeatureSplitDeclarationWriterTask.class;
        }

        @Override
        public void execute(FeatureSplitDeclarationWriterTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.uniqueIdentifier = this.variantScope.getGlobalScope().getProject().getPath();
            task.originalApplicationId = this.variantScope.getVariantData().getVariantConfiguration().getOriginalApplicationId();
            task.outputDirectory = this.variantScope.getBuildArtifactsHolder().appendArtifact((ArtifactType)InternalArtifactType.METADATA_FEATURE_DECLARATION, (Task)task, "out");
        }
    }
}

