/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.ide.common.build.ApkInfo;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import kotlin.jvm.functions.Function2;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;

public class CopyOutputs
extends AndroidVariantTask {
    FileCollection fullApks;
    FileCollection abiSplits;
    FileCollection resourcesSplits;
    File destinationDir;

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    @InputFiles
    public FileCollection getFullApks() {
        return this.fullApks;
    }

    @InputFiles
    @Optional
    public FileCollection getAbiSplits() {
        return this.abiSplits;
    }

    @InputFiles
    @Optional
    public FileCollection getResourcesSplits() {
        return this.resourcesSplits;
    }

    @TaskAction
    protected void copy() throws IOException {
        FileUtils.cleanOutputDir((File)this.getDestinationDir());
        ImmutableList.Builder allCopiedFiles = ImmutableList.builder();
        allCopiedFiles.addAll((Iterable)this.parallelCopy(InternalArtifactType.FULL_APK, this.fullApks));
        allCopiedFiles.addAll((Iterable)this.parallelCopy(InternalArtifactType.ABI_PACKAGED_SPLIT, this.abiSplits));
        allCopiedFiles.addAll((Iterable)this.parallelCopy(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, this.resourcesSplits));
        new BuildElements((Collection<BuildOutput>)allCopiedFiles.build()).save(this.getDestinationDir());
    }

    private BuildElements parallelCopy(InternalArtifactType inputType, FileCollection inputs) throws IOException {
        return ExistingBuildElements.from((ArtifactType)inputType, inputs).transform((Function2<? super ApkInfo, ? super File, ? extends File>)((Function2)(apkInfo, inputFile) -> {
            File destination = new File(this.getDestinationDir(), inputFile.getName());
            try {
                FileUtils.copyFile((File)inputFile, (File)destination);
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
            return destination;
        })).into(InternalArtifactType.APK);
    }

    public static class ConfigAction
    implements TaskConfigAction<CopyOutputs> {
        private final VariantScope variantScope;
        private final File outputDirectory;

        public ConfigAction(VariantScope variantScope, File outputDirectory) {
            this.variantScope = variantScope;
            this.outputDirectory = outputDirectory;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("copyOutputs");
        }

        @Override
        public Class<CopyOutputs> getType() {
            return CopyOutputs.class;
        }

        @Override
        public void execute(CopyOutputs task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.fullApks = this.variantScope.getOutput(InternalArtifactType.FULL_APK);
            Project project = this.variantScope.getGlobalScope().getProject();
            task.abiSplits = this.variantScope.hasOutput(InternalArtifactType.ABI_PACKAGED_SPLIT) ? this.variantScope.getOutput(InternalArtifactType.ABI_PACKAGED_SPLIT) : project.files(new Object[0]);
            task.resourcesSplits = this.variantScope.hasOutput(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT) ? this.variantScope.getOutput(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT) : project.files(new Object[0]);
            task.destinationDir = this.outputDirectory;
        }
    }
}

