/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.tools.build.bundletool.BuildBundleCommand;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00048\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00048GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u000eR&\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00148\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "_configFile", "Ljava/io/File;", "<set-?>", "Lcom/android/build/api/artifact/BuildableArtifact;", "baseModuleZip", "getBaseModuleZip", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setBaseModuleZip", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "bundleFile", "getBundleFile", "()Ljava/io/File;", "setBundleFile", "(Ljava/io/File;)V", "configFile", "configFile$annotations", "getConfigFile", "Lorg/gradle/api/file/FileCollection;", "featureZips", "getFeatureZips", "()Lorg/gradle/api/file/FileCollection;", "setFeatureZips", "(Lorg/gradle/api/file/FileCollection;)V", "bundleModules", "", "getBundlePath", "Ljava/nio/file/Path;", "folder", "ConfigAction", "gradle-core"})
public class BundleTask
extends AndroidVariantTask {
    @NotNull
    private BuildableArtifact baseModuleZip;
    @NotNull
    private FileCollection featureZips;
    @NotNull
    private File bundleFile;
    private File _configFile;

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final BuildableArtifact getBaseModuleZip() {
        BuildableArtifact buildableArtifact = this.baseModuleZip;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
        }
        return buildableArtifact;
    }

    private final void setBaseModuleZip(BuildableArtifact buildableArtifact) {
        this.baseModuleZip = buildableArtifact;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getFeatureZips() {
        FileCollection fileCollection = this.featureZips;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        return fileCollection;
    }

    private final void setFeatureZips(FileCollection fileCollection) {
        this.featureZips = fileCollection;
    }

    @OutputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final File getBundleFile() {
        File file = this.bundleFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        return file;
    }

    private final void setBundleFile(File file) {
        this.bundleFile = file;
    }

    public static /* synthetic */ void configFile$annotations() {
    }

    @Optional
    @InputFile
    @Nullable
    public final File getConfigFile() {
        File file;
        File file2 = this._configFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_configFile");
        }
        if (file2.exists()) {
            file = this._configFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_configFile");
            }
        } else {
            file = null;
        }
        return file;
    }

    @TaskAction
    public final void bundleModules() {
        File file = this.bundleFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        FileUtils.mkdirs((File)file.getParentFile());
        File file2 = this.bundleFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        if (file2.isFile()) {
            File file3 = this.bundleFile;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
            }
            FileUtils.delete((File)file3);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        BuildableArtifact buildableArtifact = this.baseModuleZip;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
        }
        builder.add((Object)this.getBundlePath((File)CollectionsKt.single((Iterable)buildableArtifact.getFiles())));
        FileCollection fileCollection = this.featureZips;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        Iterable $receiver$iv = (Iterable)fileCollection;
        Object object = $receiver$iv.iterator();
        while (object.hasNext()) {
            File it;
            Object element$iv = object.next();
            File file4 = it = (File)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"it");
            builder.add((Object)this.getBundlePath(file4));
        }
        BuildBundleCommand.Builder builder2 = BuildBundleCommand.builder();
        File file5 = this.bundleFile;
        if (file5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        BuildBundleCommand.Builder command = builder2.setOutputPath(file5.toPath()).setModulesPaths(builder.build());
        File file6 = this.getConfigFile();
        if (file6 != null) {
            Object it = object = file6;
            command.setBundleConfigPath(((File)it).toPath());
        }
        command.build().execute();
    }

    private final Path getBundlePath(File folder) {
        File[] children = folder.listFiles();
        Preconditions.checkNotNull((Object)children);
        Preconditions.checkState((((Object[])children).length == 1 ? 1 : 0) != 0);
        Path path = children[0].toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"children[0].toPath()");
        return path;
    }

    @NotNull
    public static final /* synthetic */ File access$getBundleFile$p(BundleTask $this) {
        File file = $this.bundleFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        return file;
    }

    @NotNull
    public static final /* synthetic */ BuildableArtifact access$getBaseModuleZip$p(BundleTask $this) {
        BuildableArtifact buildableArtifact = $this.baseModuleZip;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
        }
        return buildableArtifact;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getFeatureZips$p(BundleTask $this) {
        FileCollection fileCollection = $this.featureZips;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        return fileCollection;
    }

    @NotNull
    public static final /* synthetic */ File access$get_configFile$p(BundleTask $this) {
        File file = $this._configFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_configFile");
        }
        return file;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/tasks/BundleTask;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle-core"})
    public static final class ConfigAction
    implements TaskConfigAction<BundleTask> {
        private final VariantScope scope;

        @Override
        @NotNull
        public String getName() {
            return this.scope.getTaskName("bundle");
        }

        @Override
        @NotNull
        public Class<BundleTask> getType() {
            return BundleTask.class;
        }

        @Override
        public void execute(@NotNull BundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            task.setVariantName(this.scope.getFullVariantName());
            task.bundleFile = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.BUNDLE, (Task)task, "bundle.aab");
            task.baseModuleZip = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MODULE_BUNDLE);
            FileCollection fileCollection = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MODULE_BUNDLE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"scope.getArtifactFileCol\u2026tifactType.MODULE_BUNDLE)");
            task.featureZips = fileCollection;
            GlobalScope globalScope = this.scope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"scope.globalScope");
            File file = globalScope.getProject().file((Object)"BundleConfig.xml");
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"scope.globalScope.project.file(\"BundleConfig.xml\")");
            task._configFile = file;
        }

        public ConfigAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            this.scope = scope;
        }
    }
}

