/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.ide.common.build.ApkData;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u000b8\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/tasks/MainApkListPersistence;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "apkData", "", "Lcom/android/ide/common/build/ApkData;", "getApkData", "()Ljava/util/Collection;", "setApkData", "(Ljava/util/Collection;)V", "outputFile", "Ljava/io/File;", "getOutputFile", "()Ljava/io/File;", "setOutputFile", "(Ljava/io/File;)V", "fullTaskAction", "", "ConfigAction", "gradle-core"})
public class MainApkListPersistence
extends AndroidVariantTask {
    @NotNull
    public File outputFile;
    @NotNull
    public Collection<? extends ApkData> apkData;

    @OutputFile
    @NotNull
    public final File getOutputFile() {
        File file = this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        return file;
    }

    public final void setOutputFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.outputFile = file;
    }

    @Input
    @NotNull
    public final Collection<ApkData> getApkData() {
        Collection<ApkData> collection = this.apkData;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apkData");
        }
        return collection;
    }

    public final void setApkData(@NotNull Collection<? extends ApkData> collection) {
        Intrinsics.checkParameterIsNotNull(collection, (String)"<set-?>");
        this.apkData = collection;
    }

    @TaskAction
    public final void fullTaskAction() {
        File file = this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        FileUtils.deleteIfExists((File)file);
        Collection<? extends ApkData> collection = this.apkData;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apkData");
        }
        String apkDataList = ExistingBuildElements.Companion.persistApkList(collection);
        File file2 = this.outputFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        FileUtils.createFile((File)file2, (String)apkDataList);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/tasks/MainApkListPersistence$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/tasks/MainApkListPersistence;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "getScope", "()Lcom/android/build/gradle/internal/scope/VariantScope;", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle-core"})
    public static final class ConfigAction
    implements TaskConfigAction<MainApkListPersistence> {
        @NotNull
        private final VariantScope scope;

        @Override
        @NotNull
        public String getName() {
            return this.scope.getTaskName("mainApkListPersistence");
        }

        @Override
        @NotNull
        public Class<MainApkListPersistence> getType() {
            return MainApkListPersistence.class;
        }

        @Override
        public void execute(@NotNull MainApkListPersistence task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            task.setVariantName(this.scope.getFullVariantName());
            OutputScope outputScope = this.scope.getOutputScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)outputScope, (String)"scope.outputScope");
            List<ApkData> list = outputScope.getApkDatas();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"scope.outputScope.apkDatas");
            task.setApkData((Collection<? extends ApkData>)list);
            task.setOutputFile(new File(new File(this.scope.getSplitSupportDirectory(), "apk-list"), "apk-list.gson"));
            this.scope.addTaskOutput(InternalArtifactType.APK_LIST, task.getOutputFile(), this.getName());
        }

        @NotNull
        public final VariantScope getScope() {
            return this.scope;
        }

        public ConfigAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            this.scope = scope;
        }
    }
}

