/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceDirectoryParser;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/dependency/LibraryDefinedSymbolTableTransform;", "Lorg/gradle/api/artifacts/transform/ArtifactTransform;", "()V", "getPackage", "", "manifest", "Ljava/nio/file/Path;", "transform", "", "Ljava/io/File;", "explodedAar", "gradle-core"})
public final class LibraryDefinedSymbolTableTransform
extends ArtifactTransform {
    @NotNull
    public List<File> transform(@NotNull File explodedAar) {
        Intrinsics.checkParameterIsNotNull((Object)explodedAar, (String)"explodedAar");
        File manifest = FilesKt.resolve((File)explodedAar, (String)"AndroidManifest.xml");
        File resDir = FilesKt.resolve((File)explodedAar, (String)"res");
        Path path = manifest.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"manifest.toPath()");
        String pkg = this.getPackage(path);
        File outputFile = new File(this.getOutputDirectory(), "" + pkg + "-R-def.txt");
        SymbolTable symbols = resDir.isDirectory() ? ResourceDirectoryParser.parseResourceSourceSetDirectory((File)resDir, (IdProvider)IdProvider.Companion.constant(), null).rename(pkg) : SymbolTable.Companion.builder().tablePackage(pkg).build();
        SymbolIo.writeRDef((SymbolTable)symbols, (Path)outputFile.toPath());
        ImmutableList immutableList = ImmutableList.of((Object)outputFile);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of(outputFile)");
        return (List)immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getPackage(Path manifest) {
        String string;
        Closeable closeable = new BufferedInputStream(Files.newInputStream(manifest, new OpenOption[0]));
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)closeable;
            ManifestData manifestData = AndroidManifestParser.parse((InputStream)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)manifestData, (String)"AndroidManifestParser.parse(it)");
            String string2 = manifestData.getPackage();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"AndroidManifestParser.parse(it).`package`");
            String string3 = string2;
            string = string3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"BufferedInputStream(File\u2026e(it).`package`\n        }");
        return string;
    }
}

