/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.Charsets;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckInstantAppLibrariesTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "libraryFilters", "Lorg/gradle/api/artifacts/ArtifactCollection;", "getLibraryFilters", "Lorg/gradle/api/file/FileCollection;", "taskAction", "", "ConfigAction", "gradle-core"})
public class CheckInstantAppLibrariesTask
extends AndroidVariantTask {
    private ArtifactCollection libraryFilters;

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getLibraryFilters() {
        ArtifactCollection artifactCollection = this.libraryFilters;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"libraryFilters");
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"libraryFilters.artifactFiles");
        return fileCollection;
    }

    @TaskAction
    public final void taskAction() {
        Object object;
        Object object2;
        Map map = new LinkedHashMap();
        boolean found = false;
        ArtifactCollection artifactCollection = this.libraryFilters;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"libraryFilters");
        }
        Object object3 = artifactCollection.iterator();
        while (object3.hasNext()) {
            ResolvedArtifactResult artifact;
            ResolvedArtifactResult resolvedArtifactResult = artifact = (ResolvedArtifactResult)object3.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"artifact");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"artifact.id");
            if (!(componentArtifactIdentifier.getComponentIdentifier() instanceof ProjectComponentIdentifier)) {
                StringBuilder stringBuilder = new StringBuilder();
                ComponentArtifactIdentifier componentArtifactIdentifier2 = artifact.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier2, (String)"artifact.id");
                ComponentIdentifier componentIdentifier = componentArtifactIdentifier2.getComponentIdentifier();
                Intrinsics.checkExpressionValueIsNotNull((Object)componentIdentifier, (String)"artifact.id.componentIdentifier");
                throw (Throwable)new GradleException(stringBuilder.append(componentIdentifier.getDisplayName()).append(" is not a Gradle project.").toString());
            }
            ComponentArtifactIdentifier componentArtifactIdentifier3 = artifact.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier3, (String)"artifact.id");
            ComponentIdentifier componentIdentifier = componentArtifactIdentifier3.getComponentIdentifier();
            if (componentIdentifier == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
            }
            String project = ((ProjectComponentIdentifier)componentIdentifier).getProjectPath();
            File file = artifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"artifact.file");
            if (!file.isFile()) continue;
            for (Object library : Files.readLines((File)artifact.getFile(), (Charset)Charsets.UTF_8)) {
                if (map.containsKey(library)) {
                    found = true;
                    List list = (List)map.get(library);
                    if (list != null) {
                        String string = project;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project");
                        list.add(string);
                    }
                    continue;
                }
                object2 = map;
                Intrinsics.checkExpressionValueIsNotNull((Object)library, (String)"library");
                Object[] objectArray = new String[1];
                String string = project;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project");
                objectArray[0] = string;
                List list = CollectionsKt.mutableListOf((Object[])objectArray);
                object2.put(object, list);
            }
        }
        if (found) {
            Object library;
            StringBuilder output2 = new StringBuilder();
            library = map;
            Iterator iterator = library.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = object3 = iterator.next();
                library = (String)object2.getKey();
                object2 = object3;
                List projects = (List)object2.getValue();
                if (projects.size() <= 1) continue;
                object2 = null;
                object = null;
                int n = 0;
                CharSequence charSequence = "]";
                CharSequence charSequence2 = ", ";
                CharSequence charSequence3 = "[";
                output2.append("Features ").append(CollectionsKt.joinToString$default((Iterable)projects, (CharSequence)charSequence2, (CharSequence)charSequence3, (CharSequence)charSequence, (int)n, (CharSequence)object, (Function1)object2, (int)56, null)).append(" all package the same library [").append((String)library).append("].\n");
            }
            throw (Throwable)new GradleException(output2.toString());
        }
    }

    @NotNull
    public static final /* synthetic */ ArtifactCollection access$getLibraryFilters$p(CheckInstantAppLibrariesTask $this) {
        ArtifactCollection artifactCollection = $this.libraryFilters;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"libraryFilters");
        }
        return artifactCollection;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckInstantAppLibrariesTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/tasks/CheckInstantAppLibrariesTask;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "getScope", "()Lcom/android/build/gradle/internal/scope/VariantScope;", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle-core"})
    public static final class ConfigAction
    implements TaskConfigAction<CheckInstantAppLibrariesTask> {
        @NotNull
        private final VariantScope scope;

        @Override
        @NotNull
        public String getName() {
            return this.scope.getTaskName("check", "Libraries");
        }

        @Override
        @NotNull
        public Class<CheckInstantAppLibrariesTask> getType() {
            return CheckInstantAppLibrariesTask.class;
        }

        @Override
        public void execute(@NotNull CheckInstantAppLibrariesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            task.setVariantName(this.scope.getFullVariantName());
            ArtifactCollection artifactCollection = this.scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_TRANSITIVE_DEPS);
            Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"scope.getArtifactCollect\u2026.FEATURE_TRANSITIVE_DEPS)");
            task.libraryFilters = artifactCollection;
        }

        @NotNull
        public final VariantScope getScope() {
            return this.scope;
        }

        public ConfigAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            this.scope = scope;
        }
    }
}

