/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class TaskInputHelper {
    private static AtomicBoolean bypassSupplier = new AtomicBoolean(true);

    public static void disableBypass() {
        bypassSupplier.set(false);
    }

    public static void enableBypass() {
        bypassSupplier.set(true);
    }

    public static boolean bypassEnabled() {
        return bypassSupplier.get();
    }

    public static Supplier<Collection<File>> bypassFileSupplier(Supplier<Collection<File>> supplier) {
        return new Bypasser(supplier);
    }

    public static Callable<Collection<File>> bypassFileCallable(Supplier<Collection<File>> supplier) {
        return new Bypasser(supplier);
    }

    public static <T> Supplier<T> memoize(Supplier<T> supplier) {
        return Suppliers.memoize(supplier::get);
    }

    private static class Bypasser
    implements Supplier<Collection<File>>,
    Callable<Collection<File>> {
        private final Supplier<Collection<File>> supplier;

        public Bypasser(Supplier<Collection<File>> supplier) {
            this.supplier = TaskInputHelper.memoize(supplier);
        }

        @Override
        public Collection<File> get() {
            if (TaskInputHelper.bypassEnabled()) {
                return ImmutableList.of();
            }
            return this.supplier.get();
        }

        @Override
        public Collection<File> call() {
            return this.get();
        }
    }
}

